/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMOBJ.H__   1.7.1.0.1.2   09 Dec 1996 10:16:40   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMOBJ.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:40   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:56   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:42   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:12   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:16   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:16   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:48   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:06   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:37:28   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:04   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:54   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:14   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:40   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:04   Shirley
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:  SYMOBJ.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymObj
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   27 Feb. 1996 15:30:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMOBJ_H_
#define _SYMOBJ_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save expression string          *
*                                                                     *
**********************************************************************/                        
class CSymObj {
protected :
    CSymObj() {
        m_strCmd = 0;
        m_nCmdFlag = 0;
        m_nLen = 0;
        m_nErrNo = 0;
    }
    ~CSymObj() {
        if ( m_strCmd ) delete []m_strCmd;
        m_strCmd = 0;
        m_nLen = 0;  
        m_nErrNo = 0;
    }
     
protected :
    char *m_strCmd;
    int m_nCmdFlag;
    int m_nLen;
    int m_nErrNo;    // 0  --  no error
                     // 1  --  new memory failure
                     // 2  --  m_strCmd is Empty
                     // 3  --  Input parameters Error            
                     // 4  --  Token is Empty                   
                     // 5  --  not find required node            
                     // 6  --  invalid token
                     // 7  --  error symbol token
                     // 8  --  error syntax
                     // 9  --  stack operator error !
                     //10  --  c expression calculate run time error!
                     //11  --  operand type error
                     //12  --  convert operand failure 
                     //13  --  division by 0 
                     //14  --  Abi read memory failure
                     //15  --  Abi write memory failure       
                     //16  --  array size overflow

public :
	void GetErrorNum(int& nErrorNum ) {
		nErrorNum = m_nErrNo;
	};
	    
protected :
    void InitStrCmd(const char* pStrSrc,int flag = 0);
    void SkipLeftSpace(char* pStrSrc, char*& pStrRst);
    void SkipLeftSpace(int nPos, int &nResultPos);
    void SkipRightSpace(char* pStrSrc);

};
                
#endif
/******************************** E O F ***********************************/
