
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMUTIL.H__   1.7.1.0.1.2   09 Dec 1996 10:17:16   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMUTIL.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:16   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:21:18   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:46   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:50   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:44   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:38   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:48   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:32:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:54   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:42   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:24   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:24   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:36   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:08   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:58   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:52   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:56   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:02   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:24   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:24   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:54   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:08   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:00   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:22   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:30   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:16   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:22   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:44   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:40   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:44   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:48   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:54   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:08   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:18   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:30   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: symutil.h
**
** Title: Utility Routines for Symbol Server
**
** Purpose:
**    Catch-all for definitions and functions needed by multiple symbol files
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/SYMUTIL.H__   1.7.1.0.1.2   09 Dec 1996 10:17:16   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _SYMUTIL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMBOLS_LOADED  0L  // for on-demand, indicates symbols all loaded ;
 
#ifndef DEFAULT_START_ADDR 
#define DEFAULT_START_ADDR 0xFFFFFFFFL   
#endif 

#ifndef DEFAULT_END_ADDR 
#define DEFAULT_END_ADDR   0L
#endif

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

                       /**********************************
                        *                                *
                        *       FUNCTION PROTOTYPES      *
                        *                                *
                        **********************************/
BOOLEAN
UtilIsValidSymDescriptor(SYM_DESCRIPTOR symDesc);

RETCODE
UtilGetAddrFromSymDesc(SYM_DESCRIPTOR symDesc,
                       BASE_ADDRESS *baseAddr);

/*--------------------------------------------------------------------------*/
/* UtilOnDemandLoad
**
** Purpose:
**    Allows the symbol server to call the code loader so symbols for a 
**    module can be loaded on demand.
**
** Input parameters:
**    inputSymbol: a symbol descriptor to a func/block/module.  This will
**                 be used to find out if the modules symbols have been 
**                 loaded.
**
** Output parameters:
**
** Error: Reports error symbol is not a func/block/module or if the load
**        fails.
*/
/*--------------------------------------------------------------------------*/
RETCODE
UtilOnDemandLoad(SYM_DESCRIPTOR inputSymbol);


//------------------------------------------------------------------------
// UtilCmpTimestamp
//
// Purpose:
//       Return the difference between two timestamps;
//       Returns 0 if they are identical in all fields,
//          <0 if t1 < t2,
//          >0 if t1 > t2
//       where the value returned is the amount of difference, in
//       the first field where they differ.
//
// Input parameters:
//       time1: pointer to the first timestamp.
//       time2: pointer to the second timestamp.
//
// Output parameters:
//
//------------------------------------------------------------------------
S16 UtilCmpTimestamp(TIMESTAMP_TYPE *time1, TIMESTAMP_TYPE *time2);

//------------------------------------------------------------------------
// UtilDeleteTables
//
// Purpose:
//    Removes all tables and dynamically allocated memory
//
// Input parameters:
//
// Output parameters:
//
//------------------------------------------------------------------------
RETCODE UtilDeleteTables(VOID);

#define _SYMUTIL_
#endif
/******************************** E O F *************************************/
