
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TSTBASE.CPP   1.7.1.0.1.2   09 Dec 1996 10:16:10   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TSTBASE.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:10   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:26   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:14   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:46   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:50   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:20   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:02   ZJRD
** No change.
** 
**    Rev 1.7   11 Jun 1996 10:29:28   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:58:06   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:42   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:05:58   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:00   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:48   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:38   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:43:06   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:24   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:54   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:12   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:48   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:42   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:50   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:34   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:22   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:58   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:02   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:50   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:22   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:36   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:20   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:46   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:10   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:46   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:34   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:22   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:48   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:21:38   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:30   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:58:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:10   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTBASE.CPP
//
//  Description: The implementation file for the class: CFileBase.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CFileBase.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "tstbase.h"
#include "hosterrs.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CFileBase.

// Construction.
CFileBase::CFileBase()
{
    // Initial.
    m_strFileName.Empty();
    m_nErrorID = NO_ERROR;
    m_nOpenFlag = CFile::typeText;
    
    m_pszLineBuf = 0;
    
}   // End of CFileBase::CFileBase().


// Destruction.
CFileBase::~CFileBase()
{

}   // End of CFileBase::~CFileBase().


// Open a file.
void CFileBase::OpenFile(void)
{
    // Assertion of the input parameters.
    ASSERT( !m_strFileName.IsEmpty() );
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Open a special file.
    if ( !Open(m_strFileName, m_nOpenFlag) ) {
        m_nErrorID = OPEN_ERROR;
    }

}   // End of CFileBase::OpenFile().


// Close a file.
void CFileBase::CloseFile(void)
{
    // Assertion of the input parameters.
    //ASSERT( !m_strFileName.IsEmpty() );
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Close a special file.
    if ( !m_strFileName.IsEmpty() ) {
    	Close();
    }	

}   // End of CFileBase::CloseFile().


// Write data to a file.
void CFileBase::WriteToFile(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pszLineBuf );
    
    // Write to the file.
    WriteString(m_pszLineBuf);

}   // End of CFileBase::WriteToFile().


// Read data from a file.
void CFileBase::ReadFromFile(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pszLineBuf );
	
	//if ( CStdioFile::m_pStream == NULL) 
	if (m_strFileName.IsEmpty())
		return;
	
    // Read a line contents.
    if ( !ReadString(m_pszLineBuf, maxChar) ) {
        m_nErrorID = FILE_END;
        return;
    }
    
    // Over than 255 characters in ONE line.
    int i = (int) strlen(m_pszLineBuf);
    if ( maxChar-1 == i  && '\n' != *(m_pszLineBuf+i-1) ) {
        m_nErrorID = LONG_LINE;
    }
    
    // Filter the illegal characters.
    char* p = m_pszLineBuf;
    while ( *p ) {
        if ( *p < MIN_KEY || *p > MAX_KEY ) {
            *p = MIN_KEY;
        }
        p++;
    }

}   // End of CFileBase::ReadFromFile().


// Display the error message.
void CFileBase::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > NO_ERROR && m_nErrorID < MAX_ERROR );
    
    // Define the error message.
    /*
    char* pszErrorMsg[] = {
        "",
        "Log file existed already.",
        "No Log file opened.",
        "File open error.",
        "File close error.",
        "File read error.",
        "File write error.",
        "End of Include file.",
        "More than 255 characters in one line.",
        "Not an Include inner command.",
        "Include sub-command error.",
        "Include sub-command error: Syntax error.",
        "Include sub-command error: Invalid COUNT.",
        "Include sub-command error: Invalid LABEL.",
        "Include sub-command error: LABEL cannot matched.",
        "Include sub-command error: More than 256 LOOP nested.",
        "Include sub-command error: Invalid LOOPEND.",
        "Include sub-command error: IF,IF_NOT & ELSE statement cannot nest.",
        "Include sub-command error: ELSE without IF or IF_NOT statement.",
        "Include sub-command error: No expected {.",
        "Include sub-command error: No expected }.",
        "Include sub-command error: { and } unmatched.",
        "Abort by user.",  
        //Macro command             
        "The macro is not exist.",     
        "End of Macro file.",
        "Not a Macro inner command.",
        "Macro sub-command error.",
        "Macro sub-command error: Syntax error.",
        "Macro sub-command error: IF,IF_NOT & ELSE statement cannot nest.",
        "Macro sub-command error: ELSE without IF or IF_NOT statement.",
        "Macro sub-command error: No expected {.",
        "Macro sub-command error: No expected }.",
        "Macro sub-command error: { and } unmatched.",
        "Abort by user.",                             
        "Macro sub-command error: Invalid COUNT.",
        "Macro sub-command error: Invalid LABEL.",
        "Macro sub-command error: LABEL cannot matched.",
        "Macro sub-command error: More than 256 LOOP nested.",
        "Macro sub-command error: Invalid LOOPEND.",
        ""
    };
    */
    // Display the corresponding error message.
   	char* pszErr = new char[256];
   	if (m_nErrorID == FILE_END) {
		ErrGetErrorText(ER_TST_FILE_END, pszErr);   	
   	}
   	else if (m_nErrorID == MACRO_FILE_END) {
		ErrGetErrorText(ER_TST_MACRO_FILE_END, pszErr);   	
   	}
	else {
    	ErrGetErrorText(ER_TST_BASE + m_nErrorID, pszErr);
    }	
    ShowLine(pszErr);
    delete []pszErr;
//    ShowLine(pszErrorMsg[m_nErrorID]);

}   // End of CFileBase::DisplayErrorMessage().


// Convert string to unsigned long value.
void CFileBase::StrToVar(char* pszConvStr)
{
    // Assertion of the input parameters.
    ASSERT( pszConvStr );
    
    // Convertion.
    char* pszStopStr;
    m_ulVar = strtoul(pszConvStr, &pszStopStr, 16);

}   // End of CFileBase::StrToVar().

//////////////////////////////// End of File ////////////////////////////////
