
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TSTID.CPP   1.7.1.0.1.2   09 Dec 1996 10:17:04   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TSTID.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:04   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:20   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:50   ZJRD
** EasyPack/SLD Version 1.9f
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:18   ZJRD
** EasyPack/SLD Version 1.9e
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:22   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:20   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:16   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.8   20 Jun 1996 09:27:04   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:21:42   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.5   05 Jun 1996 14:53:20   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:32:00   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:03:12   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:14:44   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:22:36   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:56:36   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:35:48   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:42   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:00   Shirley
** EasyPack/SLD Version 1.0
** 
**    Rev 1.26   06 Feb 1996 15:34:28   Shirley
** EasyPack/SLD Version 0.36a
** 
**    Rev 1.25   06 Feb 1996 13:48:48   Shirley
** EasyPack/SLD Version 0.36
** 
**    Rev 1.24   01 Feb 1996 10:14:48   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:12   Shirley
** EasyPack/SLD Version 0.35a
** 
**    Rev 1.22   25 Jan 1996 13:18:06   Shirley
** EasyPack/SLD Version 0.35
** 
**    Rev 1.21   24 Jan 1996 10:35:44   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:29:00   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:13:52   Shirley
** EasyPack/SLD Version 0.34b
** 
**    Rev 1.18   15 Jan 1996 16:10:44   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:10:02   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:13:24   Shirley
** EasyPack/SLD Version 0.33
** 
**    Rev 1.15   28 Nov 1995 15:35:44   Shirley
** EasyPack/SLD Version 0.32
** 
**    Rev 1.14   21 Nov 1995 11:23:48   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:26:10   Shirley
** EasyPack/SLD Version 0.30
** 
**    Rev 1.12   12 Nov 1995 11:29:50   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:31:38   Shirley
** EasyPack/SLD Version 0.23
** 
**    Rev 1.10   08 Nov 1995 12:40:12   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:07:30   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:47:08   Shirley
** EasyPack/SLD Version 0.1h
** 
**    Rev 1.7   27 Oct 1995 13:48:20   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:29:36   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:08   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:21:40   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:53:32   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:55:34   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:46:12   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:04   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTID.CPP
//
//  Description: The implementation file for the class: CIdentify.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CIdentify.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "tstid.h"
#include "hosterrs.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.

int nFwSupport(0);	// 0: cannot support SPA;
					// 1: support SPA
					
BOOL bNewFrankEric(FALSE);


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void IdentifyCmd(int nArgc, char* pszArgv[]);

void TstIdentify(CString& strCPU, CString& strFW, CString& strSW, 
                 CString& strDOS, CString& strWin);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
//    extern STATUS AbiGetCpuId(UINT *nCpuId);
    STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);
#endif  // _SERVER_NO_ABI

void GetCpuName(CString& strName);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Supply identify information to About dialog.
void TstIdentify(CString& strCPU, CString& strFW, CString& strSW, 
                 CString& strDOS, CString& strWin)
{
    // Execute Identify command.
    CIdentify* pEmulationIdentify = new CIdentify;
    if ( !pEmulationIdentify ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationIdentify->GetIdentifyInformation(strCPU, strFW, strSW, 
                                                   strDOS, strWin);
        delete pEmulationIdentify;
    }

}   // End of TstIdentify().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   IdentifyCmd().
//
//  Description: The main control routine of Identify command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void IdentifyCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Identify command.
    CIdentify* pEmulationIdentify = new CIdentify;
    if ( !pEmulationIdentify ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationIdentify->IdentifyAction(nArgc, pszArgv);
        delete pEmulationIdentify;
    }
}   // End of IdentifyCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CIdentify.

// Construction.
CIdentify::CIdentify()
{
    // Default intial setting.
    m_uCpuID = 0;
    m_uchMajor = 1;
    m_uchMinor = 0;
    
}   // End of CIdentify::CIdentify().


// Destruction.
CIdentify::~CIdentify()
{

}   // End of CIdentify::~CIdentify().


// Emulation Identify command.
void CIdentify::IdentifyAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Call the Identify kernel.
    IdentifyKernel();

}   // End of CIdentify::IdentifyAction().


// Identify kernel routine.
void CIdentify::IdentifyKernel(void)
{
    // Assertion of the input parameters.
    ASSERT( ICE_OK == m_nErrorID );
    
    // Call ABI function to get FW ID.
    m_nErrorID = AbiGetFwId(&m_uchMajor, &m_uchMinor);
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }
    
    // Assign the global flag.
    if ( m_uchMajor == 0x13 ||
    	 m_uchMajor == 0x12 && m_uchMinor >= 0x15 ||
    	 m_uchMajor == 0x22 && m_uchMinor >= 0x13 ||
 		 m_uchMajor == 0x32 && m_uchMinor >= 0x13 ||
 		 m_uchMajor == 0x42 && m_uchMinor >= 0x08 ) {
    	::nFwSupport = 1;
    }
    else {
    	::nFwSupport = 0;
    }
    
    if ( m_uchMinor >= 0x20 ) {
    	::bNewFrankEric = TRUE;
    }
    else {
    	::bNewFrankEric = FALSE;
	}

    // Get DOS & Windows version.
    DWORD dwVersion = GetVersion();
    m_wDOS = HIWORD(dwVersion);
    m_wWin = LOWORD(dwVersion);
    
    // Display the ID information.
    DisplayIdentifyInfo();

}   // End of CIdentify::IdentifyKernel().


// Display the ID information.
void CIdentify::DisplayIdentifyInfo(void)
{
    // Assertion of the input parameters.
    
    // Display CPU type.
    ShowCPU();
    
    // Display FW version.
    ShowFW();
    
    // Display SW version.
    ShowSW();
    
    // Display DOS version.
    ShowDOS();
    
    // Display Windows version.
    ShowWin();
    
}   // End of CIdentify::DisplayIdentifyInfo().

// Display CPU type.
void CIdentify::ShowCPU(void)
{
    // Get the CPU type.
    ::GetCpuName(m_strCPU);
    
    // Format CPU type.
    strcpy(m_pszResult, "Emulation CPU: ");
    strcat(m_pszResult, m_strCPU);

    // Show the information.
    ShowLine(m_pszResult);

}   // End of CIdentify::ShowCPU().


// Display FW version.
void CIdentify::ShowFW(void)
{
    // Assertion of the input parameters.
    
    // Format FW version.
    strcpy(m_pszResult, "FW version: ");
    
    char pszVersion[6];
    sprintf(pszVersion, "%02X.%02X", m_uchMajor, m_uchMinor);

    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    ShowLine(m_pszResult);
    m_strFW = pszVersion;
    
}   // End of CIdentify::ShowFW().


// Display SW version.
void CIdentify::ShowSW(void)
{
    // Assertion of the input parameters.

    // Format SW version.
    strcpy(m_pszResult, "SW version: ");

    char pszVersion[20];
    strcpy(pszVersion, "2.0");

    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    ShowLine(m_pszResult);
    m_strSW = pszVersion;
    
}   // End of CIdentify::ShowSW().


// Display DOS version.
void CIdentify::ShowDOS(void)
{
    // Assertion of the input parameters.

    // Format DOS version.
    strcpy(m_pszResult, "MS-DOS version: ");

    char pszVersion[6];
    sprintf(pszVersion, "%d.%d", HIBYTE(m_wDOS), LOBYTE(m_wDOS));

    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    ShowLine(m_pszResult);
    m_strDOS = pszVersion;
    
}   // End of CIdentify::ShowDOS().


// Display Windows version.
void CIdentify::ShowWin(void)
{
    // Assertion of the input parameters.

    // Format Win version.
    strcpy(m_pszResult, "Windows version: ");

    char pszVersion[20];
    sprintf(pszVersion, "%d.%d", LOBYTE(m_wWin), HIBYTE(m_wWin));
    if ( stricmp(pszVersion, "3.95") == 0 ) {
    	strcpy(pszVersion, "Windows 95");
    }
    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    ShowLine(m_pszResult);
    m_strWin = pszVersion;
    
}   // End of CIdentify::ShowWin().


// Supply identify information to About dialog.
void CIdentify::GetIdentifyInformation(CString& strCPU, CString& strFW, 
                    CString& strSW, CString& strDOS, CString& strWin)
{
    // Set the server flag.
    m_isServer = TRUE;

    // Call the Identify kernel.
    IdentifyKernel();
    
    // Get the parameters.
    strCPU = m_strCPU;
    strFW = m_strFW;
    strSW = m_strSW;
    strDOS = m_strDOS;
    strWin = m_strWin;

}   // End of CIdentify::GetIdentifyInformation().
                    
//////////////////////////////// End of File ////////////////////////////////
