
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/VARINIT.H__   1.7.1.0.1.2   09 Dec 1996 10:15:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/VARINIT.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:52   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:08   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:30   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:02   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:08   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:58   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:30   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:34   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:30:56   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:04:12   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:04   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:29:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:10   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:04   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:50   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:44   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:58   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:12   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:06   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:24   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:12   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:52   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:58   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:02   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:18   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:12   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:08   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:48   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:24   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:54   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:56   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:47:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:54   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:36   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:06   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:54   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:24   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:18   Shirley
** Initial revision.
**
****************************************************************************/

#ifndef _VARINIT_H_

#define _VARINIT_H_

#include "symsyn.h"

#define VAR_GLOBAL  0x01
#define VAR_USEDEF  0x02
#define VAR_NOVALID 0x04
#define VAR_COMPLEX 0x08
#define VAR_ROOT    0x10
#define VAR_EXTEND  0x20
#define VAR_REG     0x40

struct VarNode {
    CString command;
    int flag;           
    int flag1;
    CSymSyntax *pExp;
    int num;
    int line;
    U32 desc;
    U32 typeIndex;
    ADDRESS_TYPE addr;
    ADDRESS_TYPE result;
    CString name;
    CString typeName;
    CString value;
    struct VarNode* son ;
    struct VarNode* father ;
    struct VarNode* next ;
    struct VarNode* prev;

public :
    VarNode()
    {
        son = father = 0;
        next = prev = 0;
        flag = VAR_ROOT;
        desc = 0;
        typeIndex = 0;
        num = 0;
        line = 1;       
        flag1 = 0;
        pExp = 0;
    }              
    ~VarNode()
    {
      if ( flag1 && pExp ) 
         delete pExp;
      pExp = 0;   
    }
    
public :
   void FreeNode() {
      if ( flag1 && pExp ) 
         delete pExp;
      pExp = 0;   
      flag1 = 0;
   }
   void CopyNode(VarNode *pNode) {
      if ( 0 == pNode ) return;
       command = pNode->command;
       flag = pNode->flag;           
       flag1 = pNode->flag1;
       pExp = pNode->pExp;
       //int num;
       line = pNode->line;
       desc = pNode->desc;
       typeIndex = pNode->typeIndex;
       addr.segType = pNode->addr.segType;
       addr.addr = pNode->addr.addr;
       result.segType = pNode->result.segType;
       result.addr = pNode->result.addr;
       name = pNode->name;
       typeName = pNode->typeName;
       value = pNode->value;
//     struct VarNode* son ;
//     struct VarNode* father ;
//     struct VarNode* next ;
//     struct VarNode* prev;
      pNode->flag1 = 0;
      pNode->pExp = 0;
   }
public :
   int CanBeModify();
};

struct VarNodeIndex {
    struct VarNode* node;
    struct VarNodeIndex* next;
    struct VarNodeIndex* prev;

public :
    VarNodeIndex() {
        node = 0;
        next = 0;
        prev = 0;
    }
};

class VarServer : public stkServer {
public :
    struct VarNode* varListHeader;
    struct VarNode* curVarNode;
    char   buff[1024];
    struct VarNodeIndex* namePtr;

public :
    VarServer() : stkServer() {
        varListHeader = curVarNode = 0;
        namePtr = 0;
    }

   int CheckVar(char *str,SYM_DESCRIPTOR &desc,
   TYPE_INDEX &typeIndex,BOOLEAN &isGlobal,ADDRESS_TYPE& addr);

    int AddVar( char *str );
    int AddLocalVar(SYM_DESCRIPTOR desc,CString name);
    int Add( struct VarNode* node );
    int Delete( struct VarNode* node );
    int DeleteLocal(SYM_DESCRIPTOR desc);
    void DeleteAllLocal(void);
    void VarMaxLine(int& nLine);
    
    int IsLegalValue(int nLine , CString str);
    int CheckValue(struct VarNode* node, char *str);
    
    int ModifyValue(int nLine , CString str);
    int SetValue(struct VarNode* node, char *str);
//    int VarBuildIndex();
//    int VarDeleteIndex();
    void VarDeleteAll();
    int VarExtendedNode( struct VarNode* node );
    int VarCompressNode( struct VarNode* node );
    int VarUpdataExtendedNode( struct VarNode* node );
    int EditNode(struct VarNode *node , char *str);
    int UpdataAllLocal();
    int UpdataAllNode( );
    int UpdataOneNode( struct VarNode* node );
    int UpdataOneNodeValue( struct VarNode* node );
    void ShowOneNode( struct VarNode* node );
    void ShowVarToShell();
    void ClearNode( struct VarNode* node );
    int VarLineToNode(int nRow,struct VarNode *& node);
    int VarNodeToPos(struct VarNode* node,int& nPos);
    void UpdataLine( int nLine , struct VarNode * node );
    void VarAddrToStr(ADDRESS_TYPE addr,CString& str);
    int Search( char *str , int & nLine );
    int SearchNext( char *str , int nStartLine , int & nLine ); 
};

#endif
