
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ZQUEUE.CPP   1.7.1.0.1.2   09 Dec 1996 10:16:34   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ZQUEUE.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:34   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:50   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:24   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:56   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:58   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:00   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:36   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:54   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:36:46   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:01:24   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:40   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:00   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:03:16   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:18   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:32   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:36   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:14   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:24   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:11:18   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:42   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:24   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:46   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:04   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:46   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:12   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:56   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:20   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:12   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:46   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:04   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:58   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:18   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  ZQUEUE.CPP
//
//  Description:The implement file for the class: 
//              CStringQueue
//              DWordQueue
//
//  Author:     Roger Zhang
//
//  Date:       07/08/95
//
//  Modification:
//
//      1. 07/08/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "zqueue.h"
 
/////////////////////////////////////////////////////////////////////////////
//  CStringQueue
///////////////////////////////////////////////////////////////////////////// 

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CStringQueue::SetMax
//
//  Description: Set max size of the queue
//
//  Input:  
//      nMax -- the size to set
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CStringQueue::SetMax(int nMax)
{                          
	ASSERT(nMax > 0);
	
	if(nMax <= 0)	return;
    while(nMax < GetCount()) RemoveHead();
    m_nMax = nMax;
}

/////////////////////////////////////////////////////////////////////////////
//  DWordQueue
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DWordQueue::DWordQueue
//
//  Description: Constructor of the class
//
//  Input:  
//      nMax -- the max size of the queue
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
DWordQueue::DWordQueue(int nMax)
{
    ASSERT(nMax > 0);
    
    if(nMax <= 0)   nMax = 20;
    
    pElem = new (unsigned long [nMax]);
    
    m_nMax = nMax;
    m_nIndex = 0;
    m_nCount = 0;
}               

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DWordQueue::~DWordQueue
//
//  Description: Destructor of the class
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
DWordQueue::~DWordQueue()
{
    if(pElem)   delete [] pElem;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DWordQueue::GotoHead
//
//  Description: Set index to the head of the queue
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void DWordQueue::GotoHead(void) 
{
    ASSERT(!IsEmpty());
    
    m_nIndex = 0;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DWordQueue::GotoTail
//
//  Description: Set index to the tail of the queue
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void DWordQueue::GotoTail(void) 
{
    ASSERT(!IsEmpty());
    
    m_nIndex = m_nCount - 1;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DWordQueue::GotoPrev
//
//  Description: Mov index to the previous position
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void DWordQueue::GotoPrev(void) 
{
    ASSERT(!IsEmpty());
                         
    if(!IsHead())   -- m_nIndex;                         
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   DWordQueue::GotoNext
//
//  Description: Mov index to the next position
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void DWordQueue::GotoNext(void) 
{
    ASSERT(!IsEmpty());
                         
    if(!IsTail())   ++ m_nIndex;                         
}

/////////////////////////////////(EOF)///////////////////////////////////////


