
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ZQUEUE.H__   1.7.1.0.1.2   09 Dec 1996 10:14:40   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ZQUEUE.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:40   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:58   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:14:40   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:14   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:20   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:56   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:48   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:56   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:29:20   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:36   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:28:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:48   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:30   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:28   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:28   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:48   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:02   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:56   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:08   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:28   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:50   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:32   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:10   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:02   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:16   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:08   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:46:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:06   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:12   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:52   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:00   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:50   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:02   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:58   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:18   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  ZQUEUE.H
//
//  Description:The header file for the class: 
//              CStringQueue
//              DWordQueue
//
//  Author:     Roger Zhang
//
//  Date:       07/08/95
//
//  Modification:
//
//      1. 07/08/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _ZQUEUE_
#define _ZQUEUE_

/////////////////////////////////////////////////////////////////////////////
//  CStringQueue
/////////////////////////////////////////////////////////////////////////////

class CStringQueue : public CStringList
{
// attribute
public:
    int m_nMax;
            
// constructor/destructor
public:            
    CStringQueue(int nMax, int nBlockSize = 10)
    : CStringList(nBlockSize), m_nMax(nMax) {}
    
// operations:
public:    
    POSITION AddTail(const char * pszNew) 
    { 
        if(GetCount() == m_nMax)  RemoveHead();
        return CStringList::AddTail(pszNew);
    }
    void SetMax(int nMax);
};

/////////////////////////////////////////////////////////////////////////////
//  DWordQueue
/////////////////////////////////////////////////////////////////////////////

class DWordQueue
{
protected:    
    int m_nMax;
    int m_nCount;      
    int m_nIndex;
    unsigned long * pElem;

public:
    
    DWordQueue(int nMax);
    ~DWordQueue();
    int IsOk(void) const { return pElem != 0; }

    int GetCount(void) const { return m_nCount; }
    int GetIndex(void) const { return m_nIndex; }

    int IsEmpty(void) const { return m_nCount == 0; }
    int IsFull(void) const { return m_nCount == m_nMax; }
    int IsHead(void) const { return m_nIndex == 0; }
    int IsTail(void) const { return m_nIndex == m_nCount - 1; }

    void GotoHead(void);
    void GotoTail(void);
    void GotoPrev(void);
    void GotoNext(void);

    unsigned long GetElem(void) const { return pElem[m_nIndex]; }
    unsigned long operator [] (int i) const { return pElem[i]; }   
};

#endif
    
///////////////////////////////(EOF)/////////////////////////////////////////
    
