/***************************************************************************
**    $Header:   D:/ECB2S/SRC/LOG/AL.CPP   1.2.1.5   17 Apr 1997 15:41:06   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/AL.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:41:06   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:14:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:26:50   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:08:56   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:13:56   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:25:14   ZJRD
** Easy Pack SLD 2.09c
**
**    $Header:   D:/ECB2S/SRC/LOG/AL.CPP   1.2.1.5   17 Apr 1997 15:41:06   ZJRD  $
**
**    $Log$
** 
**    Rev 1.5.1.0.1.2   09 Dec 1996 10:17:20   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 13:00:36   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:21:28   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:32:56   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 09:59:58   ZJRD
** No change.
** 
**    Rev 1.5.1.1   28 Aug 1996 15:49:46   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.5.1.0   12 Aug 1996 10:53:58   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:37:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// al.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "al.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void ALTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_fCase = " << m_fCase << "\n";
    dc << "m_fLineDebug = " << m_fLineDebug << "\n";
    dc << "m_fSymbolDebug = " << m_fSymbolDebug << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void ALTool::SetDefault(void)
{                                                    
    m_fCase = TRUE;
    m_fLineDebug = TRUE;
    m_fSymbolDebug = TRUE;
    m_strMore = " ";
    m_strPath = "c:\\cc51\\bin";
}

BOOL ALTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fCase = ach[0];
    m_fLineDebug = ach[1];
    m_fSymbolDebug = ach[2];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen); 
     
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}                 

BOOL ALTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char ach[nCnt];
    
    ach[0] = char(m_fCase);
    ach[1] = char(m_fLineDebug);
    ach[2] = char(m_fSymbolDebug);
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = WORD(m_strMore.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = WORD(m_strPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}

CString ALTool::GetOption(void)
{
    CString str = " ";

    if(!m_fCase)    
        str += "NOCA ";
        
    if(!m_fLineDebug)
        str += "NODL ";
        
    if(!m_fSymbolDebug)
        str += "NODS ";

    str += m_strMore;
    str += " ";
    
    return str;
}

