/***************************************************************************
**    $Header:   D:/ECB2S/SRC/LOG/BL.CPP   1.2.1.5   17 Apr 1997 15:41:50   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/BL.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:41:50   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:15:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:27:40   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:09:30   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:14:28   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:25:46   ZJRD
** Easy Pack SLD 2.09c
**
**    $Header:   D:/ECB2S/SRC/LOG/BL.CPP   1.2.1.5   17 Apr 1997 15:41:50   ZJRD  $
**
**    $Log$
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:15:16   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 12:58:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:16:00   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:27:34   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 09:54:40   ZJRD
** No change.
** 
**    Rev 1.4.1.1   28 Aug 1996 15:48:52   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.4.1.0   12 Aug 1996 10:53:14   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.1   29 May 1996 09:36:34   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// bl.cpp
//
// Michael Long
//                                                                           
// 5/13/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "bl.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BLTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_fZ = " << m_fZ << "\n"; 
    dc << "m_fX = " << m_fX << "\n";
    dc << "m_fW = " << m_fW << "\n";
    
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n"; 
    dc << "m_strCpu = " << m_strCpu << "\n";
       
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BLTool::SetDefault(void)
{                                                    
    m_fZ = TRUE;
    m_fX = FALSE;
    m_fW = TRUE;
    m_strMore = " ";  
    m_strPath = "c:\\icc8051\\exe";
    m_strCpu  = "8051";
}

BOOL BLTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char bch[nCnt];
    
    if(fread(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fZ = bch[0];
    m_fX = bch[1];
    m_fW = bch[2];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strCpu.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strCpu.ReleaseBuffer(wLen);  

    return TRUE;
}                 

BOOL BLTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char bch[nCnt];
    
    bch[0] = (char)m_fZ;
    bch[1] = (char)m_fX;
    bch[2] = (char)m_fW;    
    if(fwrite(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = WORD(m_strMore.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = WORD(m_strPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    wLen = WORD(m_strCpu.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strCpu.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strCpu.ReleaseBuffer(wLen);  

    return TRUE;
}

CString BLTool::GetOption(void)
{
    CString str = " ";

          
   /* if(m_fZ)        
     {
        str += "-c";
        str += m_strCpu;
        str += " ";
     }*/  
    if(m_fX)
        str += "-z ";
        
    if(m_fW)
        str += "-FDEBUG ";

    str += m_strMore;
    str += " ";
    
    return str;
}

