/***************************************************************************
**    $Header:   D:/ECB2S/SRC/LOG/DL.CPP   1.2.1.5   17 Apr 1997 15:48:06   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DL.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:48:06   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:19:22   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:30:46   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:11:42   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:16:44   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:27:52   ZJRD
** Easy Pack SLD 2.09c
**
**    $Header:   D:/ECB2S/SRC/LOG/DL.CPP   1.2.1.5   17 Apr 1997 15:48:06   ZJRD  $
**
**    $Log$
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:17:56   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 13:01:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:22:52   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:34:20   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 10:01:22   ZJRD
** No change.
** 
**    Rev 1.4.1.1   28 Aug 1996 15:45:08   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.4.1.0   12 Aug 1996 10:50:16   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.1   29 May 1996 09:35:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// dl.cpp
//
// Michael Long
//                                                                           
// 5/14/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "dl.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void DLTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_fLSymbol = " << m_fLSymbol << "\n";
    dc << "m_fLine = " << m_fLine << "\n";
    dc << "m_fPSymbol = " << m_fPSymbol << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
 
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void DLTool::SetDefault(void)
{                                                    
    m_fLSymbol = TRUE;
    m_fLine    = TRUE;
    m_fPSymbol = FALSE;
    m_strMore = "DP DL DS";
    m_strPath = "c:\\omf51\\bin";
}

BOOL DLTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char dch[nCnt];
    
    if(fread(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fLSymbol = dch[0];
    m_fLine = dch[2];
    m_fPSymbol = dch[1];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL DLTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char dch[nCnt];
    
    dch[0] = (char)m_fLSymbol;
    dch[2] = (char)m_fLine;
    dch[1] = (char)m_fPSymbol;
        
    if(fwrite(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = WORD(m_strMore.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
      
    wLen = WORD(m_strPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}

CString DLTool::GetOption(void)
{
    CString str = " ";

    if(!m_fLSymbol)    
        str += "NOSB ";
    else
        str += "SB ";
        
    if(!m_fLine)
        str += "NOLI ";
    else
        str += "LI " ;   
           
    if(!m_fPSymbol)
        str += "NOPL ";
    else
        str += "PL ";
    str += m_strMore;
    str += " ";
    
    return str;
}

