/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EMUTMPBP.CPP   1.2.1.5   17 Apr 1997 15:49:00   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EMUTMPBP.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:49:00   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:20:20   ZJRD
** 2.09F
** 
****************************************************************************/

#include "stdafx.h"
#include "abibase.h"

//typedef unsigned short PADDR;
unsigned short uTempBp;
unsigned short nTempBpBank;
BOOL fTempBp = FALSE;

extern BOOL BptSearchBpt(BYTE nBank, unsigned short addr,BYTE &eFlag);
extern STATUS AbiSetBp(ADDR);
extern STATUS AbiClrBp(ADDR);
 
STATUS EmuSetTempBp(unsigned short uAddr);
STATUS EmuClrTempBp();
ADDR MakeAbiAddr(int nBank,unsigned short uAddr);

/***************************************************************************
**
**  Name: EmuClrTempBp
**
**  Function: Clear two links.
**            1. index link
**            2. temporary breakpoints link
**
**  Return: the return code from ABI
**
***************************************************************************/

STATUS EmuSetTempBp(int nBank , unsigned short uAddr)
{
    STATUS status;
    BYTE fEnable;

    if ( !::BptSearchBpt(nBank, uAddr, fEnable) ) {
    //modify by chris for link success:
    //if ( !::BptSearchBpt(uAddr, fEnable) ) {
        status = ::AbiSetBp(MakeAbiAddr(nBank,uAddr));
        if (status == ICE_OK) {
            fTempBp = TRUE;
            uTempBp = uAddr;  
            nTempBpBank = nBank;
        }
        return status;
    }
    return (ICE_OK);
}

/***************************************************************************
**
**  Name: EmuClrTempBp
**
**  Function: Clear two links.
**            1. index link
**            2. temporary breakpoints link
**
**  Return: the return code from ABI
**
***************************************************************************/
STATUS EmuClrTempBp()
{
    STATUS status = ICE_OK;

    if ( TRUE == fTempBp ) {
        status = AbiClrBp(MakeAbiAddr(nTempBpBank,uTempBp));
    	fTempBp = FALSE;
    }
    return status;
}            

/***************************************************************************
**
**  Name: MakeAbiAddr
**
**  Function: convert unsigned short address position into struct ADDR
**
**
**
***************************************************************************/
ADDR MakeAbiAddr(int nBank,unsigned short uAddr)
{
    ADDR structAddr;
    structAddr.addrType = nBank;
    structAddr.addr = uAddr;
    return (structAddr);
}
