/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/FMTSYM.CPP   1.2.1.4   17 Apr 1997 15:52:30   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/FMTSYM.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:52:30   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:23:54   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:34:40   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:14:46   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:19:54   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:30:20   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:46:46   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:54   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:46   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:50   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:06   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:52   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:52   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:44   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:10   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:16:44   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:31:04   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:20   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:35:50   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Fmtsym.cpp
**
**  Description:  This file describe the symbol string class. Deprivde
**                from the class CFormatString.
**                This class process the symbol string, convert it to data(number)
**
**  Status: Initialization
**          1996/03/11        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                                                
#include "address.h"                // Include main head file
//#include "symuser.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern int SymToAddr(char *lpStr , unsigned char* lpType , DWORD* lpAddr);
extern int GetUserVarValue(char*, short&);

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**------------------------------------------------------------------------**
 ** Name: CFormatSymbol                                                    **
 **       Constructor of the CFormatSymbol                                 **
 **                                                                        **
 ** parameter :                                                            **
 **       CString&                                                         **
 **                                                                        **
 ** return value :                                                         **
 **       none                                                             **
 **------------------------------------------------------------------------**/

CFormatSymbol :: CFormatSymbol(const CString& str)
{
   m_strOriginSymbol = str;
}

/**------------------------------------------------------------------------**
 ** Name:  CFormatSymbol                                                   **
 **        Constructor                                                     **
 **                                                                        **
 ** parameter :                                                            **
 **        char* lpsz                                                      **
 **                                                                        **
 ** return value :                                                         **
 **        none                                                            **
 **------------------------------------------------------------------------**/

CFormatSymbol :: CFormatSymbol(const char* lpsz)
{
   m_strOriginSymbol = lpsz;
}

/**------------------------------------------------------------------------**
 ** Name:  Convert                                                         **
 **        Convert the string                                              **
 **                                                                        **
 ** parameter :  none                                                      **
 **                                                                        **
 ** return value :   none                                                  **
 **------------------------------------------------------------------------**/

void
CFormatSymbol :: Convert()      // Process the convert
{
   char *psz = new char[m_strOriginSymbol.GetLength()+2];
   DWORD dwNum = 0;

   ASSERT(NULL != psz);
   strcpy(psz, m_strOriginSymbol.GetBuffer(m_strOriginSymbol.GetLength()));
   
   //
   // Call Symbol Server
   // Symbol To Address
   //        
   short uSymbolData = 0;
   
   switch (m_uSymData) {
      case  0:             // Symbol (# as leading char)
            if (0 == ::SymToAddr(psz, &m_uchType, &m_dwData))
               m_bIsOk = TRUE;
            else
               m_bIsOk = FALSE;   
            break;               
            
      case  1:             // Symbol Data ($ as leading char)
            if (0 == ::GetUserVarValue(psz, uSymbolData)) {
               m_dwData = (DWORD)uSymbolData;
               m_bIsOk = TRUE;
            }               
            else
               m_bIsOk = FALSE;   
            break;               
   }            
      
   delete []psz;
}
