
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/JSYNLIB.H__   1.2.1.4   17 Apr 1997 15:53:38   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/JSYNLIB.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:53:38   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:24:58   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:35:40   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:15:36   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:20:46   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:31:06   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:47:16   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:54   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:14   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:44   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:04   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:50   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:52   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:08   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:46   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:28   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:28   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:26   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:46   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:30   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:10   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:06   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:08   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:14:28   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:11:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:20   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:40   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:46   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:42   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:18   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:38   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:52   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:44   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.3   29 Sep 1995 09:50:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:04   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:58   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:54   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.H
//
//  Description: The header file for the class: CSyntaxLibJ.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLibJ.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNLIB_
#define _SYNLIB_

#include "syntest.h"

/////////////////////////////////////////////////////////////////////////////
// CSyntaxLibJ class.
class CSyntaxLibJ : public CSyntaxTest
{
// Construction & Destruction.
public:
    CSyntaxLibJ();
    ~CSyntaxLibJ();
    
// Member variables.
public:
    // Local macro definition.
    enum { MAX_FILL_SIZE = 32 };
    
    // Maximum of the memory type.
    unsigned long m_ulMaxTypeP;
    unsigned long m_ulMaxTypeX;
    unsigned long m_ulMaxTypeI;
    unsigned long m_ulMaxTypeR;
    unsigned long m_ulMaxTypeB;
    
// Implementations.
public:
    unsigned long StrToVar(char* pszConvStr) const;

    // Syntax check lib routine.
    BOOL IsAddr(char* pszArgv) const;
    BOOL IsPAddr(char* pszArgv) const;
    BOOL IsPAddrDefault(char* pszArgv) const;
    BOOL IsXAddr(char* pszArgv) const;
    BOOL IsXAddrDefault(char* pszArgv) const;
    BOOL IsIAddr(char* pszArgv) const;
    BOOL IsRAddr(char* pszArgv) const;
    BOOL IsBAddr(char* pszArgv) const;
    BOOL IsBAddrDefault(char* pszArgv) const;

    BOOL IsAddrLen(char* pszArgv) const;
    BOOL IsKeywordLength(char* pszArgv) const;
    BOOL IsLengthRange(char* pszAddr, char* pszLen) const;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2) const;
    
    BOOL IsMapStartAddr(char* pszArgv) const;
    BOOL IsMapEndAddr(char* pszArgv) const;
    BOOL IsMapAddrLen(char* pszArgv) const;
    BOOL IsMapMemType(char* pszArgv) const;
    BOOL IsMapAttr(char chType, char* pszArgv) const;
    
    BOOL IsRegName(char* pszRegName) const;
    BOOL IsRegData(char* pszRegName, char* pszRegData) const;
    
    BOOL IsKeywordAll(char* pszArgv) const;
    
    BOOL IsFilename(char* pszArgv) const;
    BOOL IsLoadOption(int nArgc, char* pszArgv[]) const;
    BOOL IsModuleName(char* pszArgv) const;
    
    BOOL IsArgument(char* pszArgv) const;
    BOOL IsBackLevel(char* pszArgv) const;
    BOOL IsVariableName(char* pszArgv) const;
    
    BOOL IsData(char* pszArgv) const;
    BOOL IsDataBit(char* pszArgv) const;
    BOOL IsDataWord(char* pszArgv) const;
    BOOL IsDataLong(char* pszArgv) const;
    BOOL IsString(char* pszArgv) const;
    BOOL IsDataRange(int nArgc, char* pszArgv[]) const;
    BOOL IsStringRange(int nArgc, char* pszArgv[]) const;
    
    BOOL IsKeywordInsensitive(char* pszArgv) const;
    BOOL IsCaseStringRange(int nArgc, char* pszArgv[]) const;
    
    BOOL IsKeywordRun(char* pszArgv) const;
    BOOL IsKeywordFrom(char* pszArgv) const;
    BOOL IsKeywordTill(char* pszArgv) const;
    
    BOOL IsKeywordOver(char* pszArgv) const;
    BOOL IsKeywordForever(char* pszArgv) const;
    BOOL IsKeywordRet(char* pszArgv) const;
    BOOL IsKeywordCall(char* pszArgv) const;
    BOOL IsStepCount(char* pszArgv) const;
    BOOL IsAddrData(char* pszArgv) const;
    
    BOOL IsKeywordInstruction(char* pszArgv) const;
    BOOL IsKeywordStatement(char* pszArgv) const;
    BOOL IsKeywordLine(char* pszArgv) const;
    
    BOOL IsKeywordWith(char* pszArgv) const;
    BOOL IsKeywordClear(char* pszArgv) const;
    
    BOOL IsEventID(char* pszArgv) const;
    BOOL IsKeywordHigh(char* pszArgv) const;
    BOOL IsKeywordLow(char* pszArgv) const;
    BOOL IsKeywordRange(char* pszArgv) const;
    BOOL IsWildcardAddr(char* pszArgv) const;
    BOOL IsWildcardData(char* pszArgv) const;
    BOOL IsEventData(char* pszArgv) const;
    
    BOOL IsListOption(char* pszArgv) const;
    BOOL IsListFrame(char* pszArgv) const;
    
    BOOL IsKeywordTrace(char* pszArgv) const;
    BOOL IsKeywordTimer(char* pszArgv) const;
    BOOL IsKeywordOn(char* pszArgv) const;
    BOOL IsKeywordOff(char* pszArgv) const;
    BOOL IsEventSequence(char* pszArgv) const;

    BOOL IsKeywordReset(char* pszArgv) const;
    BOOL IsKeywordEa(char* pszArgv) const;
    BOOL IsKeywordEnable(char* pszArgv) const;
    BOOL IsKeywordDisable(char* pszArgv) const;
    BOOL IsKeywordBit(char* pszArgv) const;
    BOOL IsKeywordByte(char* pszArgv) const;

    BOOL IsCpuModule(char* pszArgv) const;
    BOOL IsPort(char* pszArgv) const;
    BOOL IsBitNo(char* pszArgv) const;
    BOOL IsBitData(char* pszArgv) const;
    BOOL IsByteData(char* pszArgv) const;
    
    BOOL IsKeywordGlobal(char* pszArgv) const;
    BOOL IsLineNo(char* pszArgv) const;

    BOOL IsKeywordClose(char* pszArgv) const;
    BOOL IsKeywordAppend(char* pszArgv) const;
    BOOL IsKeywordCommand(char* pszArgv) const;

    BOOL IsKeywordLv1(char* pszArgv) const;
    BOOL IsKeywordLv2(char* pszArgv) const;
    BOOL IsKeywordForward(char* pszArgv) const;
    BOOL IsKeywordBackward(char* pszArgv) const;
    BOOL IsKeywordCenter(char* pszArgv) const;
    BOOL IsKeywordDelay(char* pszArgv) const;
    BOOL IsKeywordThen(char* pszArgv) const;
    
    BOOL IsKeywordModule(char* pszArgv) const;
    
    BOOL IsCommand(char* pszArgv) const;

};  // End of class: CSyntaxLibJ.

#endif
//////////////////////////////// End of File ////////////////////////////////
