
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/LDROMF51.CPP   1.2.1.4   17 Apr 1997 15:54:30   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/LDROMF51.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:54:30   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:25:50   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:36:26   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:16:08   ZJRD
** 2.09E
** 
**    Rev 1.2.1.0   28 Mar 1997 10:21:14   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:31:30   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 14:47:28   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:08   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:22   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:58   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:26   ZJRD
** EasyPack/SLD Version 1.9e
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:30   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:26   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:20   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:24   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:32:08   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:20   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:12   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:23:04   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:54   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:36:58   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:58   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:26   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:40   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:10   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:13:02   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:28   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:16   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:10:14   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:28   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:12:02   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:40   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:26   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:06   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:20   Shirley
** EasyPack/SLD Version 0.30
** 
**    Rev 1.12   12 Nov 1995 11:30:08   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:33:22   Shirley
** EasyPack/SLD Version 0.23
** 
**    Rev 1.10   08 Nov 1995 12:43:42   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:38   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:48:34   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:36   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:42   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:47:56   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:52   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:51:38   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:53:30   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:12   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:32   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  LDROMF51.CPP
**
**  Description:
**      Entry points for OMF 8051 Loader.
**
**  Status:  CODED
**
**    Rev 1.0   1 Sept. 1995 8:30:00am   Gates Hua
** Initial revision.
**
**    Rev 1.1   25 Sept. 1995 13:30:00am   Gates Hua
** Changed for omf51 loader module range problem .
**
**    Rev 1.2   9 Oct. 1995 15:30:00am   Gates Hua
** Because of Rev 1.1 change module range , so lib module range is invalid ,
** EP_SLD can not step correctly , I modify the LdrOmf51GetModule() .
**
**    Version 1.92 3 May, 1996 Modify line num for PL/M-51 support.
** Line num infomation is extracted from .lst file.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <ctype.h>
#include <dos.h>

#include "symblsvr.h"
#include "abibase.h"
#include "ldr.h"           
#include "ldromf51.h"
#include "uicom.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

U8 huge *tmpHugePtr = 0;
struct ListDescType {             
    U16 n;
    U16 num;
//    U16 len;
    U32 len;
//    U8 *ptr;
    U8 huge *ptr;     // for Mr. Dome , must support one struct or 
                    // function have more than 1024 member -- no limit , 
                    // max 65535 , every item will use 45 , so total length 
                    // is 65535*45+3.
    HANDLE handle;
    struct ListDescType *next;
public :
    ListDescType() {
        n = 0;
        num = 0;  
        len = 0;
        ptr = 0;
        next = 0;
//        handle = 0;
    };
};
    
struct TypeDescType {  
    U16 num;     
    U8 len;
    U8 *ptr;
    struct TypeDescType *next;
public :
    TypeDescType() {
        num = 0;
        len = 0;
        ptr = 0;
        next = 0;
    };
};

typedef struct {
    SEGMENTTYPE type;
    U32 addr;
} ORG_ADDRESS;

typedef struct {
    ORG_ADDRESS start;
    ORG_ADDRESS end;
    int flag;
} STATE_ADDR;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern struct StoreExtendVar *varExtHdrPtr,*varExtPtr;
extern STATE_ADDR stat_addr ;
extern U32 start , end;
extern U8 LineNumInfo[16] , SymDefInfo[51] , OldKey;
extern struct BlockBlock far *curBlock ;
extern SYM_DESCRIPTOR curModDesc;
extern U8 curByte;    
extern U32 uLoadBytes;
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
struct ListDescType *listPtrHeader = 0, *listPtr = 0;
struct TypeDescType *nameHeader = 0, *namePtr = 0;


void Omf51TypeConv(U16& ui);
void InitTempStruct( void );
void Omf51SegIdToEnum(U8 ui , SEGMENTTYPE* type);
                              
BOOL bAddSymbol = TRUE;                              
int nFixAddFuncType = 0;
                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
extern STATUS AbiFill(ADDR addr1, ADDR addr2,char* pchBuff,UINT uPatternLen);
extern RETCODE SymAddLoadStartAgain();
/***************************************************************************
*                                                                          *
*  LdrOmf51LoadProcess - Omf51 Loader main process routine                 *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51LoadProcess(void)
{       
    int err , flag , codeFlag;       
    U8 key[3] , *dd;  
    U16 recLen , uj , ui;                 
    RETCODE retCode;
    U8 *ptrData;
    U8 data[6];
                  
    flag = 0;                  
    m_absflag = 1;
    codeFlag = LOAD_CODE(m_ldrFlags);
    if (m_lpModuleName) {
/* load module only */
/* Get the module descriptor from moduleName and moduleReference */
        err = LdrOmf51LoadModuleOnly() ;
    }
    else {
        m_startaddress = 0;                                                   
/* load Omf51 file all information */
                              
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
            m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
            return( -1 );
        }                  
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( (err = GetBytes(key , 3)) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        }   
        recLen = BinToU16(&key[1]);
        if( LOAD_SYM( m_ldrFlags )&&m_bAppSym&&m_bLoadInit){
            retCode = SymAddLoadStartAgain();
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
        }
        
        if ( LOAD_SYM( m_ldrFlags )&&(!m_bAppSym||!m_bLoadInit) ) {
            CString filename;
        
            filename = m_lpFileName;
            retCode = SymAddLoadStart(
                        filename.GetBuffer(filename.GetLength()) ,
                        FALSE,
                        &m_time );
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
        }
        while ( 1 ) {
            bAddSymbol = TRUE;
            switch ( key[0] ) {
            case omf_ext_record : /* 0x70 */
                dd = new unsigned char[recLen+1];
                if ( dd == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return(-1);
                }
                if ( (err = GetBytes(dd , recLen)) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    delete dd;
                    return(-1);
                }   
                if(dd) delete dd;
                break;
                
             //added by dragon for bank-switching   2/7/1997
            case omf_bl51_head_rec :/*0x2e*/     
                U16 nCurBankNum;
                int i;
                
                                //for load n time, added by dragon  2/26/1997
                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                   m_dwErrorNum = ER_LDR_FILE_BANK;
                   return -1;
                }
                dd = new unsigned char[26];
                if ( dd == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     
                    return(-1);
                }
                if ( (err = GetBytes(dd , 24)) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    delete dd;
                    return(-1);
                }
                //for initializing
                m_IsBankSwitchOn = 1;
                //?B_MODE = 1,?B_NBANKS = g_nBankNum,?B_CURRENTBANK
                //for correct format
                ASSERT(recLen == U16(25+16*6));
                if(!(dd[0] == 0&&dd[1] == g_nBankNum)){
                    m_dwErrorNum = ER_LDR_OUTOF_BANKNUM; 
                    m_bDispOff = 1;
                    m_dwOffset = g_nBankNum;
                    return -1;
                }
                m_uCurBankAddr.addr = dd[3];
                m_uCurBankAddr.addrType = 6;
                
                m_BankStartAddr = BinToU16(&dd[6]);
                m_BankEndAddr = BinToU16(&dd[8]);
                m_uBankCallAddr = BinToU16(&dd[10]);
                  
                nCurBankNum = 0;
                i=0;
                while(nCurBankNum < 16){
                   if((err = GetBytes(data , 6)) == -1){
                       m_dwErrorNum = ER_LDR_READ_FILE; 
                       m_bDispOff = 1;
                       m_dwOffset = GetFileCurPos();
                       delete dd;
                       return(-1);
                   }
                   if(data[0]==1){
                      ASSERT(i<5);
                      m_nBankInfo[i]=nCurBankNum ;
                      i++;
                   }
                   nCurBankNum++;
                }
                //for checksum
                if(GetOneByte(&curByte)==-1){
                   m_dwErrorNum = ER_LDR_READ_FILE;
                   delete dd;
                   return -1;
                }
                   
                if(dd) delete dd;
                break;                                        
            case omf_beg_module : /* 0x02 */
                flag = 0;
                dd = new unsigned char[recLen+1];
                if ( dd == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return(-1);
                }
                if ( (err = GetBytes(dd , recLen)) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    delete dd;
                    return(-1);
                }   
                if ( recLen < 3 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    delete dd;
                    return(-1);
                }
#ifndef _DUMP_                
                else if ( dd[recLen - 3] != 0xFF ) {
                    m_dwErrorNum = ER_LDR_NOT_RL51;     // 0x4017;
                    delete dd;
                    return(-1);
                }
#endif                
                if(dd) delete dd;
                break;
            case omf_scope_rec : /* 0x10 */
                 err = LdrOmf51GetModule( recLen , FALSE );
                if (err == -1) return(err);
                break;      
            case omf_end_module : /* 0x04 */
                flag = 1;
                dd = new unsigned char[recLen+1];
//                ASSERT( dd );
                if ( dd == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return(-1);
                }
                
                if ( (err = GetBytes(dd , recLen)) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    delete dd;
                    return(-1);
                }   
                if ( recLen < 3 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    delete dd;
                    return(-1);
                }            
                if(dd) delete dd;
                break;
            case omf_content_data : /* 0x06 */ 
                //Added for bankswitching 
                U8 nBankNum ;
                 
                if(GetBytes(data , 3) == -1 ) {
                   m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
                   m_bDispOff = 1;
                   m_dwOffset = GetFileCurPos();
                   return(-1);
                }
                if(m_IsBankSwitchOn){
                   nBankNum = data[0]; 
                   if(!(nBankNum==0||(nBankNum>=0x10&&nBankNum<=0x13))){
                      m_dwErrorNum = ER_LDR_OUTOF_BANKNUM;
                      m_dwOffset = g_nBankNum;
                      return -1;
                   }
                }
                else if(data[0] != 0 ) {
                      m_dwErrorNum = ER_LDR_RELOC_ADDR; // 0x401E;
                      return(-1);
                   }
                ui = BinToU16(&data[1]);
                uj = recLen - 4;
                if ( uj < 256 ) {                   
                    ptrData = new unsigned char[uj+1];
                    ASSERT( ptrData );
                    if ( GetBytes( ptrData , uj+1) == -1 ) {
                        delete ptrData;
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( codeFlag ) {           
                        ADDR stAddr , endAddr;
                        
                        stAddr.addr = (unsigned short)ui;
                        endAddr.addr= (unsigned short)(ui+uj-1);
                        if(g_nBankNum)
                           stAddr.addrType = endAddr.addrType = 6;
                        else
                           stAddr.addrType = endAddr.addrType = 1;
#ifdef _ZLR_                    
                        if(!AbiMyFill(stAddr,endAddr,(char *)ptrData,uj,nBankNum)){
                           delete ptrData;
                           return -1;
                         }
#endif                  
                        uLoadBytes += (U32)uj;
                    }
                }
                else {
                    U16 ii;
                    
                    ii = ui;
                    ptrData = new unsigned char[257];
//                    ASSERT( ptrData );
                    if ( ptrData == 0 ) {
                        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                        return(FAILURE);
                    }
                    
                    while( uj > 255 ) {
                        if ( GetBytes( ptrData , 255) == -1 ) {
                            delete ptrData;
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        if( codeFlag ) {           
                            ADDR stAddr , endAddr;

                            stAddr.addr = (unsigned short)ii;
                            endAddr.addr= (unsigned short)(ii+254);
                            if(g_nBankNum)
                               stAddr.addrType = endAddr.addrType = 6;
                            else
                               stAddr.addrType = endAddr.addrType = 1;
#ifdef _ZLR_                    
                            if(!AbiMyFill(stAddr,endAddr,(char *)ptrData,255,nBankNum)){
                               delete ptrData;
                               return -1;
                            }
#endif                  
                            uLoadBytes += 255L;
                         } 
                         ii += 255;
                         uj -= 255;
                    }
                    if ( GetBytes( ptrData , uj+1) == -1 ) {
                        delete ptrData;
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( uj && codeFlag )   {           
                        ADDR stAddr , endAddr;

                        stAddr.addr = (unsigned short)ii;
                        endAddr.addr= (unsigned short)(ii+uj-1);
                        if(g_nBankNum)
                           stAddr.addrType = endAddr.addrType = 6;
                        else
                           stAddr.addrType = endAddr.addrType = 1;
#ifdef _ZLR_                    
                        if(!AbiMyFill(stAddr,endAddr,(char *)ptrData,uj,nBankNum)){
                           delete ptrData;
                           return -1;
                         }
#endif                  
                        uLoadBytes += (U32)uj;
                    } 
                }

                if(ptrData) delete ptrData;
                break;
            default :
#ifdef _DUMP_
                Message("\r\n???Unknown  record at file %lx",
                        GetFileCurPos()-3);
#endif
                m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
                break;
            }
            
            
            if ( (err = GetBytes(key , 3)) == -1 ) {
                if ( flag ) return(0);
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }         
            if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
                if ( IsLoadCanceled() ) {
                    m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                    return( -1 );
                }                  
                TestMessage();
            }
            recLen = BinToU16(&key[1]);
        }   
    } 
    return (err);
}


/***************************************************************************
*                                                                          *
*  LdrOmf51LoadModuleOnly - Omf51 Loader a module only                     *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51LoadModuleOnly(void)
{
//  SYM_DESCRIPTOR moduleDesc;
    int err;                                                       
    char *lpStr;                           
    char *lpModule;                    
    U32 moduleOffset , ul;    
    U16 recLen;
    U8 key[3];                              
    RETCODE retCode;
    
    err = lstrlen(m_lpModuleName);
    lpModule = new char[err+1];
    if ( lpModule == 0 ) {
        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
        return (-1);
    }
    lstrcpy(lpModule , m_lpModuleName);
    lpStr = strstr(lpModule,".");
    if (lpStr) *lpStr = '\0';        

    retCode = SymAddLoadStart(
            m_lpFileName,
            TRUE,
            &m_time );
    if ( retCode != GOOD ) {
        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
        return( FAILURE );
    }
    err = (U16) SymAddModuleOpenByDesc( curModDesc , &moduleOffset , &ul );
    if ( err != GOOD ) {
        m_dwErrorNum = ER_LDR_LOAD_MODULE;      // 0x4021;
        return(-1);
    }
    if ( m_onDemand == FALSE ) {
        m_dwErrorNum = ER_LDR_MOD_INFO_LOADED;  // 0x4022;
        return 0;
    }
    if ( SeekLoadFile( moduleOffset , 0 )   != 0 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        return(-1);
    }
    if ( (err = GetBytes(key , 3)) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        return(-1);
    }                           
    recLen = BinToU16(&key[1]);
    err = LdrOmf51GetModule( recLen , TRUE );
    return(err);               
}

/***************************************************************************
*                                                                          *
*  LdrOmf51LoadModuleByDesc - Load a module local information for OnDemand *
*                   load Only loader block,symbol and linenum information  *
*  parameter :                                                             *
*       offset  --  this module in load file position .                    *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51LoadModuleByDesc( U32 offset ) 
{                    
    int err;                                                       
    U8 key[3];
    U16 recLen; 
    int nOldFlags;
    
    nOldFlags = m_ldrFlags;
    m_ldrFlags = 0x1;
    if ( SeekLoadFile( offset , 0 ) != 0 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }
    if ( (err = GetBytes(key , 3)) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }                           
    recLen = BinToU16( &key[1] );
    err = LdrOmf51GetModule( recLen , TRUE );
    m_ldrFlags = nOldFlags;
    if (err == -1) return(err);               
    
    return 0;
}
                        
/***************************************************************************
*                                                                          *
*  LdrOmf51LoadModule - Load a module information by ldrFlags and onDemand *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51LoadModule(void)
{           
    return 0;
}
                                            
/***************************************************************************
*                                                                          *
*  LdrOmf51LoadFuncType - Load Omf51 function type record information      *
*  parameter :                                                             *
*       ui    ---    function type                                         *
*       len   ---    function type record length                           *
*       typeHdrInfo  ---   type information struct                         *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51LoadFuncType(U16 ui , U16& len ,TYPE_HEADER_TYPE& typeHdrInfo)
{
    int i ;
    U16 uj;
    struct ListDescType *temp ;
    U8 data[256];
    RETCODE retCode;

    i =  1;
    if ( GetBytes(data , 2) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        return(-1);
    }
    else {
        U8 frameType=0, argCount;
        U32 attr;
                
        len -= 2;                 
        uj = (U16) data[0]; 
                
        if ( uj == 0x1F ) {
            if ( GetBytes(&data[2] , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }               
            uj = (U16)(((U16)data[1])<<8) + (U16)data[2];
            uj += (U16) (224 + m_typeDelta);
            len -= 2;
            i = 3;
        }
        else if ( data[0] < 0x20 ) {
            Omf51TypeConv( uj );
        }
        else uj += (U16)(224 + m_typeDelta);
        if ( (data[i] < 0x1F)&&( data[i] != 0) ) {    
            m_dwErrorNum = ER_LDR_FUNC_LIST;    // 0x4015;
            return(-1);
        }

        attr = 0xFFFFFFFF;                                
        typeHdrInfo.t.complexType = TY_FUNC_DEP;
        retCode = SymAddTypeHeader(ui , &typeHdrInfo);
        if ( retCode != GOOD ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
            return( FAILURE );
        }

        if ( data[i] == 0 ) {
            argCount = 0;
            retCode = SymAddTypeFunc(ui,attr,frameType,0L,uj,argCount,0,"");
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
        }
        else {       
            U16 jjj;

            if ( data[i] == 0x1F ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }               
                jjj=(U16)(((U16)data[0])<<8) + (U16)data[1];
                len -= 2;
            }
            else jjj = data[i] ;
            jjj -= 0x20;
            temp = listPtrHeader;
            while ( temp ) {
                if ( temp->num == jjj ) { 
                    argCount = (U8) temp->n;
                    retCode = SymAddTypeFunc(ui,attr,frameType,0L,uj,
                                    argCount,0,"");
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }

                    i = 0;
                    tmpHugePtr = temp->ptr;
                    for( argCount=0 ; (U8)argCount<temp->n ; argCount++ ) {
//                        i += 2;              
                        tmpHugePtr += 2;
//                        uj = (U16) temp->ptr[i]; 
                        uj = (U16) *tmpHugePtr; 
//                        i++;                
                        tmpHugePtr++;
                        if ( uj == 0x1F ) {
//                            uj = (U16)(((U16)temp->ptr[i])<<8);
                            uj = (U16)(((U16)*tmpHugePtr)<<8);
                            tmpHugePtr++;
//                            uj += (U16)temp->ptr[i+1];
                            uj += (U16)*tmpHugePtr;
                            
                            uj += (U16) (224 + m_typeDelta);
//                            i += 2;
                        }
                        else if ( uj < 0x20 ) {
                            Omf51TypeConv( uj );
                        }
                        else uj += (U16)(224 + m_typeDelta);
//                        i += temp->ptr[i] + 1;
                        i = *tmpHugePtr + 1;
                        tmpHugePtr += i;
                        retCode = SymAddTypeFuncParam(ui,uj);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                    break;
                }   
                temp = temp->next;                  
            }
        }
    }                   
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  InitTempStruct - init temp struct link for Omf51 Loader                 *
*  parameter :                                                             *
*       None ( ListDescType and TypeDescType )                             *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void InitTempStruct( void )
{                    
    struct ListDescType *temp ;
    struct TypeDescType *tt ;

    listPtr = listPtrHeader;
    while( listPtr ) {
        temp = listPtr->next;
//        if ( listPtr->ptr ) delete listPtr->ptr;
        if ( listPtr->handle ) {
            GlobalUnlock( listPtr->handle );
            GlobalFree( listPtr->handle );
        }
        delete listPtr;
        listPtr = temp;
    }
    namePtr = nameHeader;
    while( namePtr ) {
        tt = namePtr->next;
        if ( namePtr->ptr ) delete namePtr->ptr;
        delete namePtr;
        namePtr = tt;
    }                           
    listPtrHeader = listPtr = 0;   
    nameHeader = namePtr = 0;
}

/***************************************************************************
*                                                                          *
*  LdrOmf51LoadTypes - Load Omf51 types record information                 *
*  parameter :                                                             *
*       len  ---   type record length                                      *
*                                                                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51LoadTypes(U16 len)
{                                           
    TYPE_HEADER_TYPE typeHdrInfo;
    int i , k , err;
    U8 ch ;
    U16 j , jj;           
    U8 data[256];
    int flag ;           
    U16 ui , uj , uk;
    U32 ul;
    struct ListDescType *temp ;
    struct TypeDescType *tt ;
    char *nullPtr = "\0";
    RETCODE retCode;                       
    long lNum;
        
    InitTempStruct();                    
    if ( m_typeNum ) {
        m_typeDelta += m_typeNum;
        m_typeNum = 0;
    }                         

    typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;

    if ( len > 1 ) flag = 1;
    else flag = 0;  
    j = 0;
    while ( flag ) {
        typeHdrInfo.typeName = nullPtr;                    
        typeHdrInfo.sizeInMAUs = 0;      
        typeHdrInfo.sizeCalculated = FALSE;
    
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
            return(FAILURE);
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( GetOneByte(&ch) == -1 ) {
            m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(FAILURE);                        
        }                            
        len--;
        ui = (U16)(256 + m_typeDelta + j) ;
        j++;
        switch ( ch ) {
        case omf_type_list :
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(FAILURE);
            }             
            ui = BinToU16( data );
            len -= 2;
            if ( listPtrHeader == 0 ) {
                listPtrHeader = listPtr = new ListDescType;
                if ( listPtr == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return (FAILURE);
                }
            }
            else {
                listPtr->next = new ListDescType;
                if ( listPtr->next == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return (FAILURE);
                }
                listPtr = listPtr->next;
            }                        
            listPtr->num = j-1;
//            lNum = (((long)ui)<<6)+4;
            lNum = (((long)ui)*46)+4;
//            if ( lNum <= 0 || lNum >= 0x10000L ) {
//                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;       // 0x4000;
//                return (FAILURE);
//            }
////            listPtr->ptr = new unsigned char[2048];
//            listPtr->ptr = new unsigned char[lNum];
            listPtr->handle = GlobalAlloc(GPTR, lNum);
            listPtr->ptr = (U8 huge *)GlobalLock(listPtr->handle);
//            if ( listPtr->ptr == 0 ) {
            if ( listPtr->ptr == 0 || listPtr->handle == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                return(FAILURE);
            }
            
            tmpHugePtr = listPtr->ptr;
            
            listPtr->n = ui;
//            uj = 0;
            ul = 0;
            for( jj=0 ; jj < ui ; jj++) {           
                if ( GetBytes(data , 4) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(FAILURE);
                }
                len -= 4;
                if ( data[2] == 0x1F ) {
                    if ( GetBytes(&data[4] , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(FAILURE);
                    }
//                    memcpy( &listPtr->ptr[uj] , data , 6 );
                    memcpy( tmpHugePtr , data , 6 );
                    tmpHugePtr += 6;
//                    if ( GetBytes(&listPtr->ptr[uj+6] , data[5]) == -1 ) {
                    if ( GetBytes(tmpHugePtr , data[5]) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(FAILURE);
                    }             
                    len -= (U16) (2+data[5]);
//                    uj += (U16) (6+data[5]) ;
                    ul += (U32) (6+data[5]) ;
                    tmpHugePtr += data[5];
                }
                else {
//                    memcpy( &listPtr->ptr[uj] , data , 4 );
                    memcpy( tmpHugePtr , data , 4 );
                    tmpHugePtr += 4;
//                    if ( GetBytes(&listPtr->ptr[uj+4] , data[3]) == -1 ) {
                    if ( GetBytes(tmpHugePtr , data[3]) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(FAILURE);
                    }             
                    len -= (U16) data[3];
//                    uj += (U16) (4+data[3]);
                    ul += (U32) (4+data[3]);
                    tmpHugePtr += data[3];
                }
            }
            listPtr->num = j-1;
//            listPtr->len = uj;
            listPtr->len = ul;
            break;
        case omf_type_pointer : /* 0x0F */ 
            if ( GetOneByte(data) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(FAILURE);
            }               
            len--;
            uj = (U16) data[0];
            if ( uj == 0x1F ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(FAILURE);
                }               
                uj = (U16)(((U16)data[0])<<8) + (U16)data[1];
                uj += (U16) (224 + m_typeDelta);
                len -= 2;
            } else if ( data[0] < 0x20 ) {
                Omf51TypeConv( uj );
            }
            else uj += (U16) (224 + m_typeDelta);

            typeHdrInfo.sizeCalculated = TRUE;
            typeHdrInfo.sizeInMAUs = 0x03L;
            typeHdrInfo.t.complexType = TY_SMALL_PTR;
            retCode = SymAddTypeHeader(ui , &typeHdrInfo);
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            retCode = SymAddTypePointerTypeIndex(ui , uj);
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            break;
        case omf_type_array : /* 0x10 */
            if ( GetOneByte(data) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(FAILURE);
            }
                               
            len--;
            len -= (U16) (2*data[0])+1;      

            i = (int) data[0];
            if ( GetBytes(data , 2*i+1) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(FAILURE);
            }
            else {
                TYPE_OMF51_ARRAY_STRUCT arr;

                typeHdrInfo.sizeCalculated = FALSE;
                typeHdrInfo.sizeInMAUs = 0;
                typeHdrInfo.t.complexType = TY_OMF51_ARRAY;

                retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
                uj = (U16) data[2*i];
                if ( uj == 0x1F ) {
                    if ( GetBytes(&data[2*i] , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(FAILURE);
                    }               
                    uj = (U16)(((U16)data[2*i])<<8) + (U16)data[2*i+1];
                    uj += (U16) (224 + m_typeDelta);
                    len -= 2;
                }
                else if ( uj < 0x20 ) {
                    Omf51TypeConv( uj );
                }
                else {    
                    uj += (U16) (224 + m_typeDelta);
                }
                                    
                arr.typeIndex = uj;
                arr.dim = (U8) i;
                retCode = SymAddTypeArray51(ui , &arr);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
                for( k = 0; k < i; k++ ) {
                    uk = BinToU16( &data[k*2] );
                    if ( uk ) uk--;
                    if ( GOOD != SymAddTypeArrayDimSize(ui,uk) ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }               
            }
            break;
        case omf_type_func : /* 0x23 */
            if ( GOOD != LdrOmf51LoadFuncType(ui , 
                    len ,typeHdrInfo ) ) {
                return FAILURE ;
            }
            break;
        case omf_type_bitfield : /* 0x13 */
            if ( GetBytes(data , 3) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(FAILURE);
            }                     
            else {                          
                TYPE_BITFIELD_STRUCT bit;
                    
                len -= 3;
                typeHdrInfo.sizeCalculated = FALSE;
                typeHdrInfo.t.complexType = TY_BITFIELD;
                retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
                bit.bitfieldSigned = data[0];
                bit.size = data[2];
                bit.offset = data[1];
                if ( data[0] == 0 )
                    bit.baseTypeIndex = 2 ; // BI_S8_SCHAR ;
                else
                    bit.baseTypeIndex = 4 ; // BI_S16_SINT ;
                retCode = SymAddTypeBitfield(ui , &bit);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
            }
            break;
        case omf_type_type :
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(FAILURE);
            }
            if ( data[0] ) {
                U16 jjj;
                
                uj = (U16) data[0];
                if ( uj == 0x1F ) {
                    if ( GetBytes(&data[2] , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(FAILURE);
                    }               
                    uj=(U16)(((U16)data[1])<<8) + (U16)data[2];
                    uj += (U16)(224 + m_typeDelta);
                    len -= 2;
                    data[1] = data[3];
                }
                else if ( data[0] < 0x20 ) {
                    Omf51TypeConv( uj );
                }
                else uj += (U16)(224 + m_typeDelta);
                len -=  (U16)(2+data[1]);
                typeHdrInfo.sizeCalculated = FALSE;
                typeHdrInfo.t.complexType = TY_TYPE;
                jjj = (U16) data[1];
                if ( GetBytes(data , jjj) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(FAILURE);
                }                      
                data[ jjj ] = '\0';
                typeHdrInfo.typeName = (LPSTR) data;
                retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
                retCode = SymAddTypeTypeIndex(ui , uj);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
            }
            else {
                if ( nameHeader == 0 ) {
                    nameHeader = namePtr = new TypeDescType;
                    if ( nameHeader == 0 ) {
                        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                        return(FAILURE);
                    }
                }
                else {
                    namePtr->next = new TypeDescType;
                    if ( nameHeader->next == 0 ) {
                        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                        return(FAILURE);
                    }
                    namePtr = namePtr->next;
                }
                namePtr->ptr = new unsigned char[ data[1]+1 ];
                if ( namePtr->ptr == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return(FAILURE);
                }
                uj = (U16) data[1];
                namePtr->num = j-1;
                namePtr->len = data[1];
                len -=  (U16)(2+data[1]);
                if ( GetBytes(namePtr->ptr,uj) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(FAILURE);
                }                     
                namePtr->ptr[uj] = '\0';
            }
            break;
        case omf_type_struct :
            if ( GetBytes(data , 4) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }                     
            else {                   
                U16 ti1 , ti2;
                
                len -= 4;
                uj = BinToU16( data ); 
                if ( data[2] == 0x1F ) {
                    if ( GetBytes(&data[4] , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }               
                    ti1=(U16)(((U16)data[3])<<8) + (U16)data[4];
                    len -= 2;
                    data[3] = data[5];
                }
                else ti1 = (U16) data[2] ;  
                if ( data[3] == 0x1F ) {
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }               
                    ti2=(U16)(((U16)data[0])<<8) + (U16)data[1];
                    len -= 2;
                }
                else ti2 = (U16) data[3] ;  
                
                if ( ((ti1!=0)&&(ti1<0x20)) || 
                    ((ti2!=0)&&(ti2<0x20)) ) {
                    m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                typeHdrInfo.sizeCalculated = TRUE;
                typeHdrInfo.sizeInMAUs = (U32) uj;
                typeHdrInfo.t.complexType = TY_STRUCT;
                                                  
                if ( ti2 ) {                                                  
                    tt = nameHeader;
                    while ( tt ) {
                        if ( tt->num == ti2-0x20 ) { 
                            typeHdrInfo.typeName = (LPSTR) tt->ptr;
                            break;
                        }
                        tt = tt->next;                  
                    }
                }
                retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
                                              
                if ( ti1 ) {                                              
                    temp = listPtrHeader;
                    while ( temp ) {
                        if ( temp->num == ti1-0x20 ) { 
                            TYPE_S_U_STRUCT s;
                            U16 nn;

                            tmpHugePtr = temp->ptr;
//                            uk = 0;
                            ul = 0;
                            for( k=0; (unsigned int)k<temp->n ; k++ ) {
//                                uj = BinToU16( &temp->ptr[uk] );
                                uj = BinToU16( tmpHugePtr );
                                tmpHugePtr += 2;
                                s.offset = uj;
//                                nn = temp->ptr[uk+2];
                                nn = *tmpHugePtr;
                                tmpHugePtr++;
                                if ( nn == 0x1F ) {              
//                                    uk += 2;
                                    ul += 2;
//                                    nn=(U16)(((U16)temp->ptr[uk+1])<<8)
//                                            +(U16)temp->ptr[uk+2];
                                    nn=(U16)(((U16)*tmpHugePtr)<<8)
                                            +(U16)(*(tmpHugePtr+1));
                                    tmpHugePtr+=2;
                                    nn += (U16)(224 + m_typeDelta);
                                }
                                else if ( nn < 0x20 ) {
                                    Omf51TypeConv( nn );
                                }
                                else nn += (U16)(224 + m_typeDelta);
                                s.typeIndex = nn;
//                                nn = temp->ptr[uk+3];
                                nn = *tmpHugePtr;
                                tmpHugePtr++;
                                s.name = new char[ nn + 1 ];
                                if ( s.name == 0 ) {
                                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC; // 0x4000;
                                    return(FAILURE);
                                }
//                                memcpy(s.name,&temp->ptr[uk+4],nn);
                                memcpy(s.name,tmpHugePtr,nn);
//                                uk += 4+nn;
                                ul += 4+nn;             
                                tmpHugePtr += nn;
                                s.name[nn] = '\0';
                                retCode = SymAddTypeStructUnion(ui,&s);
                                if ( retCode != GOOD ) {
                                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                    delete s.name;
                                    return( FAILURE );
                                }
                                if ( s.name ) {
                                    delete []s.name ;
                                    s.name = 0;
                                }
                            }
                            break;
                        }
                        temp = temp->next;                  
                    }
                }
            }
            break;
        case omf_type_space_ptr :
            if ( GetOneByte(data) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }               
            len--;
            uj = (U16) data[0];
            if ( uj == 0x1F ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }               
                uj = (U16)(((U16)data[0])<<8) + (U16)data[1];
                uj += (U16) (224 + m_typeDelta);
                len -= 2;
            } else if ( uj < 0x20 ) {
                Omf51TypeConv( uj );
            }
            else uj += (U16) (224 + m_typeDelta);

            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }
            len -= 2;

            typeHdrInfo.sizeCalculated = TRUE;
            typeHdrInfo.sizeInMAUs = (U32) data[0];
            typeHdrInfo.t.complexType = TY_OMF51_PTR;
            retCode = SymAddTypeHeader(ui , &typeHdrInfo);
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            else {
                TYPE_OMF51_PTR_STRUCT omf51Ptr;

                omf51Ptr.typeIndex = uj;
                omf51Ptr.attribute = 2;
                omf51Ptr.ptrSpec = 1;
                switch ( data[1] ) {
                case 1 :
                case 4 :
                    omf51Ptr.memSpace = IDATA_51 ;
                    break;
                case 2 :
                case 3 :
                    omf51Ptr.memSpace = XDATA_51 ;
                    break;
                case 5 :
                    omf51Ptr.memSpace = CODE_51 ;
                    break;
                default :
                    omf51Ptr.memSpace = NONE_51 ;
                    break;
                }
                retCode = SymAddTypePointer51(ui , &omf51Ptr);
            }
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            break;
        case omf_type_gen_ptr :
            if ( GetBytes(data , 8) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }                            
            
            len -= 8;

            uj = (U16) data[7];
            if ( uj == 0x1F ) {
                if ( GetBytes(&data[8] , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }               
                uj = (U16)(((U16)data[8])<<8) + (U16)data[9];
                uj += (U16) (224 + m_typeDelta);
                len -= 2;
            } else if ( uj < 0x20 ) {
                Omf51TypeConv( uj );
            }
            else uj += (U16) (224 + m_typeDelta);

            typeHdrInfo.sizeCalculated = TRUE;
            typeHdrInfo.sizeInMAUs = (U32) ( data[1] >> 3 );
            typeHdrInfo.t.complexType = TY_OMF51_PTR;
            retCode = SymAddTypeHeader(ui , &typeHdrInfo);
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            else {
                TYPE_OMF51_PTR_STRUCT omf51Ptr;

                omf51Ptr.typeIndex = uj;
                omf51Ptr.attribute = data[0];
                omf51Ptr.ptrSpec = data[3];
                switch ( data[2] ) {
                case 1 :
                case 4 :
                    omf51Ptr.memSpace = IDATA_51 ;
                    break;
                case 2 :
                case 3 :
                    omf51Ptr.memSpace = XDATA_51 ;
                    break;
                case 5 :
                    omf51Ptr.memSpace = CODE_51 ;
                    break;
                default :
                    omf51Ptr.memSpace = NONE_51 ;
                    break;
                }
                retCode = SymAddTypePointer51(ui , &omf51Ptr);
            }
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            break;
        default :
#ifdef _DUMP_
            Message("\r\n???Unknown type record at file %lx",
                        GetFileCurPos()-1);
#endif
            m_dwErrorNum = ER_LDR_TYPE;     // 0x4016;
            return(-1);
        }               
        if ( len <= 1 ) {
            if ( GetOneByte(data) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }
            len--;
            flag = 0;
        }
    }
    m_typeNum = (U32) j;
    return(0);
}                                  

/***************************************************************************
*                                                                          *
*  LdrOmf51GetModule - Load Omf51 one module information                   *
*  parameter :                                                             *
*       reclen  --  record length                                          *
*       onDemandFlag -- on demand load flag                                *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrOmf51GetModule(U16 recLen , BOOL onDemandFlag) 
{
    SYM_DESCRIPTOR moduleDesc;
    int flag , firstFlag , symFlag , codeFlag ;
    int err;
    U8 ch ,*ptrData;           
    U8 data[LDR_BUFSIZE];
    U16 ui , uj , len;
//    char *tmpFileName;
    RETCODE retCode;
    
    ClearUpModuleBlock();
                           
    firstFlag = 1;                       
    curBlock = 0;
    symFlag = LOAD_SYM(m_ldrFlags);
    codeFlag = LOAD_CODE(m_ldrFlags);
    len = recLen;

    start = DEFAULT_START_ADDR;
    end = DEFAULT_END_ADDR;
    bAddSymbol = TRUE;

    
    while ( firstFlag || !onDemandFlag ) {
        ModuleNodeInit();                       
        
		nFixAddFuncType = 0;
		
        if ( GetOneByte(&ch) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
        if ( ch != 0 ) {
            m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        } 
        m_modNode.offset = m_uBufInFilePos + m_uBufPos - 4 ;
        m_modNode.time.day = -1;
        m_modNode.time.hour = -1;
        if ( GetBytes(data , len-1) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
        if(m_modNode.name)
            delete m_modNode.name;
        m_modNode.name = new char[ data[0]+1 ];
        ASSERT( m_modNode.name );
        memcpy( m_modNode.name , (LPSTR) &data[1] , data[0] );
        m_modNode.name[data[0]] = '\0';
        
        firstFlag = 0;

        symFlag = LOAD_SYM(m_ldrFlags);
        bAddSymbol = TRUE;
        
        if ( m_modNode.name[0] == '?' && !m_bSpecSymbol ) {
            bAddSymbol = FALSE;
            symFlag = 0; 
        }
       
       //for load n times 
        if(IsModuleExist(m_modNode.name)){
           symFlag = 0;
        }
        start = DEFAULT_START_ADDR;
        end = DEFAULT_END_ADDR;

        flag = 1;
        m_modNode.scope = 1;
        
        if ( symFlag ) {
            GetLstFileInfo();   
            if ( onDemandFlag == TRUE ) {
                moduleDesc = curModDesc;
            }
            else {
                LPSTR modName;
                if ( m_lstFileInfo ) modName = m_lstFileInfo->modName;
                else modName =  m_modNode.name;
                retCode = SymAddModuleCreate(
                    modName,            // for PL/M-51 mod name
                    &m_modNode.time ,
                    &m_modNode.codeaddr ,
                    m_modNode.offset ,
                    (BOOLEAN) m_onDemand ,
                    0,
                    &moduleDesc );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
                curModDesc = moduleDesc;
            }
        }
        
        if ( GetBytes(data , 3) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
        ch = data[0];
        len = BinToU16(&data[1]);
        while ( flag ) {
            if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            } 
            if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
                if ( IsLoadCanceled() ) {
                    m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                    return( -1 );
                }                  
                TestMessage();
            }
            switch( ch ) {
            case omf_end_module : /* 0x04 */    
            
//// Old is marked , Changed for Assemble Source

                if ( symFlag ) {
                    QUAL_ADDR_RANGE_TYPE qaddr;
                    m_modNode.codeaddr.segType = ( SEGMENTTYPE ) SEG_CODE;
                    m_modNode.codeaddr.startAddr = start;
                    m_modNode.codeaddr.endAddr = end;
                    qaddr.startAddr = start;
                    qaddr.endAddr = end;
                    qaddr.startValid = TRUE;
                    qaddr.endValid = TRUE;                      
                    if ( start > end ) {
                        qaddr.startValid = FALSE;
                        qaddr.endValid = FALSE;
                    }
                                                
                    if ( symFlag && m_modNode.linecnt > 0 ) {
                        retCode = SymAddLinenumEnd();
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                    if ( onDemandFlag == FALSE ) {
                        retCode = SymAddModuleClose( 
                            (BOOLEAN) (!m_onDemand) );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }                           
                    else {
                        retCode = SymAddModuleClose( TRUE );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                    if ( qaddr.startValid || qaddr.endValid )
                    {
                        if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                           if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                qaddr.endAddr != DEFAULT_END_ADDR ) {
                               ConvertAddrToBank(qaddr.startAddr);
                               ConvertAddrToBank(qaddr.endAddr);
                           }
                         }  
                        if(m_IsBankSwitchOn){
                           if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                qaddr.endAddr != DEFAULT_END_ADDR ) {
                                qaddr.startAddr |= (U32(m_nBankNum)<<16);     
                                qaddr.endAddr |= (U32(m_nBankNum)<<16);     
                            }
                         }
                        retCode = SymAddSymbolSetAddr( &qaddr );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                   	if (m_lstFileInfo) m_lstFileInfo->FuncSetAddr();
                    ClearUpModuleBlock();
                }              

                if ( SeekLoadFile( -3L , 1 ) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                return(0);       
                break;
            case omf_seg_define : /* 0x0E */
                if ( len < LDR_BUFSIZE ) {
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }                            
                }
                else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                }
                break;
            case omf_pub_define : /* 0x16 */
                if ( symFlag && !onDemandFlag ) {
                    if ( (err = GetOmf51Symbol(len , 0)) == -1 ) {
                        return(-1);                        
                    }                                   
                    m_modNode.symno += err;
                }                             
                else if ( !symFlag && !bAddSymbol ) {
                    if ( (err = GetOmf51Symbol(len , 0)) == -1 ) {
                        return(-1);                        
                    }                                   
                }
                else {
                    if ( len < LDR_BUFSIZE ) {
                        if ( GetBytes(data , len) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);                        
                        }                            
                    }
                    else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                }   
                break;
            case omf_ext_define : /* 0x18 */                    
                if ( len < LDR_BUFSIZE ) {
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }                            
                }
                else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                break;
            case omf_debug_rec : /* 0x12 */
            case omf_c51_debug_rec : /* 0x22 */
                if ( symFlag ) {
                    if ( GetOneByte(data) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }                                
                    len--;
                    switch( data[0] ) {
                    case 0 :
                        if ( m_modNode.scope <= 1 ) {
                            if ( m_onDemand && (!onDemandFlag) ) {
                                if ( len < LDR_BUFSIZE ) {
                                    if ( GetBytes(data , len) == -1 ) {
                                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                        m_bDispOff = 1;
                                        m_dwOffset = GetFileCurPos();
                                        return(-1);                        
                                    }                            
                                }
                                else if (SeekLoadFile((U32)len,1)==-1) {
                                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                    m_bDispOff = 1;
                                    m_dwOffset = GetFileCurPos();
                                    return(-1);
                                }
                            }
                            else if ((err=GetOmf51Symbol(len,2))==-1) {
                                return(-1);
                            }
                            else {
                                m_modNode.symno += err;
                            }
                        }
                        else if ( !m_onDemand || onDemandFlag ) {
                            if ( (err=GetOmf51Symbol(len,2)) == -1 ) {
                                return(-1);
                            }
                            curBlock->localsymno += err;
                        }
                        else if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {    
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    case 1 :
                        if ( !onDemandFlag ) {
                            if ( (err=GetOmf51Symbol(len,0)) == -1 ) {
                                return(-1);
                            }
                            m_modNode.symno += err;
                        }
                        else if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    case 2 :
                        if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    case 3 :
                        if ( !m_onDemand || onDemandFlag ) {
                            if ( (err=GetOmf51LineInfo(len))==-1 ) {
                                return(-1);
                            }
                            m_modNode.linecnt += err;
                        }
                        else if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    default :
#ifdef _DUMP_
                        Message("\r\n???Unknown record at file %lx",
                            GetFileCurPos()-4);
#endif
                        m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }               
                }
                else if ( !symFlag && !bAddSymbol ) {
                    if ( GetOneByte(data) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }                                
                    len--;
                    switch( data[0] ) {
                    case 0 :
                        if ( m_modNode.scope <= 1 ) {
                            if ( m_onDemand && (!onDemandFlag) ) {
                                if ( len < LDR_BUFSIZE ) {
                                    if ( GetBytes(data , len) == -1 ) {
                                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                        m_bDispOff = 1;
                                        m_dwOffset = GetFileCurPos();
                                        return(-1);                        
                                    }                            
                                }
                                else if (SeekLoadFile((U32)len,1)==-1) {
                                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                    m_bDispOff = 1;
                                    m_dwOffset = GetFileCurPos();
                                    return(-1);
                                }
                            }
                            else if ((err=GetOmf51Symbol(len,2))==-1) {
                                return(-1);
                            }
                        }
                        else if ( !m_onDemand || onDemandFlag ) {
                            if ( (err=GetOmf51Symbol(len,2)) == -1 ) {
                                return(-1);
                            }
                        }
                        else if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {    
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    case 1 :
                        if ( !onDemandFlag ) {
                            if ( (err=GetOmf51Symbol(len,0)) == -1 ) {
                                return(-1);
                            }
                        }
                        else if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    case 2 :
                        if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    case 3 :
                        if ( len < LDR_BUFSIZE ) {
                            if ( GetBytes(data , len) == -1 ) {
                                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                                m_bDispOff = 1;
                                m_dwOffset = GetFileCurPos();
                                return(-1);                        
                            }                            
                        }
                        else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        break;
                    default :
#ifdef _DUMP_
                        Message("\r\n???Unknown record at file %lx",
                            GetFileCurPos()-4);
#endif
                        m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }               
                }
                else if ( len < LDR_BUFSIZE ) {
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }                            
                }
                else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                break;          
            case omf_scope_rec : /* 0x10 */
                if ( m_modNode.scope == 0 ) {
                    flag = 0;
////////// Old is Marked , Changed for Assemble Source
                    if ( symFlag ) {   
                        QUAL_ADDR_RANGE_TYPE qaddr;
                        m_modNode.codeaddr.endAddr = ( SEGMENTTYPE ) SEG_CODE;
                        m_modNode.codeaddr.startAddr = start;
                        m_modNode.codeaddr.endAddr = end;
                        qaddr.startAddr = start;
                        qaddr.endAddr = end;
                        qaddr.startValid = TRUE;
                        qaddr.endValid = TRUE;                      
                        if ( start > end ) {
                            qaddr.startValid = FALSE;
                            qaddr.endValid = FALSE;
                        }
                                                
                        if ( symFlag && m_modNode.linecnt > 0 ) {
                            retCode = SymAddLinenumEnd();
                            if ( retCode != GOOD ) {
                                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                return( FAILURE );
                            }
                        }
                
                        if ( onDemandFlag == FALSE ) {
                            retCode = SymAddModuleClose( 
                                (BOOLEAN)(!m_onDemand) );
                            if ( retCode != GOOD ) {
                                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                return( FAILURE );
                            }
                        }
                        else {
                            retCode = SymAddModuleClose( TRUE );
                            if ( retCode != GOOD ) {
                                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                return( FAILURE );
                            }
                        } 
                        if ( qaddr.startValid || qaddr.endValid )
                        {
                            if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                               if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                    qaddr.endAddr != DEFAULT_END_ADDR ) {
                                    ConvertAddrToBank(qaddr.startAddr);
                                    ConvertAddrToBank(qaddr.endAddr);
                               }
                            }
                            if(m_IsBankSwitchOn){
                               if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                    qaddr.endAddr != DEFAULT_END_ADDR ) {
                                     qaddr.startAddr |= (U32(m_nBankNum)<<16);     
                                     qaddr.endAddr |= (U32(m_nBankNum)<<16);     
                                }
                             }
                            retCode = SymAddSymbolSetAddr( &qaddr );
                            if ( retCode != GOOD ) {
                                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                return( FAILURE );
                            }
                        }
                    	if (m_lstFileInfo) m_lstFileInfo->FuncSetAddr();
                        ClearUpModuleBlock();
                    }
///////////////////////////////////

                    continue;
                }   
                if ( GetOneByte(data) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }       
                len--;
                if ( (!symFlag&&data[0]!=3) || 
                    (m_onDemand && !onDemandFlag && data[0] != 3) ) {
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    break;
                }                   
                
                switch( data[0] ) {
                case 0 :                       
                    m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                    break;
                case 1 :
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( m_modNode.scope < 2 ) {
                        m_dwErrorNum = ER_LDR_SCOPE;        // 0x4019;
                        return(-1);
                    }
                    else if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                        FUNC_CLASS funcClass;
                        
                        curBlock->son = new BlockBlock;
                        ASSERT( curBlock->son );                        
                        curBlock->son->father = curBlock ;
                        curBlock = curBlock->son;
                        m_modNode.scope++;
                        curBlock->scope = m_modNode.scope;
                        curBlock->codeaddr.segType = ( SEGMENTTYPE ) SEG_CODE;
                        curBlock->codeaddr.startAddr = DEFAULT_START_ADDR ;
                        curBlock->codeaddr.endAddr = DEFAULT_END_ADDR ;
                        curBlock->srcRange.lineNumStart = 0xFFFF;
                        curBlock->srcRange.lineNumEnd = 0;
                        
                        curBlock->funcName = new char[data[0]+1];
                        memcpy( curBlock->funcName , &data[1] , data[0] );
                        curBlock->funcName[ data[0] ] = '\0';
                        if ( curBlock->scope != 2 ) funcClass = FUNC_LOCAL ;
                        else funcClass = FUNC_GLOBAL;
                        curBlock->srcRange.columnStart = 1;
                        curBlock->srcRange.columnEnd = 0;
                        retCode = SymAddFuncCreate(     
                                    "",
                                    funcClass ,
                                    curBlock->stacksize ,
                                    &curBlock->codeaddr ,
                                    0 );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }               
                    else m_modNode.scope++;
                    break;
                case 2 :                            
                //for bank switching
                case 0x10:
                case 0x11:
                case 0x12:
                case 0x13:
                    if(m_IsBankSwitchOn){
                       if(data[0]>2)
                          m_nBankNum=data[0]-0x10;
                       else m_nBankNum = 0;
                    }
                    else m_nBankNum = 0;
                    if ( m_modNode.scope != 1 ) {
                        m_dwErrorNum = ER_LDR_SCOPE;        // 0x4019;
                        return(-1);
                    }
                    m_modNode.scope++;
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( symFlag && (onDemandFlag || !m_onDemand) ) {
                        FUNC_CLASS funcClass;
                        
                        curBlock = new BlockBlock;
                        if ( curBlock == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                            return(FAILURE);
                        }
                
                        curBlock->scope = m_modNode.scope;
                        curBlock->codeaddr.segType = ( SEGMENTTYPE ) SEG_CODE ;
                        curBlock->codeaddr.startAddr = DEFAULT_START_ADDR ;
                        curBlock->codeaddr.endAddr = DEFAULT_END_ADDR ;
                        curBlock->srcRange.lineNumStart = 0xFFFF;
                        curBlock->srcRange.lineNumEnd = 0;
                        
                        curBlock->funcName = new char[data[0]+1];
                        if ( curBlock->funcName == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000 ;
                            return( FAILURE );
                        }
                        memcpy( curBlock->funcName , &data[1] , data[0] );
                        curBlock->funcName[ data[0] ] = '\0';
                        if ( curBlock->scope != 2 ) funcClass = FUNC_LOCAL ;
                        else funcClass = FUNC_GLOBAL;
                        curBlock->srcRange.columnStart = 1;
                        curBlock->srcRange.columnEnd = 0;
                        Omf51MatchFuncType( curBlock->funcName , curBlock->typeIndex );
                        
						if ( curBlock->typeIndex==0 && m_lstFileInfo ) {
							if ( nFixAddFuncType == 0 ) {
							    TYPE_HEADER_TYPE typeHdrInfo;
							    char *nullPtr = "\0";
							    
								m_typeNum++;							
						        nFixAddFuncType = 256 + m_typeDelta + m_typeNum;

						        typeHdrInfo.typeName = nullPtr;                    
						        typeHdrInfo.sizeInMAUs = 0;      
						        typeHdrInfo.sizeCalculated = FALSE;
						        typeHdrInfo.t.complexType = TY_FUNC_DEP;
							    typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
						        retCode = SymAddTypeHeader(nFixAddFuncType , &typeHdrInfo);
						        if ( retCode != GOOD ) {
						            m_dwErrorNum = ER_LDR_SYM_SERVER;	// 0x4025;
						            return( FAILURE );
						        }
					            retCode = SymAddTypeFunc(nFixAddFuncType, 0L, 0, 0L,
					            			0, 0 ,0,"");
						        if ( retCode != GOOD ) {
						            m_dwErrorNum = ER_LDR_SYM_SERVER;	// 0x4025;
						            return( FAILURE );
						        }
							}
							curBlock->typeIndex = nFixAddFuncType;
						}
                        retCode = SymAddFuncCreate(     
                                    curBlock->funcName ,
                                    funcClass ,
                                    curBlock->stacksize ,
                                    &curBlock->codeaddr ,
                                    curBlock->typeIndex );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                    break;
                case 3 :
                    if ( m_modNode.scope != 1 ) {
                        m_dwErrorNum = ER_LDR_MODULE_FORMAT;    // 0x401A;
                        return (-1);
                    }
                    m_modNode.scope--;
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( symFlag && (onDemandFlag || !m_onDemand) ) {
                        data[ data[0] + 1 ] = '\0';
                        if (memcmp(m_modNode.name,&data[1],data[0])!=0) {
                            m_dwErrorNum = ER_LDR_MODNAME_NOT_MATCH;    // 0x401B;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                    }

// Added by Gates Hua , for module range
// 10/9/95
                    break;
                case 4 :
                    if ( m_modNode.scope <= 2 ) {
                        m_dwErrorNum = ER_LDR_SCOPE;        // 0x4019;
                        return(-1);
                    }
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                        if (curBlock) {
                            if (curBlock->father->codeaddr.startAddr
                                > curBlock->codeaddr.startAddr) {
                                curBlock->father->codeaddr.startAddr =
                                    curBlock->codeaddr.startAddr;
                            }
                            if (curBlock->father->codeaddr.endAddr
                                < curBlock->codeaddr.endAddr) {
                                curBlock->father->codeaddr.endAddr =
                                    curBlock->codeaddr.endAddr;
                            }
                            QUAL_ADDR_RANGE_TYPE qaddr;
                            qaddr.startAddr = curBlock->codeaddr.startAddr;
                            qaddr.endAddr = curBlock->codeaddr.endAddr;
                            qaddr.startValid = TRUE;
                            qaddr.endValid = TRUE;                      
                            if ( qaddr.startAddr > qaddr.endAddr ) {
                                qaddr.startValid = FALSE;
                                qaddr.endValid = FALSE;
                            }
                        
                            retCode = SymAddFuncClose();
                            if ( retCode != GOOD ) {
                                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                return( FAILURE );
                            }                            
                            if ( qaddr.startValid || qaddr.endValid ) { 
                                //for load to different bank
                                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                                   if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                        qaddr.endAddr != DEFAULT_END_ADDR ) {
                                        ConvertAddrToBank(qaddr.startAddr);
                                        ConvertAddrToBank(qaddr.endAddr);
                                   }
                                }
                                if(m_IsBankSwitchOn){
                                   if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                        qaddr.endAddr != DEFAULT_END_ADDR ) {
                                        qaddr.startAddr |= (U32(m_nBankNum)<<16);     
                                        qaddr.endAddr |= (U32(m_nBankNum)<<16);     
                                    }
                                }
                                retCode = SymAddSymbolSetAddr( &qaddr );
                                if ( retCode != GOOD ) {
                                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                    return( FAILURE );
                                }
                            }
//                          else if ( !m_lstFileInfo ) GetLstFileInfo();
                                                          
                            if ( curBlock->father ) {                                                         
                                curBlock = curBlock->father;
                                ClearUpBlockBlock(curBlock->son);
                                delete curBlock->son;
                                curBlock->son = 0;
                            }
                            else {
                                ClearUpBlockBlock(curBlock);
                                delete curBlock;
                                curBlock = 0;
                            }
                        }                 
                        else {
                            m_dwErrorNum = ER_LDR_BLOCK_INFO;       // 0x401C;
                            return(-1);
                        }
                    }
                    m_modNode.scope--;
                    break;
                case 5 : 
                    if ( m_modNode.scope != 2 ) {
                        m_dwErrorNum = ER_LDR_SCOPE;        // 0x4019;
                        return(-1);
                    }
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                        data[ data[0] + 1 ] = '\0';
                        if ( curBlock ) {
                            QUAL_ADDR_RANGE_TYPE qaddr;
                            qaddr.startAddr = curBlock->codeaddr.startAddr;
                            qaddr.endAddr = curBlock->codeaddr.endAddr;
                            qaddr.startValid = TRUE;
                            qaddr.endValid = TRUE;                      
                            if ( qaddr.startAddr > qaddr.endAddr ) {
                                qaddr.startValid = FALSE;
                                qaddr.endValid = FALSE;
                            }
                        
                            retCode = SymAddFuncClose();
                            if ( retCode != GOOD ) {
                                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                return( FAILURE );
                            } 
                            if ( qaddr.startValid || qaddr.endValid )
                            {
                                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                                   if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                        qaddr.endAddr != DEFAULT_END_ADDR ) {
                                        ConvertAddrToBank(qaddr.startAddr);
                                        ConvertAddrToBank(qaddr.endAddr);
                                   }
                                }
                                if(m_IsBankSwitchOn){
                                   if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                        qaddr.endAddr != DEFAULT_END_ADDR ) {
                                        qaddr.startAddr |= (U32(m_nBankNum)<<16);     
                                        qaddr.endAddr |= (U32(m_nBankNum)<<16);     
                                    }
                                }
                                retCode = SymAddSymbolSetAddr( &qaddr );
                                if ( retCode != GOOD ) {
                                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                                    return( FAILURE );
                                }
                            }
                            
                            if ( curBlock->father ) {
                                curBlock = curBlock->father;
                                ClearUpBlockBlock(curBlock->son);
                                delete curBlock->son;
                                curBlock->son = 0;
                            }
                            else {
                                ClearUpBlockBlock(curBlock);
                                delete curBlock;
                                curBlock = 0;
                            }
                        }
                        else {
                            m_dwErrorNum = ER_LDR_BLOCK_INFO;       // 0x401C;
                            return(-1);
                        }
                    }
                    m_modNode.scope--;
                    break;
                default :  
#ifdef _DUMP_
                    Message("\r\n???Unknown record at file %lx",
                            GetFileCurPos()-3);
#endif
                    m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                break;
            case omf_content_data : /* 0x06 */
                U8 nBankNum ;
                //for bank-switching
                
                if (GetBytes(data , 3) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                if(m_IsBankSwitchOn){
                   nBankNum = data[0];
                   if(!(nBankNum==0||(nBankNum>=0x10&&nBankNum<=0x13))){
                      m_dwErrorNum = ER_LDR_OUTOF_BANKNUM;
                      return -1;
                   }
                }       
                else if( data[0] != 0 ) {
                      m_dwErrorNum = ER_LDR_RELOC_ADDR; // 0x401E;
                      return(-1);
                }
                ui = BinToU16(&data[1]);
                uj = len - 4;
                if ( uj < 256 ) {                   
                    ptrData = new unsigned char[uj+1];
                    ASSERT( ptrData );
                    if ( GetBytes( ptrData , uj+1) == -1 ) {
                        delete ptrData;
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( codeFlag ) {           
                        ADDR stAddr , endAddr;

                        stAddr.addr = (unsigned short)ui;
                        endAddr.addr= (unsigned short)(ui+uj-1);
                        if(g_nBankNum)
                           stAddr.addrType = endAddr.addrType = 6;
                        else
                           stAddr.addrType = endAddr.addrType = 1;
                           
#ifdef _ZLR_                    
                        if(!AbiMyFill(stAddr,endAddr,(char *)ptrData,uj,nBankNum)){
                           delete ptrData;
                           return -1;
                        }
#endif                  
                        uLoadBytes += (U32)uj;
                    }
                }
                else {
                    U16 ii;
                    
                    ii = ui;
                    ptrData = new unsigned char[257];
                    if ( ptrData == 0 ) {
                        delete ptrData;
                        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                        return(FAILURE);
                    }
                    
                    while( uj > 255 ) {
                        if ( GetBytes( ptrData , 255) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            delete ptrData;
                            return(-1);
                        }
                        if ( codeFlag ) {           
                            ADDR stAddr , endAddr;

                            stAddr.addr = (unsigned short)ii;
                            endAddr.addr= (unsigned short)(ii+254);
                            if(g_nBankNum)
                               stAddr.addrType = endAddr.addrType = 6;
                            else
                               stAddr.addrType = endAddr.addrType = 1;
#ifdef _ZLR_                    
                            if(!AbiMyFill(stAddr,endAddr,(char *)ptrData,255,nBankNum)){
                               delete ptrData;
                               return -1;
                            }
#endif                  
                            uLoadBytes += 255L;
                        } 
                        ii += 255;
                        uj -= 255;
                    }
                    if ( GetBytes( ptrData , uj+1) == -1 ) {
                        delete ptrData;
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    if ( uj && codeFlag )   {           
                        ADDR stAddr , endAddr;

                        stAddr.addr = (unsigned short)ii;
                        endAddr.addr= (unsigned short)(ii+uj-1);
                        if(g_nBankNum)
                           stAddr.addrType = endAddr.addrType = 6;
                        else
                           stAddr.addrType = endAddr.addrType = 1;
#ifdef _ZLR_                    
                        if(!AbiMyFill(stAddr,endAddr,(char *)ptrData,uj,nBankNum)){
                           delete ptrData;
                           return -1;
                        }
#endif                  
                        uLoadBytes += (U32)uj;
                    } 
                }
                if(ptrData) delete ptrData;
                break;
            case omf_fixup_data : /* 0x08 */
#ifdef _GATES           
//                Warning("Fixed-up Data is meeting!");
#endif                
                if ( len < LDR_BUFSIZE ) {
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }                            
                }
                else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                break;
            case omf_type_def : /* 0x20 */
                if ( symFlag && !onDemandFlag ) {
                    if ( LdrOmf51LoadTypes( len ) == -1 ) {
                        return(-1);
                    }       
                }
                else if ( len < LDR_BUFSIZE ) {
                    if ( GetBytes(data , len) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }                            
                }
                else if ( SeekLoadFile( (U32)len,1 ) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                break;
            case omf_srcname_rec : /* 0x24 */
                if ( GetBytes(data , len) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
#ifdef _DUMP_
                data[len-1] = '\0';
                Message("   Source File Name:%s",data+4);
#endif
                break;
            default :
#ifdef _DUMP_
                Message("\r\n???Unknown record at file %lx",
                            GetFileCurPos()-3);
#endif
                m_dwErrorNum = ER_LDR_OMF51_FORMAT;     // 0x401F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
                break;
            }        
            if ( GetBytes(data , 3) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                     
            ch = data[0];
            len = BinToU16(&data[1]);
        }       
    }
    
    return 0;
}   

/***************************************************************************
*                                                                          *
*  Omf51ProcessModSym - Load Omf51 module symbol or global information     *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::Omf51ProcessModSym(U8 nBankNum/*=0*/)
{
    U32 address;     
    U16 ui;     
    RETCODE retCode;
    
    VAR_STORAGE_CLASS varStorage;
    VAR_REGISTER_CLASS registerClass;
//    BOOL isConst , isValid ;
    BOOLEAN isConst , isValid ;
    ADD_VAR_ADDR_UNION addr;
    SYM_DESCRIPTOR symDesc;
    
//  registerClass = LIVING_REG;
    registerClass = NOT_REG;
    if ( SymDefInfo[0] == 0 ) varStorage = GLOBAL_VAR_CLASS;                       
    else if ( SymDefInfo[0] == 1 ) varStorage = GLOBAL_VAR_CLASS ;
    else if ( SymDefInfo[0] == 2 ) varStorage = STATIC_VAR_CLASS ;
    else varStorage = UNKNOWN_VAR_CLASS ;
    if ( SymDefInfo[10] == '?' && !m_bSpecSymbol ) return GOOD;
    
    address = BinToU32(&SymDefInfo[3]);
    if(m_IsBankSwitchOn)
       address |= (U32(nBankNum)<<16); //for bankswitching ,added by dragon
    else if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL)
       address |= (U32(m_bLoadToBank-6)<<16);
    isValid = TRUE;
    if ( (SymDefInfo[1]&0x07) == 5 ) isConst = TRUE;
    else isConst = FALSE;

    addr.addr.addr = address;
    Omf51SegIdToEnum(SymDefInfo[1],&addr.addr.segType); 
    ui = BinToU16(&SymDefInfo[8]);
    if (ui == 0 && m_lstFileInfo) 
    	ui = m_lstFileInfo->SymGetType((LPSTR)&SymDefInfo[10]);
    retCode = SymAddVar((LPSTR)&SymDefInfo[10],ui,varStorage,
                registerClass,&addr,
                isConst,isValid,&symDesc);
    if ( retCode != GOOD ) {
        if ( varExtHdrPtr ) {
            varExtPtr->next = new StoreExtendVar;
            if ( varExtPtr->next == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                return( FAILURE );
            }
            varExtPtr = varExtPtr->next;
            memcpy( varExtPtr->SymDefInfo , SymDefInfo , 51 );
        }
        else {          
            varExtHdrPtr = varExtPtr = new StoreExtendVar;
            if ( varExtPtr == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                return( FAILURE );
            }
            memcpy( varExtPtr->SymDefInfo , SymDefInfo , 51 );
        }
    }
    return 0;
}

/***************************************************************************
*                                                                          *
*  GetOmf51LineInfo - Get one module line information                      *
*  parameter :                                                             *
*       len  ---   line information length                                 *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::GetOmf51LineInfo(U16 len)
{
    U16 ui,um; 
    U32 uj; 
    int i;                    
    U8 nBankNum, data[6];
    LINENUM_TYPE srcState;
    ADDRESS_TYPE addrState;    
    U8 col;         
    RETCODE retCode;

    col = 1;

    if ( m_modNode.linecnt == 0 ) {
        retCode = SymAddLinenumStart(curModDesc);
        if ( retCode != GOOD ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
            return( FAILURE );
        }
    }
          
    i = 0;      
    ui = 0 ;
    while (ui < (len-1) ) {
        memset( LineNumInfo , 0 , 16 );
        if ( GetBytes(data , 5) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }
      //for bank switching
       if(m_IsBankSwitchOn){
          nBankNum = data[0];
          if(!(nBankNum==0||(nBankNum>=0x10&&nBankNum<=0x13))){
              m_dwErrorNum = ER_LDR_OUTOF_BANKNUM;
              return -1;
          }
          if(nBankNum)  nBankNum = U8(nBankNum-0x10);
       }
       else if ( data[0] != 0 ) {
            m_dwErrorNum = ER_LDR_RELOC_SYM;    // 0x4018;
            return(-1);
        }
        memcpy( LineNumInfo , &data[1] , 4 );
        uj = (U32)BinToU16(&data[1]);
        
        if ( start > uj ) start = uj;
        if ( end < uj ) end = uj;
        
        if ( curBlock ) {
            if (curBlock->codeaddr.startAddr > uj ) 
                curBlock->codeaddr.startAddr =  uj;
            if (curBlock->codeaddr.endAddr < uj ) 
                curBlock->codeaddr.endAddr = uj;
        }                   
        
        um = BinToU16(&data[3]);        

        if ( curBlock ) {
            if (curBlock->srcRange.lineNumStart > um ) 
                curBlock->srcRange.lineNumStart = um;
            if (curBlock->srcRange.lineNumEnd < um ) 
                curBlock->srcRange.lineNumEnd = um;
        }                   
            
        srcState=um;
        addrState.addr = uj;
        //for load to specified bank
        if(m_IsBankSwitchOn)
           addrState.addr |= (U32(nBankNum)<<16);
        else if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
           if(addrState.addr!=DEFAULT_START_ADDR){
              ConvertAddrToBank(addrState.addr);     
           }
        }      
        addrState.segType = ( SEGMENTTYPE ) SEG_CODE;

        if ( m_lstFileInfo && m_lstFileInfo->lineNum ) {
            if ( srcState != 1 ) {
                m_lstFileInfo->MapLine(srcState,addrState.addr); 
                retCode = SymAddLinenum(srcState,col,addrState.addr);
            }
            else retCode = GOOD;
        }
        else retCode = SymAddLinenum(srcState,col,addrState.addr);
        if ( retCode != GOOD ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
            return( FAILURE );
        }

        i++;
        ui += 5;
    }
    if (ui == (len-1) ) {
        if ( GetOneByte(data) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        }
    }
    else {
        m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014; 
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }
    return( i );
}           

/***************************************************************************
*                                                                          *
*  GetOmf51Symbol - Get symbol information                                 *
*  parameter :                                                             *
*       len  ---   symbol information length                               *
*       mode ---   symbol mode  ( 0 - public  ,  1 - block )               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::GetOmf51Symbol(U16 len , U8 mode)
{
    U16 ui , uj;
    int i;                    
    U8 nBankNum, data[9];
          
    i = 0;      
    ui = 0 ; 
    
    while ( ui < (len-1) ) {
        memset( SymDefInfo , 0 , 51 );
        if ( GetBytes(data , 6) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
            //for bank switching
        if(m_IsBankSwitchOn){
           nBankNum = data[0];
           if(!(nBankNum==0||(nBankNum>=0x10&&nBankNum<=0x13))){
              m_dwErrorNum = ER_LDR_OUTOF_BANKNUM;
              return -1;
           }
           if(nBankNum)  nBankNum = U8(nBankNum-0x10);
        }
        else if( data[0] != 0 ) {
               m_dwErrorNum = ER_LDR_RELOC_SYM; // 0x4018;
              return(-1);
        }
        SymDefInfo[0] = mode;
        SymDefInfo[1] = data[1];
        memcpy( &SymDefInfo[3] , &data[2] , 2 );
        SymDefInfo[8] = data[4];
        if ( SymDefInfo[8] == 0x1F ) {
            if ( GetBytes(&data[6] , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                         
            ui += 2;
            SymDefInfo[8] = data[6];
            SymDefInfo[9] = data[5];
            uj = BinToU16(&SymDefInfo[8]);
            Omf51TypeConv( uj );
            if ( m_absflag ) {
                SymDefInfo[9] = (U8) ( (uj&0xFF00) >> 8 );
                SymDefInfo[8] = (U8) ( uj&0x00FF );
            }
            else {   
                SymDefInfo[8] = (U8) ( (uj&0xFF00) >> 8 );
                SymDefInfo[9] = (U8) ( uj&0x00FF );
            }
            data[5] = data[7];
        }   
        else {
            uj = BinToU16(&SymDefInfo[8]);
            Omf51TypeConv( uj );
            if ( m_absflag ) {
                SymDefInfo[9] = (U8) ( (uj&0xFF00) >> 8 );
                SymDefInfo[8] = (U8) ( uj&0x00FF );
            }
            else {   
                SymDefInfo[8] = (U8) ( (uj&0xFF00) >> 8 );
                SymDefInfo[9] = (U8) ( uj&0x00FF );
            }
        }   

        if ( GetBytes(&SymDefInfo[10] , data[5]) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
        SymDefInfo[10+data[5]] = '\0';
        
        //for bankSwitching
        if(m_IsBankSwitchOn) GetBankCallAndSwitchAddr();

        if ( strcmp( (const char *)&SymDefInfo[10] , "_ICE_DUMMY_" ) ) {
            if ( bAddSymbol ) {
                if(m_IsBankSwitchOn) 
                   Omf51ProcessModSym(nBankNum);
                else
                   Omf51ProcessModSym();            
            }
        }
        i++;
        ui += (U16)(6+data[5]);
    }
    if ( ui == (len-1) ) {
        if ( GetOneByte(data) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        }
    }
    else {
        m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014; 
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }
    return( i );
}           

/***************************************************************************
*                                                                          *
*  Omf51TypeConv - convert omf51 type to symbol server type                *
*  parameter :                                                             *
*       ui  ---   omf51 type ( input )                                     *
*       ui  ---   symbol server type  ( output )                           *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void LoaderServer::Omf51TypeConv(U16& ui)
{
    if ( ui >= 0x20 ) {
        ui += (U16)(224 + m_typeDelta);
    }
    else {
        switch( ui ) {
        case 1 :    /* bit */
        case 0x0A :
            ui = BI_BIT;
            break;
        case 2 :    /* signed char */
            ui = BI_S8_CHAR;            
            break;
        case 3 :
            ui = BI_U8_UCHAR;
            break;
        case 4 :
            ui = BI_S16_SINT;
            break;
        case 5 :             
            ui = BI_U16_UINT;
            break;
        case 6 :
            ui = BI_S32_LONG;
            break;
        case 7 :             
            ui = BI_U32_ULONG;
            break;
        case 8 :
            ui = BI_F32;
            break;
        case 9 :
            ui = BI_F64;
            break;
        case 0x0B :
            ui = BI_VOID;
            break;
        default :
            ui = BI_UNKNOWN;
            break;
        }
    }
}           

/***************************************************************************
*                                                                          *
*  Omf51SegIdToEnum - convert omf51 segment ID to symbol server enum       *
*  parameter :                                                             *
*       ui  ---   omf51 segment ID ( input )                               *
*       type  ---  symbol server enum  ( output )                          *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void Omf51SegIdToEnum(U8 ui , SEGMENTTYPE* type)
{
    switch (ui&0x07) {
    case 7 :                              
        *type = ( SEGMENTTYPE ) SEG_UNTYPED;
        break;
    case 0 :
        *type = ( SEGMENTTYPE ) SEG_CODE ;
        break;
    case 1 :            
        *type = ( SEGMENTTYPE ) SEG_XDATA ;
        break;
    case 2 :       
        *type = ( SEGMENTTYPE ) SEG_REGISTER ;
        break;
    case 3 :
        *type = ( SEGMENTTYPE ) SEG_DATA ;
        break;
    case 4 :
        *type = ( SEGMENTTYPE ) SEG_BIT ;
        break;
    case 5 :
        *type = ( SEGMENTTYPE ) SEG_DATA;
        //*type = ( SEGMENTTYPE ) SEG_CODE ;
        break;
    default :
        *type = ( SEGMENTTYPE ) SEG_UNTYPED ;
        break;
    }
}

/***************************************************************************
*                                                                          *
*  Omf51MatchFuncType - match function type in StoreExtendVar link         *
*  parameter :                                                             *
*       str        ---  function name                                      *
*       typeindex  ---  function type                                      *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void LoaderServer::Omf51MatchFuncType(char *str , TYPE_INDEX& typeIndex)
{
struct StoreExtendVar *ttt;

    ttt = varExtHdrPtr ;
    while ( ttt ) {
        if ( 0 == stricmp( (LPSTR)(&ttt->SymDefInfo[10]) , str ) ) {
            sprintf(str,"%s",(char *)(&ttt->SymDefInfo[10]) );
            break;
        }
        ttt = ttt->next;
    }
    if ( ttt ) {
        U16 ui ;
        
        ui = BinToU16(&ttt->SymDefInfo[8]);
        typeIndex = (U32) ui;
    }
    else typeIndex = 0;
}

BOOL LoaderServer::GetLstFileInfo()
{
    char szPath[_MAX_PATH];
    lstrcpy(szPath,m_lpFileRef);
    int nLen = lstrlen(szPath);
    for (int i = nLen-1; i >= 0 ; i--) {
        if (  szPath[i] == '\\' || szPath[i] == '/' 
            || szPath[i]  == ':' ) break;
    }
    if ( i > 0 ) szPath[i+1] = '\0';

    struct _find_t fileinfo;
    CString strFileName = szPath;
    strFileName += "*.lst";
    if ( _dos_findfirst(strFileName,_A_NORMAL,&fileinfo) == 0 ) {
        do {
            strFileName = szPath;
            strFileName += fileinfo.name;
            if ( GetFromLstFile(strFileName) ) return TRUE;
        } while ( _dos_findnext( &fileinfo ) == 0 ) ;
    }
    return FALSE;
}

BOOL LoaderServer::GetFromLstFile(LPCSTR lpFileName)
{
	CString strPath = lpFileName;
	int nPos = strPath.Find('.');
	strPath.GetBufferSetLength(nPos);

	CString strSrcName = strPath;
    strSrcName += ".plm";
    OFSTRUCT of;
    if ( OpenFile(lpFileName, &of , OF_EXIST )	== HFILE_ERROR ||
    		OpenFile(strSrcName, &of , OF_EXIST )	== HFILE_ERROR) 
    	return FALSE;

	CStdioFile listFile(lpFileName,CFile::modeRead | CFile::typeText );
//	CStdioFile infoFile;
	
    char szLine[257],*p;
    int nSrcLine=0,nListLine;
    int nScope,nScopeMod;
	BOOL bFuncBegin = FALSE;
    char ch;
    BOOL bModBegin = FALSE;
    BOOL bSymBegin = FALSE;
    if ( !listFile.ReadString(szLine,256) ||
    	 	szLine[0] != 0x0c || strncmp(szLine+1,"PL/M-51",7) ) 
    	goto LST_FAIL;

    while ( listFile.ReadString(szLine,256) ) {
    	if ( szLine[0] == 0x0c || szLine[0] == 0x0a || szLine[0] == '-') continue;
    	if ( szLine[0] != ' ' && (szLine[0] < '0' || szLine[0] > '9') ) {
    		if ( bModBegin ) {
    			if (_strnicmp(szLine,"SYMBOLS",7) == 0) {
    				bSymBegin = TRUE;
    				bModBegin = FALSE;
//    				m_lstFileInfo->SetModuleName(lpFileName);
    			}
//    			listFile.Close();
    			m_lstFileInfo->SetModuleName(lpFileName);
////				SymAddModuleReference(curModDesc,(LPSTR)(LPCSTR)strSrcName);
//    			return TRUE;
				continue;
    		}
    		else if (bSymBegin) {
    			listFile.Close();
    			return TRUE;;
    		}
    		else continue;
    	}
		
		if (bSymBegin) {    		
	    	m_lstFileInfo->AddSymbol(szLine);
		}
		else {
	    	szLine[13] = '\0';
	    	nListLine = atoi(szLine);
	    	nScope = atoi(szLine+4);
	    	ch = szLine[10];
	//    	if ( sscanf(szLine," %d %d %1s",&nListLine,&nScope,&ch) == 2 ) {
			if ( ch == ' ' ) {
	    		nSrcLine++;
	    		if ( nListLine > 1 && !bModBegin ) goto LST_FAIL;
	    		else if ( nListLine == 1 ) {
	    			for (p = szLine+14; !isalpha(*p); p++);
	    			if ( strnicmp(p,m_modNode.name,lstrlen(m_modNode.name)) )
	    				goto LST_FAIL;		// check mod name compatibility
	    			bModBegin = TRUE;
					if ( m_lstFileInfo ) delete m_lstFileInfo;
					m_lstFileInfo = new LstFileInfoSvr;
					if ( !m_lstFileInfo ) goto LST_FAIL;
					nScopeMod = nScope;
	//				strPath += ".dbg";
	//				infoFile.Open(strPath,CFile::modeCreate //| CFile::shareDenyWrite
	//						| CFile::typeText );
	    		}
	    		if ( nListLine ) {
					if ( !bFuncBegin && nScopeMod+1 == nScope ) {
//						m_lstFileInfo->AddFunc(szLine+14,(LINENUM_TYPE)nSrcLine);
//						bFuncBegin = TRUE;
					}
					else if (nListLine!=1 && bFuncBegin && nScopeMod == nScope ) {
//						m_lstFileInfo->SetFuncSrcRange(1,(LINENUM_TYPE)nSrcLine);
//						bFuncBegin = FALSE;
					}
					else if (nListLine!=1 && bFuncBegin && nScopeMod+1 == nScope ) {
//						if (m_lstFileInfo->SetFuncEndLine(szLine+14,(LINENUM_TYPE)nSrcLine))
//							bFuncBegin = FALSE;
					}
					m_lstFileInfo->AddData(nListLine,nSrcLine);
	    		}
	    	}
	    }
    }
    
LST_FAIL :
    listFile.Close();
//    infoFile.Close();
	if ( m_lstFileInfo ) {
		delete m_lstFileInfo;
		m_lstFileInfo = NULL;
	}
    return FALSE;
}

/***************************************************************************
*  Added by Dragon for Bank-Switching 12/30/1996                           *
*                                                                          *
*  AbiMyFill                                                               *                                                               
*                                                                          *
*   return value : 0  1                                                    *
*                                                                          *
***************************************************************************/

BOOL LoaderServer::AbiMyFill(ADDR stAddr,ADDR endAddr,char *ptrData,U16 j,U8 nBankNum)
 {
   STATUS err; 

   //for load to x area                    
   if ( LOAD_TODATA( m_ldrFlags ) ){
        //m_dwErrorNum = ER_LDR_X_AREA;
        return -1;
   }
                    
   if(!m_IsBankSwitchOn){
      if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
         stAddr.addrType = U8(m_bLoadToBank); 
         endAddr.addrType = U8(m_bLoadToBank); 
      }
      err=AbiFill(stAddr , endAddr , ptrData , j);
      if ( err != ICE_OK ) {
           m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;    // 0x4020;
           return(0);
      }
   }
   else if(nBankNum){
      stAddr.addrType=endAddr.addrType=U8(nBankNum-0x10+6);
      err=AbiFill(stAddr , endAddr , ptrData , j);
      if ( err != ICE_OK ) {
           m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;    // 0x4020;
           return(0);
      }
   }
   else{
      int i=0, upper;
      if(g_nBankNum == 4) upper =4;
      else upper = 2;
      do{
         stAddr.addrType=endAddr.addrType=U8(i+6);
         err=AbiFill(stAddr , endAddr , ptrData , j);
         if(err != ICE_OK){
            m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;   // 0x4020;
            return(0);
         }
         i++;
      }while(i<upper);
   }//end of else
   return 1;
 }//end of function    
 
 void LoaderServer::GetBankCallAndSwitchAddr()
  {
    U32 address;
    
    address = BinToU32(&SymDefInfo[3]);
    if ( !m_bCallFlag[0]&&!strcmp( (const char *)&SymDefInfo[10] , "?B_BANK0" ) ) {
         m_uCallBankAddr[0] = address;
         m_bCallFlag[0]=1;
    }
    else if ( !m_bCallFlag[1]&&!strcmp( (const char *)&SymDefInfo[10] , "?B_BANK1" ) ) {
         m_uCallBankAddr[1] = address;
         m_bCallFlag[1]=1;
    }
    else if ( !m_bCallFlag[2]&&!strcmp( (const char *)&SymDefInfo[10] , "?B_BANK2" ) ) {
         m_uCallBankAddr[2] = address;
         m_bCallFlag[2]=1;
    }
    else if ( !m_bCallFlag[3]&&!strcmp( (const char *)&SymDefInfo[10] , "?B_BANK3" ) ) {
         m_uCallBankAddr[3] = address;
         m_bCallFlag[3]=1;
    }
    else if ( !m_bSwitchFlag[0]&&!strcmp( (const char *)&SymDefInfo[10] , "?B_SWITCH0" ) ) {
         m_uSwitchBankAddr[0] = address;
         m_bSwitchFlag[0]=1;
    }
    else if (!m_bSwitchFlag[1]&& !strcmp( (const char *)&SymDefInfo[10] , "?B_SWITCH1" ) ) {
         m_uSwitchBankAddr[1] = address;
         m_bSwitchFlag[1]=1;
    }
    else if (!m_bSwitchFlag[2]&&!strcmp( (const char *)&SymDefInfo[10] , "?B_SWITCH2" ) ) {
         m_uSwitchBankAddr[2] = address;
         m_bSwitchFlag[2]=1;
    }
    else if (!m_bSwitchFlag[3]&& !strcmp( (const char *)&SymDefInfo[10] , "?B_SWITCH3" ) ) {
         m_uSwitchBankAddr[3] = address;
         m_bSwitchFlag[3]=1;
    }
 }        
         
         
/******************************** E O F ***********************************/
