/*************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MAPEDIT.CPP   1.2.1.4   17 Apr 1997 15:55:48   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MAPEDIT.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:55:48   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:26:54   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:37:24   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:16:56   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:22:00   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:32:06   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:47:46   ZJRD
** Initial revision.
** 
**    Rev 1.0.1.2   09 Dec 1996 10:16:26   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.0.1.0   11 Nov 1996 12:59:42   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4   09 Sep 1996 13:18:58   ZJRD
** No change.
** 
**    Rev 1.3   05 Sep 1996 11:30:28   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 09:57:32   ZJRD
** No change.
** 
**    Rev 1.1   28 Aug 1996 15:52:48   ZJRD
** EasyPack/SLD Version 1.9b
**************************************************************************/
//
// mapedit.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "uicom.h"
#include "xview.h"
#include "myedit2.h"
#include "spin.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"

//
// For address server
//
#include "address.h"
#include "addrapi.h"

#include "mapedit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern void MemServerSetMap(const unsigned short uStart,
                            const unsigned short uEnd,
                            const unsigned char uchType,
                            const char chMapAttr);

extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
                        
                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/////////////////////////////////////////////////////////////////////////////
// CMapEdit dialog


CMapEdit::CMapEdit(CWnd* pParent /*=NULL*/)
   : CDialog(CMapEdit::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMapEdit)
   m_nAttribute = -1;
   m_strSpaceArea = "";
   m_strStartAddr = "";
   m_strEndAddr = "";
   //}}AFX_DATA_INIT
   m_nArea = -1;
   m_IsSet = FALSE;
}

void CMapEdit::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMapEdit)
   DDX_Radio(pDX, IDC_RIRW, m_nAttribute);
   DDX_Text(pDX, IDC_SPACE, m_strSpaceArea);
   DDX_Text(pDX, IDC_STARTADDR, m_strStartAddr);
   DDX_Text(pDX, IDC_ENDADDR, m_strEndAddr);
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMapEdit, CDialog)
   //{{AFX_MSG_MAP(CMapEdit)
   ON_BN_CLICKED(IDB_SET, OnSet)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapEdit message handlers

BOOL CMapEdit::OnInitDialog()
{
   CDialog::OnInitDialog();
   CenterWindow();
   CWnd* ctrl;
   
   // TODO: Add extra initialization here
   RECT rect, editrect;

   SetDlgItemText(IDC_MAP_EDIT1, "0x0");
   SetDlgItemText(IDC_MAP_EDIT2, "0x7f");
   m_edit1.SubclassEdit(IDC_STARTADDR, this, PES_NUMBERS);
   if ( m_nArea == 2 ) {             // DATA
      m_edit1.SetRange(dwxMin, dwxMax);  // Should be changed
   }
   else{
      m_edit1.SetRange(dwpMin, dwpMax);  // Should be changed
   }
   m_edit1.m_uWhichEdit = 1;
   m_edit1.m_uAddOrLen = 0;
   m_edit1.GetWindowRect(&editrect);
   ScreenToClient(&editrect);
   rect.left = editrect.right + 1;
   rect.right = rect.left + 15;
   rect.top = editrect.top;
   rect.bottom = editrect.bottom;
   m_spin1.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT1);
   m_spin1.SetAssociate(&m_edit1);

   m_edit2.SubclassEdit(IDC_ENDADDR, this, PES_NUMBERS);
   if ( m_nArea == 2 ) {             // DATA
      m_edit2.SetRange(dwxMin, dwxMax);  // Should be changed
   }
   else {
      m_edit2.SetRange(dwpMin, dwpMax);  // Should be changed
   }
   m_edit2.m_uWhichEdit = 2;
   m_edit2.m_uAddOrLen = 0;    
   m_edit2.GetWindowRect(&editrect);
   ScreenToClient(&editrect);
   rect.left = editrect.right + 1;
   rect.right = rect.left + 15;
   rect.top = editrect.top;
   rect.bottom = editrect.bottom;
   
   m_spin2.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT2);
   m_spin2.SetAssociate(&m_edit2);
   
   if ( m_nArea == 1 || m_nArea>=6&&m_nArea<=9) {
      ctrl = GetDlgItem(IDC_RCR);
      ((CButton*)ctrl)->EnableWindow(FALSE);
      ctrl = GetDlgItem(IDC_RCRW);
      ((CButton*)ctrl)->EnableWindow(FALSE);
   }
   else if ( m_nArea == 2 ) {
            ctrl = GetDlgItem(IDC_RCR);
            ((CButton*)ctrl)->EnableWindow(TRUE);
            ctrl = GetDlgItem(IDC_RCRW);
            ((CButton*)ctrl)->EnableWindow(TRUE);
   }

   return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMapEdit::OnCancel()
{
   // TODO: Add extra cleanup here
   m_IsSet = FALSE;   
   CDialog::OnCancel();
}

void CMapEdit::OnSet()
{
   // TODO: Add your control notification handler code here
   ADDRESS nStartAddr, nEndAddr;
   unsigned short iStartAddr, iEndAddr;
   ADDR_RETCODE retCode;
   char    attribute;

   AfxGetApp()->DoWaitCursor(1);   
   
   UpdateData(TRUE);
   retCode = AdrTextToAddr(m_strStartAddr, nStartAddr);
   if ( ADR_OK != retCode )   return;
   retCode = AdrTextToAddr(m_strEndAddr, nEndAddr);
   if ( ADR_OK != retCode )   return;
   iStartAddr = (unsigned short)nStartAddr.adrAddress;
   iEndAddr = (unsigned short)nEndAddr.adrAddress;
   switch ( m_nAttribute ) {
      case     0:
               attribute = 0;
               break;
               
      case     1:
               attribute = 1;
               break;
               
      case     2:
               attribute = 6;
               break;
               
      case     3:
               attribute = 2;              
               break;   
               
      case     4:
               attribute = 3;
               break;
               
      case     5:
               attribute = 4;
               break;
               
      case     6:
               attribute = 5;
               break;
   }
            
   MemServerSetMap(iStartAddr, iEndAddr, 
                   (unsigned char)m_nArea, 
                   attribute);
   
   m_IsSet = TRUE;   
   
   AfxGetApp()->DoWaitCursor(0);   
   
   CDialog::OnOK();
}
