
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MEMADDR.CPP   1.2.1.4   17 Apr 1997 15:55:54   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MEMADDR.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:55:54   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:27:00   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:37:28   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:16:58   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:22:02   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:32:08   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:47:48   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:10   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:26   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:46   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:50   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:20   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:02   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:06   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:40   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:56   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:58   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:46   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:36   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:43:04   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:08   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:52   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:12   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:48   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:34   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:22   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:56   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:00   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:50   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:22   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:36   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:44   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:08   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:46   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:56   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:32   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:22   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:46   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:44   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:20   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:46   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:12   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMADDR.CPP
//
//  Description: The implementation file for the class: CMemoryAddr.
//
//  Author: Chen Jun
//
//  Date: 04/17/95
//
//  Modification:
//      1. 04/17/95, Initial version of the class: CMemoryAddr.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memaddr.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
extern int GetCurrentBank(void);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.


/////////////////////////////////////////////////////////////////////////////
// Public functions.


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryAddr.

// Construction.
CMemoryAddr::CMemoryAddr()
{

}   // End of CMemoryAddr().

CMemoryAddr::CMemoryAddr(ADDRESS addr)
{
	m_uAddr = (unsigned short)addr.adrAddress;
    m_uchType = (unsigned char)addr.adrSpace;
}   // End of CMemoryAddr().

// Copy construction.
CMemoryAddr::CMemoryAddr(unsigned short uAddr, unsigned char uchType)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= 0 && uchType <= 9 );		//Chris: for bank switch, 12/20/96
    
    // Copy construction.
    m_uAddr = uAddr;
    m_uchType = uchType;

}   // End of CMemoryAddr().

// Destruction.
CMemoryAddr::~CMemoryAddr()
{

}   // End of ~CMemoryAddr().

BOOL CMemoryAddr::isSameSpace(BYTE a, BYTE b)
{
    if(a==b)
    	return TRUE;
	if(a==1)
	{
		if(GetCurrentBank()!=b)
			return FALSE;
		else
			return TRUE;
	}
	else if(b==1)
	{
		if(GetCurrentBank()!=a)
			return FALSE;
		else
			return TRUE;
	}
	else
		return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryAddr::operator*().
//
//  Description: The operator function of CMemoryAddr class.
//               Operator(+, -, =, ==, >, <, >=, <=).
//
//  Input:  CMemoryAddr.
//
//  Output: CMemoryAddr.
//
//  Return: CMemoryAddr.
//
/////////////////////////////////////////////////////////////////////////////

// CMemoryAddr1 + CMemoryAddr2.
CMemoryAddr CMemoryAddr::operator+(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    // ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    DWORD dwTemp=m_uAddr;
    CMemoryAddr TmpAddr;
    
    dwTemp+=Addr.m_uAddr;
    if(m_uchType>5&&dwTemp>0xffff)
    {
    	dwTemp+=(m_uchType-6)*0x10000;
    	TmpAddr.m_uAddr=(unsigned short)dwTemp;
    	TmpAddr.m_uchType=BYTE((dwTemp>>16)+6);
    	ASSERT(TmpAddr.m_uchType<10);
    }
    else
    {
    	TmpAddr.m_uAddr = m_uAddr + Addr.m_uAddr;
    	TmpAddr.m_uchType = m_uchType;
    }

    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }

    return (TmpAddr);
    
}   // End of CMemoryAddr::operator+().

// CMemoryAddr1 + uSize.
CMemoryAddr CMemoryAddr::operator+(const unsigned short& uSize)
{
    // Assertion of the input parameters.
    
    // Convert.
    DWORD	dwTemp=m_uAddr;
    CMemoryAddr TmpAddr;
    
    dwTemp+=uSize;
    if(m_uchType>5&&dwTemp>0xffff)
    {
    	dwTemp+=(m_uchType-6)*0x10000;
    	TmpAddr.m_uAddr=WORD(dwTemp);
    	TmpAddr.m_uchType=BYTE((dwTemp>>16)+6);
    	if(TmpAddr.m_uchType>=10)
    	{
    		TmpAddr.m_uchType=9;
    		TmpAddr.m_uAddr=0xffff;
    	}
    }
    else
    {
    	TmpAddr.m_uAddr = m_uAddr + uSize;
    	TmpAddr.m_uchType = m_uchType;
    }

    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }
    
    return (TmpAddr);

}   // End of CMemoryAddr::operator+().


// CMemoryAddr1 - CMemoryAddr2.
CMemoryAddr CMemoryAddr::operator-(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    // ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    CMemoryAddr TmpAddr;
    
    if(m_uchType>6&&m_uAddr<Addr.m_uAddr)
    {
    	TmpAddr.m_uchType = BYTE(m_uchType-1);
    	TmpAddr.m_uAddr = WORD(0x10000+m_uAddr - Addr.m_uAddr);
    	ASSERT(TmpAddr.m_uchType>5);
    }
    else
    {
    	TmpAddr.m_uAddr = m_uAddr - Addr.m_uAddr;
    	TmpAddr.m_uchType = m_uchType;
    }

    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }

    return (TmpAddr);
    
}   // End of CMemoryAddr::operator-().

// CMemoryAddr1 - uSize.
CMemoryAddr CMemoryAddr::operator-(const unsigned short& uSize)
{
    // Assertion of the input parameters.
    
    // Convert.
    CMemoryAddr TmpAddr;
    
    if(m_uchType>6&&m_uAddr<uSize)
    {
    	TmpAddr.m_uchType = BYTE(m_uchType-1);
    	TmpAddr.m_uAddr = WORD(0x10000+m_uAddr - uSize);
    	ASSERT(TmpAddr.m_uchType>5);
    }
    else
    {
    	TmpAddr.m_uAddr = m_uAddr - uSize;
    	TmpAddr.m_uchType = m_uchType;
    }
    
    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }

    return (TmpAddr);

}   // End of CMemoryAddr::operator-().


// CMemoryAddr1 = CMemoryAddr2.
void CMemoryAddr::operator=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    // ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    m_uAddr = Addr.m_uAddr;
    m_uchType = Addr.m_uchType;

}   // End of CMemoryAddr::operator=().

// CMemoryAddr1 = uNewAddr.
void CMemoryAddr::operator=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    m_uAddr = uNewAddr;

}   // End of CMemoryAddr::operator=().


// CMemoryAddr1 == CMemoryAddr2.
BOOL CMemoryAddr::operator==(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
	
	if(!isSameSpace(m_uchType, Addr.m_uchType))
		return FALSE;
    // Convert.
    return ( m_uAddr == Addr.m_uAddr );

}   // End of CMemoryAddr::operator==().


// CMemoryAddr1 == uNewAddr.
BOOL CMemoryAddr::operator==(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr == uNewAddr );

}   // End of CMemoryAddr::operator==().


// CMemoryAddr1 != CMemoryAddr2.
BOOL CMemoryAddr::operator!=(const CMemoryAddr& Addr)
{
	if(!isSameSpace(m_uchType, Addr.m_uchType))
		return TRUE;

    // Convert.
    return ( m_uAddr != Addr.m_uAddr );

}   // End of CMemoryAddr::operator!=().


// CMemoryAddr1 != m_uAddr.
BOOL CMemoryAddr::operator!=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr != uNewAddr );

}   // End of CMemoryAddr::operator!=().


// CMemoryAddr1 > CMemoryAddr2.
BOOL CMemoryAddr::operator>(const CMemoryAddr& Addr)
{
	if(!isSameSpace(m_uchType, Addr.m_uchType))
	{
		ASSERT(m_uchType>5&&Addr.m_uchType>5);
		return (m_uchType > Addr.m_uchType);
    }

    // Convert.
    if(m_uchType>5&&Addr.m_uchType>5)
    	return(m_uchType*0x10000+m_uAddr>Addr.m_uchType*0x10000+Addr.m_uAddr);
    return ( m_uAddr > Addr.m_uAddr );

}   // End of CMemoryAddr::operator>().
                
// CMemoryAddr1 > uNewAddr.
BOOL CMemoryAddr::operator>(const unsigned short& uNewAddr)
{

    // Convert.
    return ( m_uAddr > uNewAddr );

}   // End of CMemoryAddr::operator>().


// CMemoryAddr1 < CMemoryAddr2.
BOOL CMemoryAddr::operator<(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
	if(!isSameSpace(m_uchType, Addr.m_uchType))
	{
		ASSERT(m_uchType>5&&Addr.m_uchType>5);
		return (m_uchType < Addr.m_uchType);
    }
    // Convert.
    if(m_uchType>5&&Addr.m_uchType>5)
    	return(m_uchType*0x10000+m_uAddr<Addr.m_uchType*0x10000+Addr.m_uAddr);
    return ( m_uAddr < Addr.m_uAddr );

}   // End of CMemoryAddr::operator<().

// CMemoryAddr1 < uNewAddr.
BOOL CMemoryAddr::operator<(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr < uNewAddr );

}   // End of CMemoryAddr::operator<().


// CMemoryAddr1 >= CMemoryAddr2.
BOOL CMemoryAddr::operator>=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
	if(!isSameSpace(m_uchType, Addr.m_uchType))
	{
		ASSERT(m_uchType>5&&Addr.m_uchType>5);
		return (m_uchType >= Addr.m_uchType);
    }

    // Convert.
    if(m_uchType>5&&Addr.m_uchType>5)
    	return(m_uchType*0x10000+m_uAddr>=Addr.m_uchType*0x10000+Addr.m_uAddr);
    return ( m_uAddr >= Addr.m_uAddr );

}   // End of CMemoryAddr::operator>=().

// CMemoryAddr1 >= uNewAddr.
BOOL CMemoryAddr::operator>=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr >= uNewAddr );

}   // End of CMemoryAddr::operator>=().


// CMemoryAddr1 <= CMemoryAddr2.
BOOL CMemoryAddr::operator<=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
	if(!isSameSpace(m_uchType, Addr.m_uchType))
	{
		ASSERT(m_uchType>5&&Addr.m_uchType>5);
		return (m_uchType <= Addr.m_uchType);
    }

    // Convert.
    if(m_uchType>5&&Addr.m_uchType>5)
    	return(m_uchType*0x10000+m_uAddr<=Addr.m_uchType*0x10000+Addr.m_uAddr);
    return ( m_uAddr <= Addr.m_uAddr );

}   // End of CMemoryAddr::operator<=().

// CMemoryAddr1 <= uNewAddr.
BOOL CMemoryAddr::operator<=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr <= uNewAddr );

}   // End of CMemoryAddr::operator<=().


//////////////////////////////// End of File ////////////////////////////////
