
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MEMBASE.H__   1.2.1.4   17 Apr 1997 15:55:58   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MEMBASE.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:55:58   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:27:12   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:37:52   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:17:04   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:22:06   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:32:12   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:47:50   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:54   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:48   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:56   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:30   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:12   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:34   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:38:14   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:32   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:58   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:50   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:36   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:36:42   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:38   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:08   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:00   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:52   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:24   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:00   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:56   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:44   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:24   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:38   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:30   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:06   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:16   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:28   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:48   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:36   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:42   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:20   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:46   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:12   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBASE.H
//
//  Description: The header file for the class: CMemoryBase.
//
//  Author: Chen Jun
//
//  Date: 04/17/95
//
//  Modification:
//      1. 04/17/95, Initial version of the class: CMemoryBase.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMBASE_
#define _MEMBASE_

#ifndef _SERVER_NO_ABI
    #include "abitype.h"
#endif  // _SERVER_NO_ABI

#include "syntest.h"
#include "memaddr.h"

/////////////////////////////////////////////////////////////////////////////
// CMemoryBase class.
class CMemoryBase : public CSyntaxTest, public CMemoryAddr
{
// Construction & Destruction.
public:
    CMemoryBase();
    ~CMemoryBase();
    
// Member variables.
private:
    enum { LINE_LENGTH = 255 };

    enum { MAX_DIGIT = 34 };

protected:
    enum { MEM_UNDEFINE = 0,
           MEM_PROGRAM  = 1,
           MEM_EXTERNAL = 2,
           MEM_INTERNAL = 3,
           MEM_SFR      = 4,
           MEM_BIT      = 5,
           MEM_BANK1	= 6,
           MEM_BANK2	= 7,
           MEM_BANK3	= 8,
           MEM_BANK4	= 9
    };

    // Used by StrToVar() & VarToStr().
    unsigned long m_ulVar;
    char* m_pszVar;
    
    // Result which will be displayed.
    char* m_pszResult;
                                      
    // ABI Error ID.
    int m_nErrorID;
    enum { 
        ICE_OK = 0,
        ICE_FAIL_STEP,
        ICE_FAIL_MEM_WRITE,
        ICE_FAIL_MAP_INCLUDE,
        ICE_FAIL_MAP_BOUNDARY,
        ICE_NOT_FOUND,
        ICE_FOUND,
        ICE_TIME_OUT,
        ICE_PARA_ERROR,
            
        ICE_EP_RUNNING = 0x10,
        ICE_TRACE_RUNNING,
        ICE_TRACE_READ_OVER,
        ICE_COMMAND_INVALID,

        ICE_FLASH_SW_ERROR  = 0x40,
        ICE_FLASH_EC_ERROR,
        ICE_FLASH_PRG_ERROR,
        ICE_FLASH_REC_ERROR,
    };

// Implementations.
protected:
    void StrToVar(char* pszConvStr);
    void VarToStr(unsigned long ulConvVar);

    void SetAddrVar(char* pszAddr, CMemoryAddr& addr);
    void SetAddrVar(char* pszAddr, char* pszLength, CMemoryAddr& addr);
    void SetAddrVar(int nType, unsigned long ulAddr, CMemoryAddr& addr);
    
    BOOL EscapeAbort(void);

    void DisplayErrorMessage(void) const;
    
};  // End of class: CMemoryBase.

#endif
//////////////////////////////// End of File ////////////////////////////////
