
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MEMCHK.CPP   1.2.1.4   17 Apr 1997 15:56:10   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MEMCHK.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:56:10   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:27:22   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:38:00   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:17:12   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:22:14   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:32:18   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:47:54   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:18   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:34   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:21:22   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:50   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:52   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:48   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:40   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:48   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:29:08   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:24   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:10:54   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:28:30   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:59:28   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:39:34   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:53:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:56   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:36   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:50   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:54   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:48   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:04   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:02   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:16   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:34   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:18   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:58   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:14   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:00   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:34   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:16   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:54   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:28   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:56   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:30   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:36   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:56   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:50   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:42   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCHK.CPP
//
//  Description: The implementation file for the class: CMemoryChecksum.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryChecksum.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memchk.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void ChecksumCmd(int nArgc, char* pszArgv[]);
long MemServerChecksum(ADDRESS Start, ADDRESS End, unsigned char uchType);

/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiChecksum(ADDR addr1, ADDR addr2, UINT* uChecksum);
#endif  // _SERVER_NO_ABI
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   ChecksumCmd().
//
//  Description: The main control routine of Checksum command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void ChecksumCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Get Checksum.
    char error[128];
    
    CMemoryChecksum* pMemoryChecksum = new CMemoryChecksum;
    if ( !pMemoryChecksum ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryChecksum->ChecksumAction(nArgc, pszArgv);
            delete pMemoryChecksum;
          }           
       }   
    }

//    CMemoryChecksum objChecksum;
//    objChecksum.GetChecksum(nArgc, pszArgv);

}   // End of ChecksumCmd().

// Memory server: checksum.
long MemServerChecksum(ADDRESS Start, ADDRESS End, unsigned char uchType)
{
    CMemoryChecksum* pMemoryChecksum = new CMemoryChecksum;
    if ( !pMemoryChecksum ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return 0;
    }
    else {
        long lChecksum = 
            pMemoryChecksum->MemServerChecksum(Start, End, uchType);
        delete pMemoryChecksum;
        return (lChecksum);
    }

}   // End of MemServerChecksum().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryChecksum.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryChecksum::CMemoryChecksum().
//
//  Description: The construction of the class: CMemoryChecksum.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryChecksum::CMemoryChecksum()
{

}   // End of CMemoryChecksum::CMemoryChecksum().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryChecksum::~CMemoryChecksum().
//
//  Description: The destruction of the class: CMemoryChecksum.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryChecksum::~CMemoryChecksum()
{

}   // End of CMemoryChecksum::~CMemoryChecksum().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryChecksum::ChecksumAction().
//
//  Description: Checksum of EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryChecksum::ChecksumAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    BOOL endSpace;
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 3 == nArgc ) {
        // Checksum adr1 adr2.
        endSpace=!(':' != pszArgv[2][1] && ':' != pszArgv[2][2]);
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
    }
    else if ( 4 == nArgc ) {
        // Checksum adr1 Length length.
        endSpace=TRUE;
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] && ':' != pszArgv[1][2] ) {
        m_StartAddr.m_uchType = MEM_EXTERNAL;
    }
    if(!endSpace)
    	m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Checksum kernel routine.
    MemoryChecksumKernel();
        
}   // End of CMemoryChecksum::ChecksumAction().


void CMemoryChecksum::MemoryChecksumKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = 
        AbiChecksum((ADDR&) m_StartAddr, (ADDR&) m_EndAddr, &m_uChecksum);

    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
    }
    else {
        DisplayChecksum(m_uChecksum);
    }
        
}   // End of CMemoryChecksum::MemoryDumpKernel().


void CMemoryChecksum::DisplayChecksum(UINT uChecksum)
{
    // Assertion of the input parameters.
    
    // Display the Checksum of the special EMM range.
    char pszChecksum[255];
    memset(pszChecksum, 0, sizeof(pszChecksum));
    wsprintf(pszChecksum, "Checksum is: %X.", uChecksum);
    ShowLine(pszChecksum);

}   // End of CMemoryChecksum::DisplayChecksum().


// Memory server: checksum.
long CMemoryChecksum::MemServerChecksum(ADDRESS Start, ADDRESS End,
										unsigned char /*uchType*/)
{
    // Assertion of the input parameters.
    
    // Set the server flag.
    m_isServer = TRUE;
    
    // Set the parameter.
    m_StartAddr = CMemoryAddr(Start);
    m_EndAddr = CMemoryAddr(End);
    
    // Memory Checksum kernel routine.
    MemoryChecksumKernel();
    
    if ( ICE_OK != m_nErrorID ) {
        return (-1);
    }
    else {
        return (m_uChecksum);
    }

}   // End of CMemoryChecksum::MemServerChecksum().

//////////////////////////////// End of File ////////////////////////////////
