
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MISC.CPP   1.2.1.4   17 Apr 1997 15:57:10   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MISC.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:57:10   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:28:34   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:38:58   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:18:02   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:23:02   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:33:04   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:48:26   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:36   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:52   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:14:30   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:02   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:10   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:45:56   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:52   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:00   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:34:18   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:54   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:28   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:34   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:14   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.24   01 Feb 1996 10:15:24   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:42   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:54   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:40   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:16:38   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:11:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:06   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:56   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:10   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:04   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:32   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:28   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:56   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:08   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:30:18   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:51:44   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.3   29 Sep 1995 09:51:04   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:48   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:30   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:48   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : MISC.CPP 
** Author:BRIGHT CHEN
** Description:
**
**
**    Finished date: 1995.9.1
**    modifed date:1995.10.20
**                 support new control option
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


/////////////////////////////////
//misc.cpp
//Bright Cheng, Chris Fang
//95/4
/////////////////////////////////
#include "stdafx.h"
#include "stdlib.h"
#include "string.h"

#include "abibase.h"     
#include "abitype.h" 
#include "abibase.h"
#include "cpucom.h"
#include "cpuserve.h"
#include "hosterrs.h"

//add by chris:
#include "resource.h"
#include "uicom.h"

#define IDEA 0
#define IDRESET 1    
#define IDEBEN 2
#define IDDISABLE 0
#define IDENABLE 1

extern STATUS AbiGetControl(int iControlId, FLAG* uControlFlag);
extern STATUS AbiSetControl(int iControlId, FLAG uControlFlag);
extern STATUS AbiGetFwID(char*);
extern STATUS AbiInput(PARA_PORT, UINT*);
extern STATUS AbiOutput(PARA_PORT port, UINT uPortValue, UINT uMaskFlag);
extern STATUS AbiCycle(int*,CYCLE_INFO*);
extern STATUS AbiGetBank(BYTE& bBank, BYTE& bPCBank);
extern STATUS AbiSelectBank(BYTE bBank);
extern STATUS AbiSetPCBank(BYTE bBank);
extern STATUS AbiHidenCommand(char* pcSend,char* pcReceive);

extern void ShowLine(char*);
extern void CpuShowAllRegToWnd();
extern int GetControlOption(CString &strReset,CString &strEa,CString &strEben);
extern BOOL GetCpuStatus(unsigned char&);

void DisplayErrorMessage(int nErrorID);
void DisplayErrorMessageBox(int nErrorID);

int GetCurrentBank(void);
int GetPCBank(void);
STATUS SetPCBank(int);
void FWCmd(int nArgc, char* pszArgv[]);

void ControlCmd(int nArgc, char* pszArgv[])
{
FLAG   signal;
int    iControlId;
int    nErrorID;             
CString strReset,strEa,strEben;
//CCpuServer *CpuSrv;
GetControlOption(strReset,strEa,strEben);
//if display control setting
    if(1== nArgc)
    {   
      if(strEa=="EA")
       {
        iControlId=IDEA;
        nErrorID=AbiGetControl(iControlId, &signal);
        if(ICE_OK == nErrorID)
         {
            if(signal==IDENABLE)
                ShowLine("EA is enable.");
            else
                ShowLine("EA is disable.");
          }
          else
            DisplayErrorMessage(nErrorID);
        }
        
      if(strReset=="RESET")
       {      
        iControlId=IDRESET;
        nErrorID=AbiGetControl(iControlId, &signal);
        if(ICE_OK == nErrorID)
         {
            if(signal==IDENABLE)
                ShowLine("RESET is enable.");
            else
                ShowLine("RESET is disable.");
          }
          else
            DisplayErrorMessage(nErrorID);    
        }
                                             
      if(strEben=="EBEN")
       {                                             
        iControlId=IDEBEN;
        nErrorID=AbiGetControl(iControlId, &signal);
        if(ICE_OK == nErrorID)
         {
            if(signal==IDENABLE)
                ShowLine("EBEN is enable.");
            else
                ShowLine("EBEN is disable.");
          }
          else
            DisplayErrorMessage(nErrorID);        
        }    
    }
    if(3==nArgc)
    {
        CString str = strupr(pszArgv[1]);
        if(str=="RESET")
         iControlId = IDRESET;
        else
         if(str=="EA")
          iControlId = IDEA;
          else iControlId=IDEBEN;

        str = strupr(pszArgv[2]);
        if(str=="ENABLE")
            signal = IDENABLE;
        else
            signal = IDDISABLE;

        nErrorID=AbiSetControl(iControlId , signal);

        if(ICE_OK == nErrorID)
        {
            switch(iControlId)
            {
             case IDRESET:
                  if(signal == IDENABLE)
                    ShowLine("RESET is enable.");
                   else
                    ShowLine("RESET is disable.");
                  break;  
                  
             case IDEA:     
                  if(signal==IDENABLE)
                    ShowLine("EA is enable");
                   else
                    ShowLine("EA is disable");
                  break;
             
             case IDEBEN:     
                  if(signal==IDENABLE)
                    ShowLine("EBEN is enable");
                   else
                    ShowLine("EBEN is disable");       
                  break;  
                    
             }
             
             
        }
        else
            DisplayErrorMessage(nErrorID);
    }        
}


/*void IdentifyCmd(int,char*)
{
char fwVer[8];
char strDisplay[30];
int  nErrorID;
    
    nErrorID = AbiGetFwID(fwVer);
    if(ICE_OK == nErrorID)
    {
        wsprintf(strDisplay, "The F/W version is %s" , fwVer);
        ShowLine(strDisplay);
    }
    else
        DisplayErrorMessage(nErrorID);
} */


void InportCmd(int nArgc, char* pszArgv[])
{
UINT     portval;
unsigned char  nPort;
char     DisplayStr[28];
int      nErrorID;
int      i;

    nPort =(unsigned char) atoi(pszArgv[1]);
    ASSERT(nPort < 7);

    switch(nPort)
    {
        case 0:
            nErrorID = AbiInput(PORT_P0, &portval);
            break;
        case 1:
            nErrorID = AbiInput(PORT_P1, &portval);
            break;
        case 2:
            nErrorID = AbiInput(PORT_P2, &portval);
            break;
        case 3:
            nErrorID = AbiInput(PORT_P3, &portval);
            break;
        case 4:
            nErrorID = AbiInput(PORT_P4, &portval);
            break;
        case 5:
            nErrorID = AbiInput(PORT_P5, &portval);
            break;
        case 6:
            nErrorID = AbiInput(PORT_P6, &portval);
            break;    
    }
    if(ICE_OK == nErrorID)
    {
        if (nArgc == 2)
        {
            CString str("");
            wsprintf(str.GetBuffer(30),"P%i value is ",nPort);
            str.ReleaseBuffer();
            CString bitstr("");
            for(i = 7;i >=0 ; i --)
            {
                if(_rotl(1,i)&portval)
                    bitstr="1";
                else
                    bitstr="0";
                str+=bitstr;
            }          
            str+='B';
            ShowLine(str.GetBuffer(30)); str.ReleaseBuffer();
        }
        if (nArgc == 3)
        {
            wsprintf(DisplayStr,"P%i value is %02X", nPort,portval);
            ShowLine(DisplayStr);
        }
        if(nArgc == 4)
        {
            int nBit = atoi(pszArgv[3]);
            ASSERT(nBit<8);
            wsprintf(DisplayStr,"P%i bit%i is %01i",nPort,nBit,
                ((portval<<(15-nBit))>>15) );
            ShowLine(DisplayStr);
        }
    }        
    else
        DisplayErrorMessage(nErrorID);
}


void OutportCmd(int nArgc, char* pszArgv[])
{
unsigned short portval;
unsigned char  nPort;
char*    stop_at;
UINT mask=0x0001;

    nPort = (unsigned char)atoi(pszArgv[1]);
    ASSERT(nPort < 7);

    if (nArgc == 4)
    {
        portval = (unsigned short)strtoul(pszArgv[3],&stop_at,16);
        AbiOutput((PARA_PORT)nPort,portval,0xffff);  //maskflag = 0, unmask.
    }
    if(nArgc == 5)
    {
        portval = (unsigned short)strtoul(pszArgv[4],&stop_at,16);
        ASSERT(portval==0 || portval==1);
        int nBit = atoi(pszArgv[3]);
        mask =(mask<<nBit);
        portval = portval<<nBit;
        AbiOutput((PARA_PORT)nPort,portval,mask);
    }
}
  
 
extern char* statusTbl[];

void CycleCmd(int /*nArgc*/, char*[] /*pszArgv[]*/)
{
int pLineNum;
CYCLE_INFO cycleInfo[30];
char   strDisplay[60] ;
CString  strBit="";
    
    int nErrorID = AbiCycle(&pLineNum,&cycleInfo[0]);
    
    if(ICE_OK == nErrorID)
    {
        ShowLine("ADDRESS  DATA  STATUS  PORT   SPARE");
        
        for(int i = 0; i< pLineNum; i++)
        {
            unsigned char spare = (unsigned char)(cycleInfo[i].status&0xf8);
            unsigned char status =(unsigned char)(cycleInfo[i].status&0x7);
            ASSERT(status<5);
            strBit = "";
            for(int j=7;j>2;j--)
            {
                if((spare&(1<<j))!=0)
                    strBit += '1';
                else
                    strBit += '0';
            }            
            
            wsprintf(strDisplay," %4X     %2X     %s     %2X    %s",
                     cycleInfo[i].addr,cycleInfo[i].data,statusTbl[status],
                     cycleInfo[i].port,strBit);
            ShowLine(strDisplay); 
        }
        CpuShowAllRegToWnd();
    }
    else
        DisplayErrorMessage(nErrorID);

}

void FWCmd(int nArgc, char* pszArgv[])
{
	if(nArgc==1)
		return;
	if(pszArgv[1][0]=='J'&&
		pszArgv[1][1]=='E'&&
		pszArgv[1][2]=='F'&&
		pszArgv[1][3]=='F'&&
		pszArgv[1][5]==NULL)
	{
		if(!isSourceOn)
			return;
    	if(pszArgv[1][4]=='S')
    		pSourceWnd->SendMessage(WM_COMMAND, ID_VIEW_SOURCEONLY, 0L);
    	else if(pszArgv[1][4]=='M')
    		pSourceWnd->SendMessage(WM_COMMAND, ID_VIEW_MIXED, 0L);
    	else if(pszArgv[1][4]=='A')
    		pSourceWnd->SendMessage(WM_COMMAND, ID_VIEW_ASSEMBLE, 0L);
		return;
	}
	if(pszArgv[1][0]!='\"')
		return;

int nLen;
char buf[0x100];

	strncpy(buf, &pszArgv[1][1], 0xff);
	nLen=strlen(buf)-1;
	if(nLen<1)
		return;
	if(buf[nLen-1]!='\"')
		return;
	buf[nLen-1]=NULL;
	AbiHidenCommand(buf, buf);
	buf[0xff]=NULL;
	ShowLine(buf);
}

void BankCmd(int nArgc, char* pszArgv[])
{
BYTE	bBank, bPCBank, result;
STATUS	retAbi;
char	errMsg[70];

	ASSERT(nArgc==1||nArgc==2);
	if(GetCpuStatus(result))
	{
		if ( 1/*STATUS_GO*/ == result )
		{
			::ErrGetErrorText(ER_GOFLY_ERR_MSG, errMsg);
			::ShowLine (errMsg);
			return;
		}
	}
	if(nArgc==1)
	{
		retAbi=AbiGetBank(bBank, bPCBank);
		if(retAbi!=ICE_OK)
		{
			ErrGetErrorText(ER_ICE_OK+retAbi, errMsg);
			ShowLine(errMsg);
			return;
		}
		ASSERT(g_nCurrentBank==bBank&&(g_nCurrentBank=bBank));
		wsprintf(errMsg, "Current selected bank is bank%d, PC located bank is bank%d",
					bBank, bPCBank);
		ShowLine(errMsg);
	}
	else
	{
		bBank=BYTE(atoi(pszArgv[1]));
		ASSERT(bBank>=1&&bBank<=4);
		retAbi=AbiSelectBank(bBank);
		if(retAbi!=ICE_OK)
		{
			ErrGetErrorText(ER_ICE_OK+retAbi, errMsg);
			ShowLine(errMsg);
			return;
		}
		g_nCurrentBank=bBank;
		ShowLine("Bank select OK!");
	}
}

int GetCurrentBank(void)
{
	if(!g_nBankNum)
		return 1;
	ASSERT(g_nCurrentBank<5&&g_nCurrentBank>0);
	return g_nCurrentBank+5;
}

int GetPCBank(void)
{
static int s_LastPCBank=g_nBankNum?6:1;

STATUS	retAbi;
BYTE	bBank, bPCBank, result;

	if(!g_nBankNum)
		return 1;
	if(GetCpuStatus(result))
	{
		if ( 1/*STATUS_GO*/ == result )
		{
			return s_LastPCBank;
		}
	}
	retAbi=AbiGetBank(bBank, bPCBank);
	if(retAbi!=ICE_OK)
	{
		ErrDisplayError(ER_ICE_OK+retAbi);
		//return;
	}
	ASSERT(bPCBank>=1&&bPCBank<=4);
	//ASSERT(g_nCurrentBank==bBank&&(g_nCurrentBank=bBank));
	s_LastPCBank=bPCBank+5;
	return bPCBank+5;
}

STATUS SetPCBank(int nBank)
{
STATUS	retAbi;

	if(!g_nBankNum)
		return ICE_OK;
	ASSERT(nBank==1||nBank>5&&nBank<=9);
	if(nBank>5)
		nBank-=5;
	else
	{
		nBank=GetCurrentBank();
		if(nBank>5)
			nBank-=5;
	}
	retAbi=AbiSetPCBank((BYTE)nBank);
//	retAbi=ICE_OK;
	return retAbi;
}

void DisplayErrorMessage(int nErrorID)
{
  //FOR  Display the ABI error message using
    char	 pszAbiError[150];

	ErrGetErrorText(ER_ICE_OK+nErrorID, pszAbiError);
    ShowLine(pszAbiError);
}   // End of CCpuServer::DisplayErrorMessage().

void DisplayErrorMessageBox(int nErrorID)
{                                        
   //FOR  Display the ABI error message using
	ErrDisplayError(ER_ICE_OK+nErrorID);
}   // End of CCpuServer::DisplayErrorMessageBox().


//////////////////////////////(EOF)/////////////////////////////
