
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/NWMEM.H__   1.2.1.4   17 Apr 1997 15:57:36   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/NWMEM.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:57:36   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:29:10   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:39:30   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:18:34   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:23:26   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:33:30   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:48:40   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:20   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:36   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:42   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:12   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:16   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:46   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:20   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.6.1.0   19 Jul 1996 09:52:22   ZJRD
** EasyPack/SLD Version 1.20b
** 
**    Rev 1.8   20 Jun 1996 09:26:12   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:50   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:30:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:58   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:50   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:28   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:38:26   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:52   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:24   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:40   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:13:10   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:17:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:17:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:22   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:32   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:00   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:46   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:08   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:28   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:40   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:34   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:30   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:29:18   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:48   Shirley
** EasyPack/SLD Version 0.22
**
**    Rev 1.4   13 Oct 1995 13:22:58   Shirley
** EasyPack/SLD Version 0.1d
**
**    Rev 1.3   29 Sep 1995 09:49:56   Shirley
** No change.
**
**    Rev 1.2   20 Sep 1995 10:52:58   Shirley
** No change.
**
**    Rev 1.1   15 Sep 1995 09:48:40   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:53:52   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  NWMEM.H
//
//  Description:The header file for the class: CNewMemory
//
//  Author:     Lane Li
//
//  Modification:
//
//      3. 03/15/1996   1.0 version          Daniel Lin
//                   Add some remark
//
//      2. 19/10/95, 0.1d version
//                   Modified        CNewMemory
//                                   add private variable m_lLastStart;
//
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "gridmem.h"

// nwmem.h : header file
/////////////////////////////////////////////////////////////////////////////
// CMemoryWindow frame

class CMemoryWindow : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CMemoryWindow)

public:
	CMemoryWindow(BYTE no=0);
	virtual ~CMemoryWindow();
	BOOL Create(LPCSTR szTitle, LONG style = 0,
			const RECT& rect = rectDefault, 
			CMDIFrameWnd * pParent = NULL );

// Attributes
private:
	enum	{
				SM_BYTE=1,
				SM_WORD=2,
				SM_DWORD=3
			};
	enum	{
				SM_DEC=1,
				SM_UDEC=2,
				SM_HEX=3,
				SM_CODE=4
			};
	static CMenu NEAR m_menu;
    static char m_searchStr[200];

	int	m_nLines;						//m_nLines-2 lines(not include title)
										//in window in fact.
	BYTE*	m_pMemBuffer;
	DWORD	m_dwBufStartAddr;
	DWORD	m_dwBufEndAddr;
	WORD	m_wMemBufferLen;
	BYTE*	m_byMem;
	struct	dsm	*m_dsm;
	WORD	m_wDSMBufferLen;
	int		m_nDSMNum;
	DWORD	m_dwBottomlineAddr;
	WORD	pMax, pMin, xMax, xMin, iMax, iMin;		//NOT IN EP251
	DWORD	m_dwMemRegionEnd;

	CGridMem	m_gridAddr;           // Address grid
	CGridMem	m_gridMem;            // Memory grid
	CGridMem	m_gridAscii;          // Ascii grid
	CGridMem	m_gridInstruction;    // Instruction grid(only for disassembly)
	
	BOOL	m_bIconic;
	BOOL	m_bHScrollOn;

	int		m_nPosX;          	// Scroll increase
              
	WORD	m_wCaretPosX1;   // Indicate the every grid position
	WORD	m_wCaretPosX2;   // Indicate every char in one grid
	WORD	m_wCaretPosY;
	int		m_nCaretArea;

	int		m_nCharWidth;
	int		m_nLineHeight;

	BOOL	m_bFocus;
	int		m_nCursor;

	BOOL	m_bShiftDown;

	long	m_lValue;
	WORD	m_wValue;
	BYTE	m_byValue;
	char*	m_lpszValue;

public:
//next six varible all init in NewMemoryOpenWindow	
	BYTE	m_bWndNo;
	//BYTE	m_bMemoryRegion;
	BYTE	m_nSpaceType;			//NOT IN EP251
	DWORD	m_dwStartAddress;

	// m_bViewMode1    1  --    Byte
	//                 2  --    WORD
	//                 3  --    LONG
	// m_bViewMode2    1  --    Signed Decimal
	//                 2  --    Unsigned Decimal
	//                 3  --    Hexdecimal
	//                 4  --    Disassenbly
	BYTE	m_bViewMode1;
	BYTE	m_bViewMode2;
	BOOL	m_bShowAscii;
	int		m_nLineGroup;			//1 or 2
	
// Operations
private:
	void	ShowStatusGo(void);
	void	SetWindowTitle(long addr=-1);

	void FillText(LPCSTR,UINT,RECT,CDC*, BOOL isGrey=FALSE);
	void FillText2(LPCSTR,UINT,RECT,CDC*);
	void FillText3(LPCSTR,UINT,RECT,CDC*);

	void SetScrollBar();

	void SetAddress();
	void SetAscii();
	void SetInstruction();

	void SetByteSignedDecimal();
	void SetWordSignedDecimal();
	void SetLongSignedDecimal();

	void SetByteUnsignedDecimal();
	void SetWordUnsignedDecimal();
	void SetLongUnsignedDecimal();

	void SetByteHexadecimal();
	void SetWordHexadecimal();
	void SetLongHexadecimal();
	
	void SetDisassemble();
	
	void SetMemoryWindow();

	void ShowAddress(CDC*);
	void ShowAscii(CDC*);
	void ShowInstruction(CDC*);

	void ShowByteSignedDecimal(CDC*);
	void ShowWordSignedDecimal(CDC*);
	void ShowLongSignedDecimal(CDC*);
	
	void ShowByteUnsignedDecimal(CDC*);
	void ShowWordUnsignedDecimal(CDC*);
	void ShowLongUnsignedDecimal(CDC*);

	void ShowByteHexadecimal(CDC*);
	void ShowWordHexadecimal(CDC*);
	void ShowLongHexadecimal(CDC*);

	void ShowDisassemble(CDC*);

	void ShowMemoryWindow(CDC*);

	void SetMyCaretPos();
    
    void xGotoCursor();
	void GotoCursor();

	BOOL InWnd();
    void PaintLine(WORD line);
    
	void Right();
	void Left();
	void Up();
	void Down();
	void Home();
	void End();
	void Tab();

	void OnModeChange(void);
	void PrepareData(void);
	BOOL InputCheck(UINT);
	void WriteMemory(UINT);
	void GetValue();
	void ValueToStr();
	BOOL StrToValue();
	void SetRegionEnd(void);

public:
	void RefreshMemWin(BOOL hard);

// Implementation
public:
	// Generated message map functions
	//{{AFX_MSG(CMemoryWindow)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnViewByte();
	afx_msg void OnUpdateViewByte(CCmdUI* pCmdUI);
	afx_msg void OnViewWord();
	afx_msg void OnUpdateViewWord(CCmdUI* pCmdUI);
	afx_msg void OnViewLong();
	afx_msg void OnUpdateViewLong(CCmdUI* pCmdUI);
	afx_msg void OnViewSigneddecimal();
	afx_msg void OnUpdateViewSigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnViewHexadecimal();
	afx_msg void OnUpdateViewHexadecimal(CCmdUI* pCmdUI);
	afx_msg void OnViewDisassemble();
	afx_msg void OnUpdateViewDisassemble(CCmdUI* pCmdUI);
	afx_msg void OnViewAscii();
	afx_msg void OnUpdateViewAscii(CCmdUI* pCmdUI);
	afx_msg void OnViewUnsigneddecimal();
	afx_msg void OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg long OnXMRepaint(UINT,LONG);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnEditGoto();
	afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
	afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
	afx_msg void OnViewRefresh();
	afx_msg void OnUpdateViewRefresh(CCmdUI* pCmdUI);
	afx_msg void OnEditSearch();
	afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
	afx_msg void OnEditSearchnext();
	afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
	afx_msg void OnShiftreturn();
	afx_msg void OnGroupMemory();
	afx_msg void OnMap();
	afx_msg void OnUpdateMap(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGroupMemory(CCmdUI* pCmdUI);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg void OnViewShortline();
	afx_msg void OnUpdateViewShortline(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnStkTab();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

struct dsm
{
        long address;
        char code[10];
        char instruction[256];
};
