/***************************************************************************
**
** File name : abidef.h
**
**      Description: definitions of variables and constants
**
**
** Changing :
**
** A. Date -- 10/29/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Created from define.c and other .h files.
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#ifndef _ABI_DEF_
#define _ABI_DEF_
#include "windows.h"
#ifndef _BASE_TYPE_
#include "basetype.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#define STATUS S16
#define test_bit(msk,num)        (msk & (1L<<(num)))
#define set_bit(msk,num)         (msk = msk|(1L<<(num)))
#define clr_bit(msk,num)         (msk = msk&(~(1L<<(num))))
/*****************************************************************/
/* Define status codes                                           */
/*****************************************************************/
#define FLAG_I          0x01    /* break on instruction fetch */
#define FLAG_R          0x02    /* break on read */
#define FLAG_W          0x04    /* break on write */

#define MAP_END_RECORD      0xaa55
#define BUFF_LEN             512
#define MAX_COMM_BUFF        1534
#define streamMaxLen    100  /* Maximum Stream Length */
//#define ADDR            U32

typedef struct{
   U32 pos;
   U16 space;
}ADDR;

enum RUN_MODE_DEF{
   NORMAL_RUN = 0,FREE_RUN,FLY_RUN,MONITOR_RUN,TEST_RUN
}; 
/*
extern RUN_MODE_DEF RUN_MODE;
*/
/*
typedef enum {
   FIRMWARE_TYPE,
   FIRMWARE_VER,
   CPU_TYPE,
   CPU_VER,
   TRACE_EXIST,
   INIT_HW_STATUS,
   RESERVE2,
   MAX_ID
}ID_INFO;
*/
/*
typedef enum {
   S_BYTE = 0, 
   S_WORD = 1, 
   S_LONG = 2  
} SIZE;*/

#define BASE_REG_NO   5
   /* the first to fifth i86 register only write at cpu actice. */

#define TIMER_BUFFER       5
#define MAX_BASE_REG_NO    6
/*****************************************************************************/
/* Return codes     */
/*****************************************************************************/

#define ICE_DIFF_FOUND                0    /* difference data found at comparison */
#define ICE_MATCH                     0    /* Search match */
#define ICE_OK                        0    /* Normal return */
#define ICE_MICE_HALT              ( -1)   /* Target CPU halted */
#define ICE_MEM_GUARD              ( -2)   /* Access the guarded memory */
#define ICE_MEM_PROTECT            ( -3)   /* Access the protected memory */
#define ICE_ERROR_READ             ( -4)   /* Memory read failure */
#define ICE_ERROR_WRITE            ( -5)   /* Memory write failure */
#define ICE_STEP_ERROR             ( -6)   /* Target cnnot step */
#define ICE_NO_DIFF                ( -7)   /* No difference in memory compare */
#define ICE_NO_FOUND               ( -8)   /* Not found in memory search */
#define ICE_BREAK                  ( -9)   /* Break on memory access */
#define ICE_BREAK_I                (-10)   /* Break on instruction fetch */
#define ICE_BAD_REG                (-11)   /* Bad register number encountered */
#define ICE_BAD_IN                 (-12)   /* Error encountered on user input */
#define ICE_HALT_USER              (-13)   /* user pressed ^C */
#define ICE_ERROR_COM              (-14)   /* communication error */
#define ICE_ERROR_MICE             (-15)   /* linking incorrect MICE model */
#define ICE_MICE_LIMIT             (-16)   /* MICE limitation */
#define ICE_BUS_REQUEST            (-17)   /* Bus request */
#define ICE_BAD_FRAME              (-18)   /* invalid frame number */
#define ICE_ERROR_BOUN             (-19)   /* error map boundary */
#define ICE_MAP_FAIL               (-20)   /* memory map fail */
#define ICE_ABS_OVERFLOW           (-21)   /* abs address overflow */
#define ICE_TEST_FAIL              (-22)   /* test failure */
#define ICE_CPU_RUN                (-23)   /* CPU free running */
#define ICE_BROKE                  (-24)   /* CPU stop */
#define ICE_NOT_READY              (-25)   /* target is not ready */
#define ICE_COMMAND_ERROR          (-26)   /*  */
#define ICE_TIME_OUT               (-27)   /*  */
#define ICE_NO_TRACE_MODULE        (-28)   /*  */
#define ICE_BKPT1_HALT             (-29)   /*  */
#define ICE_BKPT2_HALT             (-30)   /*  */
#define ICE_VIOL_HALT              (-31)   /*  */
#define ICE_RBW_HALT               (-32)   /*  */
#define ICE_TRIG_HALT              (-33)   /*  */
#define ICE_LINK_MICE_FAIL         (-34)   /*  */
#define ICE_WARN_START             (-35)   /*  */
#define ICE_BANK_FULL              (-36)
#define ICE_ADDR_RANGE_OVERFLOW    (-37)
#define ICE_ATTRIBUTE_MISMATCH     (-38)
#define ICE_BANK_MISMATCH          (-39)
#define ICE_SPACE_MISMATCH         (-40)
#define ICE_ADDR_MISMATCH          (-41)
#define ICE_NO_VCC                 (-42) /* No target VCC */
#define ICE_USER_CC                (-43)
#define ICE_TARGET_RESET           (-44)
#define ICE_NO_EMM                 (-45)
#define ICE_CNT_ERROR              (-46)
#define ICE_TIMER_ERROR            (-47)
#define ICE_EVENT_FULL             (-48)
#define ICE_BUFFER_EMPTY           (-49)
#define ICE_EMM_SET_ERROR          (-50)
#define ICE_EP_PENDING             (-51)
#define ICE_REC_TIME_OUT           (-52)
#define ICE_INVALID_CPU            (-53) // only usd at sw.
#define ICE_MCE16A_FAIL            (-54)
#define ICE_EMM_FAIL               (-55)
#define ICE_TRACE_BOARD_FAIL       (-56)
#define ICE_COV_RBW_FAIL           (-57)
#define ICE_CPU_FLY                (-58)
#define ICE_INVALID_FLY_COMMAND    (-59)
#define ICE_INVALID_FIRMWARE       (-60) // only usd at sw.
#define ICE_SW_BKPT_HIT            (-61)
#define ICE_FILE_NOT_FOUND         (-62) // only used at sw.


#define ICE_SYNTAX_ERROR                   (-70)



#define maskBit 1

#define mapNo   33
#define BASE_TIME                0xFF  // communication time out
#define M128K                    0x20000

typedef struct {
   U32 addr;
   U8  stat;
   U16 data;
   U8  tstamp,
       tbit;
}TRACE_DATA;   

typedef struct{
   U32 addr;
   U16 space;
   U16 actual;
   U32 addr_dummy;
   U16 space_dummy;
   U16 expected;
}RET_ADDR;

typedef struct {
   U32 addr1;
   U32 addr2;
   U16 attr;
}MAP_INFO;

//typedef struct{
//   U16 defined; /* 1=trigger is defined, 0=not defined */
 //  U16 evNo[11]; /* 1 ~ 3 for MICE-III, 1 ~ 5 for MICE-IIIS */
	/* 1~11 for Michelle, 1~8 is ev#, 9 ic cnt0, 10 is cnt1, 11 is external */
	/* if the most significant bit is 1, NOT is prefixed the event */
	/* 0=end of event_sequence */
//   U16 op[5]; /* 1=OR, 2=AND, 3=THEN, 0=end of sequence */
	/* this field is not used in Michelle */
//   U16 arm[7]; /* arm other triggers, 0=end of arms. it is for MICE-IIIS only */
//   U16 act[11]; /* action in Michelle can be multi-defined */
	/* the bit position for relative action are as below: */
	/* bit-0=BREAK< bit-1=RESET, bit-2=SEQ, bit-3=TROFF, bit-4=NEXT */
	/* bit-5=INC0, bit-6=RST0, bit-7=INC1, bit-8=RST1, bit-9=EXT */
	/* bit-10=TRON, bit-11=TMON, bit-12=TMOFF */
//   U16 mode; /* 0=backward, 1=forward, 2=center, 3=delay */
//   U16 delay; /* delay count */
//}TRIGGER;

typedef enum {
   MP_QUALIFY_OFF, MP_QUALIFY_ON
   } MP_QUALIFY;


typedef struct MV_TRIG {
	int defined; /* 1=trigger deinfed, 0=not defined*/
	int isTimerOn;/* 1=timer on, 0=timer off*/
				  /* 2=not set*/
	int isTraceOn;/* 1=trace on,0=trace off*/
				  /* 2=not set*/
				  /* if you want to set state#,these two value must be 2*/
				  /* if you don't want to set state#,these two value must not all be 2*/
	U8 traceMode; /*4=delay count;2=forward;3=center;1=backward*/
	U16 count;/*delay count*/
	int isRun;     /*1=run,0=not run*/
	/*for state#*/
	U8 trigAction[10];/*0=end of action;*/
					  /*1-8=levelA-H;*/
					  /*9=reset*/
	struct MV_TRIG* next[10];/*point to next struct*/                                 
	
}MV_TRIGGER;


typedef struct {
    int defined; /* 1=event is defined, 0=not defined */
    int addrSpec; /*0: address not specified */
		       /*1:  address is a simple value */
			/*2: address with range value */
			/*3: address with mask(wildcard) */
    U32 addrLo;/*if range, start address; */
		/*if  wildcard, value */
    U32 addrHi;/*if range,end address; */
		/*if wildcard, mask:0 mask,1 not mask */
    int dataSpec; /*0: data not specified */
		       /*1:  data is a simple value */
		   /*3: data with mask(wildcard) */

    U32 dataLo;/* value */
    U32 dataHi;/*mask:0 mask,1 not mask */
    U32 stat;/*bit0=SP,bit1=SR,bit2=SW,bit3=UP,bit4=UR,bit5=UW,bit6=AK*/
    U16 count;/*0--ffff*/
}BUS_EVENT;

typedef struct {
    int defined; /* 1=event is defined, 0=clear */
    U8  isEnabled;/*0=disable; 1=enable*/
    int addrSpec; /*0: address not specified */
		       /*1:  address is a simple value */
			/*2: address with range value */
			/*3: address with mask(wildcard) */
    U32 addrLo;/*if range, start address; */
		/*if  wildcard, value */
    U32 addrHi;/*if range,end address; */
		/*if wildcard, mask:0 mask,1 not mask */
    int externSpec; /*0: extern not specified */
		       /*1:  data is a simple value */
		   /*3: data with mask(wildcard) */

    U16 externLo;/* value */
    U16 externHi;/*mask:0 mask,1 not mask */
    U32 stat;/*bit0=SP,bit1=SR,bit2=SW,bit3=UP,bit4=UR,bit5=UW,bit6=AK*/
}QUALIFY;


typedef struct{ /*only for lam2*/
   U16 defined; /* 1=level is defined, 0=not defined */
   U16 evNo[8]; /*1 ~ 5 for MICE-IIIS */
				/* 0=end of event_sequence */
				/* if bit15==1,has "not" prefix*/
   U16 op[5];     /* 1=OR, 2=AND, */
   U8  isTimerOn; /*1=on,2=off,0=not care*/
   U8  isTraceOn; /*1=on,2=off,0=not care*/
}LEVEL;


typedef struct{
    int defined; /* 1=event is defined, 0=not defined */
    U32 addr;
}EXEC_EVENT;

typedef struct {
    long startFrame;
    long endFrame;
}BUFFER_DEPTH;

typedef struct {
   U16     qFlag;
   U32     startAddr,
	   endAddr;
   U16     status;
   U16     traceBitData,
	   traceBitWild;
}QUALIFY_LIST;

struct pcstatus {
   int  flag;
   unsigned char addr[6];
   char ascii[14];
   char msg[80];
};

/*
typedef struct {
   U32 frameNo;
   U32 addr;
   U8  stat;
   U16 data;
   U8  tstamp, tbit;
} TRACE_INFO;*/

typedef struct {
   STATUS WorkingError;
   U8 EpAddress[4];
   U8 EpData[4];
   U8 EpStatus[2];
}ERROR_MCE_WORK_TEST;

typedef struct {
   STATUS ConnectorError;
   ERROR_MCE_WORK_TEST Working[96];
}ERROR_MCE_CONN_TEST;

typedef struct{
   U16 portAddr,
       idFlag,
       buffSize,
       testResult;
   U8  testFlag,
       timeOut,
       fileName[80];
   DCB comDcb;
}INITIAL_INFO;

typedef struct{
   U16 defined; /* 1=trigger is defined, 0=not defined */
   U16 evNo[11]; /* 1 ~ 3 for MICE-III, 1 ~ 5 for MICE-IIIS */
	/* 1~11 for Michelle, 1~8 is ev#, 9 ic cnt0, 10 is cnt1, 11 is external */
	/* if the most significant bit is 1, NOT is prefixed the event */
	/* 0=end of event_sequence */
   U16 op[5]; /* 1=OR, 2=AND, 3=THEN, 0=end of sequence */
	/* this field is not used in Michelle */
   U16 arm[7]; /* arm other triggers, 0=end of arms. it is for MICE-IIIS only */
   U16 act[11]; /* action in Michelle can be multi-defined */
	/* the bit position for relative action are as below: */
	/* bit-0=BREAK< bit-1=RESET, bit-2=SEQ, bit-3=TROFF, bit-4=NEXT */
	/* bit-5=INC0, bit-6=RST0, bit-7=INC1, bit-8=RST1, bit-9=EXT */
	/* bit-10=TRON, bit-11=TMON, bit-12=TMOFF */
   U16 mode; /* 0=backward, 1=forward, 2=center, 3=delay */
   U16 delay; /* delay count */
}MP_TRIGGER;

typedef enum  {
   S_BYTE = 0, /* bit 0 */
   S_WORD = 1, /* bit 1 */
   S_LONG = 2  /* bit 2 */
} ABI_SIZE;

/* define the command ID od the Michelle firmware function */
typedef enum  {
   DIAG_START,             /* 0  -- 0x0  */
   D_GET_ID,               /* 1  -- 0x1  */ // special command, must place 1st.
   INITIAL_TEST,           /* 2  -- 0x2  */
   MCE_OPEN_SHORT_TEST,    /* 3  -- 0x3  */
   MCE_PULL_HIGH_TEST,     /* 4  -- 0x4  */
   MCE_MAP_TEST,           /* 5  -- 0x5  */
   MCE_MEMORY_TEST,        /* 6  -- 0x6  */
   PROGRAM_XLX,            /* 7  -- 0x7  */
   EREC1_SHORT_TEST,       /* 8  -- 0x8  */
   EREC2_SHORT_TEST,       /* 9  -- 0x9  */
   TMAN_SHORT_TEST,        /* 10 -- 0xa  */
   VRAM_SAM_TEST,          /* 11 -- 0xb  */
   T74AS575_BUS_TEST,      /* 12 -- 0xc  */
   EXTERNAL_BUS_TEST,      /* 13 -- 0xd  */
   SEQ_RAM_TEST,           /* 14 -- 0xe  */
   VRAM_DRAM0_TEST,        /* 15 -- 0xf  */
   VRAM_DRAM1_TEST,        /* 16 -- 0x10 */
   VRAM_DRAM2_TEST,        /* 17 -- 0x11 */
   VRAM_DRAM3_TEST,        /* 18 -- 0x12 */
   VRAM_DRAM4_TEST,        /* 19 -- 0x13 */
   VRAM_DRAM5_TEST,        /* 20 -- 0x14 */
   VRAM_DRAM6_TEST,        /* 21 -- 0x15 */
   VRAM_DRAM7_TEST,        /* 22 -- 0x16 */
   VRAM_DRAM8_TEST,        /* 23 -- 0x17 */
   VRAM_DRAM9_TEST,        /* 24 -- 0x18 */
   VRAM_DRAMA_TEST,        /* 25 -- 0x19 */
   VRAM_DRAMB_TEST,        /* 26 -- 0x1a */
   VRAM_DRAMC_TEST,        /* 27 -- 0x1b */
   VRAM_DRAMD_TEST,        /* 28 -- 0x1c */
   VRAM_DRAME_TEST,        /* 29 -- 0x1d */
   VRAM_DRAMF_TEST,        /* 30 -- 0x1e */
   MCE_CONNECT_TEST,       /* 31 -- 0x1f */
   REPEAT_DIAG,            /* 32 -- 0x20 */
   END_DIAG,               /* All new command must add before this command. */
} DIAG_ID;

typedef  enum  {
   A_LINE = 0xa0,
   F_LINE = 0xf0
   } BKPT_OP_68K;
   
typedef  struct {
   ADDR_SPACE space;
   U32   offset;
   U32   actual;
   U32   expected;
   }  BAD_MEMORY;


typedef struct {
   U32 frameNo;
   U32 addr;
   U16 stat;
   U16 data;
   U16 data2;
   U8  tstamp;
   U8  spare;
   U32 misc;
} MP_TRACE_INFO;
/*
typedef enum {CPU16,CPU32,NA1,NA2,CPU306,CPU302,CPU307,CPU328,NA3,NA4,
	      CPU68302_M3,CPU68000_M3,CPU68010_M3,CPU68020_M3,
	      CPU68030_M3,CPU68040_M3} CPU_TYPEABI;
*/
#define CBR_110      0xFF10
#define CBR_300      0xFF11
#define CBR_600      0xFF12
#define CBR_1200     0xFF13
#define CBR_2400     0xFF14
#define CBR_4800     0xFF15
#define CBR_9600     0xFF16
#define CBR_14400    0xFF17
#define CBR_19200    0xFF18
#define CBR_38400    0xFF1B
#define CBR_56000    0xFF1F
#define CBR_128000   0xFF23
#define CBR_256000   0xFF27

#define ESC 0x1b

#define COM_PCE 1
#define COM_SERIAL 2

typedef struct BKPT_ENTRY_TAG_ABI {
   struct BKPT_ENTRY_TAG_ABI *next;
   struct BKPT_ENTRY_TAG_ABI *prev;
   U16 id;
   U16 opcode;
   U32 addr;
   ADDR_SPACE space;
   S16 status;
} BKPT_ENTRY_ABI;


#endif
/**************************** End of File **********************************/
