/*****************************************************************************
**
**  Name: abidrive.c
**
**  Description: This is the code for drivers of ABIs
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/arcm306/abi68k/abidrive.c_v  $
** 
**    Rev 1.3   02 Aug 1996 10:45:00   kevin
** SLD will abort automatically if communication has problem
** 
**
**  $Header:   S:/tbird/arcm306/abi68k/abidrive.c_v   1.3   02 Aug 1996 10:45:00   kevin  $
**
**  Copyright (C) 1991,1992 Microtek International.  All rights reserved.
**
*****************************************************************************/
#include <windows.h>

#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <stdio.h>


#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _PVTASK_
#include "pvtask.h"
#endif

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _COMMUNICATION_
#include "comm.h"
#endif

#ifndef _ABI_GLOBAL_
#include "abiglbs.h"
#endif

#include "abiexts.h"
/* from windows.h for Windows 3.1 */
#ifndef HFILE
typedef int HFILE; /* Polymorphic with C runtime file handle type */
#define HFILE_ERROR ((HFILE)-1)
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

extern int isEsc();

DCB ComDcb;
int portId;
COMSTAT commStat;
extern S16 LAM2;
BOOLEAN isHEMM;
/**************************************************************************
**
** Name : CheckFwStatus
**
** Function
**        Check the status of MICEpack. MICEpack have "COLD START", "NORMAL"
**        and "DIAGNOSTIC" status. the other status is not normal.
**
**    Input  :
**       None
**    Output :
**       None
** Notes:
**
**************************************************************************/
/*
RETCODE EXPORT CheckFwStatus(VOID) {
U8 idData[MAX_ID];
int i, n;

   n = 0;
   while (n++<300) {
      if (chk_hlt() == ESC) return(ICE_HALT_USER); // check keyboard.
      // Ken, Replace chk_hlt() to your program . Allen.
      if (sendB('M') != GOOD) continue;
      if (sendB('I') != GOOD) continue;
      if (sendB('C') != GOOD) continue;
      if (sendB('E') != GOOD) continue;
      i = receiveB();
      if (i == ACK) return(COLD_START);
      else if (i == ':') {
	 iceGetID(idData);
	 if (idData[0] == 'D') return(DIAGNOSTIC_STATUS);
	 else return(NORMAL_STATUS);
      }
   }
   return(ICE_TIME_OUT);
} */
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
#define FILE_SIZE     255
#define BUFF_UNIT     1024 // basic buffer unit.
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
RETCODE EXPORT linkMICE(INITIAL_INFO *initialInfo) {
RETCODE status;
U8 idInfo[MAX_ID];

   status = DownLoadFirmware(initialInfo->fileName,initialInfo->buffSize,initialInfo->timeOut);
   if (status != GOOD) return(status);
   iceGetID(idInfo);
   return (GOOD);
}   // end of linkMice()
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceInitialize(INITIAL_INFO *initialInfo) {
RETCODE status;
//U16 lp, testSeq[] = { MCE16A, EMM1, EMM2, EMM3, EMM4, TRACE_BOARD};
   int err;             
   char idInfo;         
   int i;                                  
   
   QUALIFY_LIST cond;                                   
   MP_TRACE_INFO frameData[50];
   U8 frameLen;
   
   //INIT TRIGGER BUFFER
   
// while(!isEsc());
   
   for (i=0;i<10;i++)
	trigger_record[0].next[i] = NULL;

   
   //check for PCE 
   if (initialInfo->portAddr > 10) {
	   portType = COM_PCE;  
	   portAddr = initialInfo->portAddr;
	   portStatus = initialInfo->portAddr + 1;
   } else {
       portType = COM_SERIAL;
	   //NOW FOR SERIAL
	   memcpy(&ComDcb,&(initialInfo->comDcb),sizeof(DCB));
	   portId = ComDcb.Id;  
	     
       //ComDcb.BaudRate = CBR_9600;
	   ComDcb.ByteSize = 8;
	   ComDcb.Parity = NOPARITY;
	   ComDcb.StopBits = ONESTOPBIT;
	   
	   ComDcb.fBinary = 1;
       ComDcb.fDtrDisable = 0;
       ComDcb.fRtsDisable = 0;
       ComDcb.fOutxDsrFlow = 0;
       ComDcb.fOutxCtsFlow = 0;
       ComDcb.fDtrflow = 1;
       ComDcb.fRtsflow = 0;
       ComDcb.XoffLim = 1024;
       ComDcb.XonLim = 5;
       ComDcb.Id = portId;
	       
	   /*comDcb.XoffLim = XOFF_LIMIT;*/
	   /*comDcb.XonLim = XON_LIMIT;*/
	   ComDcb.Id = portId;
	   if (SetCommState((DCB FAR *) &ComDcb) < 0) {
	       err = GetCommError(portId,&commStat);
	       //ErrDisplayError(err, FORCE_POPUP);
	       CloseComm(portId);
	       return(!ICE_OK);
	   }
   }                                       
   
   if(1==initialInfo->logOn ) log_fid = fopen("micesld.log","w");
   
   if (initialInfo->cLinkChar != 'M' && initialInfo->cLinkChar != 'S') 
	initialInfo->cLinkChar = 'S';
   status = start_up(initialInfo->cLinkChar);
   if (ICE_OK != status) return status;
    
   status = iceGetID(&idInfo);         
   if (ICE_OK != status) return status;
   
   
//   status = iceGetVerify(&verifyFlag); // get verify flag marked by jerry
//   if (ICE_OK != status) return status;
   
   if (MICE == CPU68020_M3 || MICE == CPU68030_M3) maskAddr = 0xffffffffL;
   else maskAddr = 0xffffffL;
   
//   status = iceGetAccessSize(&sizeFlag); //marked by jerry
 //  if (ICE_OK != status) return status;
   
//   status = iceIsLam2(&sizeFlag);     //marked by jerry
//   if (ICE_OK != status) return status;
   LAM2=2;
   status = iceIsHemm(&sizeFlag);
   isHEMM =sizeFlag;
   
   cond.qFlag = 0;
   frameLen = 20;
   //iceGetTraceFrame(0, 1,&cond, &frameLen,frameData);

   
   return status;
   /*status = CheckFwStatus();
   switch (status) {
      case DIAGNOSTIC_STATUS :
	 DiagnosticFunction(END_DIAG);
	 CheckFwStatus();
	 status = linkMICE(initialInfo); // for cold start and diagnostic
	 break;
      case COLD_START :
	 status = linkMICE(initialInfo); // for cold start and diagnostic
	 break;
      case NORMAL_STATUS :
	 status = ICE_WARN_START;
      case ICE_HALT_USER :
	 return(status);
      default:
	 return(ICE_TIME_OUT);
   }
   return(status);*/
}



