/***************************************************************************
 *
 * Name : ABIFUNC.H
 *
 * Description : export function prototypes of ABI routines in
 *               REG86.C, MEM86.C, SUB86.C, and EXEC86.C
 *
 * Date : 12/07/1992
 *
 *    Copyright (C) 1992 Microtek International Inc.
 *    All Rights Reserved
 *
 ***************************************************************************/
#ifndef _ABI_FUNC_
#define _ABI_FUNC_

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _BASE_TYPE_
#include "basetype.h"
#endif

#ifndef _REG68306_DEFINE_
#include "reg68k.h"
#endif


RETCODE EXPORT iceGetID(U8 *ID_Info);
RETCODE EXPORT iceSetID(U16 idFlag);
RETCODE EXPORT iceGetWait(U16 *count);
RETCODE EXPORT iceSetWait(U16 count);
RETCODE EXPORT iceGetVerify(U16 *verifyFlag);
RETCODE EXPORT iceSetVerify(U16 verifyFlag);
RETCODE EXPORT iceGetSync(U16 *sync);
RETCODE EXPORT iceSetSync(U16 syncFlag);
RETCODE EXPORT iceGetMode(U16 *modeFlag);
RETCODE EXPORT iceGetControl(U16 *signals);
RETCODE EXPORT iceSetControl(U16 id,U16 signals);
RETCODE EXPORT iceGetReady(U16 *readyFlag);
RETCODE EXPORT iceSetReady(U16 readyFlag);
RETCODE EXPORT iceGetStatus(VOID);
RETCODE EXPORT iceGetAccessSize(U16 *sizeFlag);
RETCODE EXPORT iceSetAccessSize(U16 sizeFlag);
RETCODE EXPORT iceSetTimerReg(U16 regNo);
RETCODE EXPORT iceInitialize(INITIAL_INFO *initialInfo);
RETCODE EXPORT iceDiagnostic(VOID);
RETCODE EXPORT iceSelfTest(U16 cmdId);
RETCODE EXPORT iceSetTraceBreak(U16 breakFull);
RETCODE EXPORT iceSetTraceBuffer(U16 traceBufNum);
RETCODE EXPORT iceGetTraceBuffer(U16 *traceBufNum);
RETCODE EXPORT iceGetTriggerFrame(U16 buffer, U32 *frame);
RETCODE EXPORT iceSetTimerCounter(U16 tcFlag, U32 tcData);
RETCODE EXPORT iceGetTraceInfo(U16 *lastBuff, U16 *curCNT0, U16 *curCNT1, U16 *bufNO);
RETCODE EXPORT iceGetAllTrig(MV_TRIGGER **trig_record);
RETCODE EXPORT iceSetTrig(U16 levelNo, MV_TRIGGER *tmpTrig);
RETCODE EXPORT iceClearTrig(U16 levelNo);
RETCODE EXPORT iceSetBP(U16 evId, ADDR addr);
RETCODE EXPORT iceGetEvent(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 *ext_record,
		 U8 *cntFlag, U32 *timeRecord, U16 *counter);
RETCODE EXPORT iceSetExtEvent(U16 evData);
RETCODE EXPORT iceSetAllEvents(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 ext_record);
RETCODE EXPORT iceSetEvent(U16 evId, BUS_EVENT *busEventData);

RETCODE EXPORT iceGetTraceBufferInfo(U16 bufID, S32 *start, S32 *end);

RETCODE EXPORT iceGetTraceFrame(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, 
				U8 *frameLen,MP_TRACE_INFO *frameData);

RETCODE EXPORT iceGo(U16 mode,void* bpt);
RETCODE EXPORT iceGetCpuStatus(int *goEnd);
RETCODE EXPORT iceReset(VOID);
RETCODE EXPORT iceAbort(VOID);
RETCODE EXPORT iceStepRange(ADDR addr1, ADDR addr2);
RETCODE EXPORT iceStepOne(VOID);
RETCODE EXPORT iceClearEvent(U16 evId);
RETCODE EXPORT iceGetReg(REG_MODE regMode, S16 regId,U32 *content);
RETCODE EXPORT iceGetAllReg(U32 cpuReg[]);
RETCODE EXPORT iceSetAllReg(U32 cpuReg[]);
RETCODE EXPORT iceGetAllIntReg(U16 *intReg);
RETCODE EXPORT iceSetReg(REG_MODE regMode, S16 regId, U32 content);
RETCODE EXPORT iceGetCoReg (S16 regId,U16 *content);
RETCODE EXPORT iceGetAllCoReg(U16 *cop_regs, U8 *st_regs);
RETCODE EXPORT iceSetCoReg(S16 coRegId,U8 *content);
//RETCODE EXPORT iceOutput(U16 port, U8 *data, U16 len, U16 size);
//RETCODE EXPORT iceInput(U16 port, U16 len, U16 size, U8 *buff);
RETCODE EXPORT iceTest(ADDR addr, U32 len,ADDR *ret_addr);
RETCODE EXPORT iceChecksum(ADDR addr, U32 len, U16 *n);
RETCODE EXPORT iceSearch(ADDR *addr, U32 len, U8 *buff, U16 patternLen);  /* search block for pattern */
RETCODE EXPORT iceCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findaddr1, RET_ADDR *findaddr2);
RETCODE EXPORT iceCopy(ADDR addr1, U32 len, ADDR addr2);
RETCODE EXPORT iceSetMem(ADDR addr, U8 ch);
RETCODE EXPORT iceSetMemN(ADDR addr, U8 *buff, U16 patternLen);
RETCODE EXPORT iceGetMem(ADDR addr, U8 *buff);
RETCODE EXPORT iceGetMemN(ADDR addr, U8 *buff, U16 len);
RETCODE EXPORT iceFill(ADDR *addr, U32 len, U8 *buff, U16 patternLen);
RETCODE EXPORT iceSize(ABI_SIZE size);
RETCODE EXPORT iceGetMap(MAP_INFO *mapData);
RETCODE EXPORT iceGetMapSize(U32 *emmSize);
RETCODE EXPORT iceSetMap (U32  addr1, U32  addr2, U16 attr);
RETCODE EXPORT iceIsTraceBufferFull(U16 buffer, BOOLEAN *full);
RETCODE EXPORT DiagnosticFunction(DIAG_ID diagID);
RETCODE EXPORT iceEnableSwBkpt(VOID);
RETCODE EXPORT iceDisableSwBkpt(VOID);
RETCODE EXPORT iceSetBkptCode(BKPT_OP_68K code);
void    EXPORT iceGetVerifyErrorInfo(BAD_MEMORY *badMemory);
RETCODE EXPORT iceSetIntReg(U16 offset,U16 len,U32 data,BOOLEAN reloc);
RETCODE EXPORT iceGetIntReg(U16 offset,U16 len,U32 *data,BOOLEAN reloc);
RETCODE EXPORT iceSetQualTrace(U32 addr,U32 AddrMAsk,U16 qStatus,
	   U16 qStatusMask);
RETCODE EXPORT iceDisableQual();
RETCODE EXPORT iceGetCoreType(U16 *coreType);
RETCODE EXPORT iceSetCanBaseAddr(U32 addr);

RETCODE EXPORT iceIsLam2(BOOL*);
RETCODE EXPORT iceIsHemm(BOOL*);
RETCODE EXPORT iceBinDown(ADDR addr, U8* buffer,U16 len);
RETCODE EXPORT iceEndLoad();
RETCODE EXPORT iceBinInit();
RETCODE EXPORT iceSetLevel(U16 levelNo, LEVEL *tmpLevel);
RETCODE EXPORT GetRetStr(char* p);
RETCODE EXPORT iceGetAllLevel(LEVEL **level_record);
RETCODE EXPORT iceClrLevel(U16 levelNo);
RETCODE EXPORT iceClrTrig(U16 );
RETCODE EXPORT iceClrEvent(U16 evNo);
RETCODE EXPORT GetEventStr(char*);
RETCODE EXPORT GetTriggerStr(char*);
RETCODE EXPORT GetLevelStr(char*);
RETCODE EXPORT GetQualifyStr(char*);
RETCODE EXPORT iceGetTraceDepth(U16 bufID, BUFFER_DEPTH * bd);

RETCODE EXPORT iceSetQualify(U16 Id,QUALIFY* qualify) ;
RETCODE EXPORT iceClrQualify(U16 Id,U8 option);
RETCODE EXPORT iceGetQualify(U16 Id,QUALIFY* qualify);
RETCODE EXPORT iceGetTraceStr(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								char* str[]);                        
RETCODE EXPORT iceGetTraceInst(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								char* frameData[]);
RETCODE EXPORT iceGetTraceData(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								char* frameData[]);
RETCODE EXPORT iceGetTraceDepthStr(U16 bufID, char *trcDepth);
RETCODE EXPORT Cycle(char* waitStr,BYTE isCount,U16 count,char* str);

RETCODE EXPORT iceCycleNext(BOOLEAN isESC,char* );// jerry
RETCODE EXPORT iceGetTraceFrameStrHead(U16 bufID,QUALIFY_LIST *cond,char*); 
RETCODE EXPORT iceGetTraceFrameInst(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
					    MP_TRACE_INFO* frameData);     
RETCODE EXPORT iceSetTimerBase(U8 timebase);
int check_error(char*buff);
send_long(unsigned long addr);
send_word(unsigned int addr);
send_byte(unsigned char d);
unsigned long rx_long();
int rx_byte();
int upRX_DATA();
send_str2(char* str);
send_ESC();
send_CR_wait(int c);
send_str_wait_CR(char* str);
int check_KB();
send_str(char* str);
int start_up(char ch);
send(char txc);
int TX_DATAP(char txc);
int TX_DAT(char txc);
int receive();
int receive2();
int receiveGo();
pause_delay(int i); 

RETCODE EXPORT closeLog(int x);
RETCODE EXPORT iceSetMap1 (LPSTR cmdStr) ;
int isEsc();

int GetAllRegMice3(U16 cpuReg[]);

RETCODE EXPORT iceGetTraceFrameStr(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, MP_TRACE_INFO *frameData);                        
RETCODE EXPORT iceSetMemWord(ADDR addr, U16 word);                                                                                        
RETCODE EXPORT iceRunUntil(U32 addr);
RETCODE EXPORT iceSetInterval(U8 interval);
RETCODE EXPORT iceGetInterval(U16 FAR* isOn) ;
RETCODE EXPORT iceGetHWinfo(char *szInfo) ;
RETCODE EXPORT loadBkpt(void*) ;
RETCODE EXPORT unloadBkpt(void *bpt);
RETCODE EXPORT iceClock( char* sz);
RETCODE EXPORT iceWait( char s,char*sz) ;


RETCODE EXPORT iceInput1(char *szAddr,char*sz ) ;          

RETCODE EXPORT iceOutput1( char *addr, char * data,char *sz)    ;


RETCODE EXPORT iceTimebase( char *base,char* sz);

RETCODE EXPORT iceInterval( char * on,char* sz);


RETCODE EXPORT iceFPRegister( char *FPname, char * data,char* sz);



RETCODE EXPORT iceMMURegister( char *FPname, char * data,char* sz) ;

//spa
RETCODE EXPORT emuSpaEntryStart(BYTE bOption,DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr);   
RETCODE EXPORT emuGetEntry(WORD* wEntry);
RETCODE EXPORT emuSpaDurStart(BYTE bOption,DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr);
RETCODE EXPORT emuGetDur(unsigned long* dwDur);
RETCODE EXPORT emuSpaTimeStart(BYTE bOption,DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr);
RETCODE EXPORT emuGetTime(WORD* wTime);
RETCODE EXPORT emuCoverageStart(DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr,
				     BOOL isSP,BOOL isSD,BOOL isUP,BOOL isUD,BOOL isEnd);
RETCODE EXPORT emuGetCoverage(BOOL isAbout,BYTE* bNum,DWORD* dwRange,BYTE* per1,BYTE* per2);				     
RETCODE EXPORT emuTerminal();
#ifdef __cplusplus
}
#endif
#endif 
/********************************** E O F ************************************/

