/***************************************************************************
**
** File name : comm.c
**
**
**
**
**    Copyright (C) 1993 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**

**    Include files
**
***************************************************************************/
#include <conio.h>
#include <time.h>

#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _PVTASK_
#include "pvtask.h"
#endif

#include <string.h>

U16 portAddr, portStatus, portInp;
U16 printerPort;
/**************************************************************************
**
** Local define
**
***************************************************************************/

#define HighByte(x)          ((U8)((U16)(x) >> 8))
#define LowByte(x)           ((U8)(x))
#define InPortB(a)           inp(a)
#define OutPortB(a,b)        outp(a,b)

#define   RV_RDY         1   /* status of receive ready is 00000001 */
#define   SD_RDY         2   /* status of send ready is    00000010 */
#define   ACK            6
#define   NACK           0x15

#define P_SWITCH 0
#define P_NORMAL 8
#define P_S_RDY  8
#define P_R_RDY  0x10
#define P_W_PCE  1
#define P_R_PCE  2
#define P_I_MASK 0xb8


/**************************************************************************
**
** Local define
**
***************************************************************************/

#define IO_LOOP   20000
/**************************************************************************
**
** Externals
**
**************************************************************************/

/**************************************************************************
**
** Execution codes
**
**************************************************************************/


/**************************************************************************
**
** Name : chk_hlt
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE chk_hlt(VOID) {
BOOLEAN abortFromEsc;
RETCODE  err;

//vvv   err = TskCheckAbort(&abortFromEsc);
//vvv   if(err!=GOOD) return err;
//vvv   if (abortFromEsc!=0) return ESC;
   return(GOOD);
}

/**************************************************************************
**
** Name : TransmitByte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE SetComm(U16 pData) {

   if (pData == 5) pData = 0x378;
   else if (pData == 6) pData = 0x278;
   else if (pData == 7) pData = 0x3bc;  
   else {
      printerPort = 0;
      portAddr = pData;
      portStatus = pData+1;
      return(GOOD);
   }
   printerPort = 1;
   portAddr = pData;
   portStatus = pData + 2;
   portInp = pData + 1;
   OutPortB(portStatus, P_SWITCH);
   return(GOOD);
}

/**************************************************************************
**
** Name : TransmitByte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE TransmitByte(U8 txData) {
   if(InPortB(portStatus) & SD_RDY) {
     OutPortB(portAddr,txData);
     return(1);
   } else return(-1);
}    /* end of TransmitByte(char txc) */

/**************************************************************************
**
** Name :  ReceiveByte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 ReceiveByte() {
int c;

   if(InPortB(portStatus)&RV_RDY) c=InPortB(portAddr);
   else c = -1;
   //if (c > 0 && logFlag) writeLog(log_fid, (char)c);
   return(c);
}          /* end of ReceiverByte() */

/**************************************************************************
**
** Name : sendB()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 sendB(U8 txData) {
U16 i;
   if (printerPort) {
      OutPortB(portAddr,txData);
      for (i = 0; i < IO_LOOP; i++ )
	 if ((!(InPortB(portInp) & P_S_RDY)) && 
	     (!(InPortB(portInp) & P_S_RDY))){
	    OutPortB(portStatus, (P_SWITCH | P_W_PCE)); /* STROBE\ = low SWITCH=high xsq */
	    OutPortB(portStatus, P_SWITCH); /* STROBE\ = high, SWITCH = high */
	    return(GOOD) ;
	 }
   } else {
      for (i = 0; i < IO_LOOP; i++)
	 if (InPortB(portStatus) & SD_RDY) {
	    OutPortB(portAddr,txData);
	    return(GOOD) ;
	 }
   }
   return(-1);
}        /* end of sendB() */
/**************************************************************************
**
** Name :  receiveWait()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 receiveWait(U16 waitSec) {
int rxData;
time_t startTime,currentTime;

   time(&startTime);
   while (1) {
     rxData = receiveB();
     if (rxData != -1) return(rxData);
     chk_hlt();
     time(&currentTime);
     if ((currentTime - startTime) > (time_t)waitSec) return(ICE_REC_TIME_OUT);
   }
}        /* end of receiveWait() */

/**************************************************************************
**
** Name : sendWait()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendWait(U8 txData) {
   while(1) {
      if (sendB(txData) == GOOD) return(GOOD);
      chk_hlt();
   }
}        /* end of sendB() */
/**************************************************************************
**
** Name : receiveB()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 receiveB() {
U16 i;
S16 rxData;
U8 tmp, tmp1, tmp2 ;

   if (printerPort) {
      for (i = 0; i < IO_LOOP; i++)
	 if ((!(InPortB(portInp) & P_R_RDY)) && 
	     (!(InPortB(portInp) & P_R_RDY))){
	    OutPortB(portStatus, P_NORMAL ); /* switch = LOW  xsq */
	    OutPortB(portStatus, (P_NORMAL | P_R_PCE)); /* PC-RD-PCE\ = low */
	    OutPortB(portStatus, (P_NORMAL | P_R_PCE)); /* PC-RD-PCE\ = low */
	    tmp = P_I_MASK ; /* delay, wait data send from PCE */
	    tmp1 = tmp2 = 0x80 ;
	    tmp &= InPortB(portInp) ;  /* Get high nibble */
	    OutPortB(portStatus, P_NORMAL); /* PC-RD-PCE\ = high */
	    OutPortB(portStatus, P_NORMAL); /* PC-RD-PCE\ = high */
	    tmp1 &= (~tmp) ;
	    tmp1 |= ((tmp << 1) & 0x70) ;
	    tmp = P_I_MASK ; /* delay, wait high/low nibble switch ready */
	    tmp &= InPortB(portInp) ; /* Get low  nibble */
	    OutPortB(portStatus, P_SWITCH);
	    tmp2 &= (~tmp) ;
	    tmp2 |= ((tmp << 1) & 0x70) ;
	    tmp2 >>= 4 ;
	    rxData = tmp1 | tmp2;
	    return(rxData) ;
	 }
   } else {
      for (i = 0; i < IO_LOOP; i++)
	    if (InPortB(portStatus) & RV_RDY) {
	       rxData = InPortB(portAddr);
	       return(rxData);
	    }
   }
   return(-1);
} /* end of receiveB() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE SendAddrLen(U32 addr, U32 len)
{
int i;
U8 temp[8];

   _fmemcpy(temp, &addr,4);
   _fmemcpy(temp+4, &len, 4);

   sendWait(temp[0]);
   for (i = 1; i < 8; i++)
      if (sendB(temp[i]) != GOOD) return(!GOOD);
   return(GOOD);
}

/****************************************************************************
**
**  SendStream
**
**  Description: Send command protocol to communication port.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID SendStream(U8 *stream, U16 len) {
U8 checksum,highLen,lowLen;//,tempData[0x512];
U16 lp,aa;
/*
   checksum = 0;
   for (lp = 0; lp < len; lp++)
      checksum += stream[lp];
   stream[len] = (~checksum + 1);
   len++;

   lowLen = LowByte(len);
   highLen = HighByte(len);
   checksum = ~(lowLen+highLen) + 1;

   for (;;) {
      sendWait(':');
      if (sendB(lowLen) != GOOD) continue;
      if (sendB(highLen) != GOOD) continue;
      if (sendB(checksum) != GOOD) continue;
      for (lp = 0; lp < len; lp++)
	 if (sendB(stream[lp]) != GOOD) continue;
      aa = receiveB();
      if (aa == ACK) return;
      else if (aa == 0xa5) {
       //_fmemcpy(tempData,stream,len);
       //CheckFwStatus();
       //linkMICE(1);  // sd186 function or supported function of third  party.
       //_fmemcpy(stream,tempData,len);
      }
   }
*/                   return (GOOD);
}

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive output command protocol to communication port.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
RETCODE ReceiveStream(U8 *inStream, U16 *inStreamLen,U16 waitSec) {
S16 aa;
U16 len;
U8 checksum,receiveBuf[MAX_COMM_BUFF],finalFlag;
LOOP_VAR lp;

return(GOOD);
}

/**************************** End of File **********************************/
