
/***************************************************************************
**
**    Header:   D:/MV
68KV/LOG/SRC/EXEC68K.C__   1.1   09 Aug 1996 12:01:04   ZJRD  $
**
**    $Log:   D:/MV68KV/LOG/SRC/EXEC68K.C__  $
** 
**    Rev 1.1   09 Aug 1996 12:01:04   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 12:07:36   ZJRD
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
**
** File name : exec68k.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/29/1992 By Cheerson
**     0. Update the include files.
**
**
**
** X. Date -- 12/18/1992 By Cheerson
**    0. Delete emuGetPC() routine.
**    1. Replace the "emuGetPC()" calling of the emuRunUntil() to be
**       emuGetRegister(REG_PC,&addr).
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

//#include <ctype.h>

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG68K_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#include "abiglbs.h"

#include "abifunc.h"

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#include "abidef.h"

#define OK ICE_OK
#define CR 0xd
#define LF 0xa
#define HAND_SHAKE 0x3
#define NULL 0
/**************************************************************************
**
** Local define
**
***************************************************************************/

/**************************************************************************
**
** Local variables
**
***************************************************************************/
char *logicOP[]={""," OR "," AND "," THEN "};
char *stat_code[]={" SP"," SR"," SW"," UP"," UR"," UW"," AK"};
char retStr[200];
/**************************************************************************
**
** Externals
**
**************************************************************************/
extern char clr_cmd[];
int tick_temp;
static struct pcstatus mypc;          
int isFirstLevel;

extern LPSTR EXPORT TMalloc( U32 numBytes );
extern RETCODE EXPORT TFree( LPSTR randomPointer );
VOID SimIRET(VOID) ;
/**************************************************************************
**
** Execution codes
**
**************************************************************************/
MV_TRIGGER* newTrig(MV_TRIGGER* pTrig)
{   
int i;                                 
MV_TRIGGER* tmpTrig = (MV_TRIGGER*)TMalloc(sizeof(MV_TRIGGER));

	memcpy(tmpTrig,pTrig,sizeof(MV_TRIGGER));
	for (i=0;i<8;i++) {   
		if (pTrig->next[i] != NULL) {
			tmpTrig->next[i] = newTrig(pTrig->next[i]);
		}
			
	}
	tmpTrig->next[8] = tmpTrig->next[9] = NULL;
	
	return tmpTrig;
 }
 
void deleteTrig(MV_TRIGGER* pTrig) 
{       
int i;
	for (i=0;i<10;i++) {   
		if (pTrig->next[i] != NULL) 
			deleteTrig(pTrig->next[i]);
	}
	TFree((LPSTR)pTrig);
 }


int isEsc()
{   
/*
    MSG msg;
    U16 wKey = VK_ESCAPE;
    if(PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
	PM_NOREMOVE|PM_NOYIELD)) {
	PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
	    PM_REMOVE|PM_NOYIELD);
	if(msg.message == WM_KEYDOWN && msg.wParam == wKey) 
	    return  1;        
    }            
    return  0;*/
   HWND currentWindow;
   MSG  dummyMsg;
   BOOL abort = FALSE;    
   if (TRUE) {
      // Return the state of ESC key at interrupt level - TRUE if pressed.  
      if (GetAsyncKeyState(VK_ESCAPE) != 0) {
	 abort = TRUE;
	 // Flush all keyboard messages for the current window
	 if ((currentWindow = GetFocus()) != NULL) 
	    // NOTES: if currentWindow is NULL, we will flush all key messages
	    // of all windows in the current application.
	    // Return when there is no more key messages for currentWindow. 
	    while(PeekMessage(&dummyMsg, currentWindow,
			WM_KEYFIRST, WM_KEYLAST, PM_REMOVE));
      }
   }
   return abort;
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  evId : 1- = 1-
**
**************************************************************************/
RETCODE EXPORT iceClrEvent(U16 evId) {
int i;
	if (!evId) {
		clr_cmd[2]=' ';
		strcpy(retStr,"Event Clear.");
	} else {
		clr_cmd[2]=evId+'0';         
		strcpy(retStr,"Event  ");
		retStr[6] = clr_cmd[2];
		strcat(retStr," Clear");
	}       
	send_str(clr_cmd);
	if (!evId) {
		for (i=0;i<LAM2+3;i++) {
			event_record[i].defined=0;
			strcpy((char*)(&(event_str[i][0])),retStr);
		}       
	} else {
		event_record[evId-1].defined=0;
		strcpy((char*)(&(event_str[evId-1][0])),retStr);
	}       
	
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:   evId = 4-6 or 6-8(lam2)
**
**************************************************************************/
RETCODE EXPORT iceClrBP(U16 evId) {
	clr_cmd[2]=evId+'0';
	send_str(clr_cmd);
	bp_record[evId-(LAM2+4)].defined = 0;
	strcpy(retStr,"Event Clear  ");
	retStr[12] = evId+LAM2+'0';
	strcpy((char*)(&(bp_str[evId-4-LAM2][0])),retStr);
	return ICE_OK;
	
}

/**************************************************************************
**
** Name : iceStepRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceStepRange(ADDR addr1, ADDR addr2) {
char c;
char *ptr;
int i;                  
	regOk = 0;
	send_str2("S ");
	send_long(addr1.pos);
	send(' ');
	send_long(addr2.pos);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i !=OK) return(i);
	send_ESC();
 //       GetAllRegMice3(cpuReg);
	return ICE_OK;
}      /* end of emuStepRange() */

/**************************************************************************
**
** Name : emuStepOne()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  ok
**
**************************************************************************/
RETCODE EXPORT iceStepOne(VOID){
int i;
	regOk = 0;
	if (i=for1step()) return(i);
//    if (strstr(tx_buf,"AK") != NULL) skipINT();
////.  marked by chris, 9/20/95
//        GetAllRegMice3(cpuReg);
	return ICE_OK;
}      /* end of emuStepOne() */

for1step()
{
char c;
int i;
char *ptr;
	regOk = 0;
	send('S');
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) {
		if (c > 0) *ptr++ = c;
	}
	i = check_error(tx_buf);
	if (i != OK) return(i);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) {
		if (c > 0) *ptr++ = c;
	}
	i = check_error(tx_buf);
    if (i == ICE_MEM_PROTECT || i == ICE_MEM_GUARD) {
		ptr = tx_buf;
		while (*ptr++ != '!');
		*ptr++ = CR;
		*ptr++ = LF;
		*ptr = NULL;
		//DisplayStr(tx_buf);
		i = ICE_OK;
    }
	send_ESC();
	return(i);
}

////. this function marked by chris, 9/20/95
//skipINT()
//{
//unsigned long sp_ptr, retPC;
//    GetAllRegMice3(cpuReg);
//    emuGetReg(I68K_REG,REG_SP,&sp_ptr);
//    retPC = getStack(sp_ptr+2, 4);
//    emuRunUntil(retPC);
//}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceAbort(VOID) {
char c,*ptr;      
      send_ESC();
     ptr=tx_buf;
     //while( (c=receive() )!=CR && c!=HAND_SHAKE )*ptr++=c;

     return ICE_OK;
}

/**************************************************************************
**
** Name : iceReset
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  ok
**
**************************************************************************/
RETCODE EXPORT iceReset(VOID){
	send_str("RESET");
	regOk = 0;
	return(OK);
}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: OK
**
**************************************************************************/

RETCODE EXPORT iceGetCpuStatus(int *goEnd) {
char *ptr,c;
	send(CR);
	ptr = tx_buf;
	while((c=receiveGo()) != CR && c!=HAND_SHAKE) 
	{  
	   if( c !=-1) *ptr++ = c;
	   else {*goEnd=0; return ICE_EP_PENDING; }
	}
	*ptr=0;
	if (strstr(tx_buf,"Go") != NULL) {        
	     ptr=tx_buf;
	     while((c=receiveGo()) != CR && c!=HAND_SHAKE) *ptr++=c;
	     *ptr=0;
	 }
	if (strstr(tx_buf,"progress...") != NULL) {
		*goEnd=0;return ICE_EP_PENDING;
		
	} else if( strstr(tx_buf,"user") != NULL)
	{       
	    ptr=tx_buf;
	    while( (c=receiveGo())!=HAND_SHAKE)  *ptr++=c;
	    *goEnd=1; return ICE_HALT_USER;
		
	}else if( strstr(tx_buf,"EV") != NULL)
	{       
	   if( strstr(tx_buf,"EV7") != NULL)
	   {
	     if(c==HAND_SHAKE){ *goEnd=1; SimIRET();return(ICE_BKPT1_HALT );}
	     ptr=tx_buf;
	     while( (c=receiveGo())!=HAND_SHAKE)  *ptr++=c;
	     *goEnd=1; SimIRET();return(ICE_BKPT1_HALT );
	   }
	   else 
	   {
	     if(c==HAND_SHAKE){ *goEnd=1; return(ICE_TRIG_HALT );}
	     ptr=tx_buf;                                                
	     while( (c=receiveGo())!=HAND_SHAKE)  *ptr++=c;
	     if(strstr(tx_buf,"stopped by user")!=NULL )
	     {  *goEnd=1; return(ICE_HALT_USER ); }
	     else if(strstr(tx_buf,"stop")!=NULL )
	     {  *goEnd=1; return(ICE_TRIG_HALT ); }              
	   }
	}else if( strstr(tx_buf, "trespassed" )!=NULL)
	{
	     if(c==HAND_SHAKE){ *goEnd=1; return(ICE_MEM_GUARD );}
	     ptr=tx_buf;
	     while( (c=receiveGo())!=HAND_SHAKE)  *ptr++=c;
	     *goEnd=1; return(ICE_MEM_GUARD );
	}
	*goEnd=1;                                               
	return ICE_HALT_USER;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
BOOLEAN depthChanged=1;
BUFFER_DEPTH Depth;
RETCODE EXPORT iceGetTraceDepth(U16 bufID, BUFFER_DEPTH *trcDepth) {
char *ptr, c;
U32 l;    
/*            
	trcDepth->startFrame = 0;
	trcDepth->endFrame = 60;
	return ICE_OK;*/
		
if(! depthChanged )
{
	trcDepth->endFrame = Depth.endFrame;
	trcDepth->startFrame=Depth.startFrame;
	return GOOD;
}
	send_str2("L N");
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) if (c > 0) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf,"empty") == NULL) {
		ptr = tx_buf;
		while (*ptr++ != '=');
		sscanf(ptr," %hx", &l);
		trcDepth->endFrame = l & 0xffff;
		trcDepth->startFrame=0; //jerry
		Depth.endFrame = l & 0xffff;
		Depth.startFrame=0; //jerry
		
	}       
	else return ICE_BUFFER_EMPTY;
	depthChanged=0;
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetTraceDepthStr(U16 bufID, char *trcDepth) {
char *ptr, c;
U32 l;    
/*            
	trcDepth->startFrame = 0;
	trcDepth->endFrame = 60;
	return ICE_OK;*/
		
	send_str2("L N");
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) if (c > 0) *ptr++ = c;
	ptr--;
	ptr--;
	*(--ptr) = 0;
	ptr = tx_buf;
	while(*ptr != CR) ptr++;
	ptr++;
	strcpy(trcDepth,ptr);
	return(OK);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
* typedef struct {
*    int defined;  1=event is defined, 0=not defined 
*    int addrSpec; 
*    U32 addrLo;
*    U32 addrHi;
*    int dataSpec;
*    U32 dataLo;
*    U32 dataHi;
*    U32 stat;
*    U16 count;
* }BUS_EVENT;
**      evId : 1- : 1-
**************************************************************************/
RETCODE EXPORT iceSetEvent(U16 evId, BUS_EVENT *busEventData) {
int c;
char* ptr;                   
char tmp[30];
    send_str2("E "); strcpy(retStr,"Event  ");
    send(hex[evId]); retStr[6] = evId+'0';
    if (evId == LAM2+3) {
		if (busEventData->addrLo == 1) { send_str2(" HI"); strcat(retStr," High");}
		else {send_str2(" LO");strcat(retStr," Low");}
	} else 
	if (evId <= LAM2+2){
		send_address(busEventData->addrSpec,busEventData->addrLo,
			busEventData->addrHi);
	send_data(busEventData->dataSpec,busEventData->dataLo,
		busEventData->dataHi);
		send_stat(busEventData->stat);
	send_count(busEventData->count);
    } else {
		send_long(busEventData->addrLo);        
		sprintf(tmp,"%lX",busEventData->addrLo);
		strcat(retStr,tmp);
    }                   
    
    send(CR);
    ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	ptr = NULL;
	if (NULL != strstr(tx_buf,"error")) return ICE_SYNTAX_ERROR;
	busEventData->defined = 1;
	memcpy(&event_record[evId-1],busEventData,sizeof(BUS_EVENT));
	strcpy((char*)(&(event_str[evId-1][0])),retStr);
	return(OK);
}
 
send_address(addrspec,addrlo,addrhi)
unsigned char addrspec;
U32 addrlo, addrhi;
{           
char tmp[30];    

	send(' '); /* send delimeter */
	switch(addrspec)
	{
	case 0: /* address not specified */
		if(MICE == CPU68020_M3 || MICE == CPU68030_M3) {
		    send_str2("XXXXXXX"); strcat(retStr,"XXXXXXX");
		} else {
		    send_str2("XXXXX"); strcat(retStr,"XXXXX");
		}
		break;
	case 1: /* address is a simple value */
		send_long(addrlo);
		sprintf(tmp,"%lX",addrlo);
		strcat(retStr,tmp);
		break;
	case 2: /* address with range value */
		send_str2("R ");
		strcat(retStr,"Range ");
				send_long(addrlo);
				send(' ');        
				sprintf(tmp,"%lX ",addrlo);
				strcat(retStr,tmp);
				send_long(addrhi); 
				sprintf(tmp,"%lX",addrhi);
				strcat(retStr,tmp);
		break;
	case 3: /* address with mask */
				if (MICE ==CPU68020_M3 || MICE ==CPU68030_M3)
			send_wild(addrlo, addrhi, 7);
		else 
			send_wild(addrlo, addrhi, 5);
		break;
	}
      send_str2(" ");
      strcat(retStr," ");
}

send_data(dataspec, datalo, datahi)
unsigned char dataspec;
U32 datalo, datahi;
{                          
char tmp[30];
	send(' '); /* send delimeter */   
	strcat(retStr," ");
	switch(dataspec)
	{
	case 0: /* data not specified */
		break;
	case 1: /* data is a simple value */
				send_word(datalo); 
				sprintf(tmp,"%04X",datalo);
				strcat(retStr,tmp);
		break;
	case 3: /* data with mask */
				if (MICE ==CPU68020_M3 || MICE == CPU68030_M3)
			send_wild(datalo, datahi, 7);
		else 
			send_wild(datalo, datahi, 3);
		break;
	}
}

send_extern(externspec, externlo, externhi)
unsigned char externspec;
U32 externlo, externhi;
{                          
char tmp[30];                      
		if (0 != externspec) {
		send_str2("EXternal "); /* send delimeter */   
		strcat(retStr,"External ");
	}
	switch(externspec)
	{
	case 0: /* extern not specified */
		break;
	case 1: /* extern is a simple value */
				send_word(externlo); 
				sprintf(tmp,"%04X",externlo);
				strcat(retStr,tmp);
		break;
	case 3: /* data with mask */
			send_wild(externlo, externhi, 1);
		break;
	}
}

U8 get_extern(char* str)
{                          
char tmp[30];                      
U8 byte ;
int i;
	byte = 0;
	for(i=0;i<8;i++) {
		if(str[i] == '1') byte = byte&((BYTE)1<<i);
	}                                        
	return byte;
}

send_count(count)
U16 count;
{       
char tmp[30];
	if (count) {
		send_str2(" CO ");        
		strcat(retStr," Count");
		send_word(count);
		sprintf(tmp,"%04X",count);
		strcat(retStr,tmp);
	}
}
 
send_wild(val, mask, i)
unsigned long val;
unsigned long mask;
int i;
{
int j, jj;
char c, d;   
char tmp[30];
int firstNotZero=0;
	if (!val && mask == 0xffffffff) {
		send('0');      
		strcat(retStr,"0");
		return;
	}
    for (j=i;j >= 0;j--) {
		c = (mask >> (j*4)) & 0xf;
	d = (val >> (j*4)) & 0xf;
	if (c == 0xf) {
		if (!firstNotZero && !d) continue;
		send(hex[d]);
		strcpy(tmp," ");
		tmp[0] = hex[d];
		strcat(retStr,tmp);
	} else if (!c) { send('X'); strcat(retStr,"X"); }
	else {
			send('('); strcat(retStr,"(");
	    for (jj=3; jj >= 0; jj--) {
				if (!((c >> jj) & 1)) { send('X'); strcat(retStr,"X"); }
		else if ((d >> jj) & 1) { send('1');strcat(retStr,"1"); }
		else { send('0');strcat(retStr,"0"); }
	    }
	    send(')'); strcat(retStr,")");
	}
		firstNotZero = 1;
    }
}
 
send_stat(val)
unsigned long val;
{
int i;
	for (i=0;i<7;i++) if ((val>>i)&1) { 
		send_str2(stat_code[i]); strcat(retStr,stat_code[i]);
		send_str2(" ");strcat(retStr," ");
	}
}       

int get_stat(char* tmpStr)
{
int i; 
int j;
	for (i=0;i<7;i++) 
		if ((stat_code[i][1]==tmpStr[0]) && (stat_code[i][2]==tmpStr[1])) { 
		j = 1<<i;
		return j;
	}
}               

U32 str2U32(char* in)
{ 
	U32 tmp = 0;
	BYTE x = 0;
	int i;
	for(i=0;i<strlen(in);i++) {
		if(in[i]>='0' && in[i]<='9') x = in[i]-'0';
		if(in[i]>='A' && in[i]<='F') x = in[i]-'A'+10;
		if(in[i]>='a' && in[i]<='f') x = in[i]-'a'+10;
		tmp = tmp<<4;
		tmp = tmp + x;
			     
	}
	return tmp;
 }

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: 
**                LAM2: BUS_EVENT: ev1-4
**                      EXEC_EVENT: ev6-8
**                              ext_record: ev5
**        NOT LAM2: BUS_EVENT: ev1-2
**                      EXEC_EVENT: ev4-6
**                              ext_record: ev3
**              
**************************************************************************/
RETCODE EXPORT iceSetAllEvents(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 ext_record) 
{      
int i,retCode;                                       
ADDR tmpAddr;
BUS_EVENT tmpEvent;
	for(i = 0;i<LAM2+2;i++) {
		retCode = iceSetEvent(i+1,&(event_record[i]));
		if (ICE_OK != retCode) return retCode;
	}
	
	for (i = 0;i<3; i++) {
		tmpEvent.addrLo = bp_record[i].addr;
		tmpAddr.pos = bp_record[i].addr;
		retCode = iceSetBP(i+4+LAM2,tmpAddr);
		if (ICE_OK != retCode) return retCode;
	}    
	
	if (0 == ext_record) tmpEvent.addrLo = 0;
	else tmpEvent.addrLo = 1;
	retCode = iceSetEvent(3+LAM2,&tmpEvent);
	if (ICE_OK != retCode) return retCode;
	
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**        ok
**************************************************************************/
RETCODE EXPORT iceSetExtEvent(U16 evData) {
char tmp[30];
char* ptr;
char c;
	send_str2("EV");
	send(3+LAM2+'0');
	send(' ');
	strcpy(retStr,"Event  ");
	retStr[6] = 3+LAM2+'0';
	if (evData) { send_str2("HIGH"); strcat(retStr,"HIGH"); }
	else { send_str2("LOW"); strcat(retStr,"LOW"); } 
    send(CR);
    ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	//send_CR_wait(HAND_SHAKE);
	event_record[LAM2+3-1].defined = 1;
	event_record[LAM2+3-1].addrLo = evData;
 /*
	send_str2("EV");
	send(CR);
    ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
   */
	return ICE_OK;
}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok; evId = 4-6 or 6-8(LAM2)
**
**************************************************************************/
RETCODE EXPORT iceSetBP(U16 evId, ADDR addr) {
char tmp[30];
	event_cmd[2]=evId+'0';
	send_str2(event_cmd);
	strcpy(retStr,"Event  ");
	retStr[6] = evId+'0';
	
	send_long(addr.pos); 
	sprintf(tmp,"%lX",addr.pos);
	strcat(retStr,tmp);
	send_CR_wait(HAND_SHAKE);
	bp_record[evId-(LAM2+3)-1].defined = 1;
	bp_record[evId-(LAM2+3)-1].addr = addr.pos;
	strcpy((char*)(&(bp_str[evId-4-LAM2][0])),retStr);
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: levelNo : not used
**
**************************************************************************/
RETCODE EXPORT iceClrTrig(U16 levelNo) {
int i;
	send_str2("TRI "); strcpy(retStr,"Trigger ");
	send_str(" CL"); strcat(retStr,"Clear");
	trigger_record[0].defined=0;
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: levelNo == 0 => clear all,1-8 = levelA-levelH
**
**************************************************************************/
RETCODE EXPORT iceClrLevel(U16 levelNo) {
int i;                      
char tmp[30];
  if(levelNo>8)
  {
      send_str("T L Clear");
  }
  else
  {
	send_str2("TRI "); strcpy(retStr,"Trigger ");
	if (LAM2 && levelNo) {
		send_str2("Level "); strcat(retStr,"Level ");
		strcpy(tmp," "); tmp[0] = levelNo+'A'-1; strcat(retStr,tmp);
		send(levelNo+'A'-1);
	}
	send_str(" CL"); strcat(retStr," Clear");
	if (levelNo) {
		level_record[levelNo-1].defined=0;             
		strcpy((char*)(&(level_str[levelNo-1][0])),retStr);
	} else {
	for (i=0;i<8;i++) level_record[i].defined=0;      
	strcpy((char*)(&(level_str[i][0])),retStr);
    }   
  }
	return(OK);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
#define TRA_BREAK 1
#define TRA_RESET 2
#define TRA_TROFF 8
#define TRA_TRON 0x400
#define TRA_TMOFF 0x800
#define TRA_TMON 0x1000
char *eventName[]={"EV1","EV2","EV3","EV4","EV5","EV6","EV7","EV8"};
//make state# seq for trigger
BOOL ConvertTrigger(MV_TRIGGER* tmpTrig,char* tmpBuf){
int i,maxNum,j;                
char tmp[30];
U8 isLast;
	if(strlen(tmpBuf)>200) return FALSE;
	maxNum = 0;
	for (i=0;i<8;i++) {
		if (tmpTrig->trigAction[i] == 0) break;
		maxNum++;                             
	}
	
	if (1==maxNum) {                   
		//check reset
		if (9 == tmpTrig->trigAction[0]) {
			strcat(tmpBuf,"REset "); 
			return TRUE;
		}
		
		if(isFirstLevel==1) { isFirstLevel = 0; }
		else  { 
		   strcat(tmpBuf,"THen "); 
		}   
		strcpy(tmp,"  ");
		tmp[0] = 'A'+tmpTrig->trigAction[0]-1;
		strcat(tmpBuf,tmp);              
		
		if (tmpTrig->next[0] == NULL) {
			return TRUE;
		}
		
		if(!ConvertTrigger(tmpTrig->next[0],tmpBuf)) return FALSE;
		return TRUE;
	} else {                                    
			if(isFirstLevel==1) { isFirstLevel = 0; }
	}
	
	for (i=0;i<maxNum;i++) {     
	
		if (i!=0) {
			strcat(tmpBuf,"ELse ");
		} else {                  
			strcat(tmpBuf,"If "); 
		}       
		
		if (tmpTrig->trigAction[i] == 0) break;
		
		//check if next point is the last point
		isLast = 1;
		for (j=0;j<8;j++) {
			if (NULL == tmpTrig->next[i]) break;
			if ((tmpTrig->next[i]->trigAction[j] != 0)
				 && (tmpTrig->next[i]->trigAction[j] != 9)) isLast = 0;
			
		}
		
		if (0 == isLast) {
			strcat(tmpBuf,"( ");
		}
		
		strcpy(tmp,"  ");
		tmp[0] = 'A'+tmpTrig->trigAction[i]-1;
		strcat(tmpBuf,tmp);
		
		if (tmpTrig->next[i] == NULL) {
			continue;
		}       
		
		if(!ConvertTrigger(tmpTrig->next[i],tmpBuf)) return FALSE;
		
		if (0 == isLast) {
			strcat(tmpBuf,") ");
		}
		
	}
   return TRUE;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: levelNo :  not used
**
**************************************************************************/
RETCODE EXPORT iceSetTrig(U16 levelNo, MV_TRIGGER *tmpTrig){
int i;
char *ptr, c, tmpBuf[240],tmp[30];
   isFirstLevel = 1;
	strcpy(tmpBuf," ");
	
	if(tmpTrig->isTimerOn !=2 || tmpTrig->isTraceOn !=2) {
	   send_str2("T "); strcpy(retStr,"Trigger ");
		if(tmpTrig->isTimerOn == 0) { 
			send_str2("TImer OFf ");              
			strcat(retStr,"Timer Off ");
		}
		if(tmpTrig->isTimerOn == 1){ 
			send_str2("TImer On ");              
			strcat(retStr,"Timer On ");
		}
		if(tmpTrig->isTraceOn == 0) { 
			send_str2("Trace OFf ");              
			strcat(retStr,"Trace OFf ");
		}
		if(tmpTrig->isTraceOn == 1) { 
			send_str2("Trace On ");              
			strcat(retStr,"Trace On ");
		}             
		
		send_CR_wait(CR);
		ptr=tx_buf;
		while ((c=receive()) != HAND_SHAKE) if (c > 0) *ptr++ = c;
		*ptr = NULL;
		if ((i=check_error(tx_buf)) != OK) return(i);
	trigger_record[0].defined = tmpTrig->defined = 1;
	trigger_record[0].isTimerOn = tmpTrig->isTimerOn;
	trigger_record[0].isTraceOn = tmpTrig->isTraceOn;
		return ICE_OK;
	}       

   send_str2("T "); strcpy(retStr,"Trigger ");
	if (tmpTrig->isRun) { 
		send_str2("RUN ");
		strcat(retStr,"Run");
	}
	tmpBuf[0] = 0;
	if(!ConvertTrigger(tmpTrig,tmpBuf)) return ICE_SYNTAX_ERROR;
	send_str2(tmpBuf); strcat(retStr,tmpBuf);
	switch (tmpTrig->traceMode) {
		case 0: break;
		case 1:
			send_str2(" BACK ");
			strcat(retStr," Back ");
			break;
		case 2:
			send_str2(" FOR ");
			strcat(retStr," For ");
			break;
		case 3:
			send_str2(" CEN ");  
			strcat(retStr," Center ");
			break;
		case 4:
			send_str2(" DEL ");   
			strcat(retStr," Delay ");
			send_word(tmpTrig->count);
			sprintf(tmp,"%04X",tmpTrig->count);
			strcat(retStr,tmp);
			break;
	}
	send_CR_wait(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) if (c > 0) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf,"error") != NULL) return(ICE_SYNTAX_ERROR);
	
	
    tmpTrig->defined = 1;
    for(i =0;i<10;i++) {
		if(trigger_record[0].next[i] != NULL) {
			deleteTrig(trigger_record[0].next[i]);
			trigger_record[0].next[i] = NULL;
		}       
    }   
   memcpy(&(trigger_record[0]),tmpTrig,sizeof(MV_TRIGGER)); 
   for(i =0;i<8;i++) {
		if(tmpTrig->next[i] != NULL)
			trigger_record[0].next[i] = newTrig(tmpTrig->next[i]);
	}
    
	return (OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: levelNo 1-8 ==> A-H
**
**************************************************************************/
RETCODE EXPORT iceSetLevel(U16 levelNo, LEVEL *tmpLevel){
int i;
char *ptr, c, tmpBuf[240];        
char tmp[30];     
	if(tmpLevel->evNo[0] == 0) return ICE_OK;
	send_str2("T L "); strcpy(retStr,"Trigger Level ");
	send(levelNo+'A'-1); 
	strcpy(tmp," "); tmp[0] = levelNo+'A'-1;
	strcat(retStr,tmp); 
	send(' '); strcat(retStr," ");
	for (i=0;i < 5; i++) {
		if (tmpLevel->evNo[i]&0x8000) { send_str2("N "); strcat(retStr,"NOT ");}
		send_str2(eventName[(tmpLevel->evNo[i]&0x7f)-1]);
		strcat(retStr,eventName[(tmpLevel->evNo[i]&0x7f)-1]);
		if (!tmpLevel->op[i]) break;
		else { 
			send_str2(logicOP[tmpLevel->op[i]]);
			strcat(retStr,logicOP[tmpLevel->op[i]]);
		}       
	}
	if (tmpLevel->isTraceOn==1) {
		send_str2(" T ON ");
		strcat(retStr," Trace On ");
	} else if (tmpLevel->isTraceOn==2) {
		send_str2(" T OF ");
		strcat(retStr," Trace Off ");
	}       
	if (tmpLevel->isTimerOn==1) {
		send_str2(" TI ON ");
		strcat(retStr," Time On ");
	} else if (tmpLevel->isTraceOn==2) {
		send_str2(" TI OF ");      
		strcat(retStr," Time Off ");
	}       
	
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
	*ptr = NULL;
	if (NULL != strstr(tx_buf,"error")) return ICE_SYNTAX_ERROR;
	
    tmpLevel->defined = 1;
    memcpy(&(level_record[levelNo-1]),tmpLevel,sizeof(LEVEL));
    strcpy((char*)(&(level_str[levelNo-1][0])),retStr);
	return (ICE_OK);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: not ok , not supported
**
**************************************************************************/
RETCODE EXPORT iceGetAllTrig(MV_TRIGGER **trig_record){
	*trig_record = &(trigger_record[0]);
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: 
**
**************************************************************************/
RETCODE EXPORT iceGetAllLevel(LEVEL **level){ 
	*level = level_record;
	return ICE_OK;
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceGetTraceInfo(U16 *lastBuff, U16 *curCNT0, U16 *curCNT1, U16 *bufNO){
	*lastBuff = 1;
	*curCNT0 = 1;
	*curCNT1 = 1;
	*bufNO = 1;
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  baseTime = 1 ==> 0.1 us
**                                      = 2 ==> 1 us
**                                      = 3 ==> 10 us
**                                      = 4 ==> 100 us
**                                      = 5 ==> 1000 us
**
**
**************************************************************************/
RETCODE EXPORT iceSetTimerBase(U8 baseTime)
{
char  *ptr, c, key;
char pcTmp[64];
	switch (baseTime) {
		case 1: strcpy(pcTmp,"0.1"); break;
		case 2: strcpy(pcTmp,"1"); break;
		case 3: strcpy(pcTmp,"10"); break;
		case 4: strcpy(pcTmp,"100"); break;
		case 5: 
		default : strcpy(pcTmp,"1000"); break; 
	}

   send_str2("TIM ");
   send_str2(pcTmp);
   send_CR_wait(CR);
   ptr = tx_buf;
   for (;;) {
		while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
		if (c == HAND_SHAKE) break;
		*ptr = NULL;
		//DisplayStr(tx_buf);
   }
   return( TRUE );
}                 

U32 emuGetPC ()
{
U32 l;
    iceGetReg(I68K_REG,REG_PC, &l);
    return(l);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

unsigned long adr2hex(buf)
unsigned char *buf;
{
int i, j;
unsigned char ii;
unsigned long l;
   l = 0;
   i = 4;
   for (j=0; j < i;j++) {
      ii = *buf++;
      l = (l << 8) + ii;
   }
   return(l);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/* initialize software breakpoint */
init_sw()
{
unsigned long l;
ADDR tmpAddr;
	if (!VNFlag) {
		if (MICE == CPU68000_M3 || MICE == CPU68302_M3) l=Toffset;
		else {
			iceGetReg(I68K_REG, REG_VBR, &l);
			l += Toffset;
		}
		SetVectMem(l,&newVect[0],4,0);
		if (!noRAM) SetVectMem(VectAdr,&IRET[0],2,1);
	tmpAddr.pos = VectAdr;
		if (!noRAM) iceSetBP(LAM2+5,tmpAddr);
	} else noRAM = 1;
}         

/**************************************************************************
**
** Name : hex2asc(p,data)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

hex2asc(p,data)
char *p;
unsigned data;
{
   *p++ = hex[(data >> 4) & 0xf];
   *p   = hex[data & 0xf];

}        /* end of hex2asc(p,data) */
	 

/**************************************************************************
**
** Name : GetPC(ppp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

GetPC(ppp)
struct pcstatus *ppp;
{
char *ptr, *ptr1;
int i;
unsigned long l, l1;

   //killAllRegs();       
   iceGetReg(I68K_REG, REG_PC, &l);

   ptr = ppp->addr;                 
   for (i=3;i>=0;i--) {
      l1 = (l>>(i*8)) & 0xff;
      *ptr++ = (unsigned char) l1;
   }                           
   ptr = ppp->addr;       
   ptr1 = ppp->ascii;
   for (i=0;i < 4;i++) {
      hex2asc(ptr1,*ptr++);
      ptr1 += 2;
   }                 
   ppp->flag = OK;
}         /* end of GetPC(ppp) */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
sw_set(){
int i;
ADDR tmp;
U16 tmp16;
   /*   init_sw(); */
   for (i=0;i<breakNumber;i++) {
      if (SwBreak[i].exists) {
			tmp.pos = SwBreak[i].address;
			tmp16 = Tcode2 + Tcode1*256;
			iceSetMemWord(tmp,tmp16);
				  
	 //tmp.pos = SwBreak[i].address+1;
	 //iceSetMem(tmp,Tcode2);
	 }//changed here 97.2                               
 // tmp.pos=SwBreak[i].address;
 // iceSetMem(tmp,Tcode);
   }
   return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
sw_restore() {
int i;                 
ADDR tmp;     
U16 tmp16;
   for (i=0;i<breakNumber;i++) {
      if (SwBreak[i].exists) {
		tmp.pos = SwBreak[i].address;
		tmp16  = SwBreak[i].data1*256 + SwBreak[i].data2;
		iceSetMemWord(tmp, tmp16);
      }               
	   //tmp.pos = SwBreak[i].address+1;
	   //iceSetMem(tmp, SwBreak[i].data2);
   }
   iceClrBP(LAM2+5);              
}


/**************************************************************************
**
** Name : USDSetTimer()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

USDSetTimer(int i)
{
   long ll;
   gettime(&ll);
   tick_deadline = ll + i;
}                

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
U32 getStack(U32 l, U16 len) {
U32 ll; 
ADDR addrTmp;
U8 addrBuff[4];
U16 i;
   ll = 0;   addrTmp.pos = l;
   iceGetMemN(addrTmp,addrBuff,(U32)len);
   for (i=0; i < len; i++) ll = ll*256 + addrBuff[i];
   return (ll);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
VOID SimIRET(VOID) {
U32 spPtr, retSR, retPC; 
   regOk = 0;
   iceGetAllReg(cpuReg);
   iceGetReg(I68K_REG,REG_A7, &spPtr);
   
   retSR = getStack(spPtr, 2) & 0xffff;
   retPC = getStack(spPtr+2, 4);
   if (/*TrapFlag*/0) iceSetReg(I68K_REG,REG_PC, retPC-2);
   else iceSetReg(I68K_REG,REG_PC, retPC);
   if (MICE == CPU68000_M3 || MICE == CPU68302_M3) 
		iceSetReg(I68K_REG,REG_SP, spPtr+6);
   else iceSetReg(I68K_REG,REG_SP, spPtr+8);
   iceSetReg(I68K_REG,REG_SR, retSR);
}


/**************************************************************************
**
** Name : emuRun
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuRun(U8 runFlag) {
int i, c;
unsigned long emuGetPC ();
unsigned long l;
unsigned char cont;
unsigned int retval;
unsigned long ll;
char *ptr;
U32 tmpAddr;
ADDR pcAddr;
char tmp[20];     
	regOk = 0;
	break_id=0; ESCflag = 0;
	if (!runFlag && breakNumber && !noRAM) {
		//if (for1step() == MICE_HALT) return(MICE_HALT);
		/*
		tmpAddr = emuGetPC();
		for(i=0;i<breakNumber;i++) 
			if (SwBreak[i].address == tmpAddr) {
			   breakReason=BREAK;
				return BROKE;
			}       
		*/
		if (!noRAM) sw_set();
	}
	if (runFlag) {
		send_str("G R");
		return(OK);
	}
   USDSetTimer(tick_count);
	send('G');
	send(CR);
	//while (receiveGo() != CR);
   while (receiveGo() != CR);
	ptr = tx_buf2;
	for (;;) 
	{  
	    if (ESCflag==1 || isEsc()) {
		*ptr=NULL;
	       // Added by Chen, 03/07/95
	       // PPR: pmvm5019.ini
	       send_ESC();
	       i = check_error(tx_buf2);
	       if (i != OK) return(i);
	       send_ESC();
	       if (!noRAM) sw_restore();
	       return(HALT_USER);
	    } 
	    if((c=receiveGo()) > 0 ) 
	    {
	      if (c == HAND_SHAKE) break;
	      else *ptr++ = c;
	    }
	    if (/*cmdfile_flag*/1 && tick_count != -1) 
	    {
		//gettime(&ll);
		if (/*ll >= tick_deadline*/0) 
		{
		    *ptr=NULL;
		    i = check_error(tx_buf2);
		    if (i != OK) return(i);
		    send_ESC();
		    if (!noRAM) sw_restore();
		    //if ((i=iceGetAllReg(cpuReg)) != OK) return(i);
		    return(HALT_USER);
		}
	    }
	}
	*--ptr=NULL;
//      i = check_error(tx_buf2);
    sprintf(tmp,"EV%01d",5+LAM2);
    if (strstr(tx_buf2,tmp) != NULL) 
    {
	ptr = tx_buf2;
	break_id = 5+LAM2;
    } else if (strstr(tx_buf2,"EV") != NULL) 
    { 
	ptr = tx_buf2;
	while(*ptr++ != 'V');
	break_id = *ptr - '0';
    }
	
    if (break_id != 4+LAM2) 
    {
       breakReason=BREAK;
       if (break_id == 5+LAM2) 
       {
	   if (!noRAM && breakNumber) SimIRET();
       } else if (break_id == 6+LAM2) 
       {
	    breakReason=BREAK_I;
       } else 
       { 
/* check the S/W trap already executes or not */
	    if (emuGetPC() == VectAdr) 
	    {
		SimIRET();
		breakReason=BREAK_I;
	    }
       }
    }
	//iceGetAllReg(cpuReg);
	sw_restore();
	return(BROKE);
}           

/**************************************************************************
**
** Name : ChkBreak(addr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ChkBreak(unsigned long addr)
{
int i;

   for (i = 0; i < breakNumber; i++)
      if (SwBreak[i].address == addr) return (i);
   return (-1);
}



/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT unloadBkpt(void *bpt)
{
  
  sw_restore();
  return ICE_OK;
}

RETCODE EXPORT loadBkpt(void *bpt)
{
BKPT_ENTRY_ABI *sw_bpt; 
	depthChanged=1;
	sw_bpt = (BKPT_ENTRY_ABI*)bpt;
	breakNumber = 0;                         
	while (0 != sw_bpt) {                    
		SwBreak[breakNumber].exists = 1;
		SwBreak[breakNumber].address = sw_bpt->addr;
		SwBreak[breakNumber].count = 1;
		SwBreak[breakNumber].tmp_count = 0;
		SwBreak[breakNumber].data1 = (U8)((sw_bpt->opcode)&0x00ff);
		SwBreak[breakNumber].data2 = (U8)(((sw_bpt->opcode)>>8)&0x00ff);
		breakNumber++;
		sw_bpt = sw_bpt->next;
	}

      //  if(mode != FREE_RUN) {
      //  memcpy(&bp_save,&(bp_record[1]),sizeof(EXEC_EVENT) );
      //          bp_record[1].defined = 0;   
      //  }                  
   
noRAM = 0;

   break_id = 0;
   tick_temp = tick_count;
   //if (!noRAM && breakNumber && (mode != FREE_RUN)) {
		init_sw();
  // }                
   
   if (!noRAM) sw_set();        

}



RETCODE EXPORT iceGo(U16 mode,void *bpt)
{
int i,status;
long interval = 0;
unsigned long adr2hex();
unsigned long l, addr2;
U8 goEndFlag;
char *ptr, tmp_buf[80], tmp_buf2[40];
ADDR tmpAddr;   
EXEC_EVENT bp_save;
//prepare for sw breakpoint
		    
	send('G');
	send(CR);              
	regOk=0;            
   return GOOD;
}  

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceClearEvent(U16 evId)
{
char  *ptr, c, key;
   
   send_str2("EVENT ");
   event_cmd[2]=evId+'0';
   send_str2(event_cmd);
   send_str2("CLEAR ");
   send_CR_wait(CR);
   return ICE_OK;
}  

//1 mask 
//not used
void SetWildCard(U32 mask,U32 value,U8 lenBit,char* retBuf)
{        
	int i;        
	strcpy(retBuf,"");                                          
	for (i=lenBit-1;i>=0;i--) {
		if (((i+1)%8 == 0) && (i+1 != lenBit)) strcat(retBuf,")");
		if (((i+1)%8 == 0) && (i+1 != 1)) strcat(retBuf,"(");
		if ( 0 == test_bit(mask,i) ) {
			if (0 == test_bit(value,i)) strcat(retBuf,"0");
				else strcat(retBuf,"1");
		} else {
			strcat(retBuf,"X");
		}                      
		if(i+1 == 1) strcat(retBuf,")");
	}

 }

//0 mask
char* GetWildCard(U32* mask,U32* value,U8 len,char* retBuf)
{        
	int i,j,k;         
	U16 tmpMask,tmpValue;
	*mask =0; *value = 0;
	
	i = 0;
	while ((*retBuf != ' ') && (*retBuf != 0)
		   && (*retBuf != 0x0d)) {
		if (i>=len) return 0;
		if(*retBuf == '(') {
			retBuf++;
			j = 0; tmpMask = 0; tmpValue = 0;
			while( (*retBuf != ' ') && (*retBuf != ')') &&
				   (*retBuf != 0) && (*retBuf != 0x0d)) {
				if(i>=len) return 0;
				switch (*retBuf) {
					case '0' : set_bit(tmpMask,0);
						  clr_bit(tmpValue,0);
						  break;
					case '1' : set_bit(tmpMask,0);
						  set_bit(tmpValue,0);
						  break;          
					case 'X' :
					case 'x' : clr_bit(tmpMask,0);
						  break;                     
					default : return 0;       
				}   
				j++; retBuf++;
				tmpMask = tmpMask<<1;
				tmpValue = tmpValue<<1;
				if(j == 4) {
					j = 0;               
					tmpMask = (tmpMask>>1)&0xf;
					tmpValue = (tmpValue>1)&0xf;           
					*mask = *mask + tmpMask; *value = *value + tmpValue;
					*mask = (*mask)<<4; *value = (*value)<<4;
					i++;
				}
				
			}
			if (j != 0) {
				tmpMask = (tmpMask>>1)&0xf;
				tmpValue = (tmpValue>1)&0xf;
				if (*retBuf == ')') retBuf++; else return 0;
				*mask = *mask + tmpMask; *value = *value + tmpValue;        
				*mask = (*mask)<<4; *value = (*value)<<4;
				i++;
			}       
		} else
		if ((*retBuf == 'X') || (*retBuf == 'x')) {
			for(k=0;k<4;k++) {
				clr_bit(*mask,k);
			}       
			*mask = (*mask)<<4; *value = *value<<4;
			i++;
			(*retBuf)++;
		} else 
		if ((*retBuf >= '0') && (*retBuf <= '9')) {
			*value = *value + (*retBuf - '0');     
			*mask = (*mask)<<4; *value = *value<<4;
			i++;
			(*retBuf)++;
		} else 
		if ((*retBuf >= 'A') && (*retBuf <= 'F')) {
			*value = *value + (*retBuf - 'A' + 10);
			*mask = (*mask)<<4; *value = *value<<4;
			i++;        
			(*retBuf)++;
		} else 
		return 0;
		
	}
	
    *mask = (*mask)>>4; *value = *value>>4;
    return retBuf;
 }

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok  
**                       cntFlag,timeRecord,counter not supported
**
**************************************************************************/
RETCODE EXPORT iceGetEvent(BUS_EVENT *event, EXEC_EVENT *bp,
				U16 *ext_record, U8 *cntFlag, U32 *timeRecord, U16 *counter)
{                                                                  
/*
	*event = event_record;
	*ext_record = event_record[LAM2+3].addrLo;
	*bp = bp_record;
	return ICE_OK;
*/        
	memcpy(event,event_record,4*sizeof(BUS_EVENT));
	memcpy(bp,bp_record,3*sizeof(EXEC_EVENT));
	*ext_record=event_record[LAM2+2].addrLo;

/*
int iBus,iBp;  
char* pcTmp,pcTmp2;           

    iBus = iBp = 0;
	send_str2("E");
	send(CR);
	
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
	ptr = NULL;
	pcTmp = tx_buff;
	
	while ( (pcTmp = strstr(pcTmp,"EV")) != NULL) {
		pcTmp = pcTmp + 5;
		switch (*pcTmp) {         
			case 'b' : pcTmp = pcTmp + 5;   
					   if (*pcTmp == 'C') {
						   event_record[iBus++].defined = 0;
						   break;
					   }
					   if (*pcTmp == 'R') {
					       pcTmp += 6;
					       sscanf("%X %X",event_record[iBus].addrLo,
							  event_record[iBus].addrHi);
					       while(*pcTmp != ' ') pcTmp++;
					       pcTmp++;
					       while( (*pcTmp>='0' & *pcTmp<='9') ||
							  (*pcTmp>='A' & *pcTmp<='F') ) pcTmp++;
					       while (*pcTmp == ' ') pcTmp++;
					       if(*pcTmp == 'c') {
						   pcTmp += 6;
						   sscanf("%X",event_record[iBus].count,
							      event_record[iBus].addrHi);
					       }
					       if (!(*pcTmp>='0' && *pcTmp<='9') && !(*pcTmp>='A' && *pcTmp<='F')
						   && *pcTmp!='X') {
						   
					       }           
							  
					   }
					   pcTmp2 = GetWildCard(event_record[iBus].dataHi,
											event_record[iBus].adataLo,4,pcTmp);
											
											
		}
	}
*/
		
	
 }                              

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: first call trace routines, then call this routine to get shell str
**
**************************************************************************/
RETCODE EXPORT GetRetStr(char* p) 
{
	strcpy(p,retStr);
	return ICE_OK;
 }
 
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: 
**
**************************************************************************/
RETCODE EXPORT GetEventStr(char* str) 
{                 
	char* ptr;                                     
	char c;
	send_str2("Event");
	send(CR);
    ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
    *ptr++=0;
    strcpy(str,tx_buf);
    return ICE_OK;
 }


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :    
**
** Notes: evId 3-6 or 6-8(lam2)
**
**************************************************************************/
char* EXPORT GetBpStr(U16 evId) 
{   
	return (char*)(&(bp_str[evId-4-LAM2][0]));
 }

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: 
**
**************************************************************************/
RETCODE EXPORT GetLevelStr(char* str) 
{      
	char* ptr;                                     
	char c;
	send_str2("Trigger Level");
	send(CR);
    ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
    *ptr++=0;
    strcpy(str,tx_buf);
    return ICE_OK;
 }

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: 
**
**************************************************************************/
RETCODE EXPORT GetTriggerStr(char* str) 
{                     
	char* ptr;                                     
	char c;
	send_str2("Trigger");
	send(CR);
    ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
    *ptr++=0;
    strcpy(str,tx_buf);
    return ICE_OK;

 }
 
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: isOn : 0 ==> off
**                               1 ==> on
**
**************************************************************************/
RETCODE EXPORT iceSetInterval(U8 isOn) 
{     
char tmp[30];
	if (isOn) send_str("INTerval On");
	else send_str("INTerval Off");
	return ICE_OK;
 }



RETCODE EXPORT iceGetInterval(U16 FAR* isOn) 
{     
char tmp[30];
char c;
char * ptr;
	send_str("INT");
	   send_CR_wait(CR);
   for (;;) {
	   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
	   if (c == HAND_SHAKE) break;
	   *ptr = NULL;                
   }
	if( (strstr(tx_buf,"On")!=NULL) || 
	    (strstr(tx_buf,"on")!=NULL) ||
	    (strstr(tx_buf,"ON")!=NULL) ) 
	    *isOn =1;
	else *isOn=0;    
	return ICE_OK;
 }

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output : Id : 1 =qualify 1 ; 2 = qualify 2;
**
**
**************************************************************************/
RETCODE EXPORT iceSetQualify(U16 Id,QUALIFY* qualify) 
{ 
int c;
char* ptr;                   
char tmp[30];
    send_str2("Q "); strcpy(retStr,"Qualify  ");
    if(Id == 1) {
	send_str2("1 ");strcpy(retStr,"1 ");
    } else {                                
	send_str2("2 ");strcpy(retStr,"2 ");
    }   
	send_address(qualify->addrSpec,qualify->addrLo,
				 qualify->addrHi);
	send_stat(qualify->stat);
	send_extern(qualify->externSpec,(U32)(qualify->externLo),(U32)(qualify->externHi));
	
    send(CR);
    ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
	*ptr = NULL;
	if (NULL != strstr(tx_buf,"error")) return ICE_SYNTAX_ERROR;
	qualify->defined = 1;
	memcpy(&qualify_record[Id-1],qualify,sizeof(QUALIFY));
	strcpy((char*)(&(qualify_str[Id-1][0])),retStr);
	return(OK);
 }

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  evId : 1- = 1-; 0 clear all;    
**                 option : 0=clear,1=enable,2=disable
**
**************************************************************************/
RETCODE EXPORT iceClrQualify(U16 Id,U8 option) {
int i;                
char tmp[30];
	if (!Id) {    
		switch(option) {
		case 0 : strcpy(tmp,"Q CL ");
				 strcpy(retStr,"Qualifys Clear.");
				 break;
		case 1 : strcpy(tmp,"Q ENable ");
				 strcpy(retStr,"Qualifys Enable.");
				 break;
		case 2 : strcpy(tmp,"Q DIsable ");
				 strcpy(retStr,"Qualifys Disable.");
				 break;
		}                                
				 
	} else {     
		if (1==Id) {
			strcpy(tmp,"Q 1 ");
			strcpy(retStr,"Qualify 1 ");
		} else {                        
			strcpy(tmp,"Q 2 ");
			strcpy(retStr,"Qualify 2 ");
		}
		
		switch(option) {
		case 0 : strcat(tmp,"CL");
				 strcat(retStr,"Clear.");
				 break;
		case 1 : strcat(tmp,"ENable ");
				 strcat(retStr,"Enable.");
				 break;
		case 2 : strcat(tmp,"DIsable ");
				 strcat(retStr,"Disable.");
				 break;
		}                                
	}       
	send_str(tmp);
	switch(option) {
	case 0: if (!Id) {
				for (i=0;i<2;i++) {
					qualify_record[i].defined=0;                
					strcpy((char*)(&(qualify_str[Id-1][0])),retStr);
				}       
			} else {
				qualify_record[Id-1].defined=0;
				strcpy((char*)(&(qualify_str[Id-1][0])),retStr);
			}                                                       
			break;
	case 1: if (!Id) {
				for (i=0;i<2;i++) {
					qualify_record[i].isEnabled=1;                
					strcpy((char*)(&(qualify_str[Id-1][0])),retStr);
				}       
			} else {
				qualify_record[Id-1].isEnabled=1;
				strcpy((char*)(&(qualify_str[Id-1][0])),retStr);
			}                                                       
			break;          
	case 2: if (!Id) {
				for (i=0;i<2;i++) {
					qualify_record[i].isEnabled=0;                
					strcpy((char*)(&(qualify_str[i][0])),retStr);
				}       
			} else {
				qualify_record[Id-1].isEnabled=0;
				strcpy((char*)(&(qualify_str[Id-1][0])),retStr);
			}                                                       
			break;                                         
	}               
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok  Id = 1-- ==> qualify1--
**
**************************************************************************/
RETCODE EXPORT iceGetQualify(U16 Id,QUALIFY* qualify)
{                                                                  
					   
   memcpy(qualify,&(qualify_record[Id-1]),sizeof(QUALIFY));                                             
	//*qualify = &(qualify_record[Id-1]);
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: Id 1-2(qualify1,qualify2) 
**
**************************************************************************/
RETCODE EXPORT GetQualifyStr(char* str) 
{
	char* ptr;                                     
	char c;
	send_str2("Qualify");
	send(CR);
    ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
    *ptr++=0;
    strcpy(str,tx_buf);
    return ICE_OK;
 }


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: bufID :  NO USE  ; *cond.qFlag==1 defined otherwise not defined
**
**************************************************************************/
RETCODE EXPORT iceGetTraceFrame(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								MP_TRACE_INFO *frameData)                        
{                                           
int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];
char tmp5[30];                  
char tmp6[10];
char tmp7[10];
char tmp8[10];                  
char tmp9[10];                  
char tmp10[10];                  
U8 frameLen;                   
U8 isOver = 0;
	frameLen = 0;          
	
    send_str2("List ");           
    sprintf(tmp,"%X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%X ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%X ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR) *ptr++ = c;
	*(ptr) = 0;                                                  
	//*ptr=NULL;
	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) {
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}
	
	while(TRUE) {                         
		ptr=tx_buf;
		while(TRUE) {
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		*(ptr++) = 0;   
		*ptr = NULL;
		   
		   
		   
		if(NULL != strstr(tx_buf,">")) {
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		   
		   
		   
		if(strstr(tx_buf,"More")!=NULL) {
			if(isOver==1) {
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;
			      
		sscanf(tx_buf," %s %s  %s   %s    %s   %s  %s   %s %s %s",tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,
				 tmp7,tmp8,tmp9,tmp10);
		
		frameData[frameLen].frameNo = str2U32(tmp1);
		frameData[frameLen].addr = str2U32(tmp2);
//jerry                sscanf(tmp3,"%x",&(frameData[frameLen].data));
//jerry                frameData[frameLen].stat = get_stat(tmp4);
//jerry                frameData[frameLen].spare = get_extern(tmp5);
//                strcpy(frameData[frameLen].timeStr,tmp8);
//                strcat(frameData[frameLen].timeStr,tmp9);
//Jerry 2,24                strcat(frameData[frameLen].timeStr,tmp10);
		(frameLen)++;
		if (frameLen >= *frameLenReq) {
			*frameLenReq = frameLen;  
			isOver =1;

		/*
		    send_ESC();
		    while(TRUE) {
				c=receive();
				if (c == HAND_SHAKE) break;
			 } 
			 *frameLenReq = frameLen;
			 return ICE_OK; */
		}
		
	}       
    
    return      ICE_BUFFER_EMPTY;
			  
 }                        
 
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: bufID :  NO USE  ; *cond.qFlag==1 defined otherwise not defined
**
**************************************************************************/
RETCODE EXPORT iceGetTraceFrameStr(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								MP_TRACE_INFO *frameData)                        

{                                           

int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];
char tmp5[30];                  
char tmp6[10];
char tmp7[10];
char tmp8[10];                  
char tmp9[10];                  
char tmp10[10]; 
U8 frameLen;                   
U8 isOver = 0;
char *endPtr;
U32 nnn;
	frameLen = 0;          
    send_str2("List ");           
    sprintf(tmp,"%X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%lX ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%lX ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR && c != HAND_SHAKE) *ptr++ = c;
	*(ptr) = 0;
	//*ptr=NULL;
	
	if(  ( c==HAND_SHAKE && strstr(tx_buf,">")!=NULL )  )
	{
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}

	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) 
	{
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}
	
	while(TRUE) 
	{                         
		ptr=tx_buf;
		while(TRUE) 
		{
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		*(ptr) = 0;   
// add by jerry on 2,26
	while( *(--ptr)=='\A' || *(ptr)=='\D' ) 
	    *ptr=0;
 //add by jerry on 2,26                                
		
		   
		   
		   
		if(NULL != strstr(tx_buf,">")) 
		{
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		   
		   
		   
		if(strstr(tx_buf,"More")!=NULL) 
		{
			if(isOver==1) 
			{
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) 
			{
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) 
			{
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;

		sscanf(tx_buf," %s %s  %s   %s    %s   %s  %s   %s %s %s",tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,
				 tmp7,tmp8,tmp9,tmp10);
		*(--ptr)=0;
		frameData[frameLen].frameNo = str2U32(tmp1);
		frameData[frameLen].addr = str2U32(tmp2);
//              sscanf(tmp3,"%x",&(frameData[frameLen].data));
//              frameData[frameLen].stat = get_stat(tmp4);
//              frameData[frameLen].spare = get_extern(tmp5);
//                strcpy(frameData[frameLen].timeStr,tmp8);
//                strcat(frameData[frameLen].timeStr,tmp9);
//                strcat(frameData[frameLen].timeStr,tmp10);
		nnn=strtoul(tmp1,&endPtr,16);
		sprintf(tmp1," %05d",nnn);
		strcpy(frameData[frameLen].traceStr,tmp1);
		strcat(frameData[frameLen].traceStr,"   " );
		strcat(frameData[frameLen].traceStr,&tx_buf[5]);
		(frameLen)++;
		if (frameLen >= *frameLenReq) 
		{
			*frameLenReq = frameLen;  
			isOver =1;
		}
		
	}       
       return      ICE_BUFFER_EMPTY;
			  
 }                        

RETCODE EXPORT iceGetTraceFrameStrHead(U16 bufID,QUALIFY_LIST *cond, 
											  char *strHead)                        
{ 
					  
int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];
char tmp5[30];                  
char tmp6[10];
char tmp7[10];
char tmp8[10];                  
char tmp9[10];                  
char tmp10[10];                  
U8 *frameLenReq;   
S32 startFrame = 1;
U8 tmpU8 = 1;           
U8 frameLen;                   
U8 isOver = 0;

frameLenReq = &tmpU8;

	frameLen = 0;          
	
    send_str2("List ");           
    sprintf(tmp,"%X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%lX ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%lX ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR) *ptr++ = c;
	*(ptr) = 0;
	if(*(--ptr)!='>') *ptr=0;
	strcpy(strHead,&tx_buf[6]);
	
	//*ptr=NULL;
	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) {
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}
	
	while(TRUE) {                         
		ptr=tx_buf;
		while(TRUE) {
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		*(ptr) = 0;   
		if(NULL != strstr(tx_buf,">")) {
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		
		if(strstr(tx_buf,"More")!=NULL) {
			if(isOver==1) {
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;
		/*            
		sscanf(tx_buf," %s %s  %s   %s    %s   %s  %s   %s %s %s",tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,
				 tmp7,tmp8,tmp9,tmp10);
		
		frameData[frameLen].frameNo = str2U32(tmp1);
		frameData[frameLen].addr = str2U32(tmp2);
		sscanf(tmp3,"%x",&(frameData[frameLen].data));
		frameData[frameLen].stat = get_stat(tmp4);
		frameData[frameLen].spare = get_extern(tmp5);
//                strcpy(frameData[frameLen].timeStr,tmp8);
//                strcat(frameData[frameLen].timeStr,tmp9);
//                strcat(frameData[frameLen].timeStr,tmp10);
*/

//              strcpy(frameData[frameLen].traceStr,tx_buf);
		(frameLen)++;
		if (frameLen >= *frameLenReq) {
			*frameLenReq = frameLen;  
			isOver =1;
		/*
		    send_ESC();
		    while(TRUE) {
				c=receive();
				if (c == HAND_SHAKE) break;
			 } 
			 *frameLenReq = frameLen;
			 return ICE_OK; */
		}
		
	}       
    
    return      ICE_BUFFER_EMPTY;
			  
			  
 }                        

 
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: bufID :  NO USE  ; *cond.qFlag==1 defined otherwise not defined
**
**************************************************************************/
RETCODE EXPORT iceGetTraceInst(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								char* frameData[])                        
{      
int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];
char tmp5[30];
U8 frameLen;                   
U8 isOver = 0;
	frameLen = 0;          
	
    send_str2("List INSTRUCTION ");           
    sprintf(tmp,"%04X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%lX ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%lX ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR) {
		*ptr++ = c;
		if(c == HAND_SHAKE) {
			*frameLenReq = 0;
			return ICE_OK;
		}       
	}       
	*(ptr) = 0;
	//*ptr=NULL;
	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) {
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}
	
	strcpy(frameData[frameLen],tx_buf);
	(frameLen)++;
	
	while(TRUE) {                         
		ptr=tx_buf;
		while(TRUE) {
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		*(ptr) = 0;   
		//*ptr = NULL;
		   
		   
		   
		if(NULL != strstr(tx_buf,">")) {
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		   
		   
		   
		if(strstr(tx_buf,"More")!=NULL) {
			if(isOver==1) {
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;
		*(--ptr)=0;// remove "\a\d"                                                                     
		strcpy(frameData[frameLen],tx_buf);
		(frameLen)++;
		if (frameLen >= *frameLenReq) {
			*frameLenReq = frameLen;  
			isOver =1;
		/*
		    send_ESC();
		    while(TRUE) {
				c=receive();
				if (c == HAND_SHAKE) break;
			 } 
			 *frameLenReq = frameLen;
			 return ICE_OK; */
		}
		
	}       
    
    return      ICE_BUFFER_EMPTY;
			  
 }                        
// gettraceframeinstr
char LastFrameInst[64];

RETCODE EXPORT iceGetTraceFrameInst(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
					    MP_TRACE_INFO* frameData)     
{      
int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];                                      
char tmp5[30];
char tmp6[30];
char *p;                               
char *endPtr;
int frameLen;                   
U8 isOver = 0;

U32 ttt;
U32 nnn;
	frameLen = 0;          
	
    send_str2("List INSTRUCTION ");           
    if(startFrame>0 ) 
    {   sprintf(tmp,"%X ",startFrame-1);   // add by jerry
	frameLen=-1;
    }
    else sprintf(tmp,"%X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%lX ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%lX ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR ) {
		*ptr++ = c;
		if(c == HAND_SHAKE) {
			*frameLenReq = 0;
			return ICE_OK;
		}       
	}       
	*(ptr) = 0;
	//*ptr=NULL;
	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) {
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}
	
	//strcpy(frameData[frameLen],tx_buf);
//        strcpy(frameData[frameLen].traceStr,tx_buf);
//        (frameLen)++;
	
	while(TRUE) {                         
		ptr=tx_buf;
		while(TRUE) {
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		*(ptr) = 0;   
		//*ptr = NULL;
		   
		if(NULL != strstr(tx_buf,">")) {
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		   
		   
		   
		if(strstr(tx_buf,"More")!=NULL) {
			if(isOver==1) {
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;
		    
		if(startFrame>0 && frameLen==-1 ) 
		{   
		    strcpy(LastFrameInst,tx_buf);
		    frameLen++;
		    continue;
		}
		*(--ptr)=0;
		if(tx_buf[1]==' ' ) 
		{
		    if(frameLen==0)
		    {
			sscanf(LastFrameInst," %s %s",tmp1,tmp2);
			ttt=strtoul(tmp2,&endPtr,16);
			ttt+=2;
			nnn=strtoul(tmp1,&endPtr,16);
			sprintf(tmp1,"%05d",nnn);
			if(MICE==CPU68020_M3 || MICE==CPU68030_M3 )
			{  
				sprintf(tmp4,"%08X" ,ttt);
				p=&tx_buf[23];
			}
			else  
			{   
				sprintf(tmp4,"%04X" ,ttt);
				p=&tx_buf[13];
			}
			sprintf(frameData[frameLen].traceStr," %s    %s    %s",tmp1,tmp4,p); 
			frameData[frameLen].frameNo=nnn;
			frameData[frameLen].addr=ttt;
			      
		    }
		    else
		    {
			sscanf(frameData[frameLen-1].traceStr," %s %s",tmp1,tmp2);
			ttt=strtoul(tmp2,&endPtr,16);
			ttt+=2;
			nnn=strtoul(tmp1,&endPtr,10);
			sprintf(tmp1,"%05d",nnn);
			if(MICE==CPU68020_M3 || MICE==CPU68030_M3 )
			{  
				sprintf(tmp4,"%08X" ,ttt);
				p=&tx_buf[23];
			}
			else  
			{   
				sprintf(tmp4,"%04X" ,ttt);
				p=&tx_buf[13];
			}
			sprintf(frameData[frameLen].traceStr," %s    %s    %s",tmp1,tmp4,p); 
			frameData[frameLen].frameNo=nnn;
			frameData[frameLen].addr=ttt;
		    }
		    
		    frameLen++;            

		}    
		else 
		{
		   sscanf(tx_buf," %s %s %s",tmp1,tmp2,tmp3);
		   nnn=strtoul(tmp1,&endPtr,16);
		   sprintf(tmp1,"%05d",nnn);
		   
		   if(MICE==CPU68020_M3 || MICE==CPU68030_M3 )
		   {  
			p=&tx_buf[23];
		    }
		    else  
		    {   
			p=&tx_buf[13];
		    }
		   
		   sprintf(frameData[frameLen].traceStr," %s    %s    %s",tmp1,tmp2,p);
		   frameData[frameLen].frameNo=nnn;
		   frameData[frameLen].addr=strtoul(tmp2,&endPtr,16);
		   
		   (frameLen)++;
		}   

		if (frameLen >= (*frameLenReq) ) {
			*frameLenReq = frameLen;  
			isOver =1;
		/*
		    send_ESC();
		    while(TRUE) {
				c=receive();
				if (c == HAND_SHAKE) break;
			 } 
			 *frameLenReq = frameLen;
			 return ICE_OK; */
		}
		
	}       
    
    return      ICE_BUFFER_EMPTY;
			  
 }                        


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: bufID :  NO USE  ; *cond.qFlag==1 defined otherwise not defined
**
**************************************************************************/
RETCODE EXPORT iceGetTraceData(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								char* frameData[])                        
{      
int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];
char tmp5[30];
U8 frameLen;                   
U8 isCheck=0;
U8 isOver = 0;
	frameLen = 0;          
	
    send_str2("List ");           
    sprintf(tmp,"%04X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%lX ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%lX ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	*(ptr) = 0;
	//*ptr=NULL;
	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) {
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}            
	
	strcpy(frameData[frameLen],tx_buf);
	(frameLen)++;
	
	while(TRUE) {                         
		ptr=tx_buf;
		while(TRUE) {
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		//*(--ptr) = 0;   
		*(ptr) = 0;   
		//*ptr = NULL;
		   
		if(isOver==1 && isCheck==0) 
		{   
		   if(tx_buf[1]==' ') *frameLenReq = frameLen;     
		   isCheck=1;
		}   
		if(NULL != strstr(tx_buf,">")) {
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		   
		   
		   
		if(strstr(tx_buf,"More")!=NULL) {
			if(isOver==1) {
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;
		*(--ptr)=0;                                                                     
		strcpy(frameData[frameLen],tx_buf);
		(frameLen)++;
		if (frameLen >= *frameLenReq) {
			*frameLenReq = frameLen;  
			isOver =1;
		/*
		    send_ESC();
		    while(TRUE) {
				c=receive();
				if (c == HAND_SHAKE) break;
			 } 
			 *frameLenReq = frameLen;
			 return ICE_OK; */
		}
		
	}       
    
    return      ICE_BUFFER_EMPTY;
			  
 }                        

 
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: bufID :  NO USE  ; *cond.qFlag==1 defined otherwise not defined
**
**************************************************************************/
RETCODE EXPORT iceGetTraceStr(U16 bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLenReq, 
								char* str[])                        
{      
int c;
char* ptr;                   
char tmp[30];
char tmp1[30];
char tmp2[30];
char tmp3[30];
char tmp4[30];
char tmp5[30];
U8 frameLen;                   
U8 isOver = 0;
	frameLen = 0;          
	
    send_str2("List ");           
    sprintf(tmp,"%X ",startFrame);
    send_str2(tmp);
    if(cond->qFlag==1) {  
	if(cond->addrSpec == 1) {
		sprintf(tmp,"%lX ",cond->startAddr);
		send_str2(tmp);
		sprintf(tmp,"%lX ",cond->endAddr);                   
		send_str2(tmp);
	}
	if(cond->statusSpec == 1) send_stat(cond->status);
	send_extern(cond->externSpec,cond->traceBitData,cond->traceBitWild);
    }
	
    send(CR);  
    ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	
	ptr=tx_buf;
	while((c=receive()) != CR ) *ptr++ = c;
	*(ptr++) = 0;
	*ptr=NULL;                     
	strcpy(str[frameLen++],tx_buf);
	
	if((strstr(tx_buf,"empty")!=NULL) || (strstr(tx_buf,"exceed")!=NULL)) {
		ptr=tx_buf;    
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
		*ptr = NULL;
		*frameLenReq = 0;
		return  ICE_BUFFER_EMPTY;
	}
	
	while(TRUE) {                         
		ptr=tx_buf;
		while(TRUE) {
			c=receive();
			if ((c == CR) || (c == HAND_SHAKE)) break;
			*ptr++ = c;
		}
		*(ptr++) = 0;   
		*ptr = NULL;
		   
		   
		   
		if(NULL != strstr(tx_buf,">")) {
			*frameLenReq = frameLen;
			return ICE_OK;
		}
		   
		   
		   
		if(strstr(tx_buf,"More")!=NULL) {
			if(isOver==1) {
				send_ESC();
				return ICE_OK;
			}
			send(CR);               
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			} 
			while(TRUE) {
				c=receive();
				if ((c == CR) || (c == HAND_SHAKE)) break;
			}
		   continue;
		}       
		if(isOver==1) continue;
		
		strcpy(str[frameLen++],tx_buf);       
		if (frameLen >= *frameLenReq) {
			*frameLenReq = frameLen;  
			isOver =1;
		/*
		    send_ESC();
		    while(TRUE) {
				c=receive();
				if (c == HAND_SHAKE) break;
			 } 
			 *frameLenReq = frameLen;
			 return ICE_OK; */
		}
		
	}       
    
    return      ICE_BUFFER_EMPTY;
			  
 }                        
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: bufID :  
**
**************************************************************************/
RETCODE EXPORT Cycle(char* waitStr,BYTE isCount,U16 count,char* str)                        
{                                                                                           
int c;
char* ptr;           
char tmp[30];        
	
    send_str2("CYCLE ");           
    if (0 != waitStr) { send_str2(waitStr); send_str2(" "); }
    if (0 != isCount) { sprintf(tmp,"%04X ",count); send_str2(tmp);}
    send(CR);  
   
   while (TRUE) { 
	ptr=tx_buf;
		while(TRUE) { 
			c=receive();
			if ( c== CR || c== HAND_SHAKE) break; 
			*ptr++ = c;
		}       
		if (c == HAND_SHAKE) break;
	}
	*(--ptr) = 0;
	send_ESC();
	strcpy(str,tx_buf);
	return ICE_OK;
			  
 }                        
 

RETCODE EXPORT iceCycleNext(BOOLEAN isESC,char * str)
{                                                                                           
int c;
char* ptr;           
char tmp[30];        
if(isESC) 
{send_ESC() ;
return ICE_OK;
}
    send_str2("CYCLE ");           
   send(CR);  
   
   while (TRUE) { 
	ptr=tx_buf;
		while(TRUE) { 
			c=receive();
			if ( c== CR || c== HAND_SHAKE) break; 
			*ptr++ = c;
		}       
		if (c == HAND_SHAKE) break;
	}
	*(--ptr) = 0;
//        send_ESC();
	strcpy(str,tx_buf);
	return ICE_OK;
			  
 }                        

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceRunUntil(U32 addr32) {
int c;
int i;
//Frank, 4/27/95, for PPR pmvm5021
char *ptr;
   ADDR addr;
   addr.pos = addr32;
	iceSetBP(LAM2+4,addr);
//
    ptr = tx_buf;

//    for (;;) {
//        if (emuGetPC() == addr) break;
	for1step();
		send('G');
	send_CR_wait(CR);

	while ((c=receiveGo()) != HAND_SHAKE ) {
	    if (c != '>') *ptr++ = c;
				if (ESCflag==1 || isEsc()) {
					send_ESC();
					//if (bp_record[0].defined) emuSetBP(LAM2+4, bp_record[0].addr);
					//else 
				iceClrBP(LAM2+4);
					return(OK);
				}
		   }
	*ptr = 0;
	if (strstr(tx_buf, "EV4") == 0);
	   //DisplayStr(tx_buf);

//        c = receive();
//        while (receive() != HAND_SHAKE);
//        if (c != '4'+LAM2) break;
// }

	//if (bp_record[0].defined) emuSetBP(LAM2+4, bp_record[0].addr);
	//else 
	iceClrBP(LAM2+4);
   return(OK);
}


/**************************** End of File **********************************/


RETCODE EXPORT iceClock( char* sz)
{
   char *ptr;
   char c;
   send_str2(sz);
   send_CR_wait(CR); 
   ptr=tx_buf;   
   for (;;) {
   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
   if (c == HAND_SHAKE) break;
   }
 
  *(--ptr) =0;
  *(--ptr) =0;    
  strcpy(sz,tx_buf);
 return ICE_OK;  
}
   
RETCODE EXPORT iceWait( char s,char*sz)
{   
	char *ptr,c ;
	send_str2("WA ");
	if(s!=0){       send(s);}
   send_CR_wait(CR); 
   ptr=tx_buf;   
   for (;;) {
   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
   if (c == HAND_SHAKE) break;
   }
   if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
  *(--ptr) =0;
  *(--ptr) =0;    
  strcpy(sz,tx_buf);
 return ICE_OK;    
}




RETCODE EXPORT iceInput1(char *szAddr,char*sz )
{   
	char *ptr,c ;
	send_str2("INPUT ");
	send_str2(szAddr);
   send_CR_wait(CR); 
   ptr=tx_buf;   
   for (;;) {
   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
   if (c == HAND_SHAKE) break;
   }
   if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
  *(--ptr) =0;
  *(--ptr) =0;    
  strcpy(sz,tx_buf);
 return ICE_OK;    
}             

RETCODE EXPORT iceOutput1( char *addr, char * data,char *sz)
{   
	char *ptr,c ;
	send_str2("OUTPUT ");
	send_str2(addr);
	send(' ');
	send_str2(data);
   send_CR_wait(CR); 
   ptr=tx_buf;   
   for (;;) {
   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
   if (c == HAND_SHAKE) break;
   }
   if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
  *(--ptr) =0;
  *(--ptr) =0;    
  strcpy(sz,tx_buf);
 return ICE_OK;    
}



RETCODE EXPORT iceTimebase( char *base,char* sz)
{   
	char *ptr,c ;
	send_str2("Timebase ");
   if(base[0]!=0)
	  send_str2(base);   
	
   send_CR_wait(CR); 
   ptr=tx_buf;   
   for (;;) {
   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
   if (c == HAND_SHAKE) break;
   }
   if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
  *(--ptr) =0;
  *(--ptr) =0;    
  strcpy(sz,tx_buf);
 return ICE_OK;    
}  


RETCODE EXPORT iceInterval( char * on,char* sz)
{   
	char *ptr,c ;
	send_str2("INT ");
	send_str2(on);

   send_CR_wait(CR); 
   ptr=tx_buf;   
   for (;;) {
   while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
   if (c == HAND_SHAKE) break;
   }
   if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
  *(--ptr) =0;
  *(--ptr) =0;    
  strcpy(sz,tx_buf);
 return ICE_OK;    
}



RETCODE EXPORT iceFPRegister( char *FPname, char * data,char* sz)
{   
	char *ptr,c ;
	int i;
	send_str2("REGISTER FP ");
   if(FPname!=NULL)
   { 
     send_str2(FPname);
   }
   if(data!=NULL)
   { 
	send(' ');
     send_str2(data);
    }
	
   send_CR_wait(CR); 
   
   if( FPname!=NULL && data==NULL)
   {
	  ptr=tx_buf;   
     while ((c=receive())!=CR && c!= HAND_SHAKE ) *ptr++ = c;
     *ptr=0; 
     if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
     send_ESC();
     strcpy(sz,tx_buf);   
   }
   else
   {
     ptr=tx_buf;   
     while ((c=receive()) != HAND_SHAKE ) *ptr++ = c;
     *ptr=0;                          
    
     if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
     strcpy(sz,tx_buf);
   }
   
   return ICE_OK;    
}



RETCODE EXPORT iceMMURegister( char *FPname, char * data,char* sz)
{   
	char *ptr,c ; 
	int i;
	send_str2("REGISTER MMU ");
   if(FPname!=NULL)
   { 
     send_str2(FPname);
   }  
   if(data!=NULL)
   { 
     send(' ');
     send_str2(data);
   }
	
   send_CR_wait(CR); 
   
   if( FPname!=NULL && data==NULL)
   {
	  ptr=tx_buf;   
     while ((c=receive())!=CR && c!= HAND_SHAKE ) *ptr++ = c;
     *ptr=0; 
     if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
     send_ESC();
     strcpy(sz,tx_buf);   
   }
   else
   {
    ptr=tx_buf;   
    while ((c=receive()) != HAND_SHAKE ) *ptr++ = c;
    *ptr=0;
    if( strstr(tx_buf,"error")!=NULL) return ICE_SYNTAX_ERROR;
    strcpy(sz,tx_buf);
   }
    return ICE_OK;    
}
