#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _REG68K_DEFINE_
#include "reg68k.h"
#endif

#ifndef ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#ifndef _ABI_GLOBAL_
#include "abiglbs.h"
#endif

#include "ctype.h"

#include <string.h>
		       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/
#define BUFF_SIZE        240
#define CR 0xd
#define HAND_SHAKE 0x3
#define NULL 0
#define BUFF_SIZE 50
char *attr_code[]={"IR ", "I ", "ER ", "E ", "G "};
char *space_code[] = {"SP ","SD ","UP ","UD "};

struct bankData {
	U16 used;
	U32 base;
	U8 mapTable[64];
} mapBank[4];

int first_load;
U32 next_load;
struct  csipData {
		unsigned long low;
		unsigned long high;
} RangeAdr; 
U8 MSPACE;
RETCODE EXPORT iceEndLoad();
extern int downCmdFlag;
extern U32 bankMargin;
extern S16 sizeFlag;
void esc_clearx();
extern BOOLEAN isHEMM;
/**************************************************************************
** Name :
** Function
**    Input  :
**    Output :
** Notes:   ok
**************************************************************************/
RETCODE EXPORT iceSetMap (U32  addr1, U32  addr2, U16 attr) {
char c, *ptr;
int i, j,j1, nextBank;

    if (!addr1     && !addr2    ) {
	send_str("MAP ALL E");
	
	    return ICE_OK;
    }
       if(  (MICE==CPU68020_M3 || MICE==CPU68030_M3) && isHEMM )                 
	       send_str2("MAPI ");
	else   send_str2("MAP ");                                
		
	if(MICE==CPU68020_M3 || MICE==CPU68030_M3) 
	{
		send_long2(addr1    );
		send(' ');
		send_long2(addr2    );
		send(' ');
		j1 = attr&0x7;
		send_str2(attr_code[j1]);
	} else  {   
	
	j = attr&0x100;
	if (j!=0)
	send_str2(space_code[0]);
	j = attr&0x200;
		if (j!=0)
	send_str2(space_code[1]);
	j = attr&0x400;
		if (j!=0)
	send_str2(space_code[2]);
	j = attr&0x800;
		if (j!=0)
	send_str2(space_code[3]);
			
	send_long2(addr1    );
	send(' ');
		send_long2(addr2    );
	send(' ');
	j1 = attr&0x7;
	send_str2(attr_code[j1]);
	if (j1 <2) {
	 j = (attr&0xc000)>>14;
	 send(hex[j+1]);
	}                
}
	
	
	
	send(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE /*&& c != CR*/) *ptr++ = c;
	    *ptr = NULL;    
	    if (strstr(tx_buf, "boundary") != NULL) return(ICE_BANK_FULL);
	if (strstr(tx_buf, "Warning!") != NULL) return(ICE_SYNTAX_ERROR);
	if (strstr(tx_buf, "failure") != NULL) return(ICE_BANK_FULL);
	if (strstr(tx_buf,"error") != NULL) return(ICE_SYNTAX_ERROR);
	
    return ICE_OK;
}   
/******************  add for internal use************************************/
RETCODE EXPORT iceSetMap1 (LPSTR cmdStr) 
{
char c, *ptr;
int i, j,j1, nextBank;
    
    send_str(cmdStr);

    send(CR);
    ptr = tx_buf;
    while ((c=receive()) != HAND_SHAKE /*&& c != CR*/) *ptr++ = c;
	*ptr = NULL;    
	  if (strstr(tx_buf, "boundary") != NULL) return(ICE_BANK_FULL);
	if (strstr(tx_buf, "Warning!") != NULL) return(ICE_SYNTAX_ERROR);
	if (strstr(tx_buf, "failure") != NULL) return(ICE_BANK_FULL);
	if (strstr(tx_buf,"error") != NULL) return(ICE_SYNTAX_ERROR);
	
    return ICE_OK;
}   

/******************  add for internal use************************************/

//ok
RETCODE EXPORT iceGetMapSize(U32 *emmSize) {
	if (HEMM) *emmSize = 2;
	else *emmSize = 0;
	return ICE_OK;
}

//ok              
//WILL NEVER BE CALLED,BECAUSE UI  AND SHELL HAVE THEIRS' BUFFER;
RETCODE EXPORT iceGetMap(MAP_INFO *mapData) {
int i,j,mapFlag,nextBank,segNum;
U8 lastAttr;
	for (nextBank=0,j=0;nextBank<4;nextBank++) {
		if (!mapBank[nextBank].used) continue;
		mapFlag=0;
		lastAttr=3;
		if (HEMM) segNum = 64; else segNum = 16;
		for (i=0;i<segNum;i++) {
			if ((mapBank[nextBank].mapTable[i]&0x7) != 3) {
				if (!mapFlag) {
					mapData[j].addr1=(U32)i*4096+mapBank[nextBank].base;
					mapFlag=1;
					lastAttr=mapBank[nextBank].mapTable[i];
					continue;
				} else if (lastAttr == mapBank[nextBank].mapTable[i]) continue;
				else {
					mapData[j].addr2=(U32)i*4096+mapBank[nextBank].base-1;
					mapData[j].attr=lastAttr;
					j++;
					mapData[j].addr1=(U32)i*4096+mapBank[nextBank].base;
					lastAttr=mapBank[nextBank].mapTable[i];
				}
			} else if (mapFlag) {
					mapData[j].addr2=(U32)i*4096+mapBank[nextBank].base-1;
					mapData[j].attr=lastAttr;
					j++;
					mapFlag=0;
			}
		}
		if (mapFlag) {
			mapData[j].addr2=mapBank[nextBank].base+bankMargin-1;
			mapData[j].attr=lastAttr;
			j++;
		}
	}
	mapData[j].addr1=0xffffffffL;
	return ICE_OK;
}

/****************************************************************************
**
**  iceFill
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**   notes: ok
****************************************************************************/
RETCODE EXPORT iceFill(ADDR* addr, U32 len, U8 *buff, U16 patternLen) {
char *ptr, c;
int i;
    send_str2("F ");
	send_long(addr->pos);
	send_str2(" L ");
	send_long(len);
	ptr=buff;
    for (i=0;i < patternLen;i++)        
	{
	    send(' ');
	    send_byte(*ptr++);
	}
	send(CR);
	ptr=tx_buf;
    while ((c=receive()) != HAND_SHAKE) 
       {
	*ptr++ = c;
      }
	*ptr=NULL;
	return check_error(tx_buf);
}                  /* end of emuFill(addr, len, buff, patternLen) */



/****************************************************************************
**
**   ReadMem
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**  notes: ok
****************************************************************************/
RETCODE EXPORT ReadMem(ADDR addr, U8 *buff, U16 len) {
unsigned char c, check_sum, *ptr1;
char *ptr;
int i, j, k, length;
unsigned long l;

	if (!len) return(OK);
    if (len == 1) return iceGetMem(addr, buff);
	ptr1=buff;
	if (addr.pos & 1) {
		iceGetMem(addr,buff);
		addr.pos++;
		ptr1++;
		len--;
	}
    len &= 0xffff;
	send_str2("U ");
	if (MICE != CPU68020_M3 && MICE != CPU68030_M3) addr.pos &= 0xffffff;
	send_long(addr.pos);
	send(' ');
	l = addr.pos+len-1;
	if (MICE != CPU68020_M3 && MICE != CPU68030_M3) l &= 0xffffff;
	if (l < addr.pos) {
		if (MICE == CPU68020_M3 || MICE == CPU68030_M3) l = 0xffffffff;
		else l =0xffffff;
	}
	send_long(l);
	if (MICE == CPU68030_M3) send_str2(" LOG");
	send_CR_wait(CR);
	for (;;) {
		for (j=0;j<5;j++) {
			check_sum=0;
			ptr=tx_buf;
			while ((c=receive()) != 'S') 
				if (c == HAND_SHAKE) return (ICE_ERROR_READ);
			if ((c=receive()) == '7' || c == '8') {
				while (receive() != HAND_SHAKE);
				send(ACK);
				while (receive() != HAND_SHAKE);
				send_ESC();
				return ICE_OK;
			} 
			if (c != '2' && c != '3') {
				while (receive() != HAND_SHAKE);
				return(ICE_ERROR_READ); 
			}
			length=rx_byte();
			check_sum += (unsigned char)length;
			if (MICE == CPU68020_M3 || MICE == CPU68030_M3) k=4;else k=3;
			for (i=0;i<k;i++) {
				c=rx_byte();
				check_sum += c;
			}
			if (MICE == CPU68020_M3 || MICE == CPU68030_M3) k=5;else k=4;
			for (i=0;i<length-k;i++) {
				c=rx_byte();
				check_sum += c;
				*ptr++=c;
			}
			c=rx_byte();
			receive();
			if (c == 0xff - check_sum) break;
			send(NACK);
		}
		if (j == 5) {
			send_ESC();
			return (ICE_ERROR_READ);
		}
		ptr=tx_buf;
		if (MICE == CPU68020_M3 || MICE == CPU68030_M3) k=5;else k=4;
		for (i=0;i<length-k;i++) *ptr1++ = *ptr++;
		send(ACK);
	}
      return ICE_OK;
}                  

/****************************************************************************
**
**   iceGetMemN
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
#define READ_BUF_SIZE 200
RETCODE EXPORT iceGetMemN(ADDR addr, U8 *buff, U16 len) {
RETCODE status;
U16 lp,blockLen;
U8 patternLen,*buffPtr;
	    
   if (addr.space == 8) addr.space = 5;
   status = ICE_OK;
   buffPtr = buff;
   blockLen = len / READ_BUF_SIZE;
   for (lp = 0; lp < blockLen; lp++) {
      if ((status = ReadMem(addr,buffPtr,READ_BUF_SIZE)) == ICE_OK) {
	 addr.pos += READ_BUF_SIZE;
	 buffPtr += READ_BUF_SIZE;
      }
      else break;
   }
   patternLen = len % READ_BUF_SIZE;
   if ((patternLen) && ((U16)status == ICE_OK))
      status = ReadMem(addr,buffPtr,patternLen);
   /*if ((U16)status == ICE_NOT_READY)
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1));*/ /* error addr */
   return(status);
}
   


/****************************************************************************
**
**   iceGetMem
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**  notes: ok
****************************************************************************/
RETCODE EXPORT iceGetMem(ADDR addr, U8 *buff) {
unsigned char c;
unsigned long rx_long();
unsigned long l;

	send('B');
	send(' ');
	send_long(addr.pos);
	send(CR);
	l=rx_long();
	c=(char)l;
	send_ESC();
	*buff=c;
	return ICE_OK;
}



/****************************************************************************
**  Function Name: iceGetWord()
**
**  Coded by: Chen, 12/26/94
**
****************************************************************************/
RETCODE EXPORT iceGetWord(ADDR addr, U8 *buff) {
U16 c;
unsigned long rx_long();
unsigned long l;

	send('W');
	send('O');
	send('R');
	send('D');
	send(' ');
	send_long(addr.pos);
	send(CR);
	l=rx_long();
	c=(U16)l;
	send_ESC();
	buff[0] = (c>>8) & 0xff;
	buff[1] = c & 0xff;
	buff[2] = '\0';
	return ICE_OK;
}



/****************************************************************************
**  Function Name: iceGetLong()
**
**  Coded by: Chen, 12/26/94
**
****************************************************************************/
RETCODE EXPORT iceGetLong(ADDR addr, U8 *buff) {
U32 c;
unsigned long rx_long();
unsigned long l;

	send('L');
	send('O');
	send('N');
	send('G');
	send(' ');
	send_long(addr.pos);
	send(CR);
	l=rx_long();
	c=(U32)l;
	send_ESC();
	buff[0] = (c>>24) & 0xff;
	buff[1] = (c>>16) & 0xff;
	buff[2] = (c>>8) & 0xff;
	buff[3] = c & 0xff;
	buff[4] = '\0';
	return ICE_OK;
}





/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetMemN(ADDR addr, U8 *buff, U16 patternLen) {
RETCODE status;
U16 lp,len;
U8 *buffPtr;             
    status = iceBinInit();
    if (ICE_OK != status) return status;
	status = iceBinDown(addr,buff,patternLen);
	if (ICE_OK != status) return status;
	status = iceEndLoad();
	
   return status;
   if (addr.space == 8) addr.space = 5;
   status = ICE_OK;
   buffPtr = buff;
   len = patternLen / BUFF_SIZE;
   for (lp = 0; lp < len; lp++) {
      if ((status = writeMemN(addr,buffPtr,BUFF_SIZE)) == ICE_OK) {
	 addr.pos += BUFF_SIZE;
	 buffPtr += BUFF_SIZE;
      }
      else break;
   }
   len = patternLen % BUFF_SIZE;
   if ((len) && ((U16)status == ICE_OK))
      status = writeMemN(addr,buffPtr,(U8)len);
   /*if (((U16)status == ICE_NOT_READY) || ((U16)status == ICE_ERROR_WRITE))
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1));
   ret_addr1.space = addr.space ;
   CheckStatus(status,ret_addr1);*/
   return(status);

}                  

RETCODE EXPORT iceBinDown(ADDR addr, U8 *buff, U16 len)
{
    noLoad=0;
    if (!downLoadMode) iceBinInit();
    binDown(addr, buff, len);
    next_load = addr.pos + len;
    first_load = 0;
	return (OK);
}


RETCODE EXPORT iceBinInit()
{
int i;
int c;
    first_load = 1;
	getSpace();
	send(0xb);
	for (;;) {
		c = receive(); /*    c = RX_DATAP(); */
		if (c < 0) continue;
		if (c == 0xb) break;
		if (c != HAND_SHAKE) while (receive() != HAND_SHAKE);
		downLoadMode = 1;
		binFlag=1;
		return ICE_OK;
	}
	send_ESC();
	binFlag=0;       
	return ICE_OK;
}

/*
asciiDown(addr, buffer, len)
unsigned long addr;
unsigned char *buffer;
unsigned int len;
{
int i, j, length, len1;
unsigned char c, check_sum, *ptr;
char *ptr1;
unsigned long stadr;
	stadr=addr;
	ptr=buffer;
	for (;;) {
		ptr1=tx_buf;
		check_sum=0;
		len1=len;
			for (i=0;i<224 && len1 > 0;i++,len1--) {
				c = *ptr++;
				check_sum += c;
				*ptr1++=hex[(c>>4)&0xf];
				*ptr1++=hex[c&0xf];
			}
			if (MICE == CPU68020_M3 || MICE == CPU68030_M3) i=5;else i=4;
			if (len1 == 0) length=len+i;
			else {
				length=224+i;
				len -= 224;
			}
			check_sum += length;
			if (MICE == CPU68020_M3 || MICE == CPU68030_M3) i=3;else i=2;
			for (;i>=0;i--) check_sum += (stadr>>8*i) & 0xff;
			c = 0xff-check_sum;
			*ptr1++=hex[(c>>4)&0xf];
			*ptr1++=hex[c&0xf];
			*ptr1=0;
			for (j=0;j<5;j++) {
				send('S');
				if (MICE == CPU68020_M3 || MICE == CPU68030_M3)
				send('3');else send('2');
				send_byte(length);
				send_long(stadr);
				ptr1=tx_buf;
				while (c = *ptr1++) send(c);
				for (;;) {
					c=receive();
					if (c == ACK || c == NACK) break; 
					if (c == 't' || c == 'h') {
						while (receive() != HAND_SHAKE);
						iceEndLoad();
						noLoad=1;
						return(MEM_PROTECT);
					}
				}
				while (receive() != HAND_SHAKE);
				if (c == ACK) break;
			}
			if (c == NACK) {
			emuEndLoad();
			return(OK);
		}
		if (len1 == 0) break;
		stadr += 224;
	}
} */

int binDown(ADDR addr, U8* buffer,U16 len)
{
int i, j, length, len1;
unsigned char c, check_sum, *ptr;
char *ptr1;
unsigned long stadr;
	if (first_load || addr.pos != next_load) {
		ptr1=tx_buf;
		*ptr1++ = MSPACE;
		i=3;
		if (MICE == CPU68020_M3 || MICE == CPU68030_M3) {
			*ptr1++=(addr.pos>>24) & 0xff;
			i++;
		}
		for (j=2;j >= 0 ; j--) *ptr1++=(addr.pos>>(8*j)) & 0xff;
		for (j=0,ptr1=tx_buf,check_sum=0;j<i+1; j++) check_sum += *ptr1++;
		*ptr1 = 0xff-check_sum;
		sendBin(0,i+2);
	}
	ptr=buffer;
	for (;;) {
		ptr1=tx_buf;
		check_sum=0;
		len1=len;
		for (i=0;i<224 && len1 > 0;i++,len1--) {
			c = *ptr++;
			check_sum += c;
			*ptr1++ = c;
		}
		if (len1 == 0) length=len;
		else {
			length=224;
			len -= 224;
		}
		check_sum += length;
		*ptr1 = 0xff-check_sum;
		sendBin(length, length+1);
		if (len1 == 0) break;
	}           
	return ICE_OK;
//      if (!noLoad) emuEndLoad();
}

sendBin(REC_ID, length)
int REC_ID, length;
{
int i, j;
char *ptr1, c;
	for (j=0;j<5;j++) {
		send(REC_ID);
		ptr1=tx_buf;
		for (i=0;i < length;i++) {
			c = *ptr1++;
			send(c);
		}
		c=receive();
		if (receive() != HAND_SHAKE) {
			while (receive() != HAND_SHAKE);
			noLoad=1;
			return(MEM_PROTECT);
		}
		if (c == ACK) break;
	}
	if (j == 5) {
		binEnd();
		return(ERROR_COM);
	}
	return(OK);
}

binEnd()
{
	send(0x0);
	send(0x10);
	send(0xef);
	while (receive() != 0x6);
	while (receive() != HAND_SHAKE);
}

getSpace()
{
unsigned long l;
	iceGetReg(I68K_REG,REG_SR,&l);
	if (l & 0x2000) MSPACE=0x40; else MSPACE=0x60;
	if (MICE == CPU68020_M3 || MICE == CPU68030_M3) MSPACE |= 0x4; else MSPACE |= 0x3;
}

RETCODE EXPORT iceEndLoad()
{
	if (binFlag) binEnd(); else send_ESC();
	downLoadMode=0;
	binFlag = 0;
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: OK
**
**************************************************************************/

RETCODE EXPORT iceSetMem(ADDR addr, U8 ch) {
unsigned int i;
char *ptr, c;
	send('B');
	send(' ');
	send_long(addr.pos);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
	send_byte(ch);
	send_CR_wait(HAND_SHAKE);
	send_ESC();
	return ICE_OK;
}                 /* end of emuSetMem(addr, d) */
//for go
RETCODE EXPORT iceSetMemWord(ADDR addr, U16 word) {
unsigned int i;
char *ptr, c;
char tmp[20];
	send('W');
	send(' ');
	send_long(addr.pos);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
	
	sprintf(tmp,"%04X",word);
	send_str2(tmp);
	send_CR_wait(HAND_SHAKE);
	send_ESC();
	return ICE_OK;
}                 /* end of emuSetMem(addr, d) */



/****************************************************************************
**  Function Name: iceSetWord()
**
**  Coded by: Chen, 12/26/94
**
****************************************************************************/
RETCODE EXPORT iceSetWord(ADDR addr, U8 *ch) {
unsigned int i;
char *ptr, c;
	send('W');
	send('O');
	send('R');
	send('D');
	send(' ');
	send_long(addr.pos);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
	send_str2(ch);
	send_CR_wait(HAND_SHAKE);
	send_ESC();
	return(OK);
}


/****************************************************************************
**  Function Name: iceSetLong()
**
**  Coded by: Chen, 12/26/94
**
****************************************************************************/
RETCODE EXPORT iceSetLong(ADDR addr, U8 *ch) {
unsigned int i;
char *ptr, c;
	send('L');
	send('O');
	send('N');
	send('G');
	send(' ');
	send_long(addr.pos);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
	send_str2(ch);
	send_CR_wait(HAND_SHAKE);
	send_ESC();
	return(OK);
}



/**************************************************************************
**
** Name : iceCopy()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  ok
**
**************************************************************************/

RETCODE EXPORT iceCopy(ADDR addr1, U32 len, ADDR addr2) {
char *ptr, c;
	send_str2("CO ");
	send_long(addr1.pos);
	send_str2(" L ");
		send_long(len);
		if (addr1.pos != addr2.pos) {
			 send(' ');
		send_long(addr2.pos);
	}
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	return check_error(tx_buf);
}                  /* end of emuCopy() */

/**************************************************************************
**
** Name : iceCompare()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1,
	RET_ADDR *findAddr2) {
char *ptr, c;
int i;
   send_str2("COM ");
   send_long(addr1.pos);
   send_str2(" L ");
   send_long(len);
   send(' ');
   send_long(addr2.pos);
   send(CR);
   ptr=tx_buf;
   while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
   *ptr=NULL;
   i = check_error(tx_buf);
   if (i != OK) return(i);
   if (strstr(tx_buf, "complete") != NULL) return(NO_DIFF);
   ptr = tx_buf;
   while (*ptr++ != '(');
   if (MICE == CPU68020_M3 || MICE == CPU68030_M3) {
	sscanf(ptr,"%lx) %lx",&findAddr1->addr,&findAddr1->actual);
	while (*++ptr != '(');
	sscanf(ptr,"(%lx) %lx",&findAddr2->addr,&findAddr2->actual);
   } else {
	sscanf(ptr,"%lx) = %lx",&findAddr1->addr,&findAddr1->actual);
	while (*++ptr != '(');
	sscanf(ptr,"(%lx) = %lx",&findAddr2->addr,&findAddr2->actual);
   }
   return(OK);
}                       /* end of emuCompare() */

/**************************************************************************
**
** Name : iceSearch(addr, len, buff, size)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceSearch(ADDR* addr, U32 len, U8 *buff, U16 patternLen) {  /* search block for pattern */
char *ptr, c;
int i;
    send_str2("SE ");
	send_long(addr->pos);
	send_str2(" L ");
		send_long(len);
	ptr=buff;
	for (i=0;i < patternLen;i++) {
		send(' ');
		send_byte(*ptr++);
	}
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
	if (strstr(tx_buf, "complete") != NULL) return(NO_FOUND);
	ptr = tx_buf;
	while ((c=*ptr++) != '-');
	sscanf(ptr,"- data matched at %lx", &ret_addr1);
	addr->pos = ret_addr1;
	return ICE_OK;
} /* end of emuSearch() */

/**************************************************************************
**
** Name : iceChecksum
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:   ok
**
**************************************************************************/
RETCODE EXPORT iceChecksum(ADDR addr, U32 len, U16 *n) {
char c, *ptr;
int i;
U32 j;
	   send_str2("CH ");
       send_long(addr.pos);
	send_str2(" L ");
		send_long(len);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
		ptr = tx_buf;
		while (*ptr++ != 'i');
	sscanf(ptr, "s %lx", &j);
	*n = j;
		return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: OK
**
**************************************************************************/
RETCODE EXPORT iceTest(ADDR addr, U32 len, ADDR *ret_addr) {
char c, *ptr;
int i;
	    send_str2("TE ");
	send_long(addr.pos);
	send_str2(" L ");
		send_long(len);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
		if (strstr(tx_buf, "found") != NULL) return ICE_OK;
		ptr = tx_buf;
		while (*ptr++ != '-');
		sscanf(ptr, "- failure at %lx", &(ret_addr->pos));
		return(TEST_FAIL);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:OK
**
**************************************************************************/

RETCODE EXPORT iceInput(U16 port, U16 len, U16 size, U8 *buff) {
char c, *ptr;
U32 l1, l2;
int i;
    send_str2("I ");
	send_long(port);
	send_CR_wait(CR);
	while (receive() != CR);
	ptr = tx_buf;
	while ((c=receive()) != CR) *ptr++ = c;
    *ptr = NULL;
	sscanf(tx_buf,"%lx %lx", &l1, &l2);
	for (i=0;i < sizeFlag;i++) *buff++ = (U8)((l2>>i*8)&0xff);
	while (receive() != HAND_SHAKE);
	send_ESC();
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceOutput(U16 port, U8 *data, U16 len, U16 size) {
int i;
	send_str2("O ");
	send_long(port);
	send(' ');
	for (i=0;i < sizeFlag; i++) send_byte(*data++);
	send_CR_wait(HAND_SHAKE);
	return ICE_OK;
}

send_long2(addr)
U32 addr;
{
int i;
char c;
   for (i=4; i >= 0; i--) {
     c=(addr>>i*4)&0xf;
     send(hex[c]);
   }
}

/**************************************************************************
**
** Name : writeMemN(addr, buffer, n)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  ok
**
**************************************************************************/

writeMemN(addr, buffer, n)
ADDR addr;
unsigned char *buffer;
unsigned int n;
{
unsigned int i;
unsigned char c;
char *ptr;
	if (n == 1) return iceSetMem(addr, *buffer);
	send('B');
	send(' ');
	send_long(addr.pos);
	for (i=0;i < n;i++) {
	     send(' ');
	     send_byte(*buffer++);
	}
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	if (!strstr(tx_buf,"ERROR")) return ICE_OK;
	else return ERROR_WRITE;
	/*return check_error(tx_buf);*/
}                 /* end of writeMemN() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceSize(ABI_SIZE sizeFlag) {
	send_str2("SI ");
	switch (sizeFlag) {
	case 1: send('B');
			break;
	case 2: send('W');
			break;
	case 4: send('L');
			break;
	}
	send_CR_wait(HAND_SHAKE);
	return ICE_OK;
}                                                               
////////////////////for spa/////////////////////////////////////
//#define CR 0x0d
//#define HAND_SHAKE 0X03
//#define ESC 0X1b
void sscanfMy(char* buff,BYTE* b1,BYTE* b2,int* i3) {
	int i = 0;
	BYTE bTmp=0;
	BYTE bTmp2;
	
	if(buff[i]>='0' && buff[i]<='9') bTmp = buff[i]-'0';
		else if (buff[i]>='A' && buff[i]<='F') bTmp = buff[i]-'A'+10;
		else if (buff[i]>='a' && buff[i]<='f') bTmp = buff[i]-'a'+10;
		else bTmp = 0;
	bTmp2 = bTmp*256;	
	i++;             
	if(buff[i]>='0' && buff[i]<='9') bTmp = buff[i]-'0';
		else if (buff[i]>='A' && buff[i]<='F') bTmp = buff[i]-'A'+10;
		else if (buff[i]>='a' && buff[i]<='f') bTmp = buff[i]-'a'+10;
		else bTmp = 0; 
	bTmp2 += bTmp;
	i++;
	*b1 = bTmp2;
	
	if(buff[i]>='0' && buff[i]<='9') bTmp = buff[i]-'0';
		else if (buff[i]>='A' && buff[i]<='F') bTmp = buff[i]-'A'+10;
		else if (buff[i]>='a' && buff[i]<='f') bTmp = buff[i]-'a'+10;
		else bTmp = 0;
	bTmp2 = bTmp*256;	
	i++;             
	if(buff[i]>='0' && buff[i]<='9') bTmp = buff[i]-'0';
		else if (buff[i]>='A' && buff[i]<='F') bTmp = buff[i]-'A'+10;
		else if (buff[i]>='a' && buff[i]<='f') bTmp = buff[i]-'a'+10;
		else bTmp = 0; 
	bTmp2 += bTmp;
	i++;
	*b2 = bTmp2;
	
	if(buff[i]>='0' && buff[i]<='9') bTmp = buff[i]-'0';
		else if (buff[i]>='A' && buff[i]<='F') bTmp = buff[i]-'A'+10;
		else if (buff[i]>='a' && buff[i]<='f') bTmp = buff[i]-'a'+10;
		else bTmp = 0;
	bTmp2 = bTmp*256;	
	i++;             
	if(buff[i]>='0' && buff[i]<='9') bTmp = buff[i]-'0';
		else if (buff[i]>='A' && buff[i]<='F') bTmp = buff[i]-'A'+10;
		else if (buff[i]>='a' && buff[i]<='f') bTmp = buff[i]-'a'+10;
		else bTmp = 0; 
	bTmp2 += bTmp;
	i++;
	*i3 = bTmp2;
		
}

int receive_nowait() { 
	return receiveB();
}
 
//for spa
spasend()
{
     send('S') ;
     send('P') ;
     send('A') ;
}          

void send_adr(DWORD dwAddr)
{            
	char tmp[20];
	sprintf(tmp,"%lx",dwAddr);
        send_str2(tmp);
}

int Rtest()
{
int i;
char word[30] ;
char c ;
	send('R') ;
	send_CR_wait(CR) ;
    while ( (c=receive()) != HAND_SHAKE) {
    	if(c == -1) continue;
	      if (isalpha(c)) {
			  i = 0 ;
			   while (isalpha(c)) {
			        toupper(c) ;
			        word[i++] = c ;
					while ( (c = receive()) == -1) ;
			   }
			   word[i] = '\0' ;
			   if (strcmp(word,"halted")== 0) {
	                while ( (c=receive()) != HAND_SHAKE) ;
			        return(1) ;
			   }
		  }
	  }
	  return(0) ;
}


//bOption 1 : only end,3 start and end, 2 only start, 0 no ent no start
//bNum the number of check address
RETCODE EXPORT emuSpaEntryStart(BYTE bOption,DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr)
{ 
int j ;
char c ;
int cntt = 0;
//unsigned long p,k;
     regOk=0;
	 FlushComm(portId,1);
	 FlushComm(portId,0);
	 //send(3);
	 //send(ESC);
	 spasend() ;
     send('E') ;
     send('N') ;
     send('T') ;
     send(' ');
     send(bOption + '0') ;
	 send(' ') ;          
	 if(1 == bOption) {
	 	send_adr(dwEnd) ;
		send(' ') ;
	 } else if (3 == bOption) {
	 	send_adr(dwStart) ;
		send(' ') ;
	 	send_adr(dwEnd) ;
		send(' ') ;
	 } else if (2 == bOption) {
	 	send_adr(dwStart);
		send(' ') ;
	 } 
	 
	 for(j=0;j<bNum;j++) {
        send_adr(pDwAddr[j]) ;
		send(' ') ;
     }
     send('\r') ;                         
     
     
//     for(p=0;p<40000;p++)for(k=0;k<400;k++);
     
    // char* buff = new char[8000];
     //int i=0;       
	 while ((c = receive())!= HAND_SHAKE) {
	 	if (c == '!') --cntt;
	 }	    
	            
	 if(cntt!=0) return -7 ;
	 //delete  buff;
     return 0;
 }                                  
 
int recv_entry(WORD* wCount)
{
	char c;
	int i=0, l, k;
	unsigned int j;
    WORD cc;
//    char    buff[100];
    char buff[100];

        for(i=0;i<4;i++) {
        	wCount[i] = 0;
        }
        i=0;
        
		while ((c = receive()) <=0 );
        if (c == HAND_SHAKE) {
                esc_clearx();
        	return(1) ;
        }     
        /*
        if (c == '\r' || c == '\n') {
        	while((c = receive()) != HAND_SHAKE);
        	return 2;
        }*/                                    
        
        while((c = receive()) <= 0);	
        j = c-'0' ;
        if (j > 4) {
            buff[0] = c;
            i = 1;
            while ((c=receive()) != HAND_SHAKE && i < 99) {
            	if(c<=0) continue;
            	buff[i++] = c;
            }	
            buff[i] = 0;
            if (strstr(buff, "halt") != NULL) {
               return(2) ;    
            }   
            send_ESC();
            if (Rtest()) {
            //if (emuSetReg(I68K_REG, REG_PC, content[0]) == ICE_MICE_HALT)
               return(2);     
            }
            return (3);
         }        
        //////////////////////
       /* 
        for(l=0;l<16;l++) {
        	buff[l] = receive();
        }                       
        buff[16] = 0; 
        AfxMessageBox(buff);
        return 0;
       */  
        for (l = 0; l < j ; l++) {
       	     wCount[l] = 0 ;
       	     for (k = 0; k <4;k++) {
             	while((c = receive()) <= 0);
                if (c <= '9')  cc = (c - '0') << ( (3-k)*4 );
	        else cc = ((c - 'A')+10) << ( (3-k)*4 );
		if (c > 'F')  { 
			while (receive() != HAND_SHAKE); 
			return(2) ;
		}
		wCount[l] += cc ;
	     }
	}       
	while (receive() != HAND_SHAKE); 
	return(0) ;
}
void esc_clearx()
{   
char c;
    send(ESC) ;
    
	while ((c=receive()) != HAND_SHAKE) ;
}
//return 0 : get ok; -2 terminal; -8 cpu halted             
RETCODE EXPORT emuGetEntry(WORD* wEntry)
{   
	int c;
	unsigned long j,k;
	send(0xd);      
//	for(j=0;j<40000;j++)for(k=0;k<1;k++);
	//receive entry
	if(c=recv_entry(wEntry)){
		if(c==1) return -2; //terminal
        else if (c == 2) {
            send_ESC() ;
            return -8;
		}
		send(ESC) ;
		while (receive()!= HAND_SHAKE) ;
		return(-100) ;
    }        
    
    return 0;
	
 }                                            

RETCODE EXPORT  emuTerminal() {
	FlushComm(portId,1);
	FlushComm(portId,0);

        esc_clearx();
    FlushComm(portId,1);
    FlushComm(portId,0);

	
	return 0;
} 

////////////////duration////////////////
//bOption 1 : only end,3 start and end
//bNum the number of check address
RETCODE EXPORT emuSpaDurStart(BYTE bOption,DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr)
{ 
int j ; 
int cntt = 0;
char c ;
//unsigned long p,k;
     regOk=0;
	 FlushComm(portId,1);
	 FlushComm(portId,0);
	 //send(3);
	 //send(ESC);
	 spasend() ;
     send('D') ;
     send('U') ;
     send('R') ;
     send(' ');
     send(bOption + '0') ;
	 send(' ') ;          
	 if(1 == bOption) {
	 	send_adr(dwEnd) ;
		send(' ') ;
	 } else if (3 == bOption) {
	 	send_adr(dwStart) ;
		send(' ') ;
	 	send_adr(dwEnd) ;
		send(' ') ;
	 } else if (2 ==bOption) {
	 	send_adr(dwStart) ;
		send(' ') ;
	 }
	 
	 for(j=0;j<bNum;j++) {
        send_adr(pDwAddr[j]) ;
		send(' ') ;
     }
     send('\r') ;                         
     
     
//     for(p=0;p<40000;p++)for(k=0;k<400;k++);
         // char* buff = new char[8000];
     //int i=0;       
	 while ((c = receive())!= HAND_SHAKE) {
	 	if (c == '!') --cntt;
	 }	                                  
	 
	            
	 if(cntt!=0) return -7 ;
	 //delete  buff;
     return 0;
 }  
                                 
int recv_dur(unsigned long* dwCount)
{
	char c;
	int i=0, l, k;
	unsigned int j;
	unsigned long cc;
    //char  buff[100];
    char buff[100];
    
    for(i=0;i<6;i++) {
    	dwCount[i] = 0;
    }
    i=0;
        
	while ((c = receive()) <=0 );
    if (c == HAND_SHAKE) {
        esc_clearx(); 
    	return(1) ;
    }     
    /*
    if (c == '\r' || c == '\n') {
    	while((c = receive()) != HAND_SHAKE);
    	return 2;
    }*/                                    
        
    while((c = receive()) <= 0);	
    j = c-'0' ;
    if (j > 6) {
        buff[0] = c;
        i = 1;
        while ((c=receive()) != HAND_SHAKE && i < 99) {
        	if(c<=0) continue;
        	buff[i++] = c;
        }	
        buff[i] = 0;
        if (strstr(buff, "halt") != NULL) {
           return(2);     
        }   
        send_ESC();
        if (Rtest()) {
//            if (emuSetReg(I68K_REG, REG_PC, content[0]) == ICE_MICE_HALT)
           return(2);     
        }
        return (3);
     }

	 for (l = 0; l < j ; ++l) {
	     dwCount[l] = 0 ;
		 cc = 0 ;
	     for (k = 0; k <8;++k) {
              while((c = receive()) <=0);
              if (c <= '9')  cc = (c - '0') ;
              else cc = ((c - 'A')+10) ;
			  dwCount[l] <<= 4 ;
			  dwCount[l] |= cc ;
			  cc = 0 ;
	     }
	 }                   
	while (receive() != HAND_SHAKE); 
	return(0) ;
}

//return 0 : get ok; -2 terminal; -8 cpu halted             
//wDur is an array has 6 element
RETCODE EXPORT emuGetDur(unsigned long* dwDur)
{   
	int c;
	unsigned long j,k;
	send(0xd);      
	//for(j=0;j<40000;j++)for(k=0;k<1;k++);
	//receive 
	if(c=recv_dur(dwDur)){
		if(c==1) return -2; //terminal
        else if (c == 2) {
            send_ESC() ;
            return -8;
		}
		send(ESC) ;
		while (receive()!= HAND_SHAKE) ;
		return(-100) ;
    }        
    
    return 0;
	
 }                                            

////////////////duration////////////////
//bOption 1 : only end,3 start and end
//bNum the number of check address
RETCODE EXPORT emuSpaTimeStart(BYTE bOption,DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr)
{ 
int j ;
char c ;
int cntt = 0;
//unsigned long p,k;
	 regOk=0;
	 FlushComm(portId,1);
	 FlushComm(portId,0);
	 //send(3);
	 //send(ESC);
	 spasend() ;
     send('T') ;
     send('I') ;
     send('M') ;
     send(' ');
     send(bOption + '0') ;
	 send(' ') ;          
	 if(1 == bOption) {
	 	send_adr(dwEnd) ;
		send(' ') ;
	 } else if (3 == bOption) {
	 	send_adr(dwStart) ;
		send(' ') ;
	 	send_adr(dwEnd) ;
		send(' ') ;
	 } else if (2 == bOption) {
	   send_adr(dwStart) ;
		send(' ') ;
	 }
	 
	 for(j=0;j<bNum;j++) {
        send_adr(pDwAddr[j]) ;
		send(' ') ;
     }
     send('\r') ;                         
     
     
//     for(p=0;p<40000;p++)for(k=0;k<400;k++);
     
    // char* buff = new char[8000];
     //int i=0;       
	 while ((c = receive())!= HAND_SHAKE) {
	 	if (c == '!') --cntt;
	 }	    
	            
	 if(cntt!=0) return -7 ;
	 //delete  buff;
     return 0;
 }  
                                 
int recv_time(WORD* wTime)
{
  char c ,c1; 
  int  i =0,j,l,k,c2;
  unsigned cc;
  int flag ;
  	 for(i=0;i<9;i++) {
    	wTime[i] = 0;
     }
     i=0;
    
	 while ((c2 = receive()) <= 0);
	 c = c2 ;
	 if (c == HAND_SHAKE) {
                esc_clearx();
	 	return(1) ;
	 }	
	 
	 flag = 1;
     for (l = 0; l < 9 ; ++l) {
         wTime[l] = 0 ;
         for (k = 0; k <4;++k) {
		    if (flag) flag = 0 ;
			else while((c = receive()) <=0) ;
            if (c <= '9')  cc = (c - '0') <<((3-k)*4) ;
            else cc = ((c - 'A')+10) <<((3-k)*4) ;
			/*if (c > 'F') return(2); */
            if (c > 'F')  {
               while (receive() != HAND_SHAKE) ;
               send_ESC();
               if (Rtest())
                  return(2) ;
               return (3);
            }
		    wTime[l] += cc ;
         }
	 } 
	while (receive() != HAND_SHAKE); 
	return(0) ;

}

//return 0 : get ok; -2 terminal; -8 cpu halted             
//wDur is an array has 6 element
RETCODE EXPORT emuGetTime(WORD* wTime)
{   
	int c;
	unsigned long j,k;
	send(0xd);      
	//for(j=0;j<40000;j++)for(k=0;k<1;k++);
	//receive 
	if(c=recv_time(wTime)){
		if(c==1) return -2; //terminal
        else if (c == 2) {
            send_ESC() ;
            return -8;
		}
		send(ESC) ;
		while (receive()!= HAND_SHAKE) ;
		return(-100) ;
    }        
    
    return 0;
	
 }                                            
//////////////////////coverage
void SendCommend(char *commend)
{
	int i, j, rec_char;

	for (i=0; i<strlen(commend); i++) {
		send(commend[i]);
	}
	send('\r');
 }          
void SpaCoverSetMemType(char *mem_type)
{
	char com[32];

	strcpy(com, "COV ");
	strcat(com, mem_type);
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

int SpaCoverSetRange(char * addr1,char *addr2)

{
    char com[32];
    char          ch, temp_str[80];
    int           i = 0;

    strcpy(com, "COV ");
    strcat(com, addr1);
    strcat(com, " ");
    strcat(com, addr2);
    SendCommend(com);
    while ((ch=receive()) != HAND_SHAKE) {
    //////////// added, 1994.11.09 //////////
    	if (ch<=0) continue;
        temp_str[i++] = ch;
        //if(i>60) AfxMessageBox("error!");
        if (ch == 0x0a) {
           temp_str[i++] = 0;
           if (strstr(strupr(temp_str), "ERROR") != NULL) {
              i = 0;
              while ((ch=receive()) != HAND_SHAKE)
                    temp_str[i++] = ch;
              temp_str[i] = 0;
              send_ESC();
              return(1);
           }
        }
    ////////////////////////////////////////
   }
   return(0);
}

int SetBreakPoint(char *addr)
{
    char    command[15];
    char    ch, temp_str[200];
    int     i = 0;

    strcpy(command, "EV 7 ");
    strcat(command, addr);
    SendCommend(command);

    while ((ch=receive()) != HAND_SHAKE && i < 199) {
    //////////// added, 1994.11.09 //////////
    	if(ch<=0) continue;
        temp_str[i++] = ch;
        if (ch == 0x0a) {
           temp_str[i] = 0;
           if (strstr(strupr(temp_str), "ERROR") != NULL) {
              i = 0;
              while ((ch=receive()) != HAND_SHAKE)
                    temp_str[i++] = ch;
              temp_str[i] = 0;
              send_ESC();
              return(1);
           }
        }
    ////////////////////////////////////////
    }
    return(0);
}

#define REC_BUF_ADD_BGN 6
 
//pDwAddr is the address range group 
//bNum = group*2
//RETURN 0 OK
//RETURN 1 ADDRESS ERROR
RETCODE EXPORT emuCoverageStart(DWORD dwStart,DWORD dwEnd,BYTE bNum,DWORD* pDwAddr,
				     BOOL isSP,BOOL isSD,BOOL isUP,BOOL isUD,BOOL isEnd)
{ 
    int i, j, ch, coverage_buf_count, clist_item_rowq, rec_count=0;
	char mem_type[15], command[32];
    unsigned char temp, ad_start[14], ad_end[14], clist_item[30], temp_str[80], sym_hex_conv[20], sym_hex_conv1[80];
    char addr1[20]; char addr2[20];
     regOk=0;    
	 FlushComm(portId,1);
	 FlushComm(portId,0);                                       

//    SaveEv7Old(EV7OldSetting);
    SendCommend("COV CLEAR");
    while (receive() != HAND_SHAKE);
    SendCommend("COV ENABLE");
    while (receive() != HAND_SHAKE);
	SendCommend("EV 7 CLEAR");
	while (receive() != HAND_SHAKE);
	mem_type[0] = '\0';
	
	if (isSP) strcat(mem_type, "SP ");
	if (isSD) strcat(mem_type, "SD ");
	if (isUP) strcat(mem_type, "UP ");
	if (isUD) strcat(mem_type, "UD ");
	 
	SpaCoverSetMemType(mem_type);
	for (i=0; i<bNum; i=i+2) {
		sprintf(addr1,"%lX",pDwAddr[i]);
		sprintf(addr2,"%lX",pDwAddr[i+1]);
		if(0!=SpaCoverSetRange(addr1,addr2)) return 1;
	}                                 
	
	sprintf(addr1,"%lX",dwEnd);
	if(isEnd)
		if(0!=SetBreakPoint(addr1)) return 1;
	
	command[0] = 0;
	strcpy(command, "GO ");
	sprintf(addr1,"%lX ",dwStart);
	strcat(command, addr1);
	SendCommend(command);
	
    return 0;
 }  

 
int DoCoverageusdCmd(BYTE* bNum,DWORD* dwRange,BYTE* per1,BYTE* per2)
{                                         
	int k,i, j, ch, coverage_buf_count, rec_count=0;
	int cover_addr_len,cover_num_of_block_access,data_in_cover_buf;
	char command[32];       
	unsigned cc;
    char ad_start[14], ad_end[14], clist_item[30], temp_str[80], sym_hex_conv[20], sym_hex_conv1[80];
    char coverage_buf[2050];
	int temp;                   
	FlushComm(portId,1);
	FlushComm(portId,0);
	SendCommend("COVERAGEUSD ");            
	/*
	k=0;
	do {
		temp = receive(); 
		if(temp>0) coverage_buf[k++] = temp;
	} while (temp != HAND_SHAKE);*/
	
	do {
		temp = receive();
	} while (temp != '\n');
	coverage_buf_count = 0;

	do {
		while((temp = receive())<=0);
		if ( ( (temp<=90) && (temp>=65) ) || ( (temp<=57) && (temp>=48) ) ) {
			coverage_buf[coverage_buf_count] = temp;
			coverage_buf_count++;
		}
		if (rec_count==2047) {
			send_ESC();
			break;
        }
	} while (temp != HAND_SHAKE);
	coverage_buf[coverage_buf_count] = 0;
        sscanf(coverage_buf,"%02x%02x%02x",per1,per2, &cover_addr_len);
        if(cover_addr_len == 0) MessageBox(0,"devide 0","fdas",2);
	cover_num_of_block_access = (coverage_buf_count - REC_BUF_ADD_BGN)/(cover_addr_len*2);
	if (cover_num_of_block_access == 0) data_in_cover_buf=0;
	else data_in_cover_buf=1;
	for (i=0, coverage_buf_count=REC_BUF_ADD_BGN; i<cover_num_of_block_access; i++) {
		for (j=0; j<cover_addr_len; j++) {
                        if(j>34) continue;
			ad_start[j] = coverage_buf[coverage_buf_count+j];
			ad_end[j] = coverage_buf[coverage_buf_count+j+cover_addr_len];
		}
		ad_start[j] = ad_end[j] = '\0';
		
         dwRange[i*2] = 0 ;
         for (k = 0; k <cover_addr_len;++k) {
            if ( ad_start[k] <= '9')  cc = (ad_start[k] - '0') <<(((cover_addr_len-1)-k)*4) ;
            else cc = ((ad_start[k] - 'A')+10) <<(((cover_addr_len-1)-k)*4) ;
		    dwRange[i*2] += cc ;
         }
		 
		 dwRange[i*2+1] = 0 ;
         for (k = 0; k <cover_addr_len;++k) {
            if ( ad_end[k] <= '9')  cc = (ad_end[k] - '0') <<(((cover_addr_len-1)-k)*4) ;
            else cc = ((ad_end[k] - 'A')+10) <<(((cover_addr_len-1)-k)*4) ;
		    dwRange[i*2+1] += cc ;
         }
         
		coverage_buf_count += 2*cover_addr_len;
	}
	
	*bNum = cover_num_of_block_access;
	//if(isHalt) return -2;
	return 1;
 }

//return 1 termianl
int recv_coverage(BOOL isAbout,BYTE* bNum,DWORD* dwRange,BYTE* per1,BYTE* per2) 
{                                                           
	int k,i, j, ch, coverage_buf_count, clist_item_rowq, rec_count=0;
	int cover_addr_len,cover_num_of_block_access,data_in_cover_buf;
	char command[32];                     
	BOOL isHalt;
	unsigned cc;
    char ad_start[14], ad_end[14], clist_item[30], temp_str[80], sym_hex_conv[20], sym_hex_conv1[80];
    char coverage_buf[2050];
    int temp;     
    
    *per1 = *per2  = 0;    
    
    if(isAbout) {
    	send_ESC();
    	return DoCoverageusdCmd(bNum,dwRange,per1,per2);
    }	
    
	temp = receive_nowait();
	if(temp <=0) return 5; 
	i=0;
	if(temp != HAND_SHAKE) {
		do {
			if(temp == -1) continue;
			temp_str[i++] = (unsigned char) temp;
		} while((temp=receive())!=0x0d  && temp != HAND_SHAKE);
	}	
	
	temp_str[i] = 0;  isHalt = FALSE;
	if ( (strstr(temp_str, "halt") != NULL) ||
	     (strstr(temp_str, "can't step") != NULL) ) {
             send(ESC);
             while (receive() != HAND_SHAKE);
             //DoCoverageusdCmd(coverage_buf);
             //isHalt = TRUE;
             return(2);
	} else if (strstr(strupr(temp_str), "ERROR") != NULL) {
           i = 0;
           while ((temp = receive()) != HAND_SHAKE)
              temp_str[i++] = temp;
           temp_str[i] = 0;
           send_ESC();
           //strcpy (temp_str, "Address Error! Press <ESC> to continue.");
           //ShowExecMess(temp_str);
           return(3);
    }
    if (temp == HAND_SHAKE)
		return DoCoverageusdCmd(bNum,dwRange,per1,per2);
		
	return 5;	
		
 }

//return  -2 terminal; -8 cpu halted; -5 no return; -100 error             
//dwRange is an array of range access
//the number of dwRange Arrays is 2*the bNum
//the bNum is the access range number,not array number
//isAbout : TRUE : USER ABOUT; FALSE continue trying receive;
//Please don't call emuTerminal();
RETCODE EXPORT emuGetCoverage(BOOL isAbout,BYTE* bNum,DWORD* dwRange,BYTE* per1,BYTE* per2)
{   
	int c;
	unsigned long j,k;
	
	//receive 
	if(c=recv_coverage(isAbout,bNum,dwRange,per1,per2)){
		if(c==5) return -5;
		if(c==1) return -2; //terminal
        else if (c == 2) {
            //send_ESC() ;
            return -8;
		}
		send(ESC) ;
		while (receive()!= HAND_SHAKE) ;
		
    }        
    
    return -100;
	
 }                                            



/**************************** End of File **********************************/

