/***************************************************************************
**
** File name : reg68k.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/25/1992 By Cheerson
**        0. Check "register operation"
**
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG68k_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#include "abiglbs.h"
#include "abifunc.h"

#define OK ICE_OK
#define CR 0xd
#define HAND_SHAKE 0x3
#define NULL 0
/**************************************************************************
**
** Local variables
**
***************************************************************************/
int RegMode;
int regStatus;

unsigned char   RegValid[REG_MAX];
unsigned char   flag_reg[11];
char regBuffer[512];

char *REG68K_TAB[]={
	"PC", "SSP", "SR",
	"A7","A6","A5","A4","A3","A2","A1","A0",
	"D7","D6","D5","D4","D3","D2","D1","D0",
	"USP","MSP","VBR","CACR","CAAR","SFC","DFC",
	"ISP","CACR","CAAR",
	"C","X","Z","N","V","S","M","T0","T1","SR"
};

U32 myCpuReg[26];

/* the array of registers is organized as follows:
    0   1   2   3   4   5   6   7   8   9  10  11  12
   d0, d1, d2, d3, d4, d5, d6, d7, a0, a1, a2, a3, a4

   13  14  15  16  17  18  19  20  21
   a5, a6, a7,usp,ssp,msp,isp, sr,vbr

   22  23  24  25  26  
   pc,sfc,dfc,cacr,caar

   followed by the flags. Flags are full size for speed.
   27  28  29  30  31  32  33  34  35  36
   c,  x,   z,  n,  v,  s,  m, t0, t1, sr
*/
/**************************************************************************
**
** Externals
**
**************************************************************************/

/**************************************************************************
**
** Execution codes
**
**************************************************************************/
//john 96.11 to convert MP cpu_id to MICE3 cpu_id

void RegIdConvert(S16* id) {
	switch (*id) {
		case 0:  *id = REG_PC;
			break;    
		case 1:  *id = REG_SSP;
			break;
		case 2:  *id = REG_SR;
			break;
		case 3:  *id = REG_A7;
			break;
		case 4:  *id = REG_A6;
			break;
		case 5:  *id = REG_A5;
			break;
		case 6:  *id = REG_A4;
			break;
		case 7:  *id = REG_A3;
			break;
		case 8:  *id = REG_A2;
			break;
		case 9:  *id = REG_A1;
			break;                                                                  
		case 10: *id = REG_A0;
			break;  
		case 11: *id = REG_D7;
			break;  
		case 12: *id = REG_D6;
			break;                  
		case 13: *id = REG_D5;
			break;          
		case 14: *id = REG_D4;
			break;          
		case 15: *id = REG_D3;
			break;          
		case 16: *id = REG_D2;
			break;
		case 17: *id = REG_D1;
			break;  
		case 18: *id = REG_D0;
			break;                  
		case 19: *id = REG_USP;
			break;                  
	}
}               

/**************************************************************************
**
** Name : iceGetAllReg()
**
** Function
**
**    Input  :
**
**    Output :
**                                         f
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetAllReg(U32 cpuRegGet[]) {
char *ptr, *ptr1, c;
int i;
    if(regOk == 0) {
		send('R');
		send_CR_wait(CR);
		ptr = tx_buf;
		ptr1=regBuffer;
		while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
		*ptr=NULL;
		*ptr1++ = CR;
	    i = regStatus = check_error(tx_buf);
		if (i != OK) {
			while(receive() != HAND_SHAKE);
			return(i);
		}
		ptr=tx_buf;
		while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
		*ptr=NULL;
		*ptr1++ = CR;
	    i = regStatus = check_error(tx_buf);
		if (i != OK) {
			while(receive() != HAND_SHAKE);
			return(i);
		}
		while ( strstr(tx_buf,"Dn") == NULL) {
			ptr=tx_buf;
			while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
			*ptr=NULL;
			*ptr1++ = CR;
		}
	    parseDreg(tx_buf);
		ptr=tx_buf;
		while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
		*ptr=NULL;
		*ptr1++ = CR;
		parseAreg(tx_buf);
		ptr=tx_buf;
		while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
		*ptr=NULL;
		*ptr1++ = CR;
		parseUSP(tx_buf);
		ptr=tx_buf;
		while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
		*ptr=NULL;
		*ptr1++ = CR;
		*ptr1 = NULL;
		parsePC(tx_buf);
		while (receive() != HAND_SHAKE);
	//Frank, 01/16/95
	    //GetAllFlags();
	    for (i = NUM_REGS; i--;) RegValid[i] = 1;
	    //memcpy(cpu_regs,cpuReg,2*NUM_REGS);  
	    //return ICE_OK
	regOk = 1;    
    }
    //john 96.11 to convert id

    cpuRegGet[R_PC] = cpuReg[REG_PC];
    cpuRegGet[R_A7] = cpuReg[REG_A7];
    cpuRegGet[R_A6] = cpuReg[REG_A6];
    cpuRegGet[R_D0] = cpuReg[REG_D0];
    cpuRegGet[R_D1] = cpuReg[REG_D1];
    cpuRegGet[R_D2] = cpuReg[REG_D2];
    cpuRegGet[R_D3] = cpuReg[REG_D3];
    cpuRegGet[R_D4] = cpuReg[REG_D4];
    cpuRegGet[R_D5] = cpuReg[REG_D5];
    cpuRegGet[R_D6] = cpuReg[REG_D6];
    cpuRegGet[R_D7] = cpuReg[REG_D7];
    cpuRegGet[R_A0] = cpuReg[REG_A0];
    cpuRegGet[R_A1] = cpuReg[REG_A1];
    cpuRegGet[R_A2] = cpuReg[REG_A2];
    cpuRegGet[R_A3] = cpuReg[REG_A3];
    cpuRegGet[R_A4] = cpuReg[REG_A4];
    cpuRegGet[R_A5] = cpuReg[REG_A5];
    cpuRegGet[R_SR] = cpuReg[REG_SR];
    
    cpuRegGet[R_USP] = cpuReg[REG_USP];              
    //ONLY FOR 302 68000
    cpuRegGet[R_SSP] = cpuReg[REG_SSP];
    //ONLY FOR 68020
    
    cpuRegGet[R_MSP] = cpuReg[REG_MSP];
    if(CPU68020_M3 == MICE || CPU68030_M3 == MICE)
	cpuRegGet[R_SSP] = cpuReg[REG_ISP];
    cpuRegGet[R_VBR] = cpuReg[REG_VBR];              
    
    cpuRegGet[R_CACR] = cpuReg[REG_CACR];
    cpuRegGet[R_CAAR] = cpuReg[REG_CAAR];
    cpuRegGet[R_SFC] = cpuReg[REG_SFC];              
    cpuRegGet[R_DFC] = cpuReg[REG_DFC];               
    
	return(regStatus=OK);
}
//john 96.11 this routine server for the old mice3 system
int GetAllRegMice3(U16 cpuReg[]) {
char *ptr, *ptr1, c;
int i;

	send('R');
	send_CR_wait(CR);
	ptr = tx_buf;
	ptr1=regBuffer;
	while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
	*ptr=NULL;
	*ptr1++ = CR;
    i = regStatus = check_error(tx_buf);
	if (i != OK) {
		while(receive() != HAND_SHAKE);
		return(i);
	}
	ptr=tx_buf;
	while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
	*ptr=NULL;
	*ptr1++ = CR;
    i = regStatus = check_error(tx_buf);
	if (i != OK) {
		while(receive() != HAND_SHAKE);
		return(i);
	}
	if (strstr(tx_buf,"Dn") == NULL) {
		ptr=tx_buf;
		while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
		*ptr=NULL;
		*ptr1++ = CR;
	}
    parseDreg(tx_buf);
	ptr=tx_buf;
	while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
	*ptr=NULL;
	*ptr1++ = CR;
	parseAreg(tx_buf);
	ptr=tx_buf;
	while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
	*ptr=NULL;
	*ptr1++ = CR;
	parseUSP(tx_buf);
	ptr=tx_buf;
	while((c=receive()) != CR) *ptr1++ = *ptr++ = c;
	*ptr=NULL;
	*ptr1++ = CR;
	*ptr1 = NULL;
	parsePC(tx_buf);
	while (receive() != HAND_SHAKE);
//Frank, 01/16/95
    GetAllFlags();
    for (i = NUM_REGS; i--;) RegValid[i] = 1;
    memcpy(cpu_regs,cpuReg,2*NUM_REGS);  
    //return ICE_OK
	return(regStatus=OK);
}


/**************************************************************************
**
** Name : iceGetReg (REG_MODE regMode, S16 regId,U32 *content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  OK
**
**************************************************************************/
RETCODE EXPORT iceGetReg(REG_MODE regMode, S16 regId,U32 *content) {
char c, *ptr, *dummy;
unsigned long l;
unsigned long rx_long();
char tmp[30];
    /*
	if (regId == -3) regId = REG_PC;
	else if (regId == -2) regId = REG_A7;
	else if (regId == -1) regId = REG_A6;
	if (regId < 30 && RegValid[regId]) {
		*content = cpuReg[regId];
		return(OK);
	}*/
	/*
	if (regId == REG_A7) {
	if (!(cpuReg[REG_SR] & 0x2000)) cpuReg[REG_A7] = cpuReg[REG_USP];
		else if ((MICE ==  CPU68020_M3 || MICE == CPU68030_M3)
			  && (cpuReg[REG_SR] & 0x1000)) 
			cpuReg[REG_A7] = cpuReg[REG_MSP];
		else cpuReg[REG_A7] = cpuReg[REG_SSP];
		RegValid[REG_A7]=1;
		*content = cpuReg[regId];
		return(OK);
	}*/       
	if( (MICE == CPU68020_M3 || MICE == CPU68030_M3) && regId == R_SSP) {
		regId = REG_ISP;
	}
	
	if(regOk == 0) {    
		send('R');
		send(' ');         
		
		sprintf(tmp,"%04d",regId);
		ptr=REG68K_TAB[regId];
		
		if (regId == REG_T0 && MICE != CPU68020_M3 && MICE != CPU68030_M3) send('T');
		else {           
			while (c = *ptr++) send(c);
		}
		send_CR_wait(CR);                
		ptr = tx_buf;
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
		*ptr = NULL;
		if(strstr(tx_buf,"halted")) return ICE_BAD_REG;
		sscanf(tx_buf," %s %lx", &dummy, &l);
		send_ESC();
		if (MICE != CPU68020_M3 && MICE != CPU68030_M3 && regId == REG_PC)
			l &= 0xffffff;
		RegValid[regId]=1;
		if (regId == REG_I) l=(l & 0x700) >> 8;
		cpuReg[regId] = l;
		
	}       
	*content = cpuReg[regId];
	return ICE_OK;
}                 /* end of GetReg (regId) */                     

/**************************************************************************
**
** Name : iceSetCoReg(reg_id,content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetCoReg(S16 coRegId,U8 *content)
{
}                 /* end of SetReg(regMode,reg_id,content) */

/**************************************************************************
**
** Name : SetReg(regmode,reg_id,content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceSetReg(REG_MODE regMode, S16 regId,U32 content) {
char *ptr, c;
unsigned long l;
int A7_flag;
int i;  
	

	A7_flag=0;
	if (regId == -3) regId = REG_PC;
	else if (regId == -2) regId = REG_A7;
	else if (regId == -1) regId = REG_A6;
	
	/*
	if( regId == REG_A7 ) {
	if (!(cpuReg[REG_SR] & 0x2000)) regId = REG_USP; 
		else if ((MICE == CPU68020_M3 || MICE == CPU68030_M3) &&
				 (cpuReg[REG_SR] & 0x1000)) 
			regId = REG_MSP;
		else {
			if (MICE == CPU68020_M3 || MICE == CPU68030_M3) regId = REG_ISP;
			else regId = REG_SSP;
		}
		cpuReg[REG_A7]=content;
		RegValid[REG_A7]=1;
		A7_flag=1;
    }*/                                      
   if( (MICE == CPU68020_M3 || MICE == CPU68030_M3) && regId == R_SSP) {
	regId = REG_ISP;
   }
	ptr=REG68K_TAB[regId];
	if (!*ptr) return(OK);  
	if (regId >= REG_C && regId < REG_I)  RegValid[REG_SR]=0;
	if (regId == REG_I) {
		RegValid[REG_SR]=0;
		iceGetReg(I68K_REG,REG_SR,&l);
		l &= 0xf8ff;
		content=((content & 0x7) << 8) | l ;
	}
	send('R');
	send(' ');
	if (regId == REG_T0 && MICE != CPU68020_M3 && MICE != CPU68030_M3) send('T');
	else while (c = *ptr++) send(c);
	send(CR);
	ptr = tx_buf;
	while((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i != OK) return(i);
	RegMode = 1;
	send_long(content);
	RegMode = 0;
	send(CR);
	while (receive() != HAND_SHAKE); 
	send_ESC();
	if (regId >= REG_C && regId <= REG_I) flag_reg[regId - REG_C]=content;
	else 
		cpuReg[regId]=content;
	RegValid[regId]=1;
//      if (regId == REG_SR || regId == REG_M || regId == REG_S || A7_flag
//          || regId == REG_SFC || regId == REG_DFC) 
//              emuGetAllReg();
//      if (regId == REG_VBR && noRAM && MICE == CPU68010_M3)
//              restore_EV5();
	return(OK);
}                 /* end of SetReg(regMode,regId,content) */


parseDreg(buffer)
unsigned char *buffer;
{
char *line1_682="Dn   %lX %lX %lX %lX %lX %lX %lX %lX";/* 32-68020 */
char *line1_68K="Dn  %lX %lX %lX %lX %lX F%lX %lX %lX";/* 16-68k/10 */
	if (MICE == CPU68020_M3 || MICE == CPU68030_M3)
		sscanf(buffer,line1_682,&cpuReg[REG_D0],&cpuReg[REG_D1],&cpuReg[REG_D2],
			&cpuReg[REG_D3],&cpuReg[REG_D4],&cpuReg[REG_D5],&cpuReg[REG_D6],&cpuReg[REG_D7]);
	else  
		sscanf(buffer,line1_68K,&cpuReg[REG_D0],&cpuReg[REG_D1],&cpuReg[REG_D2],
			&cpuReg[REG_D3],&cpuReg[REG_D4],&cpuReg[REG_D5],&cpuReg[REG_D6],&cpuReg[REG_D7]);
}

parseAreg(buffer)
unsigned char *buffer;
{
char *line2_682="An   %lX %lX %lX %lX %lX %lX %lX %lX";/* 32-68020 */
char *line2_68K="An  %lX %lX %lX %lX %lX %lX %lX %lX";/*16-68k/10 */
	if (MICE == CPU68020_M3 || MICE == CPU68030_M3)
		sscanf(buffer,line2_682,&cpuReg[REG_A0],&cpuReg[REG_A1],&cpuReg[REG_A2],
			&cpuReg[REG_A3],&cpuReg[REG_A4],&cpuReg[REG_A5],&cpuReg[REG_A6],&cpuReg[REG_A7]);
	else 
		sscanf(buffer,line2_68K,&cpuReg[REG_A0],&cpuReg[REG_A1],&cpuReg[REG_A2],
			&cpuReg[REG_A3],&cpuReg[REG_A4],&cpuReg[REG_A5],&cpuReg[REG_A6],&cpuReg[REG_A7]);
}

parseUSP(buffer)
unsigned char *buffer;
{
char *line3_682="USP= %lX MSP= %lX ISP=%lX VBR=%lX"; /* 32-68020 */
char *line3_68K="SSP=%lX USP=%lX"; /* 16-68k/10 */
	if (MICE == CPU68020_M3 || MICE == CPU68030_M3)
		sscanf(buffer,line3_682,&cpuReg[REG_USP],&cpuReg[REG_MSP],
							&cpuReg[REG_ISP],&cpuReg[REG_VBR]);
	else 
		sscanf(buffer,line3_68K,&cpuReg[REG_SSP],&cpuReg[REG_USP]);
}

parsePC(buffer)
unsigned char *buffer;
{
char *line4_682="PC= %lX CACR=%lX CAAR=%lX SFC=%X  DFC=%X  %X";/* 68020 */
char *line4_681="PC=%lX VBR=%lX SFC=%X DFC=%X      %X ";/* 16-68010 */
char *line4_68K="PC=%lX                               %lX ";/* 16-68k */
	if (MICE == CPU68020_M3 || MICE == CPU68030_M3)
		sscanf(buffer,line4_682,&cpuReg[REG_PC],&cpuReg[REG_CACR],&cpuReg[REG_CAAR],
			&cpuReg[REG_SFC],&cpuReg[REG_DFC],&cpuReg[REG_SR]);
	else if (MICE == CPU68010_M3)
		sscanf(buffer,line4_681,&cpuReg[REG_PC],&cpuReg[REG_VBR],&cpuReg[REG_SFC],
			&cpuReg[REG_DFC],&cpuReg[REG_SR]);
	else
		sscanf(buffer,line4_68K,&cpuReg[REG_PC],&cpuReg[REG_SR]);
}

/**************************************************************************
**
** Name : GetAllFlags()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  Coded by Frank, 01/17/95
**
**************************************************************************/
GetAllFlags()
{
unsigned int i;

   i = cpuReg[REG_SR];

//User part
   cpuReg[REG_C] = (i & 0x01) && 1;
   cpuReg[REG_V] = (i & 0x02) && 1;
   cpuReg[REG_Z] = (i & 0x04) && 1;
   cpuReg[REG_N] = (i & 0x08) && 1;
   cpuReg[REG_X] = (i & 0x10) && 1;

//System part
   cpuReg[REG_I] = ((i & 0x0700) >> 8);
   cpuReg[REG_S] =  (i & 0x2000) && 1;
   cpuReg[REG_T1] = (i & 0x8000) && 1;

   if (MICE == CPU68020_M3 || MICE == CPU68030_M3) {
      cpuReg[REG_M] =  (i & 0x1000) && 1;
      cpuReg[REG_T0] = (i & 0x4000) && 1;
   }
}


/**************************** End of File **********************************/
