#ifndef _REG68K_DEFINE_
#define _REG68K_DEFINE_
#define _REG68306_DEFINE_

typedef enum {
   R_PC,R_SSP,R_SR,
   R_A7,R_A6,R_A5,R_A4,R_A3,R_A2,R_A1,R_A0,
   R_D7,R_D6,R_D5,R_D4,R_D3,R_D2,R_D1,R_D0,
   R_USP,R_MSP,R_VBR,R_CACR,R_CAAR,R_SFC,R_DFC,
   MAX_CPU_REG_NUM
}CPU_REG;


typedef enum{
   R_HCS0C = 0XC0, R_LCS0C = 0XC2,  // 2 BYTES
   R_HCS1C = 0XC4, R_LCS1C = 0XC6,
   R_HCS2C = 0XC8, R_LCS2C = 0XCA,
   R_HCS3C = 0XCC, R_LCS3C = 0XCE,
   R_HCS4C = 0XD0, R_LCS4C = 0XD2,
   R_HCS5C = 0XD4, R_LCS5C = 0XD6,
   R_HCS6C = 0XD8, R_LCS6C = 0XDA,
   R_HCS7C = 0XDC, R_LCS7C = 0XDE,
   R_HDB0C = 0XE0, R_LDB0C = 0XE2,
   R_HDB1C = 0XE4, R_LDB1C = 0XE6,

   R_PDA   = 0XF0, R_PBA   = 0XF1,  // 1 BYTE
   R_PADD  = 0XF2, R_PBSS  = 0XF3,
   R_PAPA  = 0XF4, R_PBPA  = 0XF5,

   R_ISR   = 0XF8, R_ICR   = 0XFA,  // 2 BYTES

   R_RR    = 0XFC, R_WP    = 0XFD,  // 1 BYTE
   R_SYS   = 0XFE, R_TV    = 0XFF,
   MAX_INTERNAL_REG_NO
}M306_INTERNAL_REG;
typedef enum {
   I68K_REG,       
   I6881_REG,       
   INTERNAL_REG, M68K_REG
} REG_MODE;
#define REG_D0           18      /* Dn = D0 + n */
#define REG_D1           17
#define REG_D2           16
#define REG_D3           15
#define REG_D4           14
#define REG_D5           13
#define REG_D6           12
#define REG_D7           11

#define REG_A0          10
#define REG_A1          9
#define REG_A2          8
#define REG_A3          7
#define REG_A4          6
#define REG_A5          5
#define REG_A6          4
#define REG_FP          40              /* Frame Pointer = A6 */
#define REG_A7          3

#define REG_SP          REG_A7

#define REG_USP         19      /* copy of A7 when last left user mode */
#define REG_SSP         1      /* equivalent to REG_ISP */
#define REG_MSP         20      /* copy ofF A7 when last left master mode */
#define REG_ISP         26      /* copy of A7 when last left interrupt mode */
#define REG_SR          2      /* Status Register.  reg[REG_SR] is unused; */
				/* -- the actual SR is made up of flags */
#define REG_VBR         21      /* Vector Base Register */
#define REG_PC          0      /* used by "decode" and XRAYINT_step_inst */
#define REG_SFC         24      /* Alternate function code register */
#define REG_DFC         25      /* Alternate function code register */
#define REG_CACR        22      /* Cache Control Register */
#define REG_CAAR        23      /* CAche Addrees Register */

#define REG_C                   30
#define REG_X                   31
#define REG_Z                   32
#define REG_N                   33
#define REG_V                   34
#define REG_S                   35
#define REG_M                   36
#define REG_T0                  37
#define REG_T1                  38
#define REG_I                   39


#define LAST_REG        26
#define REG_MAX    REG_I+1      /* For range checking */
#define NUM_REGS   REG_MAX   /* size of U16 cpu_regs[] array, for cpu register */

extern unsigned long reg[REG_MAX];   /* all actual registers */
#endif
