/***************************************************************************
**
** File name : sdabidef.h
**
**      Description: definitions of variables and constants
**
**
** Changing :
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#define _SD_ABI_DEF_

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

typedef enum {COLD_START,NORMAL_STATUS,DIAGNOSTIC_STATUS} FW_STATUS;
/*****************************************************************************/
/* Return codes for ABI     */
/*****************************************************************************/
#ifndef OK
#define OK                   ICE_OK                     // Normal return
#endif

#define MICE_HALT            ICE_MICE_HALT              // Target CPU halted
#define MEM_GUARD            ICE_MEM_GUARD              // Access the guarded memory
#define MEM_PROTECT          ICE_MEM_PROTECT            // Access the protected memory
#define ERROR_READ           ICE_ERROR_READ             // Memory read failure
#define ERROR_WRITE          ICE_ERROR_WRITE            // Memory write failure
#define STEP_ERROR           ICE_STEP_ERROR             // Target cnnot step
#define NO_DIFF              ICE_NO_DIFF                // No difference in memory compare
#define NO_FOUND             ICE_NO_FOUND               // Not found in memory search
#define BREAK                ICE_BREAK                  // Break on memory access
#define BREAK_I              ICE_BREAK_I                // Break on instruction fetch
#define BAD_REG              ICE_BAD_REG                // Bad register number encountered
#define BAD_IN               ICE_BAD_IN                 // Error encountered on user input
#define HALT_USER            ICE_HALT_USER              // user pressed ^C
#define ERROR_COM            ICE_ERROR_COM              // communication error
#define ERROR_MICE           ICE_ERROR_MICE             // linking incorrect MICE model
#define MICE_LIMIT           ICE_MICE_LIMIT             // MICE limitation
#define BUS_REQUEST          ICE_BUS_REQUEST            // Bus request
#define BAD_FRAME            ICE_BAD_FRAME              // invalid frame number
#define ERROR_BOUN           ICE_ERROR_BOUN             // error map boundary
#define MAP_FAIL             ICE_MAP_FAIL               // memory map fail
#define ABS_OVERFLOW         ICE_ABS_OVERFLOW           // abs address overflow
#define TEST_FAIL            ICE_TEST_FAIL              // test failure
#define CPU_RUN              ICE_CPU_RUN                // CPU free running
#define BROKE                ICE_BROKE                  // CPU stop
#define NOT_READY            ICE_NOT_READY              // target is not ready
#define COMMAND_ERROR        ICE_COMMAND_ERROR          //
#define TIME_OUT             ICE_TIME_OUT               //
#define NO_TRACE_MODULE      ICE_NO_TRACE_MODULE        //
#define BKPT1_HALT           ICE_BKPT1_HALT             //
#define BKPT2_HALT           ICE_BKPT2_HALT             //
#define VIOL_HALT            ICE_VIOL_HALT              //
#define RBW_HALT             ICE_RBW_HALT               //
#define TRIG_HALT            ICE_TRIG_HALT              //
#define LINK_MICE_FAIL       ICE_LINK_MICE_FAIL         //
#define WARN_START           ICE_WARN_START             //
#define BANK_FULL            ICE_BANK_FULL              //
#define ADDR_RANGE_OVERFLOW  ICE_ADDR_RANGE_OVERFLOW    //
#define ATTRIBUTE_MISMATCH   ICE_ATTRIBUTE_MISMATCH     //
#define BANK_MISMATCH        ICE_BANK_MISMATCH          //
#define SPACE_MISMATCH       ICE_SPACE_MISMATCH         //
#define ADDR_MISMATCH        ICE_ADDR_MISMATCH          //
#define NO_VCC               ICE_NO_VCC                 // No target VCC
#define USER_CC              ICE_USER_CC                //
#define TARGET_RESET         ICE_TARGET_RESET           //
#define NO_EMM               ICE_NO_EMM                 //
#define CNT_ERROR            ICE_CNT_ERROR              //
#define TIMER_ERROR          ICE_TIMER_ERROR            //
#define EVENT_FULL           ICE_EVENT_FULL             //
#define BUFFER_EMPTY         ICE_BUFFER_EMPTY           //
#define EMM_SET_ERROR        ICE_EMM_SET_ERROR          //
#define EP_PENDING           ICE_EP_PENDING             //
#define REC_TIME_OUT         ICE_REC_TIME_OUT           //
#define INVALID_CPU          ICE_INVALID_CPU            // only usd at sw.
#define MCE16A_FAIL          ICE_MCE16A_FAIL
#define EMM_FAIL             ICE_EMM_FAIL
#define TRACE_BOARD_FAIL     ICE_TRACE_BOARD_FAIL
#define COV_RBW_FAIL         ICE_COV_RBW_FAIL
#define CPU_FLY              ICE_CPU_FLY
#define INVALID_FLY_COMMAND  ICE_INVALID_FLY_COMMAND
#define INVALID_FIRMWARE     ICE_INVALID_FIRMWARE       // only usd at sw.
/******************************* EOF *******************************/
