
/***************************************************************************
**
** File name : sub68k.c
**
**
**
** Changing :
**
** A. Date -- 10/22/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**

**    Include files
**
***************************************************************************/

#include <conio.h>
#include <time.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _SD_ABI_DEF_   
#include "sdabidef.h"
#endif

#ifndef _REG68K_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_GLOBAL_
#include "abiglbs.h"
#endif


#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _TYPE_DEFINE_
#include "typedef.h"
#endif

/****************************************************************
** globle variable
************************************************************/
U16 frameStart;
U16 frameEnd;
U16 signals;/* INT0 - INT3, DRQ0, DRQ1, HOLD, NMI, RESET, PEREQ, ERROR */
U8  traceMode;
U16 noUse = 0;  /* need add CONST to the header */
U8 noUseByte = 0;
U16 *diff;

U32 cpuReg[NUM_REGS];

U32  cpu_regs[NUM_REGS+1]; /* array of regs */
U16  cpu_flags;      /* CPU flags */
U32 ret_addr1 ,ret_addr2;
U32 memFailAddress;
U32 timerRecord;
U16  counter[2];
U8 tx_buf[1024];
U8 tx_buf2[1024];
S8 newVect[]={0,0,3,0xfc};
U32 VectAdr=0x3fc;
U8 IRET[2]={0x4e,0x73};
U8 IRET2[4]={0x60,0xfe, 0x4e, 0x73};
U32 Toffset = 0x10;
U8 Tcode1=0x4a, Tcode2=0xfc;
U16 Tcode=0x4afc;
S16 break_id, binFlag, INT_CTRL;
S16 MICE;
S16 noLoad, VNFlag, noRAM=0;
S16 LAM2;
S16 HEMM;
S16 downLoadMode=0;
S16 sizeFlag;
S16 ESC_flag;
S16 errorCode;
int breakReason;
//U32 bankSize;
U8 mapArray[256];
S16 bufNO = 1;
S16 curBuf = 1;
U16 ext_record;
S16 bufSeg = 0;
U8 cntFlag; // 4 : timer, 2 : counter1, 1 : counter0
S16 lastBuff;
S16 curCNT0;
S16 curCNT1;
char clr_cmd[]="E   CL"; 
U32 maskAddr;             
int verifyFlag;
SW_BREAK SwBreak[257];
long tick_deadline;
int breakNumber = 0;
U32 tick_count = 0;
//TRACE_DATA trace_frame;
TRACE_DATA trace_buf[2048] ,trace_frame;


MAP_INFO mapData[mapNo];

TRIGGER trig_record[8];

LEVEL   level_record[8];
char level_str[8][100];

BUS_EVENT event_record[8];
char event_str[8][100];

EXEC_EVENT bp_record[3];
char bp_str[3][20];

MV_TRIGGER trigger_record[2];
char trigger_str[200];

QUALIFY qualify_record[2];
char qualify_str[2][100];

BUFFER_DEPTH traceDepth[256];

//MAP_SET map_set[64];

U8 ID_Info[6];
/* [0]=cpu type, [1]=FW version, [2]-[4]=HW1 - HW3 version */ 
char HWinfo[64];
char cov_cmd[]="COVERAGE";
char event_cmd[]="E   ";
char hex[]="0123456789ABCDEF";
char bno[256];
int reloadFlag;
char *signal_name[]={"BERR","INTR","BR","CDIS","MMUDIS","CBACK"};
char existTraceBoard;
unsigned long IO_COUNT = 50000;
int down_ESC_send = 0;
unsigned long reg[REG_MAX];
S16 ESC_flag;
U32 bankMargin;

U16 portAddr, portStatus;
//john 96.11
//define for communication  1 PCE; 2 SERIAL
U16 portType; 
//97.2
int logFlag = TRUE;               
FILE* log_fid =0;  
int log_count = 0;
char log_buf[2058];  
//97.3
U8 regOk = 0;
void writeLog(char c)
{                  
	if(0 == log_fid) return;
	log_buf[log_count++]=c;
	if (log_count == 2048) {
		fwrite(log_buf,1,2048,log_fid);
		log_count = 0;  
		
	}

 }                 
RETCODE EXPORT closeLog(int x)
{ 
	if(0 == log_fid) return;
	fwrite(log_buf,1,log_count,log_fid);
	log_count = 0;  
	fclose(log_fid);
	return GOOD;
 } 
/**************************************************************************
**
** Local define
**
***************************************************************************/

/*#define inportb(a)           inp(a)
#define outportb(a,b)        outp(a,b)*/
#define HighByte(x)          ((U8)((U16)(x) >> 8))
#define LowByte(x)           ((U8)(x))

#define   RV_RDY         1   /* status of receive ready is 00000001 */
#define   SD_RDY         2   /* status of send ready is    00000010 */
#define HAND_SHAKE 0x3
/*#define NULL 0*/
#define CR 0xd                        

extern int portId;
extern COMSTAT commStat;

/**************************************************************************
**
** Local define
**
***************************************************************************/
#define InPortB(a)           inp(a)
#define OutPortB(a,b)        outp(a,b)
/**************************************************************************
**
** Local variables
**
***************************************************************************/

#define IO_LOOP   10      // 20 to 10;
long    baud_tbl[11] = {110, 150, 300, 600, 1200, 2400, 4800, 9600, 19200,
			 38400, 57600};
#define COM_IBM 2
/**************************************************************************
**
** Externals
**
**************************************************************************/
extern int targetCPU, fwVersion;
extern int RS232_COM;
extern int baud;
extern char linkChar;
int ESCflag = 0; 
int AbortTarget;
/**************************************************************************
**
** Execution codes
**
**************************************************************************/
extern U16 P_DATA, P_STATUS;
/**************************************************************************
**
** Name : receiveB()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
int receiveB() {
int rxData;
U16 i;
   for ( i = 0; i < IO_LOOP; i++ ) {
      rxData = upRX_DATA();
      if (rxData > 0) return(rxData);
   }
   return(-1);
} /* end of receiveB() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceSetAccessSize(U16 sizeFlag) {
	send_str2("SI ");
	switch (sizeFlag) {
	case 1: send('B');
			break;
	case 2: send('W');
			break;
	case 4: send('L');
			break;
	}
	send_CR_wait(HAND_SHAKE);
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceGetAccessSize(U16 *sizeFlag) {
	char c, *ptr;
	send_str2("SI");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf, "Long") != NULL) *sizeFlag=4;
	else if (strstr(tx_buf, "Word") != NULL) *sizeFlag=2;
	else *sizeFlag=1;
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceSetReady(U16 readyFlag) {
	send_str2("REA ");
	if (readyFlag == 1) send('E'); else send('I');
	send_CR_wait(HAND_SHAKE);
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceGetReady(U16 *readyFlag) {
char c, *ptr;
	*readyFlag = 0;
	send_str2("REA");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf, "externally") != NULL) *readyFlag=1;
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
/*
RETCODE EXPORT iceSetControl(U16 signals) {
int i, j;
U16 mask;
	if (MICE == CPU68020_M3 ){mask=0xf;  j=4;}
	else if( MICE == CPU68030_M3){mask=0x3f; j = 6 ;}
	else { j = 3;mask=0x7;}
	
	if (!signals) send_str("CON DIS");
	else if ((signals& mask) == mask) send_str("CON EN");
	else {
	send_str2("CON ");

   for (i=0;i<j;i++) {
     //if (i == 1) continue;
     if (signals & (1<<i)) {
	send_str2(signal_name[i]);
	send(' ');
     }
   }
	send('E');
	send_CR_wait(HAND_SHAKE);
	send_str2("CON ");
	for (i=0;i<j;i++) {
	if (!(signals&(1<<i))) {
	   send_str2(signal_name[i]);
	   send(' ');
	}
     }
     send('D');
     send_CR_wait(HAND_SHAKE);
   }             
   return ICE_OK;
}
*/
RETCODE EXPORT iceSetControl(U16 id, U16 signals) {
int i, j;
U16 mask;
	if (MICE == CPU68020_M3 ){mask=0xf;  j=4;}
	else if( MICE == CPU68030_M3){mask=0x3f; j = 6 ;}
	else { j = 3;mask=0x7;}
	if(id==0xffff) send_str("CON DIS");
	else if(id==0xeeee) send_str("CON EN");
	else {
	   send_str2("CON ");
	   send_str2(signal_name[id]);
	   send(' ');
	  if (signals ) 
	  {
	     send('E');
	     send_CR_wait(HAND_SHAKE);
	  }
	  else 
	  {   
	     send('D');
	     send_CR_wait(HAND_SHAKE);
	  }
      }          
   return ICE_OK;

}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceGetControl(U16 *signals) {
char *ptr, c;
	*signals = 0x7ff;
	send_str2("CON");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != CR) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf,"disabled") != NULL) {
		while (receive() != HAND_SHAKE);
		*signals = 0;
	} else {
		ptr = tx_buf;
		while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	    *ptr = NULL;
			strupr(tx_buf);
		if (strstr(tx_buf,"BERR") != NULL) *signals &= 0xfffe;
		if (strstr(tx_buf,"INTR") != NULL) *signals &= 0xfffd;
		if (strstr(tx_buf,"BR") != NULL) *signals &= 0xfffb;
		if (strstr(tx_buf,"CDIS") != NULL) *signals &= 0xfff7;
		if (strstr(tx_buf,"MMUDIS") != NULL) *signals &= 0xffef;
		if (strstr(tx_buf,"CBACK") != NULL) *signals &= 0xffdf;

	}
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceSetSync(U16 syncFlag) {
	if (syncFlag&2) send_str("SYN OU  O");else send_str("SYN OU OFF");
	if (syncFlag&1) send_str("SYN IN  O");else send_str("SYN IN OFF");
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output : ok
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetSync(U16 *sync) {
char c, *ptr;
	*sync=0;
	send_str2("SY");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != CR) *ptr++ = c;
	*ptr = NULL;
	strupr(tx_buf);
	if (strstr(tx_buf,"ON") != NULL) *sync = 1;
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	strupr(tx_buf);
	if (strstr(tx_buf,"ON") != NULL) *sync = *sync | 2;
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceSetVerify(U16 verifyFlag) {
	if (verifyFlag) send_str("V O");
	else send_str("V OF");
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceGetVerify(U16 *verifyFlag) {
char c, *ptr;
	send('V');
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
    *ptr = NULL;
	strupr(tx_buf);
	if (strstr(tx_buf, "OFF") != NULL) *verifyFlag = 0;
	else *verifyFlag = 1;
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: OK
**
**************************************************************************/
RETCODE EXPORT iceSetWait(U16 count) {
	send_str2("WA ");
	if (MICE == CPU68020_M3 || MICE == CPU68030_M3) send(hex[count]);
	else {
		if (count) send_str2("ON");
		else send_str2("OFF");
	}
	send_CR_wait(HAND_SHAKE);
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/
RETCODE EXPORT iceGetWait(U16 *count) {
	char c, *ptr;
	send_str2("WA");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	ptr = tx_buf;
	while (*ptr++ != '(');
	sscanf(ptr, "%x", &c);
	*count = c;   
	return ICE_OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: ok
**
**************************************************************************/

RETCODE EXPORT iceGetID(U8 *ID_Info) {
	char *ptr, c;
	int v1, v2;
	long cpu;
	send_str2("ID");
	send_CR_wait(CR); /* send CR and skip first line */
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++=c;
	*--ptr=0;
	strcpy(HWinfo,tx_buf);

	if (strstr(tx_buf, "68302") != NULL) {
		ID_Info[0] = CPU68302_M3;
		//env.Mmodel = 32; /// added, 1994.11.01
		//if (strstr(tx_buf, "68008") != NULL) bitMode8 = 1;
		//else bitMode8 = 0;
    }
    else if (strstr(tx_buf, "68010") != NULL) {
		ID_Info[0] = CPU68010_M3;
		//env.Mmodel = 32;
    }
    else if (strstr(tx_buf, "68020") != NULL) {
		ID_Info[0] = CPU68020_M3;
		//env.Mmodel = 35;
    }
    else if (strstr(tx_buf, "68030") != NULL) {
		ID_Info[0] = CPU68030_M3;
		//env.Mmodel = 35;
    }
    else if (strstr(tx_buf, "68000") != NULL) {
		ID_Info[0] = CPU68000_M3;
		//env.Mmodel = 32;
		//if (strstr(tx_buf, "8-bit") != NULL) bitMode8 = 1;
		//else bitMode8 = 0;
    }
    else return(ERROR_MICE);

	ptr = tx_buf;
	while (*ptr++ != 'V');
	sscanf(ptr,"%x.%x", &v1,&v2);
	ID_Info[2] = (v1<<4) + v2;
    
    MICE = ID_Info[0];
    return ICE_OK;

}

RETCODE EXPORT iceGetHWinfo(char *szInfo) {
	char *ptr, c;
	int i=0;
	ptr=szInfo;
	
       while( HWinfo[i]!= '\n'&& HWinfo[i]!='\r' && HWinfo[i]!=0)
       {   
	  if( HWinfo[i]!='*' )  *ptr++=HWinfo[i];
	  i++;
       }
       *ptr=0;
       return ICE_OK;
}



set_EV5()
{
     event_cmd[2]='5';
     send_str2(event_cmd);
     send_long(VectAdr);
     send_CR_wait(HAND_SHAKE);
}

SetVectMem(addr, buffer, i, space)
unsigned long addr;
unsigned char *buffer;
int i, space;
{
int j;
char c;
	send('W');
	send(' ');
	if (MICE == CPU68030_M3) send_str2("P ");
	send('S');
	if (space) send('P'); else send('D');
	send(' ');
	send_long(addr);
	for (j=0;j < i;j += 2) {
		send(' ');
		send_byte(*buffer++);
		send_byte(*buffer++);
	}       
	send(CR);
	for (;;) {
		c=receive();
		if (c == 't') {
			while (receive() != HAND_SHAKE);
			noRAM=1;
			return; /* to resume MICE from DTACK */
		}
		if (c == HAND_SHAKE) {
			noRAM=0;
			return;
		}
	}
}

int check_error(buffIn)
char *buffIn;
{
char *ptr;    
char buff[250];
char buff2[250];
   strcpy(buff,buffIn);
	strupr(buff);
	strcpy(buff2,buffIn);
	strlwr(buff2);
	
	if (strstr(buff2,"error") !=NULL) return (ICE_SYNTAX_ERROR);
	if (strstr(buff, "ERROR") != NULL) return(ICE_SYNTAX_ERROR);
	if (strstr(buff, "HALTED") != NULL) return(ICE_MICE_HALT);
	if (strstr(buff, "GUARD") != NULL) return(ICE_MEM_GUARD);
	if (strstr(buff, "WRITE FAILURE") != NULL) {
			ptr = buff;
			while (*ptr++ != '-');
		sscanf(ptr, "- WRITE FAILURE AT %lx", &ret_addr1);
		return(ICE_ERROR_WRITE);
	}
	if (strstr(buff, "NOT READY") != NULL) {
			ptr = buff;
			while (*ptr++ != 'i');
		sscanf(ptr, "S NOT READY AT %lx", &ret_addr1);
		return(ICE_NOT_READY);
	}
	if (strstr(buff, "PROTECTED") != NULL) return(ICE_MEM_PROTECT);
	//if (strstr(buff, "STEP") != NULL) return(ICE_STEP_ERROR);
	if (strstr(buff, "REQUEST") != NULL) return(ICE_BUS_REQUEST);
	if (strstr(buff, "OVERFLOW") != NULL) return(ICE_ABS_OVERFLOW);
	return ICE_OK;
}

send_long(addr)
unsigned long addr;
{
char c;
int i;
int firstNotZero;
		if (!addr) {
			send('0');
			return;
		}
	if (!downLoadMode && addr < 2) {
		c=addr&0xf;
		send(hex[c]);
		return;
	}
//              if (MICE == CPU68020_M3 || MICE == CPU68030_M3) i = 7; else i = 5;
		i = 7;
		firstNotZero = 0;
	for (; i >= 0; i--) {
		c=(addr>>i*4)&0xf;
		if (!firstNotZero) {
			if (!c) continue;
			else firstNotZero = 1;
		}
		send(hex[c]);
	}
}

send_word(addr)
unsigned int addr;
{
char c;
int i;
int firstNotZero;
		if (!addr) {
			send('0');
			return;
		}
		firstNotZero = 0;
	for (i=3; i >= 0; i--) {
		c=(addr>>i*4)&0xf;
		if (!firstNotZero) {
			if (!c) continue;
			else firstNotZero = 1;
		}
		send(hex[c]);
	}
}

send_byte(d)
unsigned char d;
{
char c;
		c=(d>>4)&0xf;
		send(hex[c]);
		c=d&0xf;
		send(hex[c]);
}

unsigned long rx_long()
{
int c;
unsigned long l;
	l=0;
	while (receive() != ' ');
	for (;;) {
		c=receive();
		if (c == HAND_SHAKE) break;
		if (isxdigit(c)) {
			c=asc__h(c);
			l = (l<<4) + c;
		}
	}
	return(l);
}

int rx_byte()
{
char c, i, j;
	while ((c=receive()) <= 0);
	i=asc__h(c);
	while ((c=receive()) <= 0);
	j=asc__h(c);
	i = (i<<4)+j;
	return(i);
}

/**************************************************************************
**
** Name :  upRX_DATA()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int upRX_DATA()
{ 
char c;
int rxData;
long startTime = GetCurrentTime();
int err,readNum,i;
     if (portType == 1) {
	   do {
	      if (InPortB(portStatus) & RV_RDY) {
		  rxData = InPortB(portAddr);
		  return(rxData);
	      }
	      } while ((GetCurrentTime() - startTime) <= 60  );

     } else {       
	     do {
		 err = GetCommError(portId, &commStat);
		 if ((readNum=ReadComm(portId,(LPSTR)&rxData,1)) != 0)
		    break;
	      } while ((GetCurrentTime() - startTime) <= 60);
	      if (readNum == 1) {
		 rxData = rxData & 0x00FF;
		 err = GetCommError(portId, &commStat);
	      } else {
		 err = GetCommError(portId, &commStat);
		 //ErrDisplayError(err, FORCE_POPUP);
		 rxData = -1;
	      }
	      return(rxData);
	 }     

    return -1;
}          /* end of upRX_DATA() */


send_str2(str)
char *str;
{
char c, *ptr;
	ptr=str;
	while (c = *ptr++) send(c);
}

send_ESC()
{
	send(ESC);
	while(receive() != HAND_SHAKE);
}

send_CR_wait(c)
int c;
{
	send(CR);
	while(receive() != c);
}

send_str_wait_CR(str)
char *str;
{
char c;

	while (c=*str++) {
		send(c);
		while (receive() != c);
	}
	send(CR);
	while (receive() != CR);
}

int check_KB()
{
	return(NULL);
}

send_str(str)
char *str;
{
char c;

	while (c=*str++) {
		send(c);
		while (receive() != c);
	}
	send(CR);
	while (receive() != HAND_SHAKE);
}

int start_up(char ch)
{
int i, j;
char c, *ptr;
int nTryCounter ;
const int nLinkStartLine = 1;  // declared in INITOLD.C by Chen, 09/26/94
// changed by Frank, 09/14/94
nTryCounter=0 ;
    //if (!AbortTarget) send(ESC);
    //else send(CR);
    
    send(CR);
	pause_delay(1);
	if (receiveB() == -1) { /* nothing echo */
	for (;;) {
	    if(++nTryCounter>5) 
	    {
		if(MessageBox(0,"      MICE-III Link Error!     ","MICE/SLD-68K",MB_RETRYCANCEL)!= IDRETRY) 
		{
		  return ICE_NOT_READY; 
		 }                     
		 nTryCounter = 0;        
	    }
	    send(ch);
	    send(CR);
	    // changed by Chen, 10/05/94
	    // pause_delay(1);
	    pause_delay(3);
	    if (receiveB() > 0) break;
	    // added by Chen, 09/26/94
	    else send(ESC);
		}
		ptr = tx_buf;
	j = nLinkStartLine; // changed by Chen, 09/26/94
		while ((c=receive()) != HAND_SHAKE) {
			if (c == CR) {
				*--ptr = NULL;
		    //DisplayLinkMsg(j, tx_buf);
		    ptr = tx_buf;
		    j++;
		} else *ptr++ = c;
		}
		while (receiveB() != -1); /* flush the data in MICE buffer */
	} else {
		while (receiveB() != HAND_SHAKE);
		while (receiveB() != -1); /* flush the data in MICE buffer */
	} 
	
	return (ICE_OK);
}

#define CTRL_C 0x3

send(txc)
char txc;
{
	int c, i;
	while(1) {
		if (chk_hlt() == ESC) ESCflag=1;
		if ((c=TX_DATAP(txc)) >= 0) return;
		/*
		if (chk_kb() == -1) {
			c = getch();
			if (c == CTRL_C) exit(1);
		}*/
	}
}

int TX_DATAP(txc)
char txc;
{
	return(TX_DAT(txc));
}

int TX_DAT(txc)
char txc;
{
	int err;
	int i;
	if (1 == portType) {
		for (i = 0; i < 300 ; i++)
	 if (InPortB(portStatus) & SD_RDY) {
	    OutPortB(portAddr,txc);
	    return ICE_OK ;
	 }
	} else {
	    do {
		 err = GetCommError(portId, &commStat);
	      } while (err == ER_COM_TXFULL);
	    if (WriteComm(portId,(LPSTR)&txc,1) == 1)
	       return(1);
	    err = GetCommError(portId, &commStat);
	    return (-1);  
    }   
    
    return -1;
}

/**************************************************************************
**
** Name : receive()
**
**************************************************************************/
int receive()
{
int c, i;
  while (1) {
     for ( i = 0; i < IO_COUNT; i++ ) {
	     if (FALSE) {
	     ESCflag=1;
		 return(-1);
	     }
	if( (c=upRX_DATA()) > 0 ){
	   if (logFlag) writeLog((char)c);
	     return(c);
	}
	 }
   }
}         /* end of receive() */

/**************************************************************************
**
** Name : receive2()
**
*************************************************************************/
int receive2()
{                     
int c, i;
   for ( i = 0; i < IO_COUNT; i++ ) {
	  //if (1==x && isEsc()) {
	  if (FALSE) {
		ESCflag=1;
	    return(-1);
      } 
      if( (c=upRX_DATA()) > 0 ){
	 if (logFlag) writeLog((char)c);
	   return(c);
      }
   }
}         /* end of receive2() */

int receiveGo()
{                     
int c, i;
   for ( i = 0; i < 2; i++ )
   {
	   if (isEsc())
	   {
		ESCflag=1;
	      return(-1);
      } 
      if( (c=upRX_DATA()) > 0 )
      {
	     if (logFlag) writeLog((char)c);
	     return(c);
      }
   }
   return -1;
}         /* end of receive2() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

pause_delay(i)
int i;
{
   long ll, lll;
   gettime(&ll);
   lll = ll + i;
   /*do {                 
      if(chk_hlt() == ESC || down_ESC_send) {
	 down_ESC_send = 0;
	 break;
      }
      gettime(&ll);
   } while(ll < lll) ;*/
   do {
      if(chk_hlt() == ESC || down_ESC_send) {
	 down_ESC_send = 0;
	 break;
      }
      gettime(&ll);
   } while(ll < lll) ;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

asc__h(k)
{
   if(isdigit(k)) k -= '0';
   else k = k - 'A' + 10;
   return(k);
}



/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: not ok
**
**************************************************************************/
RETCODE EXPORT iceSetTimerReg(U16 regNo) {
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_TIMER_REG,lp);

   varWidth = sizeof(regNo);
   SaveVar(regNo,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));*/
   return ICE_OK;
}

/**************************************************************************
**
** Name : iceDiagnostic()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes: NOT OK
**
**************************************************************************/
RETCODE EXPORT iceDiagnostic(VOID) {
/*
int lp=0;
RETCODE status;

   SaveId(DIAGNOSTIC,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
   */
   return ICE_OK;
}

/**************************************************************************
**
** Name : iceSelfTest()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:  NOT OK
**
**************************************************************************/
RETCODE EXPORT iceSelfTest(U16 cmdId) {
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(FUNCTION_TEST,lp);

   varWidth = sizeof(cmdId);
   SaveVar(cmdId,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));*/
   return ICE_OK;
}

/**************************************************************************
**
** Name : iceDiagnostic()
**
** Function :
**
**    Input  :
**
**    Output : 
**
** Notes: not ok
**
**************************************************************************/
RETCODE EXPORT DiagnosticFunction(DIAG_ID diagID) {
/*
int lp=0;
RETCODE status;

   SaveId(diagID,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if ((U16)status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status != ICE_OK) {
      switch (diagID) {
	 case MCE_MEMORY_TEST :
	 case INITIAL_TEST :
	    _fmemcpy(&memFailAddress,&inputStream[3],inputStream[2]);
	    break;
	 case MCE_CONNECT_TEST :
	    _fmemcpy(&errorMceConnTest,&inputStream[3],sizeof(ERROR_MCE_CONN_TEST));
      }
   }
   return(status);
  */
  return ICE_OK; 

}

/**************************************************************************
**
** Name : chk_hlt()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

chk_hlt()
{
/*int c=0;
extern unsigned char    CoverageEscFlag;*/

   /*c = chk_kb();
   if (c == ESC) {
      if (cmdfile_flag) cmdfile_end_flag = 1;
      CoverageEscFlag = 1;
   }
   else if (c == CTRL_S)
      while ((c=get_key()) != CTRL_Q && c != ESC)  ;
   return (c);*/
   //if(isEsc()) return ESC;
   return 0;
}  /*  of chk_hlt()  */

/**************************************************************************
**
** Name : chk_hlt()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceIsLAM2(BOOL* isLam2)
{
	unsigned char *ptr, c;
    LAM2 = 0;
    send_str_wait_CR(cov_cmd);
    ptr = tx_buf;
    while ((c=receive()) != HAND_SHAKE)     *ptr++ = c;
    if (strstr(tx_buf, "error") == NULL) LAM2=2;
    if (LAM2 == 2) *isLam2 = TRUE;
    else *isLam2 = FALSE;
    return ICE_OK;
}

RETCODE EXPORT iceIsHEMM(BOOL* isHemm)
{
    unsigned char *ptr, c;
    send_str_wait_CR("HELP MAP");
    while (receive() != CR);
    while (receive() != CR);
    while (receive() != CR);
    ptr = tx_buf;
    while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
    send_ESC();
    if (strstr(tx_buf, "HEMM") != NULL) {
	HEMM=1;
	bankMargin = 0x40000L;
    } else {
	HEMM = 0;
	    bankMargin = 0x10000L;
    }    
    if (HEMM == 1) *isHemm = TRUE;
    else *isHemm = FALSE;
    return ICE_OK;

}


/**************************** End of File **********************************/
