/****************************************************************************
**
**  Name:  about.c
**
**  Description:
**     This is the source code to support the login screen and about box.
**     The code to do the About Box was partially copied from an example
**     written by Bryan Woodruff (a public domain tty program).
**
**  $Log:   S:/tbird/arcm306/cliulib/about.c_v  $
** 
**    Rev 1.2   13 Dec 1995 11:57:56   kevin
** it is able to show loading progress msg and comes with pvlogin.bmp v1.2
** 
**    Rev 1.1   24 Nov 1995 11:55:08   kevin
** model type can show on login bitmap at run time
** 
**    Rev 1.0   07 Sep 1995 10:08:18   gene
** Initial revision.
** 
**    Rev 1.10   23 Nov 1993 14:29:48   ron
** debug version of windows showed up resource prob
** 
**    Rev 1.9   10 Sep 1993 13:59:16   ron
** changed HANDLE to LONG for parameters passed by Actor
** 
**    Rev 1.8   09 Sep 1993 14:00:56   ron
** ppr8818: register F1 help entry for about box
** 
**    Rev 1.7   31 Aug 1993 09:58:14   ron
** added SetToolBarHandle and GetToolBarHandle
** 
**    Rev 1.6   23 Jul 1993 10:52:44   ron
** dialog box needs the actual hInstance from the parent window (reverting
** to older version for that).
** 
**    Rev 1.5   23 Jul 1993 09:40:02   ron
** changed GetDC/ReleaseDC to CreateDC/DeleteDC in OpenLogin, and pass NULL
** as parent window handle.
** 
**    Rev 1.4   21 Jul 1993 16:41:28   paul
** Change source of hInstance from GetWindowWord() to instead
** read from the value saved in LibMain.  Using GWW() left us
** looking at Program Manager's hInst, Windows fails on the
** CreateWindow when we use the wrong hInst.
** Also, use GetDC/ReleaseDC in unless inside a WM_PAINT.
**
**    Rev 1.3   20 Jul 1993 13:39:02   ron
** bug fix -- use module handle to get bitmaps.
**
**    Rev 1.2   02 Jul 1993 15:56:26   ron
** changes based on code review comments
**
**    Rev 1.1   02 Jul 1993 10:52:24   ron
** forgot to remove a typo before I checked it in...
**
**    Rev 1.0   02 Jul 1993 10:00:34   ron
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/cliulib/about.c_v   1.2   13 Dec 1995 11:57:56   kevin  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _VERSIONS_
#include "versions.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#include "windows.h"
#include <string.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#define PVICON             0x200
#define PVBITMAP           821
#define PVLOGINBITMAP      700
#define PVLOGIN_WIDTH      300
#define PVLOGIN_HEIGHT     180

#define IDD_ABOUTICON      0x210
#define IDD_TITLELINE      0x211
#define IDD_VERSION        0x212
#define IDD_BYLINE         0x213
#define MAXLEN_TEMPSTR     81
#define GETHINST(hWnd)     ((HANDLE) GetWindowWord(hWnd, GWW_HINSTANCE))
#define INI_FILENAME       "micesld.ini"

HANDLE hLoginHnd = 0;
static long numLogins = 0;
static char szLoginClass[] = "LOGIN_DIALOG";
static LPSTR iResource;
long EXPORT LoginProc(HANDLE, WORD, WORD, LONG);


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern HANDLE hInstance;
static HANDLE hToolBarStatic;


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
VOID FAR PASCAL CheckMessages(VOID);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/


/*--------------------------------------------------------------------------
**  CheckMessages
**
**  Purpose:  Give low-priority messages an opportunity to be serviced.
**
**  Parameters:  None.
**
----------------------------------------------------------------------------*/
VOID FAR PASCAL CheckMessages(VOID)
{
   MSG msg;

   // give it time to draw the string
   while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
      if (msg.message == WM_QUIT) break;
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
}

/*--------------------------------------------------------------------------
**  AboutDlgProc
**
**  Purpose:
**     About Box dialog procedure for PowerViews.
**
**  Input:
**     hDlg:  The window handle.
**     uMsg:  The current message.
**     wParam:  The word message param.
**     lParam:  The long message param.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
BOOL FAR PASCAL AboutDlgProc(HANDLE hDlg, WORD uMsg,
                              WORD wParam, LONG lParam)
{
   switch (uMsg) {
      case WM_INITDIALOG:
      {
         char  szBuffer[ MAXLEN_TEMPSTR ], szTemp[ MAXLEN_TEMPSTR ] ;

         RegisterHelpEntry(HI_MESSAGEBOXEX, hDlg, HE_CONTENTS);

         /* hide the icon, to show the bitmap */

         ShowWindow(GetDlgItem(hDlg, IDD_ABOUTICON), SW_HIDE);

         /* sets up version number for PowerViews */

         GetDlgItemText(hDlg, IDD_VERSION, szTemp, sizeof(szTemp)) ;
         wsprintf(szBuffer, szTemp, VER_MAJOR, VER_MINOR, VER_BUILD) ;
         SetDlgItemText(hDlg, IDD_VERSION, (LPSTR) szBuffer) ;

      }
      return (lParam >= 0) ; /* return (TRUE) -- dummy use of lParam
                                  to avoid the compiler warning */

      /* used to paint the bitmap */

      case WM_PAINT:
      {
         HBITMAP      hBitMap ;
         HDC          hDC, hMemDC ;
         PAINTSTRUCT  ps ;

         /* load bitmap and display it */

         hDC = BeginPaint(hDlg, &ps) ;
         if (NULL != (hMemDC = CreateCompatibleDC(hDC)))
         {
            hBitMap = LoadBitmap(hInstance,
                                  MAKEINTRESOURCE(PVBITMAP)) ;
            hBitMap = SelectObject(hMemDC, hBitMap) ;
            BitBlt(hDC, 10, 10, 100, 92, hMemDC, 0, 0, SRCCOPY) ;
            DeleteObject(SelectObject(hMemDC, hBitMap)) ;
            DeleteDC(hMemDC) ;
         }
         EndPaint(hDlg, &ps) ;
      }
      break ;

      case WM_COMMAND:
         if ((WORD) wParam == IDOK)
         {
            EndDialog(hDlg, TRUE) ;
            return (TRUE) ;
         }
         break;
      case WM_CLOSE:
      {
            EndDialog(hDlg, TRUE) ;
            return (TRUE) ;
      }
   }
   return (FALSE) ;

} /* end of AboutDlgProc() */

/*--------------------------------------------------------------------------
**  AboutBox
**
**  Purpose:
**     Create the About Box for PowerViews as a modal dialog, and wait until
**     the OK button is pressed.
**
**  Input:
**     parent:  The parent window handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/

RETCODE EXPORT AboutBox(LONG partmp)
{
   HWND   hWnd;
   FARPROC lpDlgProc;
   FARPROC  lpProcInstance ;
   HANDLE my_hInstance;


   hWnd = (HWND) partmp;
   my_hInstance =  GETHINST(hWnd);
   lpDlgProc = AboutDlgProc;

   lpProcInstance = (FARPROC) MakeProcInstance((FARPROC) lpDlgProc,
                                                hInstance);
   DialogBox(my_hInstance, "ABOUT_DIALOG", hWnd, lpProcInstance);
   FreeProcInstance((FARPROC) lpProcInstance);
   return(GOOD);
}

/*--------------------------------------------------------------------------
**  LoginProc
**
**  Purpose:
**     Login Bitmap window procedure for PowerViews.
**
**  Input:
**     hWnd:  The window handle.
**     uMsg:  The current message.
**     wParam:  The word message param.
**     lParam:  The long message param.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
long FAR PASCAL _export LoginProc(HANDLE hWnd, WORD uMsg,
                              WORD wParam, LONG lParam)
{
   static char szBuffer[MAXLEN_TEMPSTR], buf[MAXLEN_TEMPSTR];
   static char  szFaceName[] = "Times New Roman";
   static LOGFONT lf;

   switch (uMsg)
   {
      case WM_CREATE:
      {
         char cpuStr[MAXLEN_TEMPSTR];

         /* set up version number for MICEpack/SLD */
         wsprintf(szBuffer, "Version %d.%d%c", VER_MAJOR, VER_MINOR, VER_BUILD) ;
         GetPrivateProfileString("SystemInfo", "MICEsld", "", cpuStr, 
            sizeof(cpuStr), INI_FILENAME);
         strcpy(&buf[2], cpuStr);
         buf[0] = 'S'; buf[1] = 'L'; buf[2] = 'D'; buf[3] = '-';
         sprintf(buf,"%s","MICE/SLD-68K" );
      }
      return 0;

      /* paint a status line along the lower edge of the splash screen */
      case WM_SETTEXT:
      {
         RECT  rect;
         HDC   hDC;
         HFONT hFont;
         HFONT hOldFont;
         TEXTMETRIC tm;
         static int blue=0;
         int devCap;

         hDC = GetDC(hWnd);
         GetTextMetrics(hDC, &tm);
//   jerry add on 4.7
        devCap=GetDeviceCaps(hDC, HORZRES);

 // end of add
         SetRect((LPRECT)&rect, 0, PVLOGIN_HEIGHT-(2*tm.tmHeight),
            PVLOGIN_WIDTH, PVLOGIN_HEIGHT);
         SetTextColor(hDC, RGB(0xFF-blue, 0x00, blue));
         SetBkMode(hDC, TRANSPARENT);
         InvalidateRect(hWnd, (LPRECT)&rect, 0);
         CheckMessages();
         

         // create new font
         lf.lfHeight = tm.tmHeight*(640)/(devCap-100);
//         lf.lfWidth = tm.tmWidth*640/(devCap-70);
         lf.lfItalic = 1;
  
         hFont = CreateFontIndirect(&lf);
         hOldFont = SelectObject(hDC, hFont);
         TextOut(hDC, 160, 155, (LPSTR)lParam, strlen((LPSTR)lParam));  // CPU type
         SelectObject(hDC, hOldFont);
         DeleteObject(hFont);
        
         ReleaseDC(hWnd, hDC);
         CheckMessages();
         blue += 10;
         if (blue > 255) blue = 255;
      }
      return 0;

      /* used to paint the bitmap */
      case WM_PAINT:
      {
         HBITMAP      hBitMap ;
         BITMAP       bm ;
         HDC          hDC, hMemDC ;
         PAINTSTRUCT  ps ;
         HFONT        hFont;
         HFONT        hOldFont;
         TEXTMETRIC   tm;
         POINT        ptSize, ptOrg;
         int devCap;
         /* load bitmap and display it */
//   jerry add on 4.7
        

         hDC = BeginPaint(hWnd, &ps) ;
         devCap=GetDeviceCaps(hDC, HORZRES);
         if (NULL != (hMemDC = CreateCompatibleDC(hDC)))
         {
            iResource = MAKEINTRESOURCE(PVLOGINBITMAP);
            hBitMap = LoadBitmap(hInstance, iResource);
            GetObject(hBitMap, sizeof(BITMAP), (LPSTR) &bm);
            SetMapMode(hDC, MM_TEXT);
            SetMapMode(hMemDC, MM_TEXT);
            ptSize.x = bm.bmWidth;
            ptSize.y = bm.bmHeight;
            DPtoLP(hDC, &ptSize, 1);
            ptOrg.x = 0;
            ptOrg.y = 0;
            DPtoLP(hMemDC, &ptOrg, 1);
            hBitMap = SelectObject(hMemDC, hBitMap) ;
            BitBlt(hDC, 0, 0, ptSize.x, ptSize.y,
               hMemDC, ptOrg.x, ptOrg.y, SRCCOPY) ;

            GetTextMetrics(hDC, &tm);

            lf.lfHeight = tm.tmHeight*640/(devCap-100) ;
 //           lf.lfWidth = tm.lfWidth*640/devCap ;
            lf.lfWeight =  tm.tmWeight;
            strcpy((char *) lf.lfFaceName, szFaceName);
            hFont = CreateFontIndirect(&lf);
            hOldFont = SelectObject(hDC, hFont);
            SetBkMode (hDC, TRANSPARENT);
            SetTextColor(hDC, RGB(0x0, 0x00, 0xFF)); /* blue */
            SetTextAlign (hDC, TA_CENTER | TA_TOP);
            TextOut(hDC, 190, 80, szBuffer, strlen(szBuffer)); // version
            SelectObject(hDC, hOldFont);
            DeleteObject(hFont);

            lf.lfHeight = tm.tmHeight*640/(devCap-100)*8/5 ;
  //          lf.lfWidth = tm.lfWidth*640/devCap ;


//            lf.lfHeight = (tm.tmHeight * 8) / 5; //(tm.tmHeight * 9) / 5; // Hight X 1.8
            lf.lfItalic = 0;// change 1 to 0;
            //lf.lfWidth = tm.tmWidth * 
            hFont = CreateFontIndirect(&lf);
            hOldFont = SelectObject(hDC, hFont);
            TextOut(hDC, 200, 47, buf, strlen(buf));  // CPU type
            SelectObject(hDC, hOldFont);
            DeleteObject(hFont);

            DeleteObject(SelectObject(hMemDC, hBitMap)) ;
            DeleteDC(hMemDC) ;
         }
         EndPaint(hWnd, &ps) ;
      }
      return 0;
   }
   /* In particular, this handles WM_CLOSE */
   return (DefWindowProc(hWnd, uMsg, wParam, lParam)) ;

} /* end of LoginProc() */

/*--------------------------------------------------------------------------
**  OpenLogin
**
**  Purpose:
**     Create and display the PowerViews bitmap.  The bitmap is displayed
**     until the CloseLoginWindow function is called (after all the DLLs
**     have been loaded).
**
**  Input:
**     None.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/

RETCODE EXPORT OpenLogin(VOID)
{
   WNDCLASS wndclass;
   U16 hPos, vPos;
   HDC hDC;


   if (hLoginHnd != 0) return (GOOD);

   if (numLogins == 0) {
      numLogins++;
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = LoginProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = NULL;
      wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
      wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szLoginClass;
      RegisterClass(&wndclass);
   }

   hDC = CreateDC("DISPLAY", NULL, NULL, NULL) ;
   if(hDC!=NULL)  {
      SetMapMode(hDC, MM_TEXT);
      hPos = GetDeviceCaps(hDC, HORZRES);
      vPos = GetDeviceCaps(hDC, VERTRES);
      hPos = (hPos / 2) - ((PVLOGIN_WIDTH + 2) / 2);
      vPos = (vPos / 2) - ((PVLOGIN_HEIGHT + 2) / 2);
      DeleteDC(hDC) ;
   }

   /* create a window just large enough to hold the bitmap */
   hLoginHnd = CreateWindow(szLoginClass, NULL,
      WS_POPUP | WS_VISIBLE | WS_BORDER, hPos, vPos,
      PVLOGIN_WIDTH + 2, PVLOGIN_HEIGHT + 2, NULL, 0,
      hInstance, NULL);

   return(GOOD);
}

/*--------------------------------------------------------------------------
**  CloseLogin
**
**  Purpose:
**     Remove the PowerViews bitmap that was displayed by the
**     OpenLoginWindow function.
**
**  Input:
**     None.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CloseLogin()
{
   if (hLoginHnd != 0) {
      SendMessage(hLoginHnd, WM_CLOSE, 0, 0);
   }
   return(GOOD);
}

/*--------------------------------------------------------------------------
**  SaveToolBarHandle
**
**  Purpose:
**     Save the toolbar window's window handle, for use by other DLLs that
**  need to send messages that any Actor window can handle (such as Window
**  menu WM_COMMAND messages, or function keys).
**
**  Input:
**     The toolbar window's handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT SaveToolBarHandle(LONG hTBtmp)
{
   HANDLE hToolBar;
   hToolBar = (HANDLE) hTBtmp; /* avoid Actor signed int problems */
   hToolBarStatic = hToolBar;
   return(GOOD);
}

/*--------------------------------------------------------------------------
**  GetToolBarHandle
**
**  Purpose:
**     Return the toolbar window's window handle, for use by other DLLs that
**  need to send messages that any Actor window can handle (such as Window
**  menu WM_COMMAND messages, or function keys).
**
**  Input:
**     None.
**
**  Output:
**     The toolbar window's handle.
----------------------------------------------------------------------------*/
RETCODE EXPORT GetToolBarHandle(HANDLE FAR * lphToolBar)
{
   *lphToolBar = hToolBarStatic;
   return(GOOD);
}

/*--------------------------------------------------------------------------
**  SetLoadingDllName
**
**  Purpose:
**     set name of loading DLL to gszDllName;
**
**  Input:
**     name of loading DLL.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT SetLoadingDllName(LPSTR statusString)
{
   if (hLoginHnd != 0) {
      SendMessage(hLoginHnd, WM_SETTEXT, 0, (LONG)(LPSTR)statusString);
   }
   return(GOOD);
}
/******************************** E O F ***********************************/
