/* RE_SID: @(%)/usr/ptk/windex_SCCS/include/SCCS/s.netconf.h.u 1.11 91/10/25 12:01:52 SMI */
/*	"@(#)netconf.h.u	1.11"	"10/25/91"	*/

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*	@(#)netconfig.h	1.5 89/12/06 SMI	*/

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */

#ifndef __NETCONFIG__
#define __NETCONFIG__

#include <tkdef.h>

#define NETPATH		"NETPATH"
#define NETCONFIG	"netconf"
#define MAXNETCONFIGLINE    200


struct netconfig {
    char    _TKFAR * nc_netid;	/* Network ID, including NULL terminator */
    unsigned long   nc_semantics;   /* Semantics */
    unsigned long   nc_flag;	    /* Flags */
    char    _TKFAR * nc_protofmly; /* Protocol family */
    char    _TKFAR * nc_proto;     /* Protocol name */
    char    _TKFAR * nc_device;    /* Full pathname of network device */
    unsigned long   nc_nlookups;    /* Number of directory lookup libraries */
    char    _TKFAR * _TKFAR * nc_lookups; /* Full pathnames of the directory */
				    /*	lookups themselves. */
    unsigned long   nc_unused[8];   /* Reserved for future expansion */
};

typedef struct {
    struct netconfig _TKFAR * _TKFAR * nc_head;
    struct netconfig _TKFAR * _TKFAR * nc_curr;
} NCONF_HANDLE;

/* nc_semantics */
#define NC_TPI_CLTS	1	    /* Datagram */
#define NC_TPI_COTS	2	    /* Virtual Circuit */
#define NC_TPI_COTS_ORD	3

/* semantics as strings */
#define NC_TPI_CLTS_S	    "tpi_clts"
#define	NC_TPI_COTS_S	    "tpi_cots"
#define	NC_TPI_COTS_ORD_S   "tpi_cots_ord"


/* nc_flag */
#define NC_NOFLAG	0x0	    /* ??? */
#define NC_VISIBLE	0x1	    /* is visible */
#define NC_BROADCAST	0x2	    /* supports broadcast */
#define NC_TRANSPORT	0x4	    /* is a transport */
#define NC_SESSION	0x8	    /* is a session layer */
#define NC_PRESENTATION	0x10	    /* is a presentation layer */
#define NC_APPLICATION	0x20	    /* is an application layer */

/* flags as characters */
#define	NC_NOFLAG_C	'-'
#define	NC_VISIBLE_C	'v'
#define	NC_BROADCAST_C	'b'
    /* these may change: */
#define NC_TRANSPORT_C	't'
#define NC_SESSION_C	's'
#define NC_PRESENTATION_C 'p'
#define NC_APPLICATION_C 'a'


/* nc_protofmly */
#define NC_NOPROTOFMLY	"-"
#define NC_LOOPBACK	"loopback"
#define NC_INET		"inet"
#define NC_IMPLINK	"implink"
#define NC_PUP		"pup"
#define NC_CHAOS	"chaos"
#define NC_NS		"ns"
#define NC_NBS		"nbs"
#define NC_ECMA		"ecma"
#define NC_DATAKIT	"datakit"
#define NC_CCITT	"ccitt"
#define NC_SNA		"sna"
#define NC_DECNET	"decnet"
#define NC_DLI		"dli"
#define NC_LAT		"lat"
#define NC_HYLINK	"hylink"
#define NC_APPLETALK	"appletalk"
#define NC_NIT		"nit"
#define NC_IEEE802	"ieee802"
#define NC_OSI		"osi"
#define NC_X25		"x25"
#define NC_OSINET	"osinet"
#define NC_GOSIP	"gosip"

/* nc_proto */
#define NC_NOPROTO	"-"
#define NC_TCP		"tcp"
#define NC_UDP		"udp"
#define NC_ICMP		"icmp"


/* lookup libraries */
#define NC_NOLOOKUP	"-"


extern	void _TKFAR * _TKFAR setnetconfig(void);
extern	struct netconfig _TKFAR * _TKFAR getnetconfig(void _TKFAR * handlep);
extern	int _TKFAR endnetconfig(void _TKFAR * handlep);
extern	struct netconfig _TKFAR * _TKFAR getnetconfigent(char _TKFAR * netid);
extern	int _TKFAR freenetconfigent(struct netconfig _TKFAR * netconfigp);
extern	char _TKFAR * _TKFAR nc_sperror(void);
extern	void _TKFAR nc_perror(char _TKFAR * s);

extern	void _TKFAR * _TKFAR setnetpath(void);
extern	struct netconfig _TKFAR * _TKFAR getnetpath(void _TKFAR * handlep);
extern	int _TKFAR endnetpath(void _TKFAR * handlep);


#endif /* endef __NETCONFIG__ */

