/* RE_SID: @(%)/usr/ptk/windex_SCCS/include/SCCS/s.netdb.h.u 9.12 91/11/06 13:28:16 SMI */
/*  "@(#)netdb.h.u	9.12"   "11/6/91" */
/*
 * Copyright (c) 1980,1983,1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/*
 * Structures returned by network data base library.
 * All addresses are supplied in host order, and
 * returned in network order (suitable for use in system calls).
 */

#ifndef _netdb_h
#define _netdb_h

#include <tkdef.h>

struct	hostent {
	char	_TKFAR * h_name;		/* official name of host */
	char	_TKFAR * _TKFAR * h_aliases;	/* alias list */
	int	h_addrtype;		/* host address type */
	int	h_length;		/* length of address */
	char	_TKFAR * _TKFAR * h_addr_list; /* list of addresses from name server */
#define	h_addr	h_addr_list[0]		/* address, for backward compat */
};

/*
 * Assumption here is that a network number
 * fits in 32 bits -- probably a poor one.
 */
struct	netent {
	char	_TKFAR * n_name;		/* official name of net */
	char	_TKFAR * _TKFAR * n_aliases;	/* alias list */
	int	n_addrtype;		/* net address type */
	unsigned long	n_net;		/* network # */
};

struct	servent {
	char	_TKFAR * s_name;		/* official service name */
	char	_TKFAR * _TKFAR * s_aliases;	/* alias list */
	int	s_port;				/* port # */
	char	_TKFAR * s_proto;		/* protocol to use */
};

struct	protoent {
	char	_TKFAR * p_name;		/* official protocol name */
	char	_TKFAR * _TKFAR * p_aliases;	/* alias list */
	int	p_proto;			/* protocol # */
};

struct rpcent {
	char	_TKFAR * r_name;	/* server name for this rpc program */
	char	_TKFAR * _TKFAR * r_aliases;	/* alias list */
	long	r_number;			/* rpc program number */
};

extern  struct hostent _TKFAR * _TKFAR gethostbyaddr(char _TKFAR * addr,
					int len,int type);
extern  struct hostent _TKFAR * _TKFAR gethostbyname(char _TKFAR * name);
extern  void _TKFAR sethostent(int f);
extern  void _TKFAR endhostent(void);
extern  struct hostent _TKFAR * _TKFAR gethostent(void);

extern  struct netent _TKFAR * _TKFAR getnetbyaddr(unsigned long net,
					int type);
extern  struct netent _TKFAR * _TKFAR getnetbyname(char _TKFAR * name);
extern  void _TKFAR setnetent(int f);
extern  void _TKFAR endnetent(void);
extern  struct netent _TKFAR * _TKFAR getnetent(void);

extern  struct servent _TKFAR * _TKFAR getservbyport(int port,
					char _TKFAR * proto);
extern  struct servent _TKFAR * _TKFAR getservbyname(char _TKFAR * name,
					char _TKFAR * proto);
extern  void _TKFAR setservent(int f);
extern  void _TKFAR endservent(void);
extern  struct servent _TKFAR * _TKFAR getservent(void);

extern  struct protoent _TKFAR * _TKFAR getprotobynumber(int proto);
extern  struct protoent _TKFAR * _TKFAR getprotobyname(char _TKFAR * name);
extern  void _TKFAR setprotoent(int f);
extern  void _TKFAR endprotoent(void);
extern  struct protoent _TKFAR * _TKFAR getprotoent(void);

extern  struct rpcent _TKFAR * _TKFAR getrpcbynumber(long number);
extern  struct rpcent _TKFAR * _TKFAR getrpcbyname(char _TKFAR * name);
extern  void _TKFAR setrpcent(int f);
extern  void _TKFAR endrpcent(void);
extern  struct rpcent _TKFAR * _TKFAR getrpcent(void);

/*
 * Error return codes from gethostbyname() and gethostbyaddr()
 * (when using the resolver)
 */

#ifdef _WINDOWS
#define h_errno (*(tkdll_h_errno()))
#include <tklib.h>			/* get prototype of tkdll_h_errno() */
#else
extern int h_errno;
#endif

#define	HOST_NOT_FOUND	1 /* Authoritive Answer Host not found */
#define	TRY_AGAIN	2 /* Non-Authoritive Host not found, or SERVERFAIL */
#define	NO_RECOVERY	3 /* Non recoverable errors, FORMERR, REFUSED, NOTIMP */
#define	NO_DATA		4 /* Valid name, no data record of requested type */
#define	NO_ADDRESS	NO_DATA		/* no address, look for MX record */

#endif /*!_netdb_h*/
