/* RE_SID: @(%)/usr/ptk/windex_SCCS/include/SCCS/s.netdir.h.u 1.12 91/12/11 13:23:11 SMI */
/*	"@(#)netdir.h.u	1.2"	"10/24/90"	*/

/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user or with the express written consent of
 * Sun Microsystems, Inc.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
/*   "@(#)netdir.h	1.3 89/12/06 Copyright 1989 Sun Microsystems, Inc." */

/*
 * netdir.h
 *
 * This is the include file that defines various structures and
 * constants used by the netdir routines.
 */

#ifndef _netdir_h
#define _netdir_h

#include <tkdef.h>

struct nd_addrlist {
	int 		n_cnt;			/* number of netbufs */
	struct netbuf 	_TKFAR * n_addrs;	/* the netbufs */
};

struct nd_hostservlist {
	int			h_cnt;		/* number of nd_hostservs */
	struct nd_hostserv	_TKFAR * h_hostservs;	/* the entries */
};

struct nd_hostserv {
	char		_TKFAR * h_host;	/* the host name */
	char		_TKFAR * h_serv;	/* the service name */
};

struct nd_mergearg {
	char		_TKFAR * s_uaddr;	/* servers universal address */
	char		_TKFAR * c_uaddr;	/* clients universal address */
	char		_TKFAR * m_uaddr;	/* merged universal address */
};

extern	int _TKFAR netdir_getbyname(struct netconfig _TKFAR * nf,
			struct nd_hostserv _TKFAR * nh,
			struct nd_addrlist _TKFAR * _TKFAR * na);
extern	int _TKFAR netdir_getbyaddr(struct netconfig _TKFAR * nf,
			struct nd_hostservlist _TKFAR * _TKFAR * nh,
			struct netbuf _TKFAR * nb);
extern	int _TKFAR netdir_options(struct netconfig _TKFAR * nf, int option,
			int fd, char _TKFAR * par);
extern	void _TKFAR netdir_free(char _TKFAR * p, int v);
extern	struct netbuf _TKFAR * _TKFAR uaddr2taddr(struct netconfig _TKFAR * nf,
			char _TKFAR * a);
extern	char _TKFAR * _TKFAR taddr2uaddr(struct netconfig _TKFAR * nf,
			struct netbuf _TKFAR * nb);
extern	void _TKFAR netdir_perror(char _TKFAR * e);
extern	char _TKFAR * _TKFAR netdir_sperror(void);


/*
 * These are all objects that can be freed by netdir_free
 */
#define ND_HOSTSERV	0
#define ND_HOSTSERVLIST	1
#define ND_ADDR		2
#define ND_ADDRLIST	3
#define	ND_UADDR	10		/* non-standard, free universal addr */

/* 
 * These are the various errors that can be encountered while attempting
 * to translate names to addresses. Note that none of them (except maybe
 * no memory) are truely fatal unless the ntoa deamon is on its last attempt
 * to translate the name. 
 *
 * Negative errors terminate the search resolution process, positive errors
 * are treated as warnings.
 */
#define ND_BADARG	-2	/* Bad arguments passed 	*/
#define ND_NOMEM 	-1	/* No virtual memory left	*/
#define ND_OK		0	/* Translation successful	*/
#define ND_NOHOST	1	/* Hostname was not resolvable	*/
#define ND_NOSERV	2	/* Service was unknown		*/
#define ND_NOSYM	3	/* Couldn't resolve symbol	*/
#define ND_OPEN		4	/* File couldn't be opened	*/
#define ND_ACCESS	5	/* File is not accessable	*/
#define ND_UKNWN	6	/* Unknown object to be freed	*/
#define ND_NOCTRL	7	/* Unknown option passed to netdir_options */
#define ND_FAILCTRL	8	/* Option failed in netdir_options */
#define ND_SYSTEM	9	/* Other System error		*/

#ifdef _WINDOWS
#define nd_errno (*(tkdll_nd_errno()))
#include <tklib.h>			/* get prototype of tkdll_nd_errno() */
#else
extern int nd_errno;
#endif

/*
 * The following special case host names are used to give the underlying
 * transport provider a clue as to the intent of the request. 
 */

#define HOST_SELF	"\\1"	/* The generic bind address for this tp */
#define HOST_ANY	"\\2"	/* A "don't care" option for the host   */
#define HOST_BROADCAST	"\\3"	/* The broadcast address for this tp    */

/*
 * The following netdir_options commands can be given to the fd. These is
 * a way of providing for any transport specific action which the caller
 * may want to initiate on his transport. It is up to the trasport provider
 * to support the netdir_options he wants to support.
 */
#define ND_SET_BROADCAST	1	/* Do t_optmgmt to support broadcast*/
#define ND_SET_RESERVEDPORT	2	/* bind it to reserve address */
#define ND_CHECK_RESERVEDPORT	3	/* check if address is reserved */
#define ND_MERGEADDR		4	/* Merge universal addresses	*/
#define ND_HOSTMASK		5	/* Bitmask for host comparison	*/
#endif /* !_netdir_h */
