/* RE_SID: @(%)/usr/ptk/windex_SCCS/include/SCCS/s.tklib.h.u 1.41 92/03/23 16:39:03 SMI */
/*	"@(#)tklib.h.u	1.41"	"3/23/92"
*/

/* Copyright (c) 1985-1989 by Sun Microsystems, Inc., Billerica, MA
 * All rights reserved.
 */

/*
   This header file contains prototypes for most of the functions
   needed when writing networked applications using the PC-NFS
   Programmer's Toolkit.
*/


#ifndef __TKLIB__
#define __TKLIB__ 1

#include <tkdef.h>
#include <string.h>
#include <sys/tk_types.h>

/* toolkit specific defines used for all the tk_xxx() calls */

/* return values from tk_suspend() call -- a bitwise or is returned */

#define TK_TIMEOUT	0x1		/* clock ticks timeout */
#define TK_HOTKEY	0x2		/* hot key event seen */
#define TK_NETEVENT	0x4		/* network receive event seen */


extern	unsigned long _TKFAR htonl(unsigned long hostlong);
extern	unsigned short _TKFAR htons(unsigned short hostshort);
extern	unsigned long _TKFAR ntohl(unsigned long netlong);
extern	unsigned short _TKFAR ntohs(unsigned short netshort);

extern  int _TKFAR getgroups(int gidsetlen, int _TKFAR * gidset);

extern  void _TKFAR setnetgrent(char _TKFAR * grp);
extern  void _TKFAR endnetgrent(void);
extern  int _TKFAR getnetgrent(char _TKFAR * _TKFAR * machinep,
			char _TKFAR * _TKFAR * namep,
			char _TKFAR * _TKFAR * domainp);
extern  int _TKFAR innetgr(char _TKFAR * grp, char _TKFAR * mach,
			char _TKFAR * nm, char _TKFAR * dom);

extern  int _TKFAR getdomainname(char _TKFAR * name, int namelen);
extern  int _TKFAR gethostname(char _TKFAR * name, int namelen);
extern  int _TKFAR getservername(char _TKFAR * name, int namelen);
extern  gid_t _TKFAR getgid(void);
extern  gid_t _TKFAR getegid(void);
extern  uid_t _TKFAR getuid(void);
extern  uid_t _TKFAR geteuid(void);
extern  char _TKFAR * _TKFAR getlogin(void);
extern  int _TKFAR get_myipaddr(char _TKFAR * ipaddr);
extern  int _TKFAR get_hostipaddr(char _TKFAR * ipaddr);
extern  int _TKFAR get_version(void);
extern	unsigned long _TKFAR get_subnetmask(void);

extern  int _TKFAR get_myaddress(struct sockaddr_in _TKFAR * my_sockaddr);
extern  int _TKFAR get_hostaddress(struct sockaddr_in _TKFAR * host_sockaddr);

extern	int _TKFAR get_nfs_path(char _TKFAR * dbfile, char _TKFAR * path,
			int pathlen);

extern  int _TKFAR select(int width, fd_set _TKFAR * readfds,
			fd_set _TKFAR * writefds,
			fd_set _TKFAR * exceptfds,
			struct timeval _TKFAR * timeout);

extern  int _TKFAR rcmd(char _TKFAR *  _TKFAR * ahost, int rport,
			char _TKFAR * locuser, char _TKFAR * remuser,
			char _TKFAR * cmd, int _TKFAR * fd2p);

extern	void  _TKFAR tk_perror(const char _TKFAR * msg);
extern	char _TKFAR * _TKFAR tk_sperror(void);
extern  int _TKFAR tk_geterrno(int s);

extern	char far * _TKFAR tk_inrtm(void);
extern	char far * _TKFAR tk_inrnm(void);

extern  void _TKFAR tk_free_env(void);
extern  int _TKFAR tk_shrink_ds(int heap_size);
extern  void _TKFAR tk_enable_suspend(void);
extern  void _TKFAR tk_disable_suspend(void);
extern  int _TKFAR tk_disable_safe(void);
extern  int _TKFAR tk_suspend(int cticks);
extern  int _TKFAR tk_hotkey(int new_key);
extern  int _TKFAR tk_time_left(void);
extern  int _TKFAR tk_net_event(void);
extern  int _TKFAR tk_rtmbusy(void);
extern  int _TKFAR tk_rnmbusy(void);
extern  void _TKFAR tk_tsr_exit(void);
extern  void _TKFAR tk_clr_exit_hook(void);
extern  void _TKFAR tk_set_exit_hook(void);

extern  char _TKFAR nfsdrive(void);

extern  int _TKFAR is_pc_nfs_installed(void);
extern  int _TKFAR ping(unsigned long ipaddr);

extern  void _TKFAR rtm_cleanup(void);
extern  void _TKFAR rnm_cleanup(void);
extern  int	_TKFAR rtm_install(char _TKFAR * name);
extern  int _TKFAR rnm_install(void);
extern  long _TKFAR rtm_version(void);
extern  long _TKFAR rnm_version(void);

/*
 * tk_free -- free a buffer that the toolkit allocated using tk_free().
 * free() can also be used in DOS app, but Windows app must use tk_free().
 */

extern int _TKFAR tk_free(char _TKFAR * mem);

/*
 * DLL support functions
 */

#if defined(_WINDOWS) || defined(_WINDLL)

extern int far tkdll_set_compiler(int type);
extern long far tkdll_version(void);
extern int far tkdll_init(void);
extern int far tkdll_cleanup(void);
extern int far * far tkdll_errno(void);
extern int far * far tkdll_t_errno(void);
extern int far * far tkdll_h_errno(void);
extern int far * far tkdll_nd_errno(void);
extern struct rpc_createerr far * far tkdll_rpc_createerr(void);
extern struct rpc_err far * far tkdll_rac_senderr(void);

#endif


#if defined(_WINDOWS) || defined(_WINDLL)
#define tk_errno (*(tkdll_errno()))
#else
#define tk_errno errno
#endif


#ifndef bcopy
#define bcopy(src,dest,count) memmove((dest),(src),(count))
#endif
 
#ifndef bzero
#define bzero(dest,count) memset((dest),0,(count))
#endif
 
#ifndef bcmp
#define bcmp(b1,b2,count) memcmp((b1),(b2),(count))
#endif

/* Compiler types for tkdll_set_compiler() */
#define	MICROSOFTC	1
#define	BORLANDC	2


#endif /* __TKLIB__ */

