/* RE_SID: @(%)/usr/ptk/windex_SCCS/include/SCCS/s.tk_errno.h.u 1.10 91/11/21 16:52:06 SMI */
/*  SccsId = @(#)tk_errno.h.u	1.10	11/21/91 */
 
/*
 * Copyright (c) 1990 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef __TK_ERRNO_INCLUDE__
#define __TK_ERRNO_INCLUDE__ 1

#ifndef EPERM
#include <errno.h>
#endif

/* toolkit error numbers */

#define EMSC_OFFSET	0
#define ERTM_OFFSET	64
#define ERNM_OFFSET	128
#define EDLL_OFFSET	164
#define	EBCC_OFFSET	256

/* error from transport module */

#define	ESYS		(ERTM_OFFSET+0)
		/* Internal error -- bug in code */
/* non-blocking and interrupt i/o */
#define	EWOULDBLOCK	(ERTM_OFFSET+1)
		/* Operation would block */
#define	EINPROGRESS	(ERTM_OFFSET+2)
		/* Operation now in progress */
#define	EALREADY	(ERTM_OFFSET+3)
		/* Operation already in progress */

/* ipc/network software */

	/* argument errors */
#define	ENOTSOCK	(ERTM_OFFSET+4)
		/* Socket operation on non-socket */
#define	EDESTADDRREQ	(ERTM_OFFSET+5)
		/* Destination address required */
#define	EMSGSIZE	(ERTM_OFFSET+6)
		/* Message too long */
#define	EPROTOTYPE	(ERTM_OFFSET+7)
		/* Protocol wrong type for socket */
#define	ENOPROTOOPT	(ERTM_OFFSET+8)
		/* Protocol not available */
#define	EPROTONOSUPPORT	(ERTM_OFFSET+9)
		/* Protocol not supported */
#define	ESOCKTNOSUPPORT	(ERTM_OFFSET+10)
		/* Socket type not supported */
#define	EOPNOTSUPP	(ERTM_OFFSET+11)
		/* Operation not supported on socket */
#define	EPFNOSUPPORT	(ERTM_OFFSET+12)
		/* Protocol family not supported */
#define	EAFNOSUPPORT	(ERTM_OFFSET+13)
		/* Address family not supported by protocol family */
#define	EADDRINUSE	(ERTM_OFFSET+14)
		/* Address already in use */
#define	EADDRNOTAVAIL	(ERTM_OFFSET+15)
		/* Can't assign requested address */

	/* operational errors */
#define	ENETDOWN	(ERTM_OFFSET+16)
		/* Network is down */
#define	ENETUNREACH	(ERTM_OFFSET+17)
		/* Network is unreachable */
#define	ENETRESET	(ERTM_OFFSET+18)
		/* Network dropped connection on reset */
#define	ECONNABORTED	(ERTM_OFFSET+19)
		/* Software caused connection abort */
#define	ECONNRESET	(ERTM_OFFSET+20)
		/* Connection reset by peer */
#define	ENOBUFS		(ERTM_OFFSET+21)
		/* No buffer space available */
#define	EISCONN		(ERTM_OFFSET+22)
		/* Socket is already connected */
#define	ENOTCONN	(ERTM_OFFSET+23)
		/* Socket is not connected */
#define	ESHUTDOWN	(ERTM_OFFSET+24)
		/* Can't send after socket shutdown */
#define	ETOOMANYREFS	(ERTM_OFFSET+25)
		/* Too many references: can't splice */
#define	ETIMEDOUT	(ERTM_OFFSET+26)
		/* Connection timed out */
#define	ECONNREFUSED	(ERTM_OFFSET+27)
		/* Connection refused */

	/* */
#define	ELOOP		(ERTM_OFFSET+28)
		/* Too many levels of symbolic links */
#define	ENAMETOOLONG	(ERTM_OFFSET+29)
		/* File name too long */

/* should be rearranged */
#define	EHOSTDOWN	(ERTM_OFFSET+30)
		/* Host is down */
#define	EHOSTUNREACH	(ERTM_OFFSET+31)
		/* No route to host */
#define	ENOTEMPTY	(ERTM_OFFSET+32)
		/* Directory not empty */

/* quotas & mush */
#define	EPROCLIM	(ERTM_OFFSET+33)
		/* Too many processes */
#define	EUSERS		(ERTM_OFFSET+34)
		/* Too many users */
#define	EDQUOT		(ERTM_OFFSET+35)
		/* Disc quota exceeded */

/* Network File System */
#define	ESTALE		(ERTM_OFFSET+36)
		/* Stale NFS file handle */
#define	EREMOTE		(ERTM_OFFSET+37)
		/* Too many levels of remote in path */

/* Errors from RTM (resident transport module) */

#define ERTMVERSION	(ERTM_OFFSET+38)
		/* RTM version mismatch */
#define EDOSVERSION	(ERTM_OFFSET+39)
		/* MS-DOS version 3 or greater required */
#define EDOSMEM	(ERTM_OFFSET+40)
		/* DOS memory corrupted */
#define EIVTBUSY	(ERTM_OFFSET+41)
		/* Int2f is in use by another application */
#define	ERTMFILE	(ERTM_OFFSET+42)
		/* RTM file not found or corrupted */
#define	ERTMNOTLOADED	(ERTM_OFFSET+43)
		/* RTM is not loaded */
#define EPCNFS_NOT_INSTALLED	(ERTM_OFFSET+44)
		/* PC-NFS is not loaded */
#define EPCNFS_VERSION	(ERTM_OFFSET+45)
		/* PC-NFS Version mismatch */
#define ERTMBADWINOP  (ERTM_OFFSET+46)
		/* RTM operation not supported under windows */

/* errors from RNM (resident naming module) */

#define ERNMVERSION	(ERNM_OFFSET+0)
		/* RNM version mismatch */
#define	ERNMFILE	(ERNM_OFFSET+1)
		/* RNM file not found or corrupted */
#define	ERNMNOTLOADED	(ERNM_OFFSET+2)
		/* RNM is not loaded */
#define ERNMBADWINOP  (ERNM_OFFSET+3)
		/* RNM operation not supported under windows */

#define EDLLVERSION 	(EDLL_OFFSET+0)
		/* Toolkit DLL version mismatch */
#define ETASKFULL 	(EDLL_OFFSET+1)
		/* Too many instances */
#define EDLL		(EDLL_OFFSET+2)
		/* General DLL error */

#ifdef __BORLANDC__
	/* Borland C defines the following errno values as -1.
	 * Toolkit will return them where appropriate so they are
	 * redefined here. tk_perror and tk_sperror recognize these values.
	 */
#undef	EINTR
#define	EINTR	(EBCC_OFFSET+0)

#undef	EBUSY
#define	EBUSY	(EBCC_OFFSET+1)

#undef	EPIPE
#define	EPIPE	(EBCC_OFFSET+2)

#endif	/* __BORLANDC__ */

#endif 	/* __TK_ERRNO_INCLUDE__ */
