/* RE_SID: @(%)/usr/ptk/windex_SCCS/include/SCCS/s.xti.h.u 1.22 92/03/11 16:22:34 SMI */
/*	"@(#)xti.h.u	1.22"	"3/11/92"	*/

/*
 *
 *
 * DESCRIPTION:
 *	This file contains the data structures and define's needed for
 *	communication between XTI client and XTI service provider.  
 *
 */

#ifndef XTI_H
#define XTI_H

#include <tkdef.h>

#include <sys/tk_types.h>

/*
 *  The following are the error codes needed by both kernel level
 *  Transport providers and the user level library.
 */

#define TSUCCESS	0		/* successful operation */
#define TBADADDR	1		/* incorrect addr format */
#define TBADOPT		2		/* incorrect option format */
#define TACCES		3		/* incorrect permissions */
#define TBADF		4		/* illegal transport fd */
#define TNOADDR		5		/* couldn't allocate address */
#define TOUTSTATE	6		/* out of state */
#define TBADSEQ		7		/* bad call sequence number */
#define TSYSERR		8		/* system error */
#define TLOOK		9		/* event requires attention */
#define TBADDATA	10		/* illegal amount of data */
#define TBUFOVFLW	11		/* buffer not large enough */
#define TFLOW		12		/* flow control */
#define TNODATA		13		/* no data */
#define TNODIS		14		/* discon_ind not found on queue */
#define TNOUDERR	15		/* unitdata error not found */
#define TBADFLAG	16		/* bad flags */
#define TNOREL		17		/* no ord rel found on queue */
#define TNOTSUPPORT	18		/* primitive/action not supported */
#define TSTATECHNG	19		/* state in process of changing */
#define TNOSTRUCTYPE 20		/* unsupported struct-type requested */
#define TBADNAME	21		/* invalid transport provider name */
#define TBADQLEN	22		/* qlen is zero */
#define TADDRBUSY	23		/* address in use */
#define TINDOUT		24		/* outstanding connection indications */
#define TPROVMISMATCH 25	/* transport provider mismatch */
#define TRESQLEN	26		/* resfd specificed to accept with qlen > 0 */
#define	TRESADDR	27		/* resfd not bound to same addr as fd */
#define TQFULL		28		/* incoming connection queue full */
#define	TPROTO		29		/* XTI protocol error */

/*
 *  The following are the events returned 
 */

#define T_NOEVENT	0x0000		/* No event received after last consumption. */
#define T_LISTEN	0x0001		/* Connection indication received */
#define T_CONNECT	0x0002		/* Connect confirmation received */
#define T_DATA		0x0004		/* Normal data received */
#define T_EXDATA	0x0008		/* Expedited data received */
#define T_DISCONNECT	0x0010		/* Disconnect received */
#define T_UDERR		0x0040		/* Datagram error indication */
#define T_ORDREL	0x0080		/* Orderly release indication */
#define T_GODATA	0x0100		/* Sending normal data is again possible */
#define T_GOEXDATA	0x0200		/* Sending expedited data is again possible */
#define T_EVENTS	0x03DF		/* all possible events */

/* 
 * The following are the flag definitions needed by the 
 * user library routines.
 */

#define T_MORE		0x001		/* More data */
#define T_EXPEDITED	0x002		/* Expedited data */
#define T_NEGOTIATE	0x004 		/* Set opts */
#define T_CHECK		0x008		/* Check opts */
#define T_DEFAULT	0x010		/* Get default opts */
#define T_SUCCESS	0x020		/* Successfule */
#define T_FAILURE	0x040		/* Failure */

/* 
 * Protocol-specific service limits
 */

struct t_info {
	long addr;		/* size of protocol address */
	long options;	/* size of protocol options */
	long tsdu;		/* size of max tsdu */
	long etsdu;		/* size of max exped. tsdu */
	long connect;	/* max data for connection primitives */
	long discon;	/* max data for disconnect primitives */
	long servtype;	/* provider service type */
	long flags;		/* other info about transport provider */
};

/*
 * Service type defines
 */

#define T_COTS		01	/* connection-oriented transport service */
#define T_COTS_ORD	02 	/* connection-oriented with orderly release */
#define T_CLTS		03	/* connectionless transport service */

/*
 * netbuf structure
 */

struct netbuf {
	unsigned short maxlen;
	unsigned short len;
	char _TKFAR * buf;
};

/* 
 * t_bind - format of the address and options arguments of bind
 */

struct t_bind {
	struct netbuf	addr;
	unsigned	qlen;
};

/* 
 * options management structure 
 */

struct t_optmgmt {
	struct netbuf	opt;
	long		flags;
};

/* 
 * disconnect structure 
 */

struct t_discon {
	struct netbuf	udata;	/* user data */
	short		reason;		/* reason code */
	short 		sequence; 	/* sequence number */
};

/* 
 * call structure
 */

struct t_call {
	struct netbuf	addr;	/* address */
	struct netbuf	opt;	/* options */
	struct netbuf	udata;	/* user data */
	short		sequence;	/* sequence number */
};

/* 
 * datagram structure
 */

struct t_unitdata {
	struct netbuf	addr;		/* address */
	struct netbuf	opt;		/* options */
	struct netbuf	udata;		/* user data */
};

/* 
 * unitdata error structure
 */

struct t_uderr {
	struct	netbuf	addr;	/* address */
	struct	netbuf	opt;	/* options */
	long		error;		/* error code */
};

/* 
 * The following are structure types used when dynamically
 * allocating the above structures via t_alloc().
 */

#define	T_BIND_STR	1		/* struct t_bind */
#define T_OPTMGMT_STR	2		/* struct t_optmgmt */
#define	T_CALL_STR	3		/* struct t_call */
#define T_DIS_STR	4		/* struct t_discon */
#define T_UNITDATA_STR  5		/* struct t_unitdata */
#define T_UDERROR_STR	6		/* struct t_uderr */
#define T_INFO_STR	7		/* struct t_info */

/* The following are the same define's as above. */

#define	T_BIND		1		/* struct t_bind */
#define T_OPTMGMT	2		/* struct t_optmgmt */
#define	T_CALL		3		/* struct t_call */
#define T_DIS		4		/* struct t_discon */
#define T_UNITDATA 	5		/* struct t_unitdata */
#define T_UDERROR	6		/* struct t_uderr */
#define T_INFO		7		/* struct t_info */

/*
 * The following bits specify which fields of the above
 * structures should be allocated by t_alloc().
 */

#define T_ADDR		0x01		/* address */
#define T_OPT		0x02		/* options */
#define T_UDATA		0x04		/* user data */
#define T_ALL		0xffff		/* all of the above */

/*
 * The following are the states for the user (XTI endpoint states)
 */

#define T_UNINIT	0		/* uninited */
#define T_UNBND		1		/* unbound */
#define T_IDLE		2		/* idle */
#define T_OUTCON	3		/* outgoing connection pending */
#define T_INCON		4		/* incoming connection pending */
#define T_DATAXFER	5		/* data transfer */
#define T_OUTREL	6		/* outgoing release pending */
#define T_INREL		7		/* incoming release pending */

/* General purpose defines */

#define T_YES		1
#define T_NO		0
#define	T_UNUSED	-1
#define T_NULL		0
#define T_ABSREQ	0x8000

/*
 * TCP SPECIFIC ENVIRONMENT 
 */

/* transport provider names */

#define T_TCP "\\rtm\\tcp"	/* Note double \'s are for C's benefit */
#define T_UDP "\\rtm\\udp"	/* Read as a single \ */


/*
 * TCP prededence levels
 */

#define	T_ROUTINE	0
#define T_PRIORITY	1
#define T_IMMEDIATE	2
#define T_FLASH		3
#define T_OVERRIDEFLASH	4
#define T_CRITIC_ECP	5
#define T_INETCONTROL	6
#define T_NETCONTROL	7

/*
 *	TCP security options structure
 */

struct secoptions {
	short	security;	/* security field */
	short 	compartment;	/* compartment */
	short 	handling;	/* handling resrictions */
	long 	tcc;		/* transmission control code */
};

/*
 * TCP options
 */

struct tcp_options {
	short 	precedence;		/* precedence */
	long	timeout;		/* abort timeout */
	long 	max_seg_size;		/* maximum segment size */
	struct secoptions secopt;	/* TCP security options */
};

/* 	
 *		Misc. defines
 */

#define O_NONBLOCK	0x1000		/* Non-blocking I/O.  XTI definition */
#define T_NDELAY	O_NONBLOCK      /* Non-blocking I/O.  XTI definition */
		/* Defined here since MSC did not defined it. */

/* 
 *		XTI libray prototypes 
 */

extern int _TKFAR t_accept(int fd, int resfd, struct t_call _TKFAR * call);
extern char _TKFAR * _TKFAR t_alloc(int fd, int struct_type, int fields);
extern int _TKFAR t_bind(int fd, struct t_bind _TKFAR * req,
			struct t_bind _TKFAR * ret);
extern int _TKFAR t_connect(int fd, struct t_call _TKFAR * sndcall,
			struct t_call _TKFAR * rcvcall);
extern int _TKFAR t_close(int fd);
extern int _TKFAR t_error(char _TKFAR * errmsg);
extern char _TKFAR * _TKFAR t_strerror(int errval);
extern int _TKFAR t_free(char _TKFAR * ptr, int struct_type);
extern int _TKFAR t_getinfo(int fd, struct t_info _TKFAR * info);
extern int _TKFAR t_getstate(int fd);
extern int _TKFAR t_listen(int fd, struct t_call _TKFAR * call);
extern int _TKFAR t_look(int fd);
extern int _TKFAR t_open(char _TKFAR * name, int oflag,
			struct t_info _TKFAR * info);
extern int _TKFAR t_optmgmt(int fd, struct t_optmgmt _TKFAR * req,
			struct t_optmgmt _TKFAR * ret);
extern int _TKFAR t_rcv(int fd, char _TKFAR * buf, unsigned int nbytes,
			int _TKFAR * flags);
extern int _TKFAR t_rcvconnect(int fd, struct t_call _TKFAR * call);
extern int _TKFAR t_rcvdis(int fd, struct t_discon _TKFAR * discon);
extern int _TKFAR t_rcvrel(int fd);
extern int _TKFAR t_rcvudata(int fd, struct t_unitdata _TKFAR * unitdata,
			int _TKFAR * flags);
extern int _TKFAR t_rcvuderr(int fd, struct t_uderr _TKFAR * uderr);
extern int _TKFAR t_snd(int fd, char _TKFAR * buf, unsigned int nbytes,
			int flags);
extern int _TKFAR t_snddis(int fd, struct t_call _TKFAR * call);
extern int _TKFAR t_sndrel(int fd);
extern int _TKFAR t_sndudata(int fd, struct t_unitdata _TKFAR * unitdata);
extern int _TKFAR t_sync(int fd);
extern int _TKFAR t_unbind(int fd);

#if defined (_WINDOWS) || defined(_WINDLL)
#define t_errno (*(tkdll_t_errno()))
#include <tklib.h>			/* get prototype of tkdll_t_errno() */
#else
extern int t_errno;
#endif

extern int t_nerr;
extern char *t_errlist[];

#endif	/* XTI_H */

