/****************************************************************************
**
**  Name:  map.h
**
**  Description:
**     Map server definitions
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/arcm306/inc/map_v22c.h_v  $
** 
**    Rev 1.0   07 Sep 1995 10:26:08   gene
** Initial revision.
** 
**    Rev 1.1   11 Apr 1994 15:49:42   nghia
** Revised to support C++ compiling.
** 
**    Rev 1.0   11 Apr 1994 15:33:38   nghia
** Initial revision.
** 
**    Rev 1.10   13 Jul 1993 11:14:28   tom
** Added MapSaveCS, MapRestoreCS, and MapConfigCS entrypoints.
** 
**    Rev 1.9   23 Oct 1992 21:26:54   brucea
** Added: InitServer prototype
** 
**    Rev 1.8   03 Sep 1992 14:14:52   john
** moved map changed event to events.h and renamed
** 
**    Rev 1.7   14 Aug 1992 12:55:20   john
** added new enum for clearing the map
** 
**    Rev 1.6   13 Aug 1992 11:44:14   john
** Fixed new compile warnings
** 
**    Rev 1.5   04 Aug 1992 15:55:22   john
** GetMapPresent prototype moved here from map.c
** 
**    Rev 1.4   01 Aug 1992 17:35:54   john
** moved prototype for mapblockoverlap from map.c
** 
**    Rev 1.3   31 Jul 1992 16:46:02   john
** Had to change prototypes to allow calls from actor
** 
**    Rev 1.2   27 Jul 1992 13:27:12   john
** Changed prototype on MapSet; added MAP_BLOCK typedef
** 
**    Rev 1.1   22 Jul 1992 14:50:08   doug
** change order to match hardware
** 
**    Rev 1.0   22 Jul 1992 09:51:54   john
** Initial revision.
**
**  $Header:   S:/tbird/arcm306/inc/map_v22c.h_v   1.0   07 Sep 1995 10:26:08   gene  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _MAP_
#define _MAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef enum {MAP_DISABLE, MAP_ENABLE, MAP_TYPE_END = 0x7fff} MAP_TYPE;

typedef enum {MAP_ENTRY_NOT_FOUND, MAP_ENTRY_FOUND, MAP_BLOCK_ALREADY_MAPPED, 
              MAP_BLOCKS_IDENTICAL, MAP_NO_FREE_BLOCKS, MAP_ENTRY_CLEAR,
              MAP_BLOCK_END = 0X7FFF} MAP_BLOCK;

typedef struct {
   DESCRIPTOR address;
   U32 blockSize;       /* size of block in bytes */  
   U16 accessRights;    /* ram/rom/none */
   U32 blockNumber;     /* which block to map */
   BOOLEAN enabled;
} MEMORY_MAP_DATA;

#define DUMMY_MAP_ORDER 0xFFFFFFFFL

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
**
**  GetMapBlockCount
**
**  Description:
**     Returns the number of map blocks available in the hw.
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        blockCount: number of blocks
**
*****************************************************************************/
RETCODE EXPORT GetMapBlockCount(U16 *blockCount);

/****************************************************************************
**
**  GetMapBlockGranularity
**
**  Description:
**     Returns the minimum size of map blocks available in the hw.
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        blockGran: size of map block
**
*****************************************************************************/
RETCODE EXPORT GetMapBlockGranularity(U32 *blockGran);

/****************************************************************************
**
**  GetMapBlockSize
**
**  Description:
**     Returns the maximum size of map blocks available in the hw.
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        blockSize: size of map block
**
*****************************************************************************/
RETCODE EXPORT GetMapBlockSize(U32 *blockSize);

/****************************************************************************
**
**  GetMapPresent
**
**  Description:
**     Returns a boolean to indicate if there is any ovly memory
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        (return): true if map memory present
**
*****************************************************************************/
BOOLEAN EXPORT GetMapPresent(VOID);

/****************************************************************************
**
** InitServer
**
** Description:
**    Reads HW to get known resources, initializes map HW
**
** Parameters:
**    input:
**       none:
**
**    output:
**
*****************************************************************************/
RETCODE EXPORT InitServer(VOID);


/****************************************************************************
**
**  MapBlockOverlap
**
**  Description:
**     Checks to see if the block about to be mapped overlaps one already 
**     mapped.
**
**  Parameters:
**     input:
**        map:  structure containing the address, length, access
**                 rights, and enable for setting the map
**        offset: starting offset of the map block
**        
**     output:
**        status: the overlap status of the block to be programmed
**
*****************************************************************************/
RETCODE EXPORT MapBlockOverlap(MEMORY_MAP_DATA *map, U32 offset, 
                               MAP_BLOCK *status);


/****************************************************************************
**
**  MapSet
**
**  Description:
**     Set the overlay map to an address.
**
**     Call MapClear to clear entry and use only target memory.
**
**  Parameters:
**     input:
**        memMap:  structure containing the address, length, access
**                 rights, and enable for setting the map
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapSet(MEMORY_MAP_DATA *memMap);

/****************************************************************************
**
**  MapGet
**
**  Description:
**     Get the current setting of the map.
**
**  Parameters:
**     input:
**        mapInfo.blockNumber:  map block entry to get
**     output:
**        mapInfo:  structure that returns information on one block
**
*****************************************************************************/
RETCODE EXPORT MapGet(MEMORY_MAP_DATA *mapInfo);

/****************************************************************************
**
**  MapClear
**
**  Description:
**     Clear the memory map.  Sets all memory to target; overlay is not used.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapClear(VOID);

/****************************************************************************
**
**  MapConfigCS
**
**  Description:
**     Sends command to chassis to program the probe hardware to match
**     the 683XX internal chip select registers.  Restore the registers from
**     this ascii file first, then sends the command to program the probe HW.
**
**  Parameters:
**     none.
**
*****************************************************************************/
RETCODE EXPORT MapConfigCS(void);

/****************************************************************************
**
**  MapSaveCS
**
**  Description:
**     Gets the 683XX internal chip select registers from the processor
**     and outputs the values in ascii to the entered filename.
**
**  Parameters:
**     fileName (in):  file which will contain register info.
**
*****************************************************************************/
RETCODE EXPORT MapSaveCS(LPSTR fileName);

/****************************************************************************
**
**  MapRestoreCS
**
**  Description:
**     Interface to restore chip selects.
**
**  Parameters:
**     fileName (in):  file which contains register info.
**
*****************************************************************************/
RETCODE EXPORT MapRestoreCS(LPSTR fileName);

#ifdef __cplusplus
}
#endif

#endif /* _MAP_ */
/******************************** E O F ***********************************/
