/*
 *    Name:    srceval.h
 *
 *    Description: 
 *       Routines to interface to the source evaluation server
 *
 *    $Log:   S:/tbird/arcm306/inc/srceval.h_v  $
** 
**    Rev 1.0   14 Sep 1995 14:22:26   kevin
** Initial revision.
 * 
 *    Rev 1.0   14 Jun 1991 13:35:30   jim
 * Initial revision.
 *
 *    $Header:   S:/tbird/arcm306/inc/srceval.h_v   1.0   14 Sep 1995 14:22:26   kevin  $
 */
#ifndef SRCEVAL_SERVER
#define SRCEVAL_SERVER

#include "system.h"

typedef enum { EVAL_HEX, EVAL_DEC, EVAL_BIN, EVAL_ASCII } EVAL_BASE;

ERROR EvalSetBase(EVAL_BASE base);
/*
Description:
   Sets the default base for the expression evaluator to use when returning
   the results.
Parameters:
   input:
      base:                expression result radix
   output:
      none
*/

ERROR EvalGetBase(EVAL_BASE *base);
/*
Description:
   Returns the default base the expression evaluator is using when returning
   the results.
Parameters:
   input:
      none
   output:
      base:                expression result radix
*/

ERROR EvalExpression(UCHAR *inText, UCHAR *resultText, 
                             UWORD *errorPos, UWORD *tokenLength);
/*
Description:
   Processes the incoming text string through a parser and interpreter to 
   determine if the expression is valid and what the result text string
   is.  The 'inText' string can be just an rvalue to evaluate or 
   lvalue=rvalue assignment to evaluate and execute.  If the lvalue portion
   of the 'inText' string doesn't equate to an lvalue then an error is 
   returned.  Also if the expression can't be evaluated to a single rvalue
   then an error is also returned (i.e.: if the expression evaluates to a
   structure type).  If some part of the 'inText' string is bad a syntax
   error code is returned and errorPos points to the start of the syntax 
   or semantic problem and tokenLength indicates the length of the area
   causing the syntax or semantic error.   
Parameters:
   input:
      inText:              text string containing the expression to evaluate
                           and possibly modify
   output:
      resultText:          text string of result information
      errorPos:            starting index of area causing syntax or semantic
                           error
      tokenLength:         length of area causing syntax or semantic error
*/

#endif
