/* Dummy class to access C++ periphereal presenter */ !!

inherit(Window, #PeriphPresenter, nil, 2, nil)!!

now(class(PeriphPresenter))!!

/* 8/5/1993 13:51 */
Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
   /* the Peripheral presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(PeriphPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
  if not(exists(self))
      if not(ThePeripheralPresenter := new(PeriphPresenter, nil, nil,
            "Peripheral",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(ThePeripheralPresenter));
      if ((newHWnd := openPeriphWindow(PeriphLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(ThePeripheralPresenter,newHWnd);
         show(ThePeripheralPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^ThePeripheralPresenter; 
   
}
!!

/* 7/5/1993 14:43 */
Def exists(self | handle)
{
   if ThePeripheralPresenter
      handle := existsPeriphWindow(PeriphLibClass$Inst);
      if handle 
         setHWnd(ThePeripheralPresenter,handle)
      else
         ThePeripheralPresenter := nil;
      endif;
   endif;
   ^ThePeripheralPresenter;
}
!!

/* 7/2/1993 11:08 
  Open a new Peripheral Presenter. 
  Example: open(PeriphPresenter);
*/
Def open(self)
{
   /* the Peripheral presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(PeriphPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
   if not(exists(self))
      if not(ThePeripheralPresenter:=new(PeriphPresenter,nil,nil,
            "Peripheral",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(ThePeripheralPresenter));
      setHWnd(ThePeripheralPresenter,openPeriphWindow(PeriphLibClass$Inst,
            nil, nil));
      show(ThePeripheralPresenter,SW_SHOW);
   endif;
   ^ThePeripheralPresenter;

} 
!!

now(PeriphPresenter)!!

/* 4/19/1994 10:37 - PUBLIC
 get the location rect of the window and save it to the ini file 
*/
Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Peripheral window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif;

  if (windRect) then   
    layout := new(String, 18);
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD;
}!!

/* 7/2/1993 15:10 */
Def close(self)
{ 
   if (exists(class(self)))
      closePeriphWindow(PeriphLibClass$Inst);
      ThePeripheralPresenter := nil;
   endif;
   ^GOOD;
}
!!

