/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the BKROOT.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/bkroot/libmain.c_v  $
** 
**    Rev 1.0   13 Feb 1997 08:43:32   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:06:22   gene
** Initial revision.
** 
**    Rev 1.1   31 Jul 1992 10:17:42   mindy
** Each server is responsible for initializing themself so now we call
** BkrootInit routine in libmain.
** 
**    Rev 1.0   25 Jun 1992 11:15:40   jim
** Initial revision.
   
      Rev 1.0   22 Jun 1992 19:06:42   brucea
   Initial revision.
** 
**  $Header:   S:/tbird/mt2_68k/bkroot/libmain.c_v   1.0   13 Feb 1997 08:43:32   gene  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _BKROOT_
#include "bkroot.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
PRIVATE HANDLE hLib;

#define MODULE_NAME "bkroot.dll"

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the BKPTEXEC.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    RETCODE err;
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;

    ErrInitDLL(MODULE_BKROOT, MODULE_NAME);  /* set up for error text */
    if((err=BkRootInit())!=GOOD)
      ErrDisplayError(err, FORCE_POPUP);
    return(TRUE);
}


/******************************** E O F ***********************************/
