/****************************************************************************
**
** Name: cliulib.h
**
** Description:  CLI utility library.
**
** Status: CODED
**
** Copyright (C) 1992 Microtek International.  All rights reserved.
**
** $Log:   S:/tbird/mt2_68k/inc/cliulib.h_v  $
** 
**    Rev 1.0   13 Feb 1997 08:49:42   gene
** Initial revision.
** 
**    Rev 1.1   13 Dec 1995 13:15:28   kevin
** added SetLoadingDllName()
** 
**    Rev 1.0   07 Sep 1995 10:25:50   gene
** Initial revision.
** 
**    Rev 1.6   23 Mar 1994 16:49:34   tom
** Check for compatible versions
** 
**    Rev 1.5   28 Sep 1993 15:39:10   ron
** added ReadLine and FindLine (initially, for peripheral presenter)
** 
**    Rev 1.4   23 Sep 1993 10:40:08   nghia
** Revised LDRPROC parameter flags as an U32 to support new laod option.
** 
**    Rev 1.3   10 Sep 1993 13:58:04   ron
** changed prototypes to pass LONG for window handle, for things that
** Actor calls (it can't pass unsigned ints).
** 
**    Rev 1.2   01 Sep 1993 14:37:14   ron
** changes for help/menu support in Peripheral Presenter
** 
**    Rev 1.1   30 Aug 1993 10:53:44   ron
** changes for Load Progress dialog
** 
**    Rev 1.0   08 May 1992 11:51:00   tom
** Initial revision.
**  
** $Header:   S:/tbird/mt2_68k/inc/cliulib.h_v   1.0   13 Feb 1997 08:49:42   gene  $
**
*****************************************************************************/

#define _CLIULIB_

#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /**************************
                        *                        *
                        *    TYPE DEFINITIONS    *
                        *                        *
                        **************************/
/* 
 * The maximum size of the string to hold the current module name
 * (no point in being stingy, since there's just one of these structs
 * used).
 */
#define MAX_MODULE_NAME_LEN   64 
#define MAX_LOADFILE_NAME_LEN 64 
/*
 * Here is where the callback functions called by the cliulib ldrprog.c
 * progress reporting dialog put the information about the size and 
 * status of the load.
 */
typedef struct {
   U32 loadFileSize;/* size, in bytes, of the current loadfile */
   U32 curLocation; /* ftell offset within loadfile */
   U32 numSymbols;  /* number of symbols loaded so far */
   U32 numBytes;    /* number of bytes loaded so far */
   U16 numModules;  /* number of modules loaded so far */
   U32 numLines;    /* number of lines loaded so far */
   U32 numFunctions;/* number of functions loaded so far */
   U32 numTypes;    /* number of types loaded so far */
   S32 startPC;     /* -1 if unknown */
   S32 stackBase;   /* -1 if unknown */
   S32 stackSize;   /* -1 if unknown */
   char curModule[MAX_MODULE_NAME_LEN];
   char curLoadFile[MAX_LOADFILE_NAME_LEN];
} LDRSTATBLOCK;

#ifndef HFILE
/* from windows.h for Windows 3.1 */
typedef int HFILE; /* Polymorphic with C runtime file handle type */
#endif

/*
 * Define a type LDRPROC, which is like a FARPROC but specific for loader
 * progress indicator.  This is to avoid load order dependencies, by using
 * a callback function.
 */
typedef RETCODE (EXPORT *LDRPROC)(LPSTR lpBinfile, BOOLEAN ondemand, 
   U32 flags, U32 parenthWnd); 

                       /**************************
                        *                        *
                        *          ERRORS        *
                        *                        *
                        **************************/

                        /*************************
                        *                        *
                        *   EVENT NOTIFICATION   *
                        *                        *
                        **************************/

                       /**************************
                        *                        *
                        *      PROTOTYPES        *
                        *                        *
                        **************************/

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------
**  CLISetActive
**
**  Purpose:
**     Mark the CLI as active.  Should only be called from CLI Server.
**
**  Input:
**     cliHandle:  The CLI Server handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLISetActive(HANDLE cliHandle);


/*--------------------------------------------------------------------------
**  CLIClearActive
**
**  Purpose:
**     Mark the CLI as inactive.  Should only be called from CLI Server.
**
**  Input:
**     None.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIClearActive(void);


/*--------------------------------------------------------------------------
**  CLIGetActive
**
**  Purpose:
**     Return an indication of whether the CLI is active or not.
**
**  Input:
**     None.
**
**  Output:
**     cliHandle:  The CLI Server handle; 0 indicates CLI Server inactive.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIGetActive(HANDLE *cliHandle);


/*--------------------------------------------------------------------------
**  GetPowerViewsVersion
**
**  Purpose:
**     Return the PowerViews version.
**
**  Parameters:
**     major:  major version number.
**     minor:  minor version number.
**     build:  build version number.
----------------------------------------------------------------------------*/
RETCODE EXPORT GetPowerViewsVersion(U16 *major, U16 *minor, CHAR *build);

/*--------------------------------------------------------------------------
**  CliLdrProgressActive
**
**  Purpose:
**     Tell the caller if the load progress dialog is active or not.
**
**  Input:
**
**  Output:
**     answer:  Return TRUE if we are doing the progress dialog.
----------------------------------------------------------------------------*/
RETCODE EXPORT CliLdrProgressActive(BOOL FAR *answer);

/*--------------------------------------------------------------------------
**  CliLdrProgressStep
**
**  Purpose:
**     Update the load progress dialog status based on the current
**  values in the loader status block.
**
**  Input:
**
**  Output:
----------------------------------------------------------------------------*/
RETCODE EXPORT CliLdrProgressStep(void);

/*--------------------------------------------------------------------------
**  CliLdrProgressDone
**
**  Purpose:
**     Update the load progress dialog status to final values, based on
**  values in the loader status block.
**
**  Input:
**     normal: if true, update and keep dialog up until OK is pressed.
**             Otherwise remove the dialog immediately.
**
**  Output:
----------------------------------------------------------------------------*/
RETCODE EXPORT CliLdrProgressDone(BOOL keepDialog);

/*--------------------------------------------------------------------------
**  CliLdrProgressDialog
**
**  Purpose:
**     Create the Progress Dialog for PowerViews, and wait until
**     the Cancel/OK button is pressed.
**
**  Input:
**     parent:  The parent window handle.
**     callBack:  The function to call back, in the loader.  This is only
**                here because of load order dependencies in the DLLs.
**
**  Output:
**     None.  
----------------------------------------------------------------------------*/
RETCODE EXPORT CliLdrProgressDialog(HANDLE parent, LDRPROC callBack);

/*--------------------------------------------------------------------------
**  CliLdrStatBlock
**
**  Purpose:
**     Save a pointer to the loader status block.  Needed in order to
**  prevent load order dependencies.  The status block is static data in
**  a DLL, so the pointer will not change during PowerViews operation.
**
**  Input:
**     lpstb: the pointer to the loader status block (see cliulib.h).
**
**  Output:
----------------------------------------------------------------------------*/
RETCODE EXPORT CliLdrStatBlock(LDRSTATBLOCK FAR *lpstb);

/*--------------------------------------------------------------------------
**  SaveToolBarHandle
**
**  Purpose:
**     Save the toolbar window's window handle, for use by other DLLs that
**  need to send messages that any Actor window can handle (such as Window
**  menu WM_COMMAND messages, or function keys).
**
**  Input:
**     The toolbar window's handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT SaveToolBarHandle(LONG hToolBar);

/*--------------------------------------------------------------------------
**  GetToolBarHandle
**
**  Purpose:
**     Return the toolbar window's window handle, for use by other DLLs that
**  need to send messages that any Actor window can handle (such as Window
**  menu WM_COMMAND messages, or function keys).
**
**  Input:
**     None.
**
**  Output:
**     The toolbar window's handle.
----------------------------------------------------------------------------*/
RETCODE EXPORT GetToolBarHandle(HANDLE FAR * lphToolBar);

/*--------------------------------------------------------------------------
**  RegisterHelpEntry
**
**  Purpose:
**    Record the Window Handle of a PowerViews window or dialog along with
**    the help entry to use for it.
**
**  Input:
**     hInd:       The index in the handle/entry array for this window.
**     hWnd:       The parent window handle (long since Actor can't pass
**                 unsigned ints).
**     helpEntry:  The help entry to use if F1 is pressed over that window.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT RegisterHelpEntry(U16 hInd, LONG hWnd, WORD helpEntry);

/*--------------------------------------------------------------------------
**  ReadLine
**
**  Purpose:
**     Read a line (efficiently) from the open file (a replacement for
**     a function that read the file one byte at a time).
**
**  Input:
**     hFile:  The file handle.
**     buf:    The input buffer (supplied by caller).
**     bufsize:The size of the buffer.
**
**  Output:
**     None.
**
** Requires <IO.H>(tell,lseek), <STRING.H>(_fstrchr, _fstrlen)
**
----------------------------------------------------------------------------*/
RETCODE EXPORT ReadLine(HFILE hFile, LPSTR buf, U16 bufsize);

/*--------------------------------------------------------------------------
**  FindLine
**
**  Purpose:
**     Find and return the next non-blank non-comment line (used by 
**     configuration file readers).
**
**  Input:
**     hFile:  The file handle.
**     line:   The line number in the file.
**     buf:    The input buffer (supplied by caller).
**     bufsize:The size of the buffer.
**
**  Output:
**     None.
**
** Requires <IO.H>(tell,lseek), <STRING.H>(_fstrchr, _fstrlen)
**
----------------------------------------------------------------------------*/
RETCODE EXPORT FindLine(HFILE hFile, U16 FAR *line, LPSTR buf, U16 bufsize);

/*--------------------------------------------------------------------------
**  SetLoadingDllName
**
**  Purpose:
**     set name of loading DLL to gszDllName;
**
**  Input:
**     name of loading DLL.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT SetLoadingDllName(LPSTR lpszName);

#ifdef __cplusplus
}
#endif

/******************************** E O F ***********************************/
