/****************************************************************************
**
**  Name:  cur_link.h
**
**  Description:
**     Routines to support the linked cursor function.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/inc/cur_link.h_v  $
** 
**    Rev 1.0   13 Feb 1997 08:49:44   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:25:50   gene
** Initial revision.
**  
**     Rev 1.1   21 Aug 1991 11:22:16   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:36:50   jim
 * Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/inc/cur_link.h_v   1.0   13 Feb 1997 08:49:44   gene  $
**
*****************************************************************************/

#define _CUR_LINK_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct {
   BOOLEAN       valid;
   ADDRESS_RANGE position;
} CURSOR;

typedef U32 LINKID;

typedef U8 *WINNAME;

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  ClsGetCursor
**
**  Description: 
**     When the server receives this command, it will return the "master"
**     cursor position to the presenter indicated by the ID.
**  
**  Parameters:
**     input:
**        id:  A pointer to a linked ID.  This was obtained in Link command.
**     output:
**        serverCursor:  A pointer to the "master" cursor that all linked
**           presenters are using.
**
*****************************************************************************/
RETCODE EXPORT ClsGetCursor (LINKID *id, CURSOR serverCursor);

/****************************************************************************
**
**  ClsLink
**
**  Description: 
**     When the server receives this command, it will add it to the Linked
**     Presenters Table (LPT) and return a unique ID which will be used by
**     the presenter for all of its communications with the server.
**  
**  Parameters:
**     input:
**        winName:  A pointer to a string containing the text in the
**           window's title bar.  Used by the server to display a list of
**           windows that are linked.
**        ClsPLink:  A pointer to the PresenterLink() function.
**        ClsPSetCursor:  A pointer to the PresenterSetCursor() function.
**        ClsPUnLink:  A pointer to the PresenterUnLink() function.
**     output:
**        id:  A pointer to a link ID.  Similar to a file descriptor.
**           Must be used in all other communications with the server.
**
*****************************************************************************/
RETCODE EXPORT ClsLink (WINNAME *winName, RETCODE (*ClsPLink)(),
   RETCODE (*ClsPSetCursor)(CURSOR), RETCODE (*ClsPUnLink)(), LINKID *id);

/****************************************************************************
**
**  ClsPresenterLink
**
**  Description: 
**     When the presenter receives this command, it will adjust its
**     display to indicate it is currently linked.  This command is used to
**     "undo" the last "unlink".
**  
**  Parameters:
**     None.
**
*****************************************************************************/
RETCODE EXPORT ClsPresenterLink (VOID);

/****************************************************************************
**
**  ClsPresenterSetCursor
**
**  Description: 
**     When the presenter receives this command, it will update it own 
**     cursor position (and adjust it's display) to the one sent to it.
**  
**  Parameters:
**     input:
**        serverCursor:  The cursor that all linked presenters are using.
**
*****************************************************************************/
RETCODE EXPORT ClsPresenterSetCursor (CURSOR serverCursor);

/****************************************************************************
**
**  ClsPresenterUnlink
**
**  Description: 
**     When the presenter receives this command, it will adjust its display
**     to indicate it is no longer linked.
**  
**  Parameters:
**     None.
**
*****************************************************************************/
RETCODE EXPORT ClsPresenterUnLink (VOID);

/****************************************************************************
**
**  ClsSetCursor
**
**  Description: 
**     When the server receives this command it will upddate the "master"
**     cursor position and then send a PresenterSetCursor to all presenters
**     that are currently linked (i.e. all those listed in the LPT).
**  
**  Parameters:
**     input:
**        id:  A pointer to a link ID.  This was obtained in by Link command.
**        myCursor:  The calling presenters current cursor.
**
*****************************************************************************/
RETCODE EXPORT ClsSetCursor (LINKID *id, CURSOR myCursor);

/****************************************************************************
**
**  ClsUnlink
**
**  Description: 
**     When the server receives this command, it will verify that this
**     presenter is currently linked in, and remove it.
**  
**  Parameters:
**     input:
**        id:  A pointer to a linked ID.  This was obtained in Link command.
**
*****************************************************************************/
RETCODE EXPORT ClsUnlink (LINKID *id);

/******************************** E O F ***********************************/
