/****************************************************************************
**
**  Name:  LFLAGS.H
**
**  Description:
**      Flags used by modules for on-demand loading.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_68k/l695/lflags.h_v  $
** 
**    Rev 1.1   01 Jul 1998 13:56:20   hera
** ID247
** 
**    Rev 1.0   13 Feb 1997 08:50:54   gene
** Initial revision.
** 
**    Rev 1.1   01 Dec 1995 13:27:24   kevin
** added load_user macro
** 
**    Rev 1.0   07 Sep 1995 10:32:18   gene
** Initial revision.
** 
**    Rev 1.6   23 Sep 1993 11:23:18   nghia
** Added LAOD_ASM() macro and remove RELOAD() - it's not include in the flag
** any more. Get rid of the ALTLANG stuff.
** 
**    Rev 1.5   03 Jun 1993 18:50:24   nghia
** Revised macros and Flags values to support the new Report Warning option.
** 
**    Rev 1.4   08 Mar 1993 10:43:24   nghia
** Cleanup.
** 
**    Rev 1.3   01 Jun 1992 20:13:56   courtney
** Added altlang macro.
** 
**    Rev 1.2   07 May 1992 16:09:36   courtney
** Added reload macro to check load flags (PPR #5449).
** 
**    Rev 1.1   31 Dec 1991 10:53:40   courtney
** Revisions to fully support ondemand loading, as well as loader 'flags',
** to load only code or only symbols.
** 
**    Rev 1.0   12 Dec 1991 13:43:20   courtney
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/l695/lflags.h_v   1.1   01 Jul 1998 13:56:20   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LFLAGS__
#define __LFLAGS__

#ifndef _LDRSVR_
#include "ldrsvr.h"
#endif

/* These flags indicate what to load, they can be or'ed together
   to load everything - used internal to the Loader. */
#define L695_GLOBALS    0x01
#define L695_LOCALS     0x02

#define LOAD_GLOBALS(flags) ((flags) & L695_GLOBALS)
#define LOAD_LOCALS(flags)  ((flags) & L695_LOCALS)

/* How to process a module */
#define MCREATE			1	/* create entry in symbol table */
#define MOPEN			2	/* re-open (has already been created) - used
							   in ondemand loading */

/* MACROS : flag processing macros for flags passed in by caller */
#define LOAD_SYM(flags)       ((flags) & L695_DBG)
#define LOAD_CODE(flags)      ((flags) & L695_CODE)
#define REPORT_STATUS(flags)  ((flags) & L695_STATUS)
#define REPORT_WARNING(flags) ((flags) & L695_WARNING)
#define LOAD_ASM(flags)       ((flags) & L695_ASM)
#define LOAD_USER(flags)      ((flags) & L695_SPACE)
#define LOAD_COMMON(flags)    ((flags) & L695_COMMON)//Hera ID247
#endif
