/****************************************************************************
**
**  Name:  genericn.h
**
**  Description:  Definition of the generic network entry points.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/lanservr/genericn.h_v  $
** 
**    Rev 1.0   13 Feb 1997 08:51:32   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:37:52   gene
** Initial revision.
** 
**    Rev 1.0   17 Jan 1994 11:49:02   tom
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_68k/lanservr/genericn.h_v   1.0   13 Feb 1997 08:51:32   gene  $
**
**  Copyright (C) 1993-4 Microtek International.  All rights reserved.
**
*****************************************************************************/
#define _GENERICN_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/****************************************************************************
**
** genericNetworkConnect
**
** description:
**   Establish a TCP/IP network connection between the PC host and the emulator.
**
** parameters:
**   hostName (in):  name of the emulator.
**   connection (out):  connection identifier.
**
** return code:
**   GOOD: connection operation successful.
**  !GOOD: error code for connection failure.
**
*****************************************************************************/
RETCODE FAR PASCAL genericNetworkConnect(U8 *hostName, U32 *connection);

/****************************************************************************
**
** genericNetworkRead
**
** description:
**   Receive bytes from the emulator over the TCP/IP network connection.
**   This call trys once, and returns number of bytes immediately available.
**
** parameters:
**   connection (in):  connection identifier.
**   buffer (out):  character buffer to receive data
**                  (buffer allocated by caller).
**   length (in/out):  in: number of bytes to read;
**                     out: number of bytes read.
**
** return code:
**   GOOD: read operation successful.
**  !GOOD: error code for read operation failure.
**
*****************************************************************************/
RETCODE FAR PASCAL genericNetworkRead(U32 connection,
   U8 FAR *buffer, U16 *length);

/****************************************************************************
**
** genericNetworkWrite
**
** description:
**   Send bytes to the emulator over the TCP/IP network connection.
**   Does not return until all of the bytes have been sent.
**
** parameters:
**   connection (in):  connection identifier.
**   buffer (in):  buffer of characters to be written.
**   length (in/out):  in: number of bytes to write;
**                     out: number of bytes written.
**
** return code:
**   GOOD: write operation successful.
**  !GOOD: error code for write operation failure.
**
*****************************************************************************/
RETCODE FAR PASCAL genericNetworkWrite(U32 connection,
   U8 FAR *buffer, U16 *length);

/****************************************************************************
**
** genericNetworkFlush
**
** description:
**   Immediately send all of the bytes waiting to be sent to the emulator over
**   the TCP/IP network connection.
**
** parameters:
**   connection (in):  connection identifier.
**
** return code:
**   GOOD: flush operation successful.
**  !GOOD: error code for flush operation failure.
**
*****************************************************************************/
RETCODE FAR PASCAL genericNetworkFlush(U32 connection);

/****************************************************************************
**
** genericNetworkClose
**
** description:
**   Destroy the TCP/IP network connection with the emulator.
**
** parameters:
**   connection (in):  connection identifier.
**
** return code:
**   GOOD: close operation successful.
**  !GOOD: error code for close operation failure.
**
*****************************************************************************/
RETCODE FAR PASCAL genericNetworkClose(U32 connection);
