/****************************************************************************
**
**  Name:  LFLAGS.H
**
**  Description:
**      Flags used by modules for on-demand loading.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_68k/loader/srec/lflags.h_v  $
** 
**    Rev 1.0   30 Sep 1997 16:03:30   gene
** Initial revision.
** 
**    Rev 1.4   13 Jul 1993 09:41:10   ernie
** Added include of sldrsvr.h to get definition of L695_WARNING
** 
**    Rev 1.3   04 Jun 1993 10:06:42   nghia
** Revised all loader flags macros to meet coding standard.
** PIP for Source.
** 
**    Rev 1.2   12 Feb 1993 17:58:46   nghia
** No change.
** 
**    Rev 1.1   25 Sep 1992 21:06:20   courtney
** Added reload macro.
** 
**    Rev 1.0   31 Dec 1991 09:30:36   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_68k/loader/srec/lflags.h_v   1.0   30 Sep 1997 16:03:30   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LFLAGS__
#define __LFLAGS__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _SLDRSVR_
#include "sldrsvr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* These flags indicate what to load, they can be or'ed together
   to load everything - used internal to the Loader. */
#define L695_GLOBALS    0x01
#define L695_LOCALS     0x02

#define LOAD_GLOBALS(flags) ((flags) & L695_GLOBALS)
#define LOAD_LOCALS(flags)  ((flags) & L695_LOCALS)

/* How to process a module */
#define MCREATE			1	/* create entry in symbol table */
#define MOPEN			2	/* re-open (has already been created) - used
							   in ondemand loading */

/* flag processing macros for flags passed in by caller */
#define LOAD_SYM(flags)       ((flags) & L695_DBG)
#define LOAD_CODE(flags)      ((flags) & L695_CODE)
#define REPORT_STATUS(flags)  ((flags) & L695_STATUS)
#define REPORT_WARNING(flags) ((flags) & L695_WARNING)
#define RELOAD(flags)         ((flags) & L695_RELOAD)
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F *************************************/
#endif
