/****************************************************************************
**
**  Name:  LSYM.H
**
**  Description:
**      Definitions which interface the Symbol Server.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_68k/loader/srec/lsym.h_v  $
** 
**    Rev 1.0   30 Sep 1997 16:03:30   gene
** Initial revision.
** 
**    Rev 1.2   04 Jun 1993 10:08:10   nghia
** Revised to meet coding standard.
** PIP for Source.
** 
**    Rev 1.1   12 Feb 1993 17:59:16   nghia
** No change.
** 
**    Rev 1.0   25 Sep 1992 21:04:30   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_68k/loader/srec/lsym.h_v   1.0   30 Sep 1997 16:03:30   gene  $
**
**  Copyright (C) 1991-2 Microtek International.  All rights reserved.
**
*****************************************************************************/
#define __LSYM__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef __SYMERROR__
/* some errors we need to capture - they are not really errors */
#include "symerror.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* boolean values for SymAddLoadStart ondemand parameter */
#define INITIAL_LOAD  0
#define MODULE_LOAD   1

#define RANGE_NOT_SET 0xffffffffL
#define START_RANGE_NOT_SET 0x11111111L
#define END_RANGE_NOT_SET   0x00000000L

#define SBASE_FAKE  "BASE_RTACTIVATE"	/* fake base for regs/autos */
#define SBASE_FAKE_INDEX	99			/* section index for fake base */

/* built-in types which require size definitions - be sure they are long */
#define T695_INT		0x10L
#define T695_UNS		0x11L
#define T695_UNS_INT	0x12L

/* sizeof(int) for MRI C 68K is 4 bytes */
#define SZ_STACKPUSH_68K	4L
/* sizeof(pointer) for MRI C 68K types */
#define SZ_SMPTR68K			2L
#define SZ_LGPTR68K			4L

/* other built-in types needed */
#define T695_VOIDP		0x01L
#define T695_CODE		0x0fL

/* complex types as defined by IEEE 695 (known as 'High Level types' */
#define T695_UNKNOWN		'!'
#define T695_SMALL_PTR		'O'
#define T695_LARGE_PTR		'P'
#define T695_ENUM  			'N'
#define T695_STRUCT 		'S'
#define T695_TYPEDEF		'T'
#define T695_UNION 			'U'
#define T695_VOID			'V'		/* undocumented by 695; used by MRI C */
#define T695_PROC_SIMPLE	'X'
#define T695_ARRAY			'Z'
#define T695_BITFIELD		'g'
#define T695_PROC			'x'

#define MAX_CMDLINE         255     /* for generating tool */

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
S16 FindSymBase(U32, U16 *, BOOLEAN *);
S16 FindCodeBaseIndex(U16 *);
S16 FindDataDefIndex(U16 *);
S16 FindRTABaseIndex(U16 *);
S16 FindSecModifier(U16);
S16 Get695Time(HANDLE, TIMESTAMP_TYPE *);
S16 GetTimestamp(HANDLE, TIMESTAMP_TYPE *);

/******************************** E O F *************************************/
