// mpsetup.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "mpsetup.h"

#include "mainfrm.h"
#include "mpsetdoc.h"
#include "mpsetvw.h"
#include <lzexpand.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMpsetupApp

BEGIN_MESSAGE_MAP(CMpsetupApp, CWinApp)
      //{{AFX_MSG_MAP(CMpsetupApp)
      ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
            // NOTE - the ClassWizard will add and remove mapping macros here.
            //    DO NOT EDIT what you see in these blocks of generated code!
      //}}AFX_MSG_MAP
      // Standard file based document commands
      ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
      ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMpsetupApp construction

CMpsetupApp::CMpsetupApp()
{
      // TODO: add construction code here,
      // Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMpsetupApp object

CMpsetupApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CMpsetupApp initialization

BOOL CMpsetupApp::InitInstance()
{
      // Standard initialization
      // If you are not using these features and wish to reduce the size
      //  of your final executable, you should remove from the following
      //  the specific initialization routines you do not need.

      SetDialogBkColor();        // Set dialog background color to gray
      LoadStdProfileSettings();  // Load standard INI file options (including MRU)

      // Register the application's document templates.  Document templates
      //  serve as the connection between documents, frame windows and views.

//    CSingleDocTemplate* pDocTemplate;
//    pDocTemplate = new CSingleDocTemplate(
//          IDR_MAINFRAME,
//          RUNTIME_CLASS(CMpsetupDoc),
//          RUNTIME_CLASS(CMainFrame),     // main SDI frame window
//          RUNTIME_CLASS(CMpsetupView));
//    AddDocTemplate(pDocTemplate);

      // create a new (empty) document
//    OnFileNew();
      CSetupDlg setupDlg;

      if (m_lpCmdLine[0] != '\0')
      {
            // TODO: add command line processing here  
            setupDlg.SetPath(&(m_lpCmdLine[0]));
      }           
      setupDlg.DoModal();


      return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
      CAboutDlg();

// Dialog Data
      //{{AFX_DATA(CAboutDlg)
      enum { IDD = IDD_ABOUTBOX };
      //}}AFX_DATA

// Implementation
protected:
      virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
      //{{AFX_MSG(CAboutDlg)
            // No message handlers
      //}}AFX_MSG
      DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
      //{{AFX_DATA_INIT(CAboutDlg)
      //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
      CDialog::DoDataExchange(pDX);
      //{{AFX_DATA_MAP(CAboutDlg)
      //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
      //{{AFX_MSG_MAP(CAboutDlg)
            // No message handlers
      //}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMpsetupApp::OnAppAbout()
{
      CAboutDlg aboutDlg;
      aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMpsetupApp commands
/////////////////////////////////////////////////////////////////////////////
// CSetupDlg dialog


CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
      : CDialog(CSetupDlg::IDD, pParent)
{
      //{{AFX_DATA_INIT(CSetupDlg)
      //}}AFX_DATA_INIT
    m_TargetPath[0] = NULL;
      
    GetPrivateProfileString("Comm","Type","Serial",m_CommType,
                       sizeof(m_CommType),IniFile);    
    GetPrivateProfileString("Serial","comPort","COM2",m_CommPort,
                       sizeof(m_CommPort),IniFile);    
    GetPrivateProfileString("SystemInfo","MicePack","68306",m_MICEpack,
                         sizeof(m_MICEpack),IniFile);  
    if (stricmp(m_MICEpack,"68302LC") == 0)
       memcpy(m_MICEpack,"68LC302",8);
                         
    GetPrivateProfileString("SystemInfo","EPClock","20",m_EPClock,
                         sizeof(m_MICEpack),IniFile);
    GetPrivateProfileString("Serial","BaudRate","57600",m_BaudRate,
                       sizeof(m_BasePort),IniFile);                         
}

void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{
      CDialog::DoDataExchange(pDX);
      //{{AFX_DATA_MAP(CSetupDlg)
      //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetupDlg, CDialog)
      //{{AFX_MSG_MAP(CSetupDlg)
      ON_BN_CLICKED(IDC_HELP, OnHelp)
      ON_CBN_SELCHANGE(IDC_COMMTYPE, OnSelchangeCommtype)
      //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSetupDlg message handlers

void CSetupDlg::OnHelp()
{
      ::WinHelp(m_hWnd, "mpsetup.hlp", HELP_CONTENTS,0);
}
                                
#define szSrc68K    "map_68k.dll"
#define szSrcLC302  "map_lc.dll" 
#define szDest      "map.dll"
void CSetupDlg::OnOK()
{ 
    HFILE hfSrcFile, hfDestFile;
    OFSTRUCT ofStrSrc, ofStrDest;
    char szSrc[20];
    char szMsg[80] = "File not find.(";
    char szFullPath[128];

    GetDlgItemText(IDC_MICEPACK, (LPTSTR)m_MICEpack, 32);
    GetDlgItemText(IDC_EPCLOCK, (LPTSTR)m_EPClock, 32);
    GetDlgItemText(IDC_COMMTYPE, (LPTSTR)m_CommPort, 32);
    GetDlgItemText(IDC_BAUDRATE, (LPTSTR)m_BaudRate, 32);
    WritePrivateProfileString("Comm","Type","Serial",IniFile);    
    WritePrivateProfileString("Serial","comPort",m_CommPort,IniFile);    
    WritePrivateProfileString("Serial","BaudRate",m_BaudRate,IniFile);    
    WritePrivateProfileString("SystemInfo","EPClock",m_EPClock,IniFile);
//    WritePrivateProfileString("MicrotekParallel","basePort",m_BasePort,IniFile);

//  Copy selected Map.dll       
    LZStart();
    if (stricmp(m_MICEpack,"68LC302") == 0) {
       strcpy(szSrc,szSrcLC302);
       strcat(szMsg,szSrcLC302);
       WritePrivateProfileString("SystemInfo","MICEpack","68302LC",IniFile);
    } else {
       strcpy(szSrc,szSrc68K);
       strcat(szMsg,szSrc68K);
       WritePrivateProfileString("SystemInfo","MICEpack",m_MICEpack,IniFile);
    }          
    if (m_TargetPath[0] != '\0') {     
       strcpy(szFullPath,m_TargetPath);
       strcat(szFullPath,"\\");
       strcat(szFullPath,szSrc);
    } else {
       strcpy(szFullPath,szSrc);
    }                                            
    hfSrcFile = LZOpenFile(szFullPath,&ofStrSrc,OF_READ);

    strcat(szMsg,")");
    if (hfSrcFile == -1) {             
       ::MessageBox(NULL,szMsg,"File open error",MB_OK);
    } else { 
       remove(szDest);            
       if (m_TargetPath[0] != '\0') {     
          strcpy(szFullPath,m_TargetPath);
          strcat(szFullPath,"\\");
          strcat(szFullPath,szDest);
       } else {
          strcpy(szFullPath,szDest);
       }      
       hfDestFile = LZOpenFile(szFullPath,&ofStrDest,OF_CREATE);
       LZCopy(hfSrcFile,hfDestFile);
       LZClose(hfDestFile);
    }   
    LZClose(hfSrcFile);
    LZDone();
      
    CDialog::OnOK();
}

BOOL CSetupDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
      
      ::SendDlgItemMessage(m_hWnd,IDC_MICEPACK,CB_SELECTSTRING,-1,(LPARAM)(LPSTR)m_MICEpack);
      ::SendDlgItemMessage(m_hWnd,IDC_COMMTYPE,CB_SELECTSTRING,-1,(LPARAM)(LPSTR)m_CommPort);
      ::SendDlgItemMessage(m_hWnd,IDC_BAUDRATE,CB_SELECTSTRING,-1,(LPARAM)(LPSTR)m_BaudRate);
      ::SendDlgItemMessage(m_hWnd,IDC_EPCLOCK,CB_SELECTSTRING,-1,(LPARAM)(LPSTR)m_EPClock);
//    SetDlgItemText(IDC_BASEPORT, m_BasePort);
//      if (::SendDlgItemMessage(m_hWnd,IDC_COMMTYPE,CB_GETCURSEL,0,0) != 0) {
//         ::EnableWindow(GetDlgItem(IDC_STRPORT)->m_hWnd, FALSE);
//         ::EnableWindow(GetDlgItem(IDC_BASEPORT)->m_hWnd, FALSE);
//      } 
      
      return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetupDlg::OnSelchangeCommtype()
{
//      if (::SendDlgItemMessage(m_hWnd,IDC_COMMTYPE,CB_GETCURSEL,0,0) != 0) {
//         ::EnableWindow(GetDlgItem(IDC_STRPORT)->m_hWnd, FALSE);
//         ::EnableWindow(GetDlgItem(IDC_BASEPORT)->m_hWnd, FALSE);
//      } 
//      else {
//         ::EnableWindow(GetDlgItem(IDC_STRPORT)->m_hWnd, TRUE);
//         ::EnableWindow(GetDlgItem(IDC_BASEPORT)->m_hWnd, TRUE);
//      } 
}

void CSetupDlg::SetPath(LPSTR path)
{
    lstrcpy(m_TargetPath,path);
}