/* draws a bitmap */!!

inherit(Window, #BitmapWindow, #(hBitmap), 2, nil)!!

now(class(BitmapWindow))!!

/* PUBLIC */
Def style(self)
{ ^( WS_POPUP bitOr WS_DLGFRAME )
}
!!

now(BitmapWindow)!!

/* 8/18/1992 13:56 */
Def destroy(self)
{
  hBitmap cand Call DeleteObject( hBitmap ) ;
  
  destroy( self:ancestor ) ;
}
!!

/* PUBLIC */
Def loadBitmap(self, bitmapID)
{
  hBitmap := Call LoadBitmap(HInstance, bitmapID);
  if (hBitmap = 0) 
  then 
    ^(hBitmap := nil) 
  endif ;
}
!!

/* PRIVATE */
Def draw(self, hDC | hMemDC cr)
{
  if hBitmap
  then
    cr := clientRect( self ) ;
    hMemDC := Call CreateCompatibleDC( hDC ) ;
    Call SelectObject( hMemDC, hBitmap ) ;
    Call BitBlt( hDC, 0, 0, width(cr), height(cr), hMemDC, 0, 0, SRCCOPY );
    Call DeleteDC( hMemDC ) ;
  endif ;
}
!!

/* WINDOWS */
Def paint(self, hDC)
{
  if hBitmap
  then
    draw( self, hDC ) ;
  else
    paint( self:ancestor, hDC ) ;
  endif ;
}
!!