/*****************************************************************************
** Name:  stkcli.h
**
** Description:
**    Routines to access the CLI for the stack server.
**
** Status:   PRELIMINARY
**
** $Log:   S:/tbird/mt2_68k/stkservr/stkcli.h_v  $
** 
**    Rev 1.0   13 Feb 1997 09:04:58   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:14:18   gene
** Initial revision.
** 
**    Rev 1.3   16 Jul 1993 11:52:06   nghia
** PIP for Stack:
** - Added SetStackArea.
** 
**    Rev 1.2   27 Feb 1992 15:41:04   marilyn
** No change.
** 
**    Rev 1.1   14 Feb 1992 11:39:34   marilyn
** Added enum for stack type.
** 
**    Rev 1.0   11 Feb 1992 16:02:40   marilyn
** Initial revision.
**
** $Header:   S:/tbird/mt2_68k/stkservr/stkcli.h_v   1.0   13 Feb 1997 09:04:58   gene  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _STKCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MAX_CHARS_PER_LINE 132
#define LINES_FOR_STACK_INFO 7

typedef enum {
   HI_TO_LOW, LOW_TO_HI
} STACK_TYPE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************************************************************
**
**   DisableHighWaterMark
**
**   Purpose:
**      To disable the high water mark which can generate an alarm condition.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  DisableHighWaterMark(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**   DisplayStack
**
**   Purpose:
**      To display the stack frames in user comprehensible format.
**      Defaults to address and funcion names.  Locals options includes local
**      symbols.  Hex option displays in hex format using 16 bytes per line.
**      Defaults to hex format if no symbolic information is available.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  DisplayStack(LPSTR cmdString, U32 argc, U32 argv[]);


/******************************************************************************
**
**   EnableHighWaterMark
**
**   Purpose:
**      To enable the high water mark which can generate an alarm condition.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  EnableHighWaterMark(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**   FillStackPattern
**
**   Purpose:
**      To initialize the stack area to a special pattern such as 55AA.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  FillStackPattern(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**   SetStackBase
**
**   Purpose:
**      To set the stack base pointer.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  SetStackBase(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**   SetStackSize
**
**   Purpose:
**      To set the stack size.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  SetStackSize(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**   SetStackAlarm
**
**   Purpose:
**      To set the stack alarm limit(must be between stackbase +/- stacksize).
**
**   Inpput parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  SetStackAlarm(LPSTR cmdString, U32 argc, U32 argv[]);



/******************************************************************************
**
**   StackInfo
**
**   Purpose:
**      To display general stack information: stack base, stack size, current
**      stack pointer, number of frames, alarm limit, high water mark, and
**      growth direction of the stack.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  StackInfo(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**   SetStackArea
**
**   Purpose:
**      To set and initialize stack area with stack base pointer and size.
**
**   Input parameters:
**      cmdString : the CLI command string
**      argc : number of arguments in command string
**      argv : array of pointers to the arguments
**
**   Output parameters:
**      none
**
**   Error:
**
******************************************************************************/
RETCODE EXPORT  SetStackArea(LPSTR cmdString, U32 argc, U32 argv[]);


/************************************************************************
**
**   InitSessionForCli
**
**   Get the default stack's session id or register the cli with
**   the stack server.
**
*************************************************************************/
RETCODE InitSessionForCli(DESCRIPTOR *sessionId);

/******************************** E O F ***********************************/
